/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SerializationFilterBase;
import com.intellij.util.xmlb.XmlSerializer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.ui.UiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoggerInitializedWithForeignClassInspection
extends BaseInspection {
    @NonNls
    private static final String DEFAULT_LOGGER_CLASS_NAMES = "org.apache.log4j.Logger,org.slf4j.LoggerFactory,org.apache.commons.logging.LogFactory,java.util.logging.Logger";
    @NonNls
    private static final String DEFAULT_FACTORY_METHOD_NAMES = "getLogger,getLogger,getLog,getLogger";
    protected final List<String> loggerFactoryClassNames = new ArrayList<String>();
    protected final List<String> loggerFactoryMethodNames = new ArrayList<String>();
    public String loggerClassName = "org.apache.log4j.Logger,org.slf4j.LoggerFactory,org.apache.commons.logging.LogFactory,java.util.logging.Logger";
    public String loggerFactoryMethodName = "getLogger,getLogger,getLog,getLogger";

    public LoggerInitializedWithForeignClassInspection() {
        LoggerInitializedWithForeignClassInspection.parseString(this.loggerClassName, this.loggerFactoryClassNames);
        LoggerInitializedWithForeignClassInspection.parseString(this.loggerFactoryMethodName, this.loggerFactoryMethodNames);
    }

    public JComponent createOptionsPanel() {
        ListTable table = new ListTable(new ListWrappingTableModel(Arrays.asList(this.loggerFactoryClassNames, this.loggerFactoryMethodNames), new String[]{InspectionGadgetsBundle.message("logger.factory.class.name", new Object[0]), InspectionGadgetsBundle.message("logger.factory.method.name", new Object[0])}));
        return UiUtils.createAddRemoveTreeClassChooserPanel(table, "Choose logger factory class", new String[0]);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("logger.initialized.with.foreign.class.display.name", new Object[0]);
        if (string == null) {
            LoggerInitializedWithForeignClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("logger.initialized.with.foreign.class.problem.descriptor", new Object[0]);
        if (string == null) {
            LoggerInitializedWithForeignClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LoggerInitializedWithForeignClassFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoggerInitializedWithForeignClassVisitor();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            LoggerInitializedWithForeignClassInspection.$$$reportNull$$$0(2);
        }
        super.readSettings(element);
        LoggerInitializedWithForeignClassInspection.parseString(this.loggerClassName, this.loggerFactoryClassNames);
        LoggerInitializedWithForeignClassInspection.parseString(this.loggerFactoryMethodName, this.loggerFactoryMethodNames);
        if (this.loggerFactoryClassNames.size() != this.loggerFactoryMethodNames.size() || this.loggerFactoryClassNames.isEmpty()) {
            LoggerInitializedWithForeignClassInspection.parseString(DEFAULT_LOGGER_CLASS_NAMES, this.loggerFactoryClassNames);
            LoggerInitializedWithForeignClassInspection.parseString(DEFAULT_FACTORY_METHOD_NAMES, this.loggerFactoryMethodNames);
        }
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            LoggerInitializedWithForeignClassInspection.$$$reportNull$$$0(3);
        }
        this.loggerClassName = LoggerInitializedWithForeignClassInspection.formatString(this.loggerFactoryClassNames);
        this.loggerFactoryMethodName = LoggerInitializedWithForeignClassInspection.formatString(this.loggerFactoryMethodNames);
        XmlSerializer.serializeInto((Object)((Object)this), (Element)element, (SerializationFilter)new SerializationFilterBase(){

            protected boolean accepts(@NotNull Accessor accessor, @NotNull Object bean, @Nullable Object beanValue) {
                if (accessor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (bean == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ("loggerClassName".equals(accessor.getName()) && LoggerInitializedWithForeignClassInspection.DEFAULT_LOGGER_CLASS_NAMES.equals(beanValue)) {
                    return false;
                }
                return !"loggerFactoryMethodNames".equals(accessor.getName()) || !LoggerInitializedWithForeignClassInspection.DEFAULT_FACTORY_METHOD_NAMES.equals(beanValue);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "accessor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "bean";
                        break;
                    }
                }
                objectArray[1] = "com/siyeh/ig/logging/LoggerInitializedWithForeignClassInspection$1";
                objectArray[2] = "accepts";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/logging/LoggerInitializedWithForeignClassInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/logging/LoggerInitializedWithForeignClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LoggerInitializedWithForeignClassVisitor
    extends BaseInspectionVisitor {
        private LoggerInitializedWithForeignClassVisitor() {
        }

        public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
            super.visitClassObjectAccessExpression(expression2);
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
                if (!expression2.equals(referenceExpression.getQualifierExpression())) {
                    return;
                }
                String name2 = referenceExpression.getReferenceName();
                if (!"getName".equals(name2)) {
                    return;
                }
                PsiElement grandParent = referenceExpression.getParent();
                if (!(grandParent instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                PsiExpressionList list = methodCallExpression.getArgumentList();
                if (!list.isEmpty()) {
                    return;
                }
                parent = methodCallExpression.getParent();
            }
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions2 = argumentList.getExpressions();
            if (expressions2.length != 1) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression2);
            while (containingClass instanceof PsiAnonymousClass) {
                containingClass = ClassUtils.getContainingClass((PsiElement)containingClass);
            }
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getName();
            if (containingClassName == null) {
                return;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            int index = LoggerInitializedWithForeignClassInspection.this.loggerFactoryClassNames.indexOf(className);
            if (index < 0) {
                return;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            String loggerFactoryMethodName = LoggerInitializedWithForeignClassInspection.this.loggerFactoryMethodNames.get(index);
            if (!loggerFactoryMethodName.equals(referenceName)) {
                return;
            }
            PsiTypeElement operand2 = expression2.getOperand();
            PsiClass initializerClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)operand2.getType());
            if (initializerClass == null) {
                return;
            }
            if (containingClass.equals(initializerClass)) {
                return;
            }
            this.registerError((PsiElement)expression2, containingClassName);
        }
    }

    private static class LoggerInitializedWithForeignClassFix
    extends InspectionGadgetsFix {
        private final String newClassName;

        private LoggerInitializedWithForeignClassFix(String newClassName) {
            this.newClassName = newClassName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("logger.initialized.with.foreign.class.quickfix", this.newClassName);
            if (string == null) {
                LoggerInitializedWithForeignClassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace foreign class" == null) {
                LoggerInitializedWithForeignClassFix.$$$reportNull$$$0(1);
            }
            return "Replace foreign class";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            if (!(element instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)element;
            PsiReplacementUtil.replaceExpression((PsiExpression)classObjectAccessExpression, this.newClassName + ".class", new CommentTracker());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/logging/LoggerInitializedWithForeignClassInspection$LoggerInitializedWithForeignClassFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

