/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ui.JBUI;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressionAnnotationInspection
extends BaseInspection {
    public List<String> myAllowedSuppressions = new ArrayList<String>();

    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm("Ignore suppressions", this.myAllowedSuppressions);
        JComponent panel = form.getContentPanel();
        panel.setPreferredSize((Dimension)JBUI.size((int)150, (int)100));
        return panel;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        boolean suppressionIdPresent = (Boolean)infos[1];
        if (infos[0] instanceof PsiAnnotation) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray;
            PsiAnnotation annotation = (PsiAnnotation)infos[0];
            if (suppressionIdPresent) {
                InspectionGadgetsFix[] inspectionGadgetsFixArray2 = new InspectionGadgetsFix[2];
                inspectionGadgetsFixArray2[0] = new DelegatingFix(new RemoveAnnotationQuickFix(annotation, null));
                inspectionGadgetsFixArray = inspectionGadgetsFixArray2;
                inspectionGadgetsFixArray2[1] = new AllowSuppressionsFix();
            } else {
                InspectionGadgetsFix[] inspectionGadgetsFixArray3 = new InspectionGadgetsFix[1];
                inspectionGadgetsFixArray = inspectionGadgetsFixArray3;
                inspectionGadgetsFixArray3[0] = new DelegatingFix(new RemoveAnnotationQuickFix(annotation, null));
            }
            if (inspectionGadgetsFixArray == null) {
                SuppressionAnnotationInspection.$$$reportNull$$$0(0);
            }
            return inspectionGadgetsFixArray;
        }
        if (infos[0] instanceof PsiComment) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray;
            if (suppressionIdPresent) {
                InspectionGadgetsFix[] inspectionGadgetsFixArray4 = new InspectionGadgetsFix[2];
                inspectionGadgetsFixArray4[0] = new RemoveSuppressCommentFix();
                inspectionGadgetsFixArray = inspectionGadgetsFixArray4;
                inspectionGadgetsFixArray4[1] = new AllowSuppressionsFix();
            } else {
                InspectionGadgetsFix[] inspectionGadgetsFixArray5 = new InspectionGadgetsFix[1];
                inspectionGadgetsFixArray = inspectionGadgetsFixArray5;
                inspectionGadgetsFixArray5[0] = new RemoveSuppressCommentFix();
            }
            if (inspectionGadgetsFixArray == null) {
                SuppressionAnnotationInspection.$$$reportNull$$$0(1);
            }
            return inspectionGadgetsFixArray;
        }
        if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
            SuppressionAnnotationInspection.$$$reportNull$$$0(2);
        }
        return InspectionGadgetsFix.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inspection.suppression.annotation.display.name", new Object[0]);
        if (string == null) {
            SuppressionAnnotationInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("inspection.suppression.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            SuppressionAnnotationInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            SuppressionAnnotationInspection.$$$reportNull$$$0(5);
        }
        return false;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        if (SuppressQuickFix.EMPTY_ARRAY == null) {
            SuppressionAnnotationInspection.$$$reportNull$$$0(6);
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuppressionAnnotationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/maturity/SuppressionAnnotationInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/maturity/SuppressionAnnotationInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SuppressionAnnotationVisitor
    extends BaseInspectionVisitor {
        private SuppressionAnnotationVisitor() {
        }

        public void visitComment(PsiComment comment) {
            super.visitComment(comment);
            IElementType tokenType = comment.getTokenType();
            if (!tokenType.equals(JavaTokenType.END_OF_LINE_COMMENT) && !tokenType.equals(JavaTokenType.C_STYLE_COMMENT)) {
                return;
            }
            String commentText = comment.getText();
            if (commentText.length() <= 2) {
                return;
            }
            String strippedComment = commentText.substring(2).trim();
            if (!strippedComment.startsWith("noinspection")) {
                return;
            }
            String suppressedIds = JavaSuppressionUtil.getSuppressedInspectionIdsIn((PsiElement)comment);
            if (suppressedIds == null) {
                this.registerError((PsiElement)comment, comment, Boolean.FALSE);
                return;
            }
            Iterable ids = StringUtil.tokenize((String)suppressedIds, (String)",");
            for (String id : ids) {
                if (SuppressionAnnotationInspection.this.myAllowedSuppressions.contains(id)) continue;
                this.registerError((PsiElement)comment, comment, Boolean.TRUE);
                break;
            }
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            PsiElement annotationParent;
            super.visitAnnotation(annotation);
            PsiJavaCodeReferenceElement reference = annotation.getNameReferenceElement();
            if (reference == null) {
                return;
            }
            String text2 = reference.getText();
            if (("SuppressWarnings".equals(text2) || "java.lang.SuppressWarnings".equals(text2)) && (annotationParent = annotation.getParent()) instanceof PsiModifierList) {
                Collection<String> ids = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation((PsiModifierList)annotationParent);
                if (!SuppressionAnnotationInspection.this.myAllowedSuppressions.containsAll(ids)) {
                    this.registerError((PsiElement)annotation, annotation, Boolean.TRUE);
                } else if (ids.isEmpty()) {
                    this.registerError((PsiElement)annotation, annotation, Boolean.FALSE);
                }
            }
        }
    }

    private class AllowSuppressionsFix
    extends InspectionGadgetsFix {
        private AllowSuppressionsFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            Iterable<String> ids;
            PsiElement psiElement = descriptor2.getPsiElement();
            if (psiElement instanceof PsiAnnotation) {
                ids = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation((PsiModifierList)psiElement.getParent());
            } else {
                String suppressedIds = JavaSuppressionUtil.getSuppressedInspectionIdsIn(psiElement);
                if (suppressedIds == null) {
                    return;
                }
                ids = StringUtil.tokenize((String)suppressedIds, (String)",");
            }
            for (String id : ids) {
                if (SuppressionAnnotationInspection.this.myAllowedSuppressions.contains(id)) continue;
                SuppressionAnnotationInspection.this.myAllowedSuppressions.add(id);
            }
            ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getName() {
            if ("Allow these suppressions" == null) {
                AllowSuppressionsFix.$$$reportNull$$$0(0);
            }
            return "Allow these suppressions";
        }

        @NotNull
        public String getFamilyName() {
            if ("Allow suppressions" == null) {
                AllowSuppressionsFix.$$$reportNull$$$0(1);
            }
            return "Allow suppressions";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/maturity/SuppressionAnnotationInspection$AllowSuppressionsFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class RemoveSuppressCommentFix
    extends InspectionGadgetsFix {
        private RemoveSuppressCommentFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement psiElement = descriptor2.getPsiElement();
            if (psiElement != null) {
                psiElement.delete();
            }
        }

        @NotNull
        public String getFamilyName() {
            if ("Remove //noinspection" == null) {
                RemoveSuppressCommentFix.$$$reportNull$$$0(0);
            }
            return "Remove //noinspection";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/maturity/SuppressionAnnotationInspection$RemoveSuppressCommentFix", "getFamilyName"));
        }
    }
}

