/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.ui.ConventionOptionsPanel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPackageStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.BaseSharedLocalInspection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageNamingConventionInspection
extends BaseGlobalInspection {
    private static final int DEFAULT_MIN_LENGTH = 3;
    private static final int DEFAULT_MAX_LENGTH = 16;
    @NonNls
    public String m_regex = "[a-z]*";
    public int m_minLength = 3;
    public int m_maxLength = 16;
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("package.naming.convention.display.name", new Object[0]);
        if (string == null) {
            PackageNamingConventionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (refEntity == null) {
            PackageNamingConventionInspection.$$$reportNull$$$0(1);
        }
        if (analysisScope == null) {
            PackageNamingConventionInspection.$$$reportNull$$$0(2);
        }
        if (inspectionManager == null) {
            PackageNamingConventionInspection.$$$reportNull$$$0(3);
        }
        if (globalInspectionContext == null) {
            PackageNamingConventionInspection.$$$reportNull$$$0(4);
        }
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        String name2 = StringUtil.getShortName((String)refEntity.getQualifiedName());
        if (InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]).equals(name2)) {
            return null;
        }
        int length = name2.length();
        if (length == 0) {
            return null;
        }
        if (length < this.m_minLength) {
            String errorString = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.short", name2);
            return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
        }
        if (length > this.m_maxLength) {
            String errorString = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.long", name2);
            return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
        }
        Matcher matcher = this.m_regexPattern.matcher(name2);
        if (matcher.matches()) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.regex.mismatch", name2, this.m_regex);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            PackageNamingConventionInspection.$$$reportNull$$$0(5);
        }
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    public JComponent createOptionsPanel() {
        return new ConventionOptionsPanel((InspectionProfileEntry)this, "m_minLength", "m_maxLength", "m_regex", "m_regexPattern", new JComponent[0]);
    }

    boolean isValid(String name2) {
        int length = name2.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (this.m_maxLength > 0 && length > this.m_maxLength) {
            return false;
        }
        Matcher matcher = this.m_regexPattern.matcher(name2);
        return matcher.matches();
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new LocalPackageNamingConventionInspection(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/naming/PackageNamingConventionInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/naming/PackageNamingConventionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LocalPackageNamingConventionInspection
    extends BaseSharedLocalInspection<PackageNamingConventionInspection> {
        LocalPackageNamingConventionInspection(PackageNamingConventionInspection inspection) {
            super(inspection);
        }

        @Override
        @NotNull
        protected String buildErrorString(Object ... infos) {
            String name2 = (String)infos[0];
            if (name2.length() < ((PackageNamingConventionInspection)this.mySettingsDelegate).m_minLength) {
                String string = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.short", name2);
                if (string == null) {
                    LocalPackageNamingConventionInspection.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (name2.length() > ((PackageNamingConventionInspection)this.mySettingsDelegate).m_maxLength) {
                String string = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.long", name2);
                if (string == null) {
                    LocalPackageNamingConventionInspection.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.regex.mismatch", name2, ((PackageNamingConventionInspection)this.mySettingsDelegate).m_regex);
            if (string == null) {
                LocalPackageNamingConventionInspection.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public BaseInspectionVisitor buildVisitor() {
            return new BaseInspectionVisitor(){

                public void visitPackageStatement(PsiPackageStatement statement) {
                    PsiJavaCodeReferenceElement reference = statement.getPackageReference();
                    if (reference == null) {
                        return;
                    }
                    String text2 = reference.getText();
                    int start = 0;
                    int index = text2.indexOf(46, start);
                    while (index > 0) {
                        String name2 = text2.substring(start, index);
                        if (!((PackageNamingConventionInspection)mySettingsDelegate).isValid(name2)) {
                            this.registerErrorAtOffset((PsiElement)reference, start, index - start, name2);
                        }
                        start = index + 1;
                        index = text2.indexOf(46, start);
                    }
                    String lastName = text2.substring(start);
                    if (!lastName.isEmpty() && !((PackageNamingConventionInspection)mySettingsDelegate).isValid(lastName)) {
                        this.registerErrorAtOffset((PsiElement)reference, start, lastName.length(), lastName);
                    }
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/PackageNamingConventionInspection$LocalPackageNamingConventionInspection", "buildErrorString"));
        }
    }
}

