/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonReproducibleMathCallInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> nonReproducibleMethods = new HashSet<String>(20);

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.reproducible.math.call.display.name", new Object[0]);
        if (string == null) {
            NonReproducibleMathCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.reproducible.math.call.problem.descriptor", new Object[0]);
        if (string == null) {
            NonReproducibleMathCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new MakeStrictFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BigDecimalEqualsVisitor();
    }

    static {
        nonReproducibleMethods.add("acos");
        nonReproducibleMethods.add("asin");
        nonReproducibleMethods.add("atan");
        nonReproducibleMethods.add("atan2");
        nonReproducibleMethods.add("cbrt");
        nonReproducibleMethods.add("cos");
        nonReproducibleMethods.add("cosh");
        nonReproducibleMethods.add("exp");
        nonReproducibleMethods.add("expm1");
        nonReproducibleMethods.add("hypot");
        nonReproducibleMethods.add("log");
        nonReproducibleMethods.add("log10");
        nonReproducibleMethods.add("log1p");
        nonReproducibleMethods.add("pow");
        nonReproducibleMethods.add("sin");
        nonReproducibleMethods.add("sinh");
        nonReproducibleMethods.add("tan");
        nonReproducibleMethods.add("tanh");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/NonReproducibleMathCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class BigDecimalEqualsVisitor
    extends BaseInspectionVisitor {
        private BigDecimalEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                BigDecimalEqualsVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!nonReproducibleMethods.contains(methodName)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass referencedClass = method.getContainingClass();
            if (referencedClass == null) {
                return;
            }
            String className = referencedClass.getQualifiedName();
            if (!"java.lang.Math".equals(className)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/NonReproducibleMathCallInspection$BigDecimalEqualsVisitor", "visitMethodCallExpression"));
        }
    }

    private static class MakeStrictFix
    extends InspectionGadgetsFix {
        private MakeStrictFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("non.reproducible.math.call.replace.quickfix", new Object[0]);
            if (string == null) {
                MakeStrictFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiIdentifier nameIdentifier = (PsiIdentifier)descriptor2.getPsiElement();
            PsiReferenceExpression reference = (PsiReferenceExpression)nameIdentifier.getParent();
            assert (reference != null);
            String name2 = reference.getReferenceName();
            PsiReplacementUtil.replaceExpression((PsiExpression)reference, "StrictMath." + name2, new CommentTracker());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/NonReproducibleMathCallInspection$MakeStrictFix", "getFamilyName"));
        }
    }
}

