/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BoxingBoxedValueInspection
extends BaseInspection {
    @NonNls
    static final Map<String, String> boxedPrimitiveMap = new HashMap<String, String>(8);

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("boxing.boxed.value.display.name", new Object[0]);
        if (string == null) {
            BoxingBoxedValueInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("boxing.boxed.value.problem.descriptor", new Object[0]);
        if (string == null) {
            BoxingBoxedValueInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new BoxingBoxedValueFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BoxingBoxedValueVisitor();
    }

    static {
        boxedPrimitiveMap.put("java.lang.Integer", "int");
        boxedPrimitiveMap.put("java.lang.Short", "short");
        boxedPrimitiveMap.put("java.lang.Boolean", "boolean");
        boxedPrimitiveMap.put("java.lang.Long", "long");
        boxedPrimitiveMap.put("java.lang.Byte", "byte");
        boxedPrimitiveMap.put("java.lang.Float", "float");
        boxedPrimitiveMap.put("java.lang.Double", "double");
        boxedPrimitiveMap.put("java.lang.Character", "char");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/BoxingBoxedValueInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class BoxingBoxedValueVisitor
    extends BaseInspectionVisitor {
        private BoxingBoxedValueVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiType constructorType = expression2.getType();
            if (constructorType == null) {
                return;
            }
            String constructorTypeText = constructorType.getCanonicalText();
            if (!boxedPrimitiveMap.containsKey(constructorTypeText)) {
                return;
            }
            PsiMethod constructor = expression2.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiParameter parameter2 = parameters2[0];
            PsiType parameterType = parameter2.getType();
            String parameterTypeText = parameterType.getCanonicalText();
            String boxableConstructorType = boxedPrimitiveMap.get(constructorTypeText);
            if (!boxableConstructorType.equals(parameterTypeText)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return;
            }
            String argumentTypeText = argumentType.getCanonicalText();
            if (!constructorTypeText.equals(argumentTypeText)) {
                return;
            }
            this.registerError((PsiElement)argument, new Object[0]);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"valueOf".equals(referenceName)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if (className == null) {
                return;
            }
            if (!boxedPrimitiveMap.containsKey(className)) {
                return;
            }
            if (method.getParameterList().getParametersCount() != 1) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return;
            }
            String argumentTypeText = argumentType.getCanonicalText();
            if (!className.equals(argumentTypeText)) {
                return;
            }
            this.registerError((PsiElement)argument, new Object[0]);
        }
    }

    private static class BoxingBoxedValueFix
    extends InspectionGadgetsFix {
        private BoxingBoxedValueFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("boxing.boxed.value.quickfix", new Object[0]);
            if (string == null) {
                BoxingBoxedValueFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiCallExpression parent = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethodCallExpression.class, PsiNewExpression.class});
            if (parent == null) {
                return;
            }
            parent.replace(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/BoxingBoxedValueInspection$BoxingBoxedValueFix", "getFamilyName"));
        }
    }
}

