/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.AllowedApiFilterExtension;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DynamicRegexReplaceableByCompiledPatternInspection
extends BaseInspection {
    @NonNls
    protected static final Collection<String> regexMethodNames = new HashSet<String>(4);

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DynamicRegexReplaceableByCompiledPatternFix();
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("dynamic.regex.replaceable.by.compiled.pattern.display.name", new Object[0]);
        if (string == null) {
            DynamicRegexReplaceableByCompiledPatternInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("dynamic.regex.replaceable.by.compiled.pattern.problem.descriptor", new Object[0]);
        if (string == null) {
            DynamicRegexReplaceableByCompiledPatternInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DynamicRegexReplaceableByCompiledPatternVisitor();
    }

    static {
        regexMethodNames.add("matches");
        regexMethodNames.add("replace");
        regexMethodNames.add("replaceFirst");
        regexMethodNames.add("replaceAll");
        regexMethodNames.add("split");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/DynamicRegexReplaceableByCompiledPatternInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class DynamicRegexReplaceableByCompiledPatternVisitor
    extends BaseInspectionVisitor {
        private DynamicRegexReplaceableByCompiledPatternVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!DynamicRegexReplaceableByCompiledPatternVisitor.isCallToRegexMethod(expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean isCallToRegexMethod(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name2 = methodExpression.getReferenceName();
            if (!regexMethodNames.contains(name2)) {
                return false;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return false;
            }
            Object value2 = ExpressionUtils.computeConstantExpression(arguments[0]);
            if (!(value2 instanceof String)) {
                return false;
            }
            String regex = (String)value2;
            if (PsiUtil.isLanguageLevel7OrHigher((PsiElement)expression2) && "split".equals(name2) && DynamicRegexReplaceableByCompiledPatternVisitor.isOptimizedPattern(regex) || PsiUtil.isLanguageLevel9OrHigher((PsiElement)expression2) && "replace".equals(name2)) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String className = containingClass.getQualifiedName();
            if (!"java.lang.String".equals(className)) {
                return false;
            }
            if (Extensions.getRootArea().hasExtensionPoint(AllowedApiFilterExtension.EP_NAME.getName())) {
                return AllowedApiFilterExtension.isClassAllowed("java.util.regex.Pattern", (PsiElement)expression2);
            }
            return true;
        }

        private static boolean isOptimizedPattern(String regex) {
            char ch;
            return (regex.length() == 1 && ".$|()[{^?*+\\".indexOf(ch = regex.charAt(0)) == -1 || regex.length() == 2 && regex.charAt(0) == '\\' && ((ch = regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff');
        }
    }

    private static class DynamicRegexReplaceableByCompiledPatternFix
    extends InspectionGadgetsFix {
        private DynamicRegexReplaceableByCompiledPatternFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("dynamic.regex.replaceable.by.compiled.pattern.quickfix", new Object[0]);
            if (string == null) {
                DynamicRegexReplaceableByCompiledPatternFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            int i;
            String qualifierText;
            String methodName;
            boolean literalReplacement;
            PsiElement element = descriptor2.getPsiElement();
            PsiClass aClass = ClassUtils.getContainingStaticClass(element);
            if (aClass == null) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent;
            PsiElement grandParent = methodExpression.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList list = methodCallExpression.getArgumentList();
            PsiExpression[] expressions2 = list.getExpressions();
            CommentTracker commentTracker = new CommentTracker();
            StringBuilder fieldText = new StringBuilder("private static final java.util.regex.Pattern PATTERN = java.util.regex.Pattern.compile(");
            int expressionsLength = expressions2.length;
            if (expressionsLength > 0) {
                fieldText.append(commentTracker.text((PsiElement)expressions2[0]));
            }
            if (literalReplacement = "replace".equals(methodName = methodExpression.getReferenceName())) {
                fieldText.append(", java.util.regex.Pattern.LITERAL");
            }
            fieldText.append(");");
            StringBuilder expressionText = new StringBuilder("PATTERN.");
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            String string = qualifierText = qualifier == null ? "this" : commentTracker.text((PsiElement)qualifier);
            if ("split".equals(methodName)) {
                expressionText.append(methodName);
                expressionText.append('(');
                expressionText.append(qualifierText);
                for (i = 1; i < expressionsLength; ++i) {
                    expressionText.append(',').append(commentTracker.text((PsiElement)expressions2[i]));
                }
                expressionText.append(')');
            } else {
                expressionText.append("matcher(").append(qualifierText).append(").");
                if (literalReplacement) {
                    expressionText.append("replaceAll");
                } else {
                    expressionText.append(methodName);
                }
                expressionText.append('(');
                if (literalReplacement) {
                    expressionText.append("java.util.regex.Matcher.quoteReplacement(");
                }
                if (expressionsLength > 1) {
                    expressionText.append(commentTracker.text((PsiElement)expressions2[1]));
                    for (i = 2; i < expressionsLength; ++i) {
                        expressionText.append(',').append(commentTracker.text((PsiElement)expressions2[i]));
                    }
                }
                if (literalReplacement) {
                    expressionText.append(')');
                }
                expressionText.append(')');
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiElement field = aClass.add((PsiElement)factory.createFieldFromText(fieldText.toString(), element));
            PsiMethodCallExpression newMethodCallExpression = (PsiMethodCallExpression)commentTracker.replaceAndRestoreComments((PsiElement)methodCallExpression, expressionText.toString());
            newMethodCallExpression = (PsiMethodCallExpression)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)newMethodCallExpression);
            PsiReferenceExpression reference = DynamicRegexReplaceableByCompiledPatternFix.getReference(newMethodCallExpression);
            HighlightUtils.showRenameTemplate((PsiElement)aClass, (PsiNameIdentifierOwner)field, new PsiReference[]{reference});
        }

        private static PsiReferenceExpression getReference(PsiMethodCallExpression newMethodCallExpression) {
            PsiReferenceExpression methodExpression = newMethodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)qualifierExpression2;
                return DynamicRegexReplaceableByCompiledPatternFix.getReference(methodCallExpression);
            }
            if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                return null;
            }
            return (PsiReferenceExpression)qualifierExpression2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/DynamicRegexReplaceableByCompiledPatternInspection$DynamicRegexReplaceableByCompiledPatternFix", "getFamilyName"));
        }
    }
}

