/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantStringFormatCallInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.string.format.call.display.name", new Object[0]);
        if (string == null) {
            RedundantStringFormatCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("redundant.call.problem.descriptor", new Object[0]);
        if (string == null) {
            RedundantStringFormatCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Boolean printf = (Boolean)infos[0];
        return printf != false ? new ReplaceWithPrintFix() : new RedundantStringFormatCallFix();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantStringFormatCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/RedundantStringFormatCallInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class RedundantStringFormatCallVisitor
    extends BaseInspectionVisitor {
        private RedundantStringFormatCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            boolean printf;
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if ("format".equals(methodName)) {
                printf = false;
            } else if ("printf".equals(methodName)) {
                printf = true;
            } else {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > 2 || arguments.length == 0) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (printf ? !"java.io.PrintStream".equals(className) : !"java.lang.String".equals(className)) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            PsiType firstType = firstArgument.getType();
            if (firstType == null) {
                return;
            }
            if (firstType.equalsToText("java.lang.String")) {
                if (arguments.length == 1 && !RedundantStringFormatCallVisitor.containsPercentN(firstArgument)) {
                    this.registerMethodCallError(expression2, printf);
                }
            } else if (firstType.equalsToText("java.util.Locale")) {
                if (arguments.length != 2) {
                    return;
                }
                PsiExpression secondArgument = arguments[1];
                PsiType secondType = secondArgument.getType();
                if (secondType == null || !secondType.equalsToText("java.lang.String")) {
                    return;
                }
                if (RedundantStringFormatCallVisitor.containsPercentN(secondArgument)) {
                    return;
                }
                this.registerMethodCallError(expression2, printf);
            }
        }

        private static boolean containsPercentN(PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            if (expression2 instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
                String expressionText = literalExpression.getText();
                return expressionText.contains("%n");
            }
            if (expression2 instanceof PsiPolyadicExpression) {
                PsiExpression[] operands2;
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                IElementType tokenType = polyadicExpression.getOperationTokenType();
                if (!tokenType.equals(JavaTokenType.PLUS)) {
                    return false;
                }
                for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                    if (!RedundantStringFormatCallVisitor.containsPercentN(operand2)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class RedundantStringFormatCallFix
    extends InspectionGadgetsFix {
        private RedundantStringFormatCallFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.string.format.call.quickfix", new Object[0]);
            if (string == null) {
                RedundantStringFormatCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement().getParent().getParent();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
            PsiExpression[] arguments = methodCallExpression.getArgumentList().getExpressions();
            new CommentTracker().replaceAndRestoreComments((PsiElement)methodCallExpression, (PsiElement)arguments[arguments.length - 1]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/RedundantStringFormatCallInspection$RedundantStringFormatCallFix", "getFamilyName"));
        }
    }

    private static class ReplaceWithPrintFix
    extends InspectionGadgetsFix {
        private ReplaceWithPrintFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"printf()", "print()"});
            if (string == null) {
                ReplaceWithPrintFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            CommentTracker commentTracker = new CommentTracker();
            StringBuilder newExpression = new StringBuilder();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 != null) {
                newExpression.append(commentTracker.text((PsiElement)qualifierExpression2)).append('.');
            }
            newExpression.append("print").append(commentTracker.text((PsiElement)methodCallExpression.getArgumentList()));
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/RedundantStringFormatCallInspection$ReplaceWithPrintFix", "getFamilyName"));
        }
    }
}

