/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceExpressionWithTextFix
extends InspectionGadgetsFix {
    @NotNull
    private final String myReplacementText;
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    private final String myName;

    public ReplaceExpressionWithTextFix(@NotNull String replacementText, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String name2) {
        if (replacementText == null) {
            ReplaceExpressionWithTextFix.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            ReplaceExpressionWithTextFix.$$$reportNull$$$0(1);
        }
        this.myReplacementText = replacementText;
        this.myName = name2;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor2) {
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getStartElement(), PsiNewExpression.class);
        if (newExpression == null) {
            return;
        }
        PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)newExpression, this.myReplacementText);
        PsiDiamondTypeUtil.removeRedundantTypeArguments(result);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ReplaceExpressionWithTextFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.myName;
        if (string == null) {
            ReplaceExpressionWithTextFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/performance/ReplaceExpressionWithTextFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/performance/ReplaceExpressionWithTextFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

