/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TrivialStringConcatenationInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ConcatenationWithEmptyString" == null) {
            TrivialStringConcatenationInspection.$$$reportNull$$$0(0);
        }
        return "ConcatenationWithEmptyString";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("trivial.string.concatenation.display.name", new Object[0]);
        if (string == null) {
            TrivialStringConcatenationInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("trivial.string.concatenation.problem.descriptor", new Object[0]);
        if (string == null) {
            TrivialStringConcatenationInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NonNls
    static String calculateReplacementExpression(PsiLiteralExpression expression2, CommentTracker commentTracker) {
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
        if (!(parent instanceof PsiPolyadicExpression)) {
            return null;
        }
        if (parent instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
            PsiExpression lOperand = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            PsiExpression rOperand = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
            PsiExpression replacement = ExpressionUtils.isEmptyStringLiteral(lOperand) ? rOperand : lOperand;
            return replacement == null ? "" : TrivialStringConcatenationInspection.buildReplacement(replacement, false, commentTracker);
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)expression2);
        boolean seenString = false;
        boolean seenEmpty = false;
        boolean replaced = false;
        PsiExpression operandToReplace = null;
        StringBuilder text2 = new StringBuilder();
        for (PsiExpression operand2 : operands2) {
            if (operandToReplace != null && !replaced) {
                if (ExpressionUtils.hasStringType(operand2)) {
                    seenString = true;
                }
                if (text2.length() > 0) {
                    text2.append(" + ");
                }
                text2.append(TrivialStringConcatenationInspection.buildReplacement(operandToReplace, seenString, commentTracker));
                text2.append(" + ");
                text2.append(commentTracker.text((PsiElement)operand2));
                replaced = true;
                continue;
            }
            if (ParenthesesUtils.stripParentheses(operand2) == expression2) {
                seenEmpty = true;
                continue;
            }
            if (seenEmpty && !replaced) {
                operandToReplace = operand2;
                continue;
            }
            if (stringType.equals((Object)operand2.getType())) {
                seenString = true;
            }
            if (text2.length() > 0) {
                text2.append(" + ");
            }
            text2.append(commentTracker.text((PsiElement)operand2));
        }
        if (!replaced && operandToReplace != null) {
            text2.append(" + ");
            text2.append(TrivialStringConcatenationInspection.buildReplacement(operandToReplace, seenString, commentTracker));
        }
        return text2.toString();
    }

    @NonNls
    static String buildReplacement(@NotNull PsiExpression operandToReplace, boolean seenString, CommentTracker commentTracker) {
        if (operandToReplace == null) {
            TrivialStringConcatenationInspection.$$$reportNull$$$0(3);
        }
        if (ExpressionUtils.isNullLiteral(operandToReplace)) {
            if (seenString) {
                return "null";
            }
            return "String.valueOf((Object)null)";
        }
        if (seenString || ExpressionUtils.hasStringType(operandToReplace)) {
            return operandToReplace.getText();
        }
        return "String.valueOf(" + commentTracker.text((PsiElement)operandToReplace) + ')';
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryTemporaryObjectFix((PsiLiteralExpression)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TrivialStringConcatenationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/performance/TrivialStringConcatenationInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandToReplace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/performance/TrivialStringConcatenationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildReplacement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TrivialStringConcatenationVisitor
    extends BaseInspectionVisitor {
        private TrivialStringConcatenationVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            PsiExpression[] operands2;
            super.visitPolyadicExpression(expression2);
            if (!ExpressionUtils.hasStringType((PsiExpression)expression2)) {
                return;
            }
            for (PsiExpression operand2 : operands2 = expression2.getOperands()) {
                if ((operand2 = ParenthesesUtils.stripParentheses(operand2)) == null) {
                    return;
                }
                if (!ExpressionUtils.isEmptyStringLiteral(operand2)) continue;
                if (PsiUtil.isConstantExpression((PsiExpression)expression2)) {
                    return;
                }
                this.registerError((PsiElement)operand2, operand2);
            }
        }
    }

    private static class UnnecessaryTemporaryObjectFix
    extends InspectionGadgetsFix {
        private final String m_name;

        UnnecessaryTemporaryObjectFix(PsiLiteralExpression expression2) {
            this.m_name = InspectionGadgetsBundle.message("string.replace.quickfix", TrivialStringConcatenationInspection.calculateReplacementExpression(expression2, new CommentTracker()));
        }

        @NotNull
        public String getName() {
            String string = this.m_name;
            if (string == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace concatenation" == null) {
                UnnecessaryTemporaryObjectFix.$$$reportNull$$$0(1);
            }
            return "Replace concatenation";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiLiteralExpression expression2 = (PsiLiteralExpression)descriptor2.getPsiElement();
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
            if (!(parent instanceof PsiExpression)) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String newExpression = TrivialStringConcatenationInspection.calculateReplacementExpression(expression2, commentTracker);
            PsiReplacementUtil.replaceExpression((PsiExpression)parent, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/performance/TrivialStringConcatenationInspection$UnnecessaryTemporaryObjectFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

