/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakConverter {
    private final PsiSwitchStatement mySwitchStatement;
    private final String myReplacement;

    public BreakConverter(PsiSwitchStatement switchStatement, String replacement) {
        this.mySwitchStatement = switchStatement;
        this.myReplacement = replacement;
    }

    public void process() {
        List<PsiBreakStatement> breaks = this.collectBreaks();
        for (PsiBreakStatement breakStatement : breaks) {
            if (BreakConverter.isRemovable(this.mySwitchStatement, (PsiStatement)breakStatement)) {
                DeleteUnnecessaryStatementFix.deleteUnnecessaryStatement((PsiStatement)breakStatement);
                continue;
            }
            assert (this.myReplacement != null);
            new CommentTracker().replaceAndRestoreComments((PsiElement)breakStatement, this.myReplacement);
        }
    }

    @NotNull
    private List<PsiBreakStatement> collectBreaks() {
        final ArrayList<PsiBreakStatement> breaks = new ArrayList<PsiBreakStatement>();
        this.mySwitchStatement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitBreakStatement(PsiBreakStatement statement) {
                super.visitBreakStatement(statement);
                if (statement.findExitedStatement() == BreakConverter.this.mySwitchStatement) {
                    breaks.add(statement);
                }
            }

            public void visitExpression(PsiExpression expression2) {
            }

            public void visitClass(PsiClass aClass) {
            }
        });
        ArrayList<PsiBreakStatement> arrayList = breaks;
        if (arrayList == null) {
            BreakConverter.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    private static String getReplacement(PsiStatement statement) {
        PsiElement parent = statement.getParent();
        if (parent instanceof PsiIfStatement || parent instanceof PsiLabeledStatement) {
            return BreakConverter.getReplacement((PsiStatement)parent);
        }
        PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        if (nextStatement != null) {
            if (nextStatement instanceof PsiContinueStatement || nextStatement instanceof PsiBreakStatement || nextStatement instanceof PsiReturnStatement || nextStatement instanceof PsiThrowStatement) {
                return nextStatement.getText();
            }
            return null;
        }
        if (parent == null) {
            return null;
        }
        if (parent instanceof PsiLoopStatement) {
            return "continue;";
        }
        if (parent instanceof PsiCodeBlock) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiMethod && PsiType.VOID.equals((Object)((PsiMethod)grandParent).getReturnType()) || grandParent instanceof PsiLambdaExpression && PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiFunctionalExpression)grandParent)))) {
                return "return;";
            }
            if (grandParent instanceof PsiBlockStatement) {
                return BreakConverter.getReplacement((PsiStatement)grandParent);
            }
        }
        return null;
    }

    private static boolean isRemovable(PsiSwitchStatement switchStatement, PsiStatement statement) {
        PsiElement parent = statement.getParent();
        if (parent instanceof PsiIfStatement || parent instanceof PsiLabeledStatement) {
            return BreakConverter.isRemovable(switchStatement, (PsiStatement)parent);
        }
        PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        if (nextStatement == null && parent instanceof PsiCodeBlock) {
            PsiElement grandParent = parent.getParent();
            return grandParent == switchStatement || grandParent instanceof PsiBlockStatement && BreakConverter.isRemovable(switchStatement, (PsiStatement)grandParent);
        }
        if (nextStatement instanceof PsiSwitchLabelStatement) {
            return ((PsiSwitchLabelStatement)nextStatement).getEnclosingSwitchStatement() == switchStatement && !ControlFlowUtils.statementMayCompleteNormally(statement);
        }
        if (nextStatement instanceof PsiBreakStatement) {
            return ((PsiBreakStatement)nextStatement).findExitedStatement() == switchStatement;
        }
        return false;
    }

    @Nullable
    public static BreakConverter from(PsiSwitchStatement switchStatement) {
        String replacement = BreakConverter.getReplacement((PsiStatement)switchStatement);
        if (replacement == null) {
            class Visitor
            extends JavaRecursiveElementWalkingVisitor {
                boolean hasNonRemovableBreak;
                final /* synthetic */ PsiSwitchStatement val$switchStatement;

                Visitor(PsiSwitchStatement psiSwitchStatement) {
                    this.val$switchStatement = psiSwitchStatement;
                }

                public void visitBreakStatement(PsiBreakStatement statement) {
                    super.visitBreakStatement(statement);
                    if (statement.findExitedStatement() == this.val$switchStatement && !BreakConverter.isRemovable(this.val$switchStatement, (PsiStatement)statement)) {
                        this.hasNonRemovableBreak = true;
                        this.stopWalking();
                    }
                }

                public void visitExpression(PsiExpression expression2) {
                }

                public void visitClass(PsiClass aClass) {
                }
            }
            Visitor visitor = new Visitor(switchStatement);
            switchStatement.accept((PsiElementVisitor)visitor);
            if (visitor.hasNonRemovableBreak) {
                return null;
            }
        }
        return new BreakConverter(switchStatement, replacement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BreakConverter", "collectBreaks"));
    }
}

