/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.resources.ImplicitResourceCloser;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import com.siyeh.ig.ui.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoCloseableResourceInspection
extends ResourceInspection {
    private static final CallMatcher CLOSE = CallMatcher.instanceCall("java.lang.AutoCloseable", "close");
    private static final List<String> DEFAULT_IGNORED_TYPES = Arrays.asList("java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream");
    protected final MethodMatcher myMethodMatcher;
    final List<String> ignoredTypes = new ArrayList<String>(DEFAULT_IGNORED_TYPES);
    public boolean ignoreFromMethodCall = false;
    CallMatcher STREAM_HOLDING_RESOURCE = CallMatcher.staticCall("java.nio.file.Files", "lines", "walk", "list", "find");

    public AutoCloseableResourceInspection() {
        this.myMethodMatcher = new MethodMatcher().add("java.util.Formatter", "format").add("java.io.Writer", "append").add("com.google.common.base.Preconditions", "checkNotNull").add("org.hibernate.Session", "close").add("java.io.PrintWriter", "printf").finishDefault();
    }

    @Override
    @NotNull
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(2));
        ListTable table = new ListTable(new ListWrappingTableModel(this.ignoredTypes, InspectionGadgetsBundle.message("ignored.autocloseable.types.column.label", new Object[0])));
        JPanel tablePanel = UiUtils.createAddRemoveTreeClassChooserPanel(table, InspectionGadgetsBundle.message("choose.autocloseable.type.to.ignore.title", new Object[0]), "java.lang.AutoCloseable");
        ListTable table2 = new ListTable(new ListWrappingTableModel(Arrays.asList(this.myMethodMatcher.getClassNames(), this.myMethodMatcher.getMethodNamePatterns()), new String[]{InspectionGadgetsBundle.message("result.of.method.call.ignored.class.column.title", new Object[0]), InspectionGadgetsBundle.message("method.name.regex", new Object[0])})){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled && !AutoCloseableResourceInspection.this.ignoreFromMethodCall);
            }
        };
        JPanel tablePanel2 = UiUtils.createAddRemoveTreeClassChooserPanel(table2, "Choose class", new String[0]);
        JPanel wrapperPanel = new JPanel(new BorderLayout());
        wrapperPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Ignore AutoCloseable instances returned from these methods", (boolean)false));
        wrapperPanel.add(tablePanel2);
        panel.add(tablePanel);
        panel.add(wrapperPanel);
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("auto.closeable.resource.returned.option", new Object[0]), (InspectionProfileEntry)this, "ignoreFromMethodCall");
        checkBox.addChangeListener(e -> table2.setEnabled(!this.ignoreFromMethodCall));
        panel.add((Component)checkBox);
        panel.add((Component)new CheckBox(InspectionGadgetsBundle.message("any.method.may.close.resource.argument", new Object[0]), (InspectionProfileEntry)this, "anyMethodMayClose"));
        JPanel jPanel = panel;
        if (jPanel == null) {
            AutoCloseableResourceInspection.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("auto.closeable.resource.display.name", new Object[0]);
        if (string == null) {
            AutoCloseableResourceInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("resource" == null) {
            AutoCloseableResourceInspection.$$$reportNull$$$0(2);
        }
        return "resource";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        String text2 = type2.getPresentableText();
        String string = InspectionGadgetsBundle.message("auto.closeable.resource.problem.descriptor", text2);
        if (string == null) {
            AutoCloseableResourceInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean buildQuickfix = (Boolean)infos[1];
        if (!buildQuickfix) {
            return null;
        }
        return new AutoCloseableResourceFix();
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            AutoCloseableResourceInspection.$$$reportNull$$$0(4);
        }
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            String ignoredTypesString;
            String name2 = option.getAttributeValue("name");
            if (!"ignoredTypes".equals(name2) || (ignoredTypesString = option.getAttributeValue("value")) == null) continue;
            this.ignoredTypes.clear();
            AutoCloseableResourceInspection.parseString(ignoredTypesString, this.ignoredTypes);
        }
        this.myMethodMatcher.readSettings(node);
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            AutoCloseableResourceInspection.$$$reportNull$$$0(5);
        }
        this.writeBooleanOption(node, "ignoreFromMethodCall", false);
        this.writeBooleanOption(node, "anyMethodMayClose", true);
        if (!DEFAULT_IGNORED_TYPES.equals(this.ignoredTypes)) {
            String ignoredTypesString = AutoCloseableResourceInspection.formatString(this.ignoredTypes);
            node.addContent(new Element("option").setAttribute("name", "ignoredTypes").setAttribute("value", ignoredTypesString));
        }
        this.myMethodMatcher.writeSettings(node);
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression2) {
        return TypeUtils.expressionHasTypeOrSubtype(expression2, "java.lang.AutoCloseable") && (this.isStreamHoldingResource(expression2) || !TypeUtils.expressionHasTypeOrSubtype(expression2, this.ignoredTypes));
    }

    private boolean isStreamHoldingResource(PsiExpression expression2) {
        return this.STREAM_HOLDING_RESOURCE.matches((PsiExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class));
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel7OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AutoCloseableResourceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/resources/AutoCloseableResourceInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/resources/AutoCloseableResourceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AutoCloseableResourceVisitor
    extends BaseInspectionVisitor {
        private AutoCloseableResourceVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (this.isSafelyClosedResource((PsiExpression)expression2)) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2.getType(), Boolean.FALSE);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (AutoCloseableResourceInspection.this.ignoreFromMethodCall || AutoCloseableResourceInspection.this.myMethodMatcher.matches((PsiCall)expression2) || this.isSafelyClosedResource((PsiExpression)expression2)) {
                return;
            }
            PsiExpression returnedValue = JavaMethodContractUtil.findReturnedValue(expression2);
            PsiExpression[] arguments = expression2.getArgumentList().getExpressions();
            PsiExpression qualifier = expression2.getMethodExpression().getQualifierExpression();
            if (qualifier == returnedValue) {
                return;
            }
            for (PsiExpression argument : arguments) {
                if (returnedValue != argument) continue;
                return;
            }
            this.registerMethodCallError(expression2, expression2.getType(), !AutoCloseableResourceInspection.this.isStreamHoldingResource((PsiExpression)expression2));
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            super.visitMethodReferenceExpression(expression2);
            if (!expression2.isConstructor()) {
                return;
            }
            PsiType type2 = PsiMethodReferenceUtil.getQualifierType((PsiMethodReferenceExpression)expression2);
            if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.AutoCloseable")) {
                return;
            }
            for (String ignoredType : AutoCloseableResourceInspection.this.ignoredTypes) {
                if (!InheritanceUtil.isInheritor((PsiType)type2, (String)ignoredType)) continue;
                return;
            }
            this.registerError((PsiElement)expression2, type2, Boolean.FALSE);
        }

        private boolean isSafelyClosedResource(PsiExpression expression2) {
            if (!AutoCloseableResourceInspection.this.isResourceCreation(expression2)) {
                return true;
            }
            if (CLOSE.test(ExpressionUtils.getCallForQualifier(expression2))) {
                return true;
            }
            PsiVariable variable = ResourceInspection.getVariable(expression2);
            if (variable instanceof PsiResourceVariable || AutoCloseableResourceInspection.this.isResourceEscapingFromMethod(variable, expression2)) {
                return true;
            }
            if (variable == null) {
                return false;
            }
            return StreamEx.of((Collection)ImplicitResourceCloser.EP_NAME.getExtensionList()).anyMatch(closer -> closer.isSafelyClosed(variable));
        }
    }

    private class AutoCloseableResourceFix
    extends InspectionGadgetsFix {
        private AutoCloseableResourceFix() {
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("auto.closeable.resource.quickfix", new Object[0]);
            if (string == null) {
                AutoCloseableResourceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return;
            }
            AutoCloseableResourceInspection.this.myMethodMatcher.add(methodCallExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/resources/AutoCloseableResourceInspection$AutoCloseableResourceFix", "getFamilyName"));
        }
    }
}

