/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class SerialVersionUIDNotStaticFinalInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("SerialVersionUIDWithWrongSignature" == null) {
            SerialVersionUIDNotStaticFinalInspection.$$$reportNull$$$0(0);
        }
        return "SerialVersionUIDWithWrongSignature";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serialversionuid.private.static.final.long.display.name", new Object[0]);
        if (string == null) {
            SerialVersionUIDNotStaticFinalInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("serialversionuid.private.static.final.long.problem.descriptor", new Object[0]);
        if (string == null) {
            SerialVersionUIDNotStaticFinalInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (((Boolean)infos[0]).booleanValue()) {
            return null;
        }
        return new SerialVersionUIDNotStaticFinalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerialVersionUIDNotStaticFinalVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/serialization/SerialVersionUIDNotStaticFinalInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SerialVersionUIDNotStaticFinalVisitor
    extends BaseInspectionVisitor {
        private SerialVersionUIDNotStaticFinalVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            boolean wrongType;
            if (aClass == null) {
                SerialVersionUIDNotStaticFinalVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            PsiField field = aClass.findFieldByName("serialVersionUID", false);
            if (field == null) {
                return;
            }
            PsiType type2 = field.getType();
            boolean bl = wrongType = !PsiType.LONG.equals((Object)type2);
            if (field.hasModifierProperty("static") && field.hasModifierProperty("private") && field.hasModifierProperty("final") && !wrongType) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerFieldError(field, wrongType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/SerialVersionUIDNotStaticFinalInspection$SerialVersionUIDNotStaticFinalVisitor", "visitClass"));
        }
    }

    private static class SerialVersionUIDNotStaticFinalFix
    extends InspectionGadgetsFix {
        private SerialVersionUIDNotStaticFinalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("serialversionuid.private.static.final.long.quickfix", new Object[0]);
            if (string == null) {
                SerialVersionUIDNotStaticFinalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)parent;
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.setModifierProperty("private", true);
            modifierList.setModifierProperty("static", true);
            modifierList.setModifierProperty("final", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerialVersionUIDNotStaticFinalInspection$SerialVersionUIDNotStaticFinalFix", "getFamilyName"));
        }
    }
}

