/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import org.jetbrains.annotations.NotNull;

class SerializableInnerClassHasSerialVersionUIDFieldVisitor
extends BaseInspectionVisitor {
    private final SerializableInspectionBase inspection;

    SerializableInnerClassHasSerialVersionUIDFieldVisitor(SerializableInspectionBase inspection) {
        this.inspection = inspection;
    }

    public void visitClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SerializableInnerClassHasSerialVersionUIDFieldVisitor.$$$reportNull$$$0(0);
        }
        if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
            return;
        }
        if (aClass instanceof PsiTypeParameter) {
            return;
        }
        if (this.inspection.ignoreAnonymousInnerClasses && aClass instanceof PsiAnonymousClass) {
            return;
        }
        if (aClass.findFieldByName("serialVersionUID", false) != null) {
            return;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
        if (containingClass == null) {
            return;
        }
        if (aClass.hasModifierProperty("static")) {
            return;
        }
        PsiModifierListOwner staticElement = PsiUtil.getEnclosingStaticElement((PsiElement)aClass, (PsiClass)containingClass);
        if (staticElement != null) {
            return;
        }
        if (!SerializationUtils.isSerializable(aClass)) {
            return;
        }
        if (this.inspection.isIgnoredSubclass(aClass)) {
            return;
        }
        this.registerClassError(aClass, new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/SerializableInnerClassHasSerialVersionUIDFieldVisitor", "visitClass"));
    }
}

