/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConstantExpressionInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final int MAX_RESULT_LENGTH_TO_DISPLAY = 50;
    private static final int MAX_EXPRESSION_LENGTH = 200;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ConstantExpressionInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitUnaryExpression(PsiUnaryExpression expression2) {
                this.handle((PsiExpression)expression2);
            }

            public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
                this.handle((PsiExpression)expression2);
            }

            void handle(PsiExpression expression2) {
                if (expression2.getTextLength() > 200) {
                    return;
                }
                if (expression2.getType() == null) {
                    return;
                }
                if (!PsiUtil.isConstantExpression((PsiExpression)expression2)) {
                    return;
                }
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
                if (parent instanceof PsiExpression && PsiUtil.isConstantExpression((PsiExpression)((PsiExpression)parent))) {
                    return;
                }
                try {
                    String valueText;
                    Object value2 = ExpressionUtils.computeConstantExpression(expression2, true);
                    if (value2 != null && !expression2.textMatches((CharSequence)(valueText = ConstantExpressionInspection.getValueText(value2)))) {
                        String message2 = valueText.length() > 50 ? InspectionGadgetsBundle.message("inspection.constant.expression.display.name", new Object[0]) : InspectionGadgetsBundle.message("inspection.constant.expression.message", valueText);
                        holder.registerProblem((PsiElement)expression2, message2, new LocalQuickFix[]{new ComputeConstantValueFix(expression2, valueText)});
                    }
                }
                catch (ConstantEvaluationOverflowException constantEvaluationOverflowException) {
                    // empty catch block
                }
            }
        };
        if (javaElementVisitor == null) {
            ConstantExpressionInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static String getValueText(Object value2) {
        String newExpression;
        if (value2 instanceof String) {
            String string = (String)value2;
            newExpression = '\"' + StringUtil.escapeStringCharacters((String)string) + '\"';
        } else {
            double v;
            newExpression = value2 instanceof Character ? '\'' + StringUtil.escapeStringCharacters((String)value2.toString()) + '\'' : (value2 instanceof Long ? value2.toString() + 'L' : (value2 instanceof Double ? (Double.isNaN(v = ((Double)value2).doubleValue()) ? "java.lang.Double.NaN" : (Double.isInfinite(v) ? (v > 0.0 ? "java.lang.Double.POSITIVE_INFINITY" : "java.lang.Double.NEGATIVE_INFINITY") : Double.toString(v))) : (value2 instanceof Float ? (Float.isNaN(v = ((Float)value2).floatValue()) ? "java.lang.Float.NaN" : (Float.isInfinite(v) ? (v > 0.0f ? "java.lang.Float.POSITIVE_INFINITY" : "java.lang.Float.NEGATIVE_INFINITY") : Float.toString(v) + 'f')) : (value2 == null ? "null" : String.valueOf(value2)))));
        }
        return newExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/ConstantExpressionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/ConstantExpressionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ComputeConstantValueFix
    implements LocalQuickFix {
        private final String myText;
        private final String myValueText;

        ComputeConstantValueFix(PsiExpression expression2, String valueText) {
            this.myText = PsiExpressionTrimRenderer.render((PsiExpression)expression2);
            this.myValueText = valueText;
        }

        @Nls
        @NotNull
        public String getName() {
            if (this.myValueText.length() > 50) {
                String string = InspectionGadgetsBundle.message("inspection.constant.expression.fix.name", this.myText);
                if (string == null) {
                    ComputeConstantValueFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("inspection.constant.expression.fix.name.with.value", this.myText, this.myValueText);
            if (string == null) {
                ComputeConstantValueFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.constant.expression.fix.family.name", new Object[0]);
            if (string == null) {
                ComputeConstantValueFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                ComputeConstantValueFix.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                ComputeConstantValueFix.$$$reportNull$$$0(4);
            }
            PsiExpression expression2 = (PsiExpression)descriptor2.getStartElement();
            Object value2 = ExpressionUtils.computeConstantExpression(expression2);
            String newExpression = ConstantExpressionInspection.getValueText(value2);
            PsiReplacementUtil.replaceExpression(expression2, newExpression, new CommentTracker());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/ConstantExpressionInspection$ComputeConstantValueFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/ConstantExpressionInspection$ComputeConstantValueFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

