/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaCanBeReplacedWithAnonymousInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance(LambdaCanBeReplacedWithAnonymousInspection.class);

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.can.be.replaced.with.anonymous.name", new Object[0]);
        if (string == null) {
            LambdaCanBeReplacedWithAnonymousInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = this.getDisplayName();
        if (string == null) {
            LambdaCanBeReplacedWithAnonymousInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LambdaToAnonymousVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new LambdaToAnonymousFix();
    }

    private static void doFix(@NotNull Project project, @NotNull PsiLambdaExpression lambdaExpression) {
        if (project == null) {
            LambdaCanBeReplacedWithAnonymousInspection.$$$reportNull$$$0(2);
        }
        if (lambdaExpression == null) {
            LambdaCanBeReplacedWithAnonymousInspection.$$$reportNull$$$0(3);
        }
        PsiParameter[] paramListCopy = ((PsiParameterList)lambdaExpression.getParameterList().copy()).getParameters();
        PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
        LOG.assertTrue(functionalInterfaceType != null);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        LOG.assertTrue(method != null);
        String blockText = LambdaCanBeReplacedWithAnonymousInspection.getBodyText(lambdaExpression);
        if (blockText == null) {
            return;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiCodeBlock blockFromText = psiElementFactory.createCodeBlockFromText(blockText, (PsiElement)lambdaExpression);
        LambdaCanBeReplacedWithAnonymousInspection.qualifyThisExpressions(lambdaExpression, psiElementFactory, blockFromText);
        blockFromText = psiElementFactory.createCodeBlockFromText(blockFromText.getText(), null);
        PsiNewExpression newExpression = (PsiNewExpression)psiElementFactory.createExpressionFromText("new " + functionalInterfaceType.getCanonicalText() + "(){}", (PsiElement)lambdaExpression);
        newExpression = (PsiNewExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(lambdaExpression.replace((PsiElement)newExpression));
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        LOG.assertTrue(anonymousClass != null);
        List<PsiGenerationInfo<PsiMethod>> infos = OverrideImplementUtil.overrideOrImplement((PsiClass)anonymousClass, method);
        if (infos.size() == 1) {
            PsiCodeBlock codeBlock;
            PsiMethod member = infos.get(0).getPsiMember();
            PsiParameter[] parameters2 = member.getParameterList().getParameters();
            if (parameters2.length == paramListCopy.length) {
                for (int i = 0; i < parameters2.length; ++i) {
                    PsiParameter parameter2 = parameters2[i];
                    String lambdaParamName = paramListCopy[i].getName();
                    if (lambdaParamName == null) continue;
                    parameter2.setName(lambdaParamName);
                }
            }
            LOG.assertTrue((codeBlock = member.getBody()) != null);
            codeBlock.replace((PsiElement)blockFromText);
            PsiElement parent = anonymousClass.getParent().getParent();
            if (parent instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)parent))) {
                PsiExpression operand2 = ((PsiTypeCastExpression)parent).getOperand();
                LOG.assertTrue(operand2 != null);
                parent.replace((PsiElement)operand2);
            }
        }
    }

    private static void qualifyThisExpressions(PsiLambdaExpression lambdaExpression, PsiElementFactory psiElementFactory, PsiCodeBlock blockFromText) {
        String thisClassName;
        ChangeContextUtil.encodeContextInfo((PsiElement)blockFromText, true);
        PsiClass thisClass = RefactoringChangeUtil.getThisClass((PsiElement)lambdaExpression);
        String string = thisClassName = thisClass != null && !(thisClass instanceof PsiSyntheticClass) ? thisClass.getName() : null;
        if (thisClassName != null) {
            final PsiThisExpression thisAccessExpr = RefactoringChangeUtil.createThisExpression(lambdaExpression.getManager(), thisClass);
            ChangeContextUtil.decodeContextInfo((PsiElement)blockFromText, thisClass, (PsiExpression)thisAccessExpr);
            final HashSet replacements = new HashSet();
            blockFromText.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitClass(PsiClass aClass) {
                }

                public void visitSuperExpression(PsiSuperExpression expression2) {
                    super.visitSuperExpression(expression2);
                    if (expression2.getQualifier() == null) {
                        replacements.add(expression2);
                    }
                }

                public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                    super.visitMethodCallExpression(expression2);
                    if (thisAccessExpr != null) {
                        PsiMethod psiMethod = expression2.resolveMethod();
                        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
                        if (psiMethod != null && !psiMethod.hasModifierProperty("static") && methodExpression.getQualifierExpression() == null) {
                            replacements.add(expression2);
                        }
                    }
                }
            });
            for (PsiExpression expression2 : replacements) {
                if (expression2 instanceof PsiSuperExpression) {
                    expression2.replace((PsiElement)psiElementFactory.createExpressionFromText(thisClassName + "." + expression2.getText(), (PsiElement)expression2));
                    continue;
                }
                if (expression2 instanceof PsiMethodCallExpression) {
                    ((PsiMethodCallExpression)expression2).getMethodExpression().setQualifierExpression((PsiExpression)thisAccessExpr);
                    continue;
                }
                LOG.error("Unexpected expression");
            }
        }
    }

    private static String getBodyText(PsiLambdaExpression lambdaExpression) {
        String blockText;
        PsiElement body2 = lambdaExpression.getBody();
        if (body2 instanceof PsiExpression) {
            PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression);
            blockText = "{\n";
            blockText = blockText + (PsiType.VOID.equals((Object)returnType) ? "" : "return ");
            blockText = blockText + body2.getText() + ";\n}";
        } else {
            blockText = body2 != null ? body2.getText() : null;
        }
        return blockText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/LambdaCanBeReplacedWithAnonymousInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/LambdaCanBeReplacedWithAnonymousInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LambdaToAnonymousFix
    extends InspectionGadgetsFix {
        private LambdaToAnonymousFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("lambda.can.be.replaced.with.anonymous.quickfix", new Object[0]);
            if (string == null) {
                LambdaToAnonymousFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement parent;
            PsiElement element = descriptor2.getStartElement();
            PsiElement psiElement = parent = element instanceof PsiLambdaExpression ? element : element.getParent();
            if (parent instanceof PsiLambdaExpression) {
                LambdaCanBeReplacedWithAnonymousInspection.doFix(project, (PsiLambdaExpression)parent);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaCanBeReplacedWithAnonymousInspection$LambdaToAnonymousFix", "getFamilyName"));
        }
    }

    private static class LambdaToAnonymousVisitor
    extends BaseInspectionVisitor {
        private LambdaToAnonymousVisitor() {
        }

        public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
            super.visitLambdaExpression(lambdaExpression);
            if (LambdaToAnonymousVisitor.isConvertibleLambdaExpression((PsiElement)lambdaExpression)) {
                PsiParameterList parameterList = lambdaExpression.getParameterList();
                PsiElement nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)parameterList);
                if (PsiUtil.isJavaToken((PsiElement)nextElement, (IElementType)JavaTokenType.ARROW)) {
                    if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)nextElement)) {
                        this.registerErrorAtRange((PsiElement)parameterList, nextElement, new Object[0]);
                    } else {
                        this.registerError((PsiElement)lambdaExpression, ProblemHighlightType.ERROR, new Object[0]);
                    }
                } else {
                    this.registerError((PsiElement)parameterList, new Object[0]);
                }
            }
        }

        private static boolean isConvertibleLambdaExpression(PsiElement parent) {
            if (parent instanceof PsiLambdaExpression) {
                PsiMethod interfaceMethod;
                PsiType functionalInterfaceType;
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)parent;
                PsiClass thisClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PsiClass.class, (boolean)true);
                if (thisClass == null || thisClass instanceof PsiAnonymousClass) {
                    PsiElement body2 = lambdaExpression.getBody();
                    if (body2 == null) {
                        return false;
                    }
                    final boolean[] disabled = new boolean[1];
                    body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitThisExpression(PsiThisExpression expression2) {
                            disabled[0] = true;
                        }

                        public void visitSuperExpression(PsiSuperExpression expression2) {
                            disabled[0] = true;
                        }
                    });
                    if (disabled[0]) {
                        return false;
                    }
                }
                if ((functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType()) != null && LambdaUtil.isFunctionalType((PsiType)functionalInterfaceType) && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType)) != null) {
                    PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType));
                    for (PsiType type2 : interfaceMethod.getSignature(substitutor).getParameterTypes()) {
                        if (PsiTypesUtil.isDenotableType((PsiType)type2, (PsiElement)parent)) continue;
                        return false;
                    }
                    PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
                    return PsiTypesUtil.isDenotableType((PsiType)returnType, (PsiElement)parent);
                }
            }
            return false;
        }
    }
}

