/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifiableIfStatementInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean DONT_WARN_ON_TERNARY = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.option.dont.warn.on.ternary", new Object[0]), (InspectionProfileEntry)this, "DONT_WARN_ON_TERNARY");
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.display.name", new Object[0]);
        if (string == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(1);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitIfStatement(PsiIfStatement ifStatement) {
                boolean infoLevel;
                ReplaceIfWithConditionalModel model = ReplaceIfWithConditionalModel.from(ifStatement);
                if (model == null) {
                    return;
                }
                String operator2 = model.getTargetOperator();
                if (operator2.isEmpty()) {
                    return;
                }
                boolean bl = infoLevel = SimplifiableIfStatementInspection.this.DONT_WARN_ON_TERNARY && operator2.equals("?:");
                if (!isOnTheFly && infoLevel) {
                    return;
                }
                holder.registerProblem(ifStatement.getFirstChild(), InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.message", operator2), infoLevel ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new SimplifiableIfStatementFix(operator2)});
            }
        };
        if (javaElementVisitor == null) {
            SimplifiableIfStatementInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/SimplifiableIfStatementInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/SimplifiableIfStatementInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ReplaceIfWithConditionalModel {
        @NotNull
        final PsiExpression myCondition;
        @NotNull
        final PsiExpression myThenExpression;
        @NotNull
        final PsiExpression myElseExpression;
        @NotNull
        final PsiStatement myThenBranch;
        @NotNull
        final PsiStatement myElseBranch;
        @NotNull
        final PsiType myType;

        ReplaceIfWithConditionalModel(@NotNull PsiExpression condition2, @NotNull PsiExpression thenExpression2, @NotNull PsiExpression elseExpression2, @NotNull PsiStatement thenBranch, @NotNull PsiStatement elseBranch, @NotNull PsiType type2) {
            if (condition2 == null) {
                ReplaceIfWithConditionalModel.$$$reportNull$$$0(0);
            }
            if (thenExpression2 == null) {
                ReplaceIfWithConditionalModel.$$$reportNull$$$0(1);
            }
            if (elseExpression2 == null) {
                ReplaceIfWithConditionalModel.$$$reportNull$$$0(2);
            }
            if (thenBranch == null) {
                ReplaceIfWithConditionalModel.$$$reportNull$$$0(3);
            }
            if (elseBranch == null) {
                ReplaceIfWithConditionalModel.$$$reportNull$$$0(4);
            }
            if (type2 == null) {
                ReplaceIfWithConditionalModel.$$$reportNull$$$0(5);
            }
            this.myCondition = condition2;
            this.myThenExpression = thenExpression2;
            this.myElseExpression = elseExpression2;
            this.myThenBranch = thenBranch;
            this.myElseBranch = elseBranch;
            this.myType = type2;
        }

        @NotNull
        String getTargetOperator() {
            if (PsiType.BOOLEAN.equals((Object)this.myType)) {
                Boolean value2;
                Boolean elseValue;
                PsiLiteralExpression thenLiteral = ExpressionUtils.getLiteral(this.myThenExpression);
                PsiLiteralExpression elseLiteral = ExpressionUtils.getLiteral(this.myElseExpression);
                Boolean thenValue = thenLiteral == null ? null : (Boolean)ObjectUtils.tryCast((Object)thenLiteral.getValue(), Boolean.class);
                Boolean bl = elseValue = elseLiteral == null ? null : (Boolean)ObjectUtils.tryCast((Object)elseLiteral.getValue(), Boolean.class);
                if (thenValue != null && elseValue != null) {
                    if ("" == null) {
                        ReplaceIfWithConditionalModel.$$$reportNull$$$0(6);
                    }
                    return "";
                }
                Boolean bl2 = value2 = thenValue == null ? elseValue : thenValue;
                if (value2 != null) {
                    String string = value2 != false ? "||" : "&&";
                    if (string == null) {
                        ReplaceIfWithConditionalModel.$$$reportNull$$$0(7);
                    }
                    return string;
                }
            }
            if ("?:" == null) {
                ReplaceIfWithConditionalModel.$$$reportNull$$$0(8);
            }
            return "?:";
        }

        String buildExpressionText(CommentTracker ct) {
            PsiExpression condition2 = ParenthesesUtils.stripParentheses(this.myCondition);
            PsiExpression thenValue = ParenthesesUtils.stripParentheses(this.myThenExpression);
            PsiExpression elseValue = ParenthesesUtils.stripParentheses(this.myElseExpression);
            thenValue = ReplaceIfWithConditionalModel.expandDiamondsWhenNeeded(thenValue, this.myType);
            elseValue = ReplaceIfWithConditionalModel.expandDiamondsWhenNeeded(elseValue, this.myType);
            if (thenValue == null || elseValue == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals((Object)this.myType)) {
                Boolean elseBoolean;
                PsiLiteralExpression thenLiteral = ExpressionUtils.getLiteral(thenValue);
                PsiLiteralExpression elseLiteral = ExpressionUtils.getLiteral(elseValue);
                Boolean thenBoolean = thenLiteral == null ? null : (Boolean)ObjectUtils.tryCast((Object)thenLiteral.getValue(), Boolean.class);
                Boolean bl = elseBoolean = elseLiteral == null ? null : (Boolean)ObjectUtils.tryCast((Object)elseLiteral.getValue(), Boolean.class);
                if (thenBoolean != null) {
                    return thenBoolean != false ? ReplaceIfWithConditionalModel.joinConditions(condition2, elseValue, false, ct) : BoolUtils.getNegatedExpressionText(condition2, 13, ct) + "&&" + ct.text(elseValue, 13);
                }
                if (elseBoolean != null) {
                    return elseBoolean != false ? BoolUtils.getNegatedExpressionText(condition2, 14, ct) + "||" + ct.text(thenValue, 14) : ReplaceIfWithConditionalModel.joinConditions(condition2, thenValue, true, ct);
                }
            }
            StringBuilder conditional = new StringBuilder();
            String conditionText = ct.text(condition2, 15);
            if (condition2 instanceof PsiConditionalExpression) {
                conditional.append('(').append(conditionText).append(')');
            } else {
                conditional.append(conditionText);
            }
            conditional.append('?');
            PsiType thenType = thenValue.getType();
            PsiType elseType = elseValue.getType();
            if (thenType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)thenType) && !(elseType instanceof PsiPrimitiveType) && !(this.myType instanceof PsiPrimitiveType)) {
                PsiPrimitiveType primitiveType = (PsiPrimitiveType)thenType;
                conditional.append(primitiveType.getBoxedTypeName());
                conditional.append(".valueOf(").append(ct.text((PsiElement)thenValue)).append("):");
                conditional.append(ct.text(elseValue, 15));
            } else if (elseType instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)elseType) && !(thenType instanceof PsiPrimitiveType) && !(this.myType instanceof PsiPrimitiveType)) {
                conditional.append(ct.text(thenValue, 15));
                conditional.append(':');
                PsiPrimitiveType primitiveType = (PsiPrimitiveType)elseType;
                conditional.append(primitiveType.getBoxedTypeName());
                conditional.append(".valueOf(").append(ct.text((PsiElement)elseValue)).append(')');
            } else {
                conditional.append(ct.text(thenValue, 15));
                conditional.append(':');
                conditional.append(ct.text(elseValue, 15));
            }
            return conditional.toString();
        }

        static ReplaceIfWithConditionalModel from(PsiIfStatement ifStatement) {
            ReplaceIfWithConditionalModel model = ReplaceIfWithConditionalModel.extractFromAssignment(ifStatement);
            if (model != null) {
                return model;
            }
            model = ReplaceIfWithConditionalModel.extractFromImplicitReturn(ifStatement);
            if (model != null) {
                return model;
            }
            model = ReplaceIfWithConditionalModel.extractFromReturn(ifStatement);
            if (model != null) {
                return model;
            }
            return ReplaceIfWithConditionalModel.extractFromMethodCall(ifStatement);
        }

        @Nullable
        private static ReplaceIfWithConditionalModel extractFromAssignment(PsiIfStatement ifStatement) {
            IElementType elseTokenType;
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return null;
            }
            PsiExpressionStatement thenBranch = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), PsiExpressionStatement.class);
            PsiExpressionStatement elseBranch = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getElseBranch()), PsiExpressionStatement.class);
            if (thenBranch == null || elseBranch == null) {
                return null;
            }
            PsiAssignmentExpression thenExpression2 = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)thenBranch.getExpression(), PsiAssignmentExpression.class);
            PsiAssignmentExpression elseExpression2 = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)elseBranch.getExpression(), PsiAssignmentExpression.class);
            if (thenExpression2 == null || elseExpression2 == null) {
                return null;
            }
            PsiExpression thenRhs = thenExpression2.getRExpression();
            PsiExpression elseRhs = elseExpression2.getRExpression();
            if (thenRhs == null || elseRhs == null) {
                return null;
            }
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenRhs, elseRhs)) {
                return null;
            }
            IElementType thenTokenType = thenExpression2.getOperationTokenType();
            if (!thenTokenType.equals(elseTokenType = elseExpression2.getOperationTokenType())) {
                return null;
            }
            PsiExpression thenLhs = thenExpression2.getLExpression();
            PsiExpression elseLhs = elseExpression2.getLExpression();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenLhs, elseLhs)) {
                return null;
            }
            PsiType type2 = thenLhs.getType();
            if (type2 == null) {
                return null;
            }
            return new ReplaceIfWithConditionalModel(condition2, thenRhs, elseRhs, (PsiStatement)thenBranch, (PsiStatement)elseBranch, type2);
        }

        @Nullable
        private static ReplaceIfWithConditionalModel extractFromReturn(PsiIfStatement ifStatement) {
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return null;
            }
            PsiReturnStatement thenBranch = (PsiReturnStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), PsiReturnStatement.class);
            PsiReturnStatement elseBranch = (PsiReturnStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getElseBranch()), PsiReturnStatement.class);
            return ReplaceIfWithConditionalModel.extractFromReturn(condition2, thenBranch, elseBranch);
        }

        @Nullable
        private static ReplaceIfWithConditionalModel extractFromImplicitReturn(PsiIfStatement ifStatement) {
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return null;
            }
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiReturnStatement thenBranch = (PsiReturnStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), PsiReturnStatement.class);
            PsiReturnStatement nextReturnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ifStatement), PsiReturnStatement.class);
            return ReplaceIfWithConditionalModel.extractFromReturn(condition2, thenBranch, nextReturnStatement);
        }

        @Contract(value="_, null, _ -> null; _, !null, null -> null")
        @Nullable
        private static ReplaceIfWithConditionalModel extractFromReturn(PsiExpression condition2, PsiReturnStatement thenBranch, PsiReturnStatement elseBranch) {
            if (thenBranch == null || elseBranch == null) {
                return null;
            }
            PsiExpression thenReturn = thenBranch.getReturnValue();
            if (thenReturn == null) {
                return null;
            }
            PsiExpression elseReturn = elseBranch.getReturnValue();
            if (elseReturn == null) {
                return null;
            }
            PsiType thenType = thenReturn.getType();
            PsiType elseType = elseReturn.getType();
            if (thenType == null || elseType == null) {
                return null;
            }
            PsiType type2 = PsiTypesUtil.getMethodReturnType((PsiElement)thenReturn);
            if (type2 == null) {
                return null;
            }
            if (!thenType.isAssignableFrom(elseType) && !elseType.isAssignableFrom(thenType)) {
                if (!(thenType instanceof PsiClassType) || !(elseType instanceof PsiClassType)) {
                    return null;
                }
                if (TypeConversionUtil.isPrimitiveWrapper((PsiType)thenType) || TypeConversionUtil.isPrimitiveWrapper((PsiType)elseType)) {
                    return null;
                }
                PsiType leastUpperBound = GenericsUtil.getLeastUpperBound((PsiType)thenType, (PsiType)elseType, (PsiManager)condition2.getManager());
                if (leastUpperBound == null || !type2.isAssignableFrom(leastUpperBound)) {
                    return null;
                }
            }
            return new ReplaceIfWithConditionalModel(condition2, thenReturn, elseReturn, (PsiStatement)thenBranch, (PsiStatement)elseBranch, type2);
        }

        @Nullable
        private static ReplaceIfWithConditionalModel extractFromMethodCall(PsiIfStatement ifStatement) {
            PsiExpression[] elseArguments;
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return null;
            }
            PsiExpressionStatement thenBranch = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getThenBranch()), PsiExpressionStatement.class);
            PsiExpressionStatement elseBranch = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(ifStatement.getElseBranch()), PsiExpressionStatement.class);
            if (thenBranch == null || elseBranch == null) {
                return null;
            }
            PsiMethodCallExpression thenCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)thenBranch.getExpression(), PsiMethodCallExpression.class);
            PsiMethodCallExpression elseCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)elseBranch.getExpression(), PsiMethodCallExpression.class);
            if (thenCall == null || elseCall == null) {
                return null;
            }
            PsiReferenceExpression thenMethodExpression = thenCall.getMethodExpression();
            PsiReferenceExpression elseMethodExpression = elseCall.getMethodExpression();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)thenMethodExpression, (PsiExpression)elseMethodExpression)) {
                return null;
            }
            PsiMethod thenMethod = thenCall.resolveMethod();
            PsiMethod elseMethod = elseCall.resolveMethod();
            if (thenMethod == null || elseMethod == null || !thenMethod.equals(elseMethod)) {
                return null;
            }
            PsiExpression[] thenArguments = thenCall.getArgumentList().getExpressions();
            if (thenArguments.length != (elseArguments = elseCall.getArgumentList().getExpressions()).length) {
                return null;
            }
            PsiParameter[] parameterList = thenMethod.getParameterList().getParameters();
            if (parameterList.length > thenArguments.length) {
                return null;
            }
            boolean vararg = MethodCallUtils.isVarArgCall(thenCall);
            if (vararg != MethodCallUtils.isVarArgCall(elseCall)) {
                return null;
            }
            if (!vararg && parameterList.length != thenArguments.length) {
                return null;
            }
            ReplaceIfWithConditionalModel model = null;
            for (int i = 0; i < thenArguments.length; ++i) {
                PsiExpression thenArgument = thenArguments[i];
                PsiExpression elseArgument = elseArguments[i];
                if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenArgument, elseArgument)) continue;
                if (model != null) {
                    return null;
                }
                int lastParameter = parameterList.length - 1;
                PsiType type2 = vararg && i >= lastParameter ? ((PsiEllipsisType)parameterList[lastParameter].getType()).getComponentType() : parameterList[i].getType();
                model = new ReplaceIfWithConditionalModel(condition2, thenArgument, elseArgument, (PsiStatement)thenBranch, (PsiStatement)elseBranch, type2);
            }
            return model;
        }

        private static PsiExpression expandDiamondsWhenNeeded(PsiExpression thenValue, PsiType requiredType) {
            if (thenValue instanceof PsiNewExpression && !PsiDiamondTypeUtil.canChangeContextForDiamond((PsiNewExpression)thenValue, requiredType)) {
                return PsiDiamondTypeUtil.expandTopLevelDiamondsInside(thenValue);
            }
            return thenValue;
        }

        @NotNull
        private static String joinConditions(PsiExpression left, PsiExpression right, boolean isAnd, CommentTracker ct) {
            IElementType tokenType;
            String token;
            int precedence;
            if (isAnd) {
                precedence = 13;
                token = "&&";
                tokenType = JavaTokenType.ANDAND;
            } else {
                precedence = 14;
                token = "||";
                tokenType = JavaTokenType.OROR;
            }
            PsiPolyadicExpression leftPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)left), PsiPolyadicExpression.class);
            PsiPolyadicExpression rightPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)right), PsiPolyadicExpression.class);
            if (rightPolyadic != null && rightPolyadic.getOperationTokenType().equals(tokenType) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ArrayUtil.getFirstElement((Object[])rightPolyadic.getOperands()), left) && !SideEffectChecker.mayHaveSideEffects(left)) {
                String string = ct.text((PsiElement)rightPolyadic);
                if (string == null) {
                    ReplaceIfWithConditionalModel.$$$reportNull$$$0(9);
                }
                return string;
            }
            if (leftPolyadic != null && leftPolyadic.getOperationTokenType().equals(tokenType) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)ArrayUtil.getLastElement((Object[])leftPolyadic.getOperands()), right) && !SideEffectChecker.mayHaveSideEffects(right)) {
                String string = ct.text((PsiElement)leftPolyadic);
                if (string == null) {
                    ReplaceIfWithConditionalModel.$$$reportNull$$$0(10);
                }
                return string;
            }
            String string = ct.text(left, precedence) + token + ct.text(right, precedence);
            if (string == null) {
                ReplaceIfWithConditionalModel.$$$reportNull$$$0(11);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseExpression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thenBranch";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elseBranch";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/SimplifiableIfStatementInspection$ReplaceIfWithConditionalModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/SimplifiableIfStatementInspection$ReplaceIfWithConditionalModel";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetOperator";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "joinConditions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SimplifiableIfStatementFix
    implements LocalQuickFix {
        private final String myOperator;

        SimplifiableIfStatementFix(String operator2) {
            this.myOperator = operator2;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.fix.name", this.myOperator);
            if (string == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.simplifiable.if.statement.fix.family.name", new Object[0]);
            if (string == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiIfStatement ifStatement;
            if (project == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                SimplifiableIfStatementFix.$$$reportNull$$$0(3);
            }
            if ((ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getStartElement(), PsiIfStatement.class)) == null) {
                return;
            }
            ReplaceIfWithConditionalModel model = ReplaceIfWithConditionalModel.from(ifStatement);
            if (model == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String conditional = model.buildExpressionText(commentTracker);
            if (conditional == null) {
                return;
            }
            commentTracker.replace((PsiElement)model.myThenExpression, conditional);
            if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)model.myElseBranch, (boolean)true)) {
                commentTracker.delete((PsiElement)model.myElseBranch);
            }
            PsiElement result = commentTracker.replaceAndRestoreComments((PsiElement)ifStatement, (PsiElement)model.myThenBranch);
            SimplifiableIfStatementFix.tryJoinDeclaration(result);
        }

        private static void tryJoinDeclaration(PsiElement result) {
            if (!(result instanceof PsiExpressionStatement)) {
                return;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)result).getExpression(), PsiAssignmentExpression.class);
            if (assignment == null) {
                return;
            }
            if (!assignment.getOperationTokenType().equals(JavaTokenType.EQ)) {
                return;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
            if (ref == null) {
                return;
            }
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)result), PsiDeclarationStatement.class);
            if (declaration2 == null) {
                return;
            }
            PsiElement[] elements = declaration2.getDeclaredElements();
            if (elements.length != 1) {
                return;
            }
            PsiLocalVariable var = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class);
            if (var == null || var.getInitializer() != null || !ref.isReferenceTo((PsiElement)var)) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            var.setInitializer((PsiExpression)ct.markUnchanged((PsiElement)Objects.requireNonNull(assignment.getRExpression())));
            ct.deleteAndRestoreComments(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/SimplifiableIfStatementInspection$SimplifiableIfStatementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/SimplifiableIfStatementInspection$SimplifiableIfStatementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

