/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.fixes.IgnoreClassFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.ui.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SizeReplaceableByIsEmptyInspection
extends BaseInspection {
    public boolean ignoreNegations = false;
    public OrderedSet<String> ignoredTypes = new OrderedSet();

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("size.replaceable.by.isempty.display.name", new Object[0]);
        if (string == null) {
            SizeReplaceableByIsEmptyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("expression.can.be.replaced.problem.descriptor", infos[0]);
        if (string == null) {
            SizeReplaceableByIsEmptyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        ListTable table = new ListTable(new ListWrappingTableModel(this.ignoredTypes, InspectionGadgetsBundle.message("ignored.classes.table", new Object[0])));
        JPanel tablePanel = UiUtils.createAddRemoveTreeClassChooserPanel(table, InspectionGadgetsBundle.message("choose.class.type.to.ignore", new Object[0]), new String[0]);
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("size.replaceable.by.isempty.negation.ignore.option", new Object[0]), (InspectionProfileEntry)this, "ignoreNegations");
        panel.add((Component)tablePanel, "Center");
        panel.add((Component)checkBox, "South");
        return panel;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        String name2;
        SmartList result = new SmartList();
        PsiExpression expression2 = (PsiExpression)infos[1];
        String methodName = (String)infos[2];
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
        if (aClass != null && (name2 = aClass.getQualifiedName()) != null) {
            result.add(new IgnoreClassFix(name2, (Collection<? super String>)this.ignoredTypes, "Ignore '." + methodName + "()' calls on type '" + name2 + "'"));
        }
        result.add(new SizeReplaceableByIsEmptyFix());
        InspectionGadgetsFix[] inspectionGadgetsFixArray = result.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
        if (inspectionGadgetsFixArray == null) {
            SizeReplaceableByIsEmptyInspection.$$$reportNull$$$0(2);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SizeReplaceableByIsEmptyVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/SizeReplaceableByIsEmptyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SizeReplaceableByIsEmptyVisitor
    extends BaseInspectionVisitor {
        private SizeReplaceableByIsEmptyVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            boolean flipped;
            super.visitBinaryExpression(expression2);
            if (!ComparisonUtils.isComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getROperand());
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getLOperand());
            if (lhs instanceof PsiMethodCallExpression) {
                flipped = false;
            } else if (rhs instanceof PsiMethodCallExpression) {
                flipped = true;
            } else {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)(flipped ? rhs : lhs);
            String isEmptyCall = null;
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"size".equals(referenceName) && !"length".equals(referenceName)) {
                return;
            }
            if (!callExpression.getArgumentList().isEmpty()) {
                return;
            }
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 == null) {
                return;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierExpression2.getType());
            if (aClass == null || PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)callExpression, (boolean)true)) {
                return;
            }
            for (String ignoredType : SizeReplaceableByIsEmptyInspection.this.ignoredTypes) {
                if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)ignoredType)) continue;
                return;
            }
            for (PsiMethod method : aClass.findMethodsByName("isEmpty", true)) {
                PsiParameterList parameterList = method.getParameterList();
                if (!parameterList.isEmpty()) continue;
                isEmptyCall = qualifierExpression2.getText() + ".isEmpty()";
                break;
            }
            if (isEmptyCall == null) {
                return;
            }
            Object object = ExpressionUtils.computeConstantExpression(flipped ? lhs : rhs);
            if (!(object instanceof Integer) || (Integer)object != 0) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (JavaTokenType.EQEQ.equals(tokenType)) {
                this.registerError((PsiElement)expression2, isEmptyCall, qualifierExpression2, referenceName);
            }
            if (SizeReplaceableByIsEmptyInspection.this.ignoreNegations) {
                return;
            }
            if (JavaTokenType.NE.equals(tokenType)) {
                this.registerError((PsiElement)expression2, '!' + isEmptyCall, qualifierExpression2, referenceName);
            } else if (flipped) {
                if (JavaTokenType.LT.equals(tokenType)) {
                    this.registerError((PsiElement)expression2, '!' + isEmptyCall, qualifierExpression2, referenceName);
                }
            } else if (JavaTokenType.GT.equals(tokenType)) {
                this.registerError((PsiElement)expression2, '!' + isEmptyCall, qualifierExpression2, referenceName);
            }
        }
    }

    protected static class SizeReplaceableByIsEmptyFix
    extends InspectionGadgetsFix {
        protected SizeReplaceableByIsEmptyFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"isEmpty()"});
            if (string == null) {
                SizeReplaceableByIsEmptyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)descriptor2.getPsiElement();
            PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getLOperand());
            if (!(operand2 instanceof PsiMethodCallExpression)) {
                operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getROperand());
            }
            if (!(operand2 instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String newExpression = commentTracker.text((PsiElement)qualifierExpression2);
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.EQEQ.equals(tokenType)) {
                newExpression = '!' + newExpression;
            }
            newExpression = newExpression + ".isEmpty()";
            PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SizeReplaceableByIsEmptyInspection$SizeReplaceableByIsEmptyFix", "getFamilyName"));
        }
    }
}

