/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnnecessarilyQualifiedStaticallyImportedElementInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.statically.imported.element.display.name", new Object[0]);
        if (string == null) {
            UnnecessarilyQualifiedStaticallyImportedElementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMember member = (PsiMember)infos[0];
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.statically.imported.element.problem.descriptor", member.getName());
        if (string == null) {
            UnnecessarilyQualifiedStaticallyImportedElementInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessarilyQualifiedStaticallyImportedElementFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarilyQualifiedStaticallyImportedElementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessarilyQualifiedStaticallyImportedElementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessarilyQualifiedStaticallyImportedElementVisitor
    extends BaseInspectionVisitor {
        private UnnecessarilyQualifiedStaticallyImportedElementVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            if (ImportUtils.isAlreadyStaticallyImported(reference)) {
                this.registerError(Objects.requireNonNull(reference.getQualifier()), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{reference.resolve()});
            }
        }
    }

    private static class UnnecessarilyQualifiedStaticallyImportedElementFix
    extends InspectionGadgetsFix {
        private UnnecessarilyQualifiedStaticallyImportedElementFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessarily.qualified.statically.imported.element.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarilyQualifiedStaticallyImportedElementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement element = descriptor2.getPsiElement();
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarilyQualifiedStaticallyImportedElementInspection$UnnecessarilyQualifiedStaticallyImportedElementFix", "getFamilyName"));
        }
    }
}

