/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryThisInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreAssignments = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.this.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryThisInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.this.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryThisInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.this.ignore.assignments.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAssignments");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryThisFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryThisVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryThisInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryThisVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryThisVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            if (expression2 == null) {
                UnnecessaryThisVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression2);
            PsiReferenceParameterList parameterList = expression2.getParameterList();
            if (parameterList == null) {
                return;
            }
            if (parameterList.getTypeArguments().length > 0) {
                return;
            }
            PsiExpression qualifierExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getQualifierExpression());
            if (!(qualifierExpression2 instanceof PsiThisExpression)) {
                return;
            }
            PsiThisExpression thisExpression = (PsiThisExpression)qualifierExpression2;
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            String referenceName = expression2.getReferenceName();
            if (referenceName == null) {
                return;
            }
            if (UnnecessaryThisInspection.this.ignoreAssignments && PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
                return;
            }
            PsiElement parent = expression2.getParent();
            if (qualifier == null) {
                if (parent instanceof PsiCallExpression) {
                    this.registerError((PsiElement)qualifierExpression2, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                    return;
                }
                PsiElement target = expression2.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                if (!DeclarationSearchUtils.variableNameResolvesToTarget(referenceName, variable, (PsiElement)expression2)) {
                    return;
                }
                if (variable instanceof PsiField && HighlightUtil.isIllegalForwardReferenceToField(expression2, (PsiField)variable, true) != null) {
                    return;
                }
                this.registerError((PsiElement)thisExpression, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
            } else {
                String qualifierName = qualifier.getReferenceName();
                if (qualifierName == null) {
                    return;
                }
                if (parent instanceof PsiCallExpression) {
                    PsiCallExpression callExpression = (PsiCallExpression)parent;
                    PsiMethod calledMethod = callExpression.resolveMethod();
                    if (calledMethod == null) {
                        return;
                    }
                    String methodName = calledMethod.getName();
                    PsiClass parentClass = ClassUtils.getContainingClass((PsiElement)expression2);
                    Project project = expression2.getProject();
                    JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                    PsiResolveHelper resolveHelper = psiFacade.getResolveHelper();
                    while (parentClass != null) {
                        PsiMethod[] methods;
                        if (qualifierName.equals(parentClass.getName())) {
                            this.registerError((PsiElement)thisExpression, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                        }
                        for (PsiMethod method : methods = parentClass.findMethodsByName(methodName, true)) {
                            PsiClass containingClass = method.getContainingClass();
                            if (!resolveHelper.isAccessible((PsiMember)method, (PsiElement)expression2, null) || method.hasModifierProperty("private") && !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)expression2, (boolean)true)) continue;
                            return;
                        }
                        parentClass = ClassUtils.getContainingClass((PsiElement)parentClass);
                    }
                } else {
                    PsiElement target = expression2.resolve();
                    if (!(target instanceof PsiVariable)) {
                        return;
                    }
                    PsiVariable variable = (PsiVariable)target;
                    if (!DeclarationSearchUtils.variableNameResolvesToTarget(referenceName, variable, (PsiElement)expression2)) {
                        return;
                    }
                    PsiClass parentClass = ClassUtils.getContainingClass((PsiElement)expression2);
                    while (parentClass != null) {
                        PsiField field;
                        if (qualifierName.equals(parentClass.getName())) {
                            this.registerError((PsiElement)thisExpression, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                        }
                        if ((field = parentClass.findFieldByName(referenceName, true)) != null) {
                            return;
                        }
                        parentClass = ClassUtils.getContainingClass((PsiElement)parentClass);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/UnnecessaryThisInspection$UnnecessaryThisVisitor", "visitReferenceExpression"));
        }
    }

    private static class UnnecessaryThisFix
    extends InspectionGadgetsFix {
        private UnnecessaryThisFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.this.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryThisFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) {
            PsiElement thisToken = descriptor2.getPsiElement();
            PsiReferenceExpression thisExpression = (PsiReferenceExpression)PsiUtil.skipParenthesizedExprUp((PsiElement)thisToken.getParent());
            assert (thisExpression != null);
            String newExpression = thisExpression.getReferenceName();
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)thisExpression, newExpression, new CommentTracker());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryThisInspection$UnnecessaryThisFix", "getFamilyName"));
        }
    }
}

