/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddThisQualifierFix;
import org.jetbrains.annotations.NotNull;

public class UnqualifiedMethodAccessInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unqualified.method.access.display.name", new Object[0]);
        if (string == null) {
            UnqualifiedMethodAccessInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnqualifiedMethodAccessVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unqualified.method.access.problem.descriptor", new Object[0]);
        if (string == null) {
            UnqualifiedMethodAccessInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiReferenceExpression expressionToQualify = (PsiReferenceExpression)infos[0];
        PsiMethod methodAccessed = (PsiMethod)infos[1];
        return AddThisQualifierFix.buildFix((PsiExpression)expressionToQualify, (PsiMember)methodAccessed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnqualifiedMethodAccessInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnqualifiedMethodAccessVisitor
    extends BaseInspectionVisitor {
        private UnqualifiedMethodAccessVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            if (methodExpression.getQualifierExpression() != null) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null || method.isConstructor() || method.hasModifierProperty("static")) {
                return;
            }
            this.registerError((PsiElement)methodExpression, methodExpression, method);
        }
    }
}

