/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.style.Variance;
import com.siyeh.ig.style.VarianceCandidate;
import org.jetbrains.annotations.NotNull;

class VarianceUtil {
    VarianceUtil() {
    }

    @NotNull
    private static Variance getMethodSignatureVariance(@NotNull PsiMethod method, @NotNull PsiTypeParameter typeParameter) {
        if (method == null) {
            VarianceUtil.$$$reportNull$$$0(0);
        }
        if (typeParameter == null) {
            VarianceUtil.$$$reportNull$$$0(1);
        }
        PsiTypeParameterListOwner owner2 = typeParameter.getOwner();
        PsiClass methodClass = method.getContainingClass();
        if (methodClass == null || !(owner2 instanceof PsiClass)) {
            Variance variance = Variance.INVARIANT;
            if (variance == null) {
                VarianceUtil.$$$reportNull$$$0(2);
            }
            return variance;
        }
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)methodClass, (PsiClass)((PsiClass)owner2), (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (superClassSubstitutor == null) {
            Variance variance = Variance.INVARIANT;
            if (variance == null) {
                VarianceUtil.$$$reportNull$$$0(3);
            }
            return variance;
        }
        Variance r = Variance.NOVARIANT;
        for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
            PsiType type2 = parameter2.getType();
            if (VarianceUtil.typeResolvesTo(type2, typeParameter, superClassSubstitutor)) {
                r = Variance.CONTRAVARIANT;
                continue;
            }
            if (!VarianceUtil.containsDeepIn(type2, typeParameter, superClassSubstitutor, false)) continue;
            Variance variance = Variance.INVARIANT;
            if (variance == null) {
                VarianceUtil.$$$reportNull$$$0(4);
            }
            return variance;
        }
        PsiType returnType = method.getReturnType();
        if (returnType != null && !TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)returnType)) {
            if (VarianceUtil.typeResolvesTo(returnType, typeParameter, superClassSubstitutor)) {
                r = r.combine(Variance.COVARIANT);
            } else if (!VarianceUtil.isComposeMethod(method, returnType, typeParameter, superClassSubstitutor) && VarianceUtil.containsDeepIn(returnType, typeParameter, superClassSubstitutor, false)) {
                r = Variance.INVARIANT;
            }
        }
        Variance variance = r;
        if (variance == null) {
            VarianceUtil.$$$reportNull$$$0(5);
        }
        return variance;
    }

    private static boolean isComposeMethod(@NotNull PsiMethod method, @NotNull PsiType returnType, @NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor superClassSubstitutor) {
        PsiClass containingClass;
        if (method == null) {
            VarianceUtil.$$$reportNull$$$0(6);
        }
        if (returnType == null) {
            VarianceUtil.$$$reportNull$$$0(7);
        }
        if (typeParameter == null) {
            VarianceUtil.$$$reportNull$$$0(8);
        }
        if (superClassSubstitutor == null) {
            VarianceUtil.$$$reportNull$$$0(9);
        }
        if ((containingClass = method.getContainingClass()) == null || !(returnType instanceof PsiClassType) || !containingClass.equals(((PsiClassType)returnType).resolve())) {
            return false;
        }
        PsiTypeParameterListOwner typeParameterOwner = typeParameter.getOwner();
        PsiTypeParameterList typeParameterList = typeParameterOwner == null ? null : typeParameterOwner.getTypeParameterList();
        int index = typeParameterList == null ? -1 : typeParameterList.getTypeParameterIndex(typeParameter);
        PsiType[] parameters2 = ((PsiClassType)returnType).getParameters();
        if (index == -1 || parameters2.length <= index) {
            return false;
        }
        return VarianceUtil.typeResolvesTo(parameters2[index], typeParameter, superClassSubstitutor);
    }

    static boolean containsDeepIn(@NotNull PsiType rootType, final @NotNull PsiTypeParameter parameter2, final @NotNull PsiSubstitutor superClassSubstitutor, final boolean ignoreWildcardT) {
        if (rootType == null) {
            VarianceUtil.$$$reportNull$$$0(10);
        }
        if (parameter2 == null) {
            VarianceUtil.$$$reportNull$$$0(11);
        }
        if (superClassSubstitutor == null) {
            VarianceUtil.$$$reportNull$$$0(12);
        }
        return (Boolean)rootType.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

            @NotNull
            public Boolean visitClassType(PsiClassType classType) {
                for (PsiType param : classType.getParameters()) {
                    if (!((Boolean)param.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                    Boolean bl = true;
                    if (bl == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return bl;
                }
                Boolean bl = this.visitType((PsiType)classType);
                if (bl == null) {
                    1.$$$reportNull$$$0(1);
                }
                return bl;
            }

            @NotNull
            public Boolean visitArrayType(PsiArrayType arrayType) {
                Boolean bl = (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
                if (bl == null) {
                    1.$$$reportNull$$$0(2);
                }
                return bl;
            }

            @NotNull
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    Boolean bl = false;
                    if (bl == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return bl;
                }
                if (ignoreWildcardT && VarianceUtil.typeResolvesTo(bound, parameter2, superClassSubstitutor)) {
                    Boolean bl = false;
                    if (bl == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return bl;
                }
                Boolean bl = (Boolean)bound.accept((PsiTypeVisitor)this);
                if (bl == null) {
                    1.$$$reportNull$$$0(5);
                }
                return bl;
            }

            @NotNull
            public Boolean visitType(PsiType type2) {
                Boolean bl = VarianceUtil.typeResolvesTo(type2, parameter2, superClassSubstitutor);
                if (bl == null) {
                    1.$$$reportNull$$$0(6);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/siyeh/ig/style/VarianceUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitClassType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitArrayType";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitWildcardType";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
    }

    static boolean typeResolvesTo(@NotNull PsiType type2, @NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor superClassSubstitutor) {
        PsiType substituted;
        if (type2 == null) {
            VarianceUtil.$$$reportNull$$$0(13);
        }
        if (typeParameter == null) {
            VarianceUtil.$$$reportNull$$$0(14);
        }
        if (superClassSubstitutor == null) {
            VarianceUtil.$$$reportNull$$$0(15);
        }
        if (!((substituted = superClassSubstitutor.substitute(type2)) instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult result = ((PsiClassType)substituted).resolveGenerics();
        return typeParameter.equals(result.getElement()) && result.getSubstitutor().equals(PsiSubstitutor.EMPTY);
    }

    @NotNull
    static Variance getClassVariance(@NotNull PsiClass aClass, @NotNull PsiTypeParameter typeParameter) {
        PsiMethod method;
        PsiClass containingClass;
        if (aClass == null) {
            VarianceUtil.$$$reportNull$$$0(16);
        }
        if (typeParameter == null) {
            VarianceUtil.$$$reportNull$$$0(17);
        }
        Variance result = Variance.NOVARIANT;
        PsiMethod[] psiMethodArray = aClass.getAllMethods();
        int n = psiMethodArray.length;
        for (int i = 0; i < n && ((containingClass = (method = psiMethodArray[i]).getContainingClass()) == null || "java.lang.Object".equals(containingClass.getQualifiedName()) || method.hasModifierProperty("static") || (result = result.combine(VarianceUtil.getMethodSignatureVariance(method, typeParameter))) != Variance.INVARIANT); ++i) {
        }
        Variance variance = result;
        if (variance == null) {
            VarianceUtil.$$$reportNull$$$0(18);
        }
        return variance;
    }

    static boolean wildCardIsUseless(@NotNull VarianceCandidate candidate, boolean isExtends) {
        PsiParameter[] parameters2;
        if (candidate == null) {
            VarianceUtil.$$$reportNull$$$0(19);
        }
        if (!(candidate.type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType type2 = (PsiClassType)candidate.type;
        PsiClassType.ClassResolveResult resolve = type2.resolveGenerics();
        PsiClass typeParameter = resolve.getElement();
        if (!(typeParameter instanceof PsiTypeParameter)) {
            return false;
        }
        PsiManager psiManager = typeParameter.getManager();
        if (!psiManager.areElementsEquivalent((PsiElement)((PsiTypeParameter)typeParameter).getOwner(), (PsiElement)candidate.method)) {
            return false;
        }
        PsiType returnType = candidate.method.getReturnType();
        if (returnType == null) {
            return true;
        }
        boolean returnContainsT = VarianceUtil.containsDeepIn(returnType, (PsiTypeParameter)typeParameter, resolve.getSubstitutor(), false);
        if (!isExtends && returnContainsT) {
            return false;
        }
        for (PsiParameter parameter2 : parameters2 = candidate.method.getParameterList().getParameters()) {
            PsiType parameterType;
            if (psiManager.areElementsEquivalent((PsiElement)candidate.methodParameter, (PsiElement)parameter2) || !VarianceUtil.containsDeepIn(parameterType = parameter2.getType(), (PsiTypeParameter)typeParameter, resolve.getSubstitutor(), true)) continue;
            if (!isExtends && !VarianceUtil.typeResolvesTo(parameterType, (PsiTypeParameter)typeParameter, resolve.getSubstitutor())) {
                return false;
            }
            if (!isExtends) continue;
            return false;
        }
        return !isExtends || VarianceUtil.typeResolvesTo(returnType, (PsiTypeParameter)typeParameter, resolve.getSubstitutor()) || !returnContainsT;
    }

    static boolean areBoundsSaturated(@NotNull VarianceCandidate candidate, boolean isExtends) {
        if (candidate == null) {
            VarianceUtil.$$$reportNull$$$0(20);
        }
        if (!(candidate.type instanceof PsiClassType)) {
            return true;
        }
        PsiClass aClass = ((PsiClassType)candidate.type).resolve();
        if (aClass == null) {
            return true;
        }
        if (isExtends) {
            return aClass.hasModifierProperty("final") || "java.lang.Object".equals(aClass.getQualifiedName());
        }
        return TypeUtils.isJavaLangObject(candidate.type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 8: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/VarianceUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassSubstitutor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/VarianceUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignatureVariance";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassVariance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodSignatureVariance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 18: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isComposeMethod";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsDeepIn";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "typeResolvesTo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClassVariance";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "wildCardIsUseless";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "areBoundsSaturated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

