/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AssertHint {
    private final int myArgIndex;
    private final boolean myMessageOnFirstPosition;
    private final PsiExpression myMessage;
    private final PsiMethod myMethod;

    private AssertHint(int index, boolean messageOnFirstPosition, PsiExpression message2, PsiMethod method) {
        this.myArgIndex = index;
        this.myMessageOnFirstPosition = messageOnFirstPosition;
        this.myMessage = message2;
        this.myMethod = method;
    }

    public boolean isMessageOnFirstPosition() {
        return this.myMessageOnFirstPosition;
    }

    public int getArgIndex() {
        return this.myArgIndex;
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    public PsiExpression getPosition(PsiExpression[] arguments) {
        return arguments[this.myArgIndex];
    }

    @Nullable
    public PsiExpression getMessage() {
        return this.myMessage;
    }

    public static AssertHint createAssertEqualsHint(PsiMethodCallExpression expression2, boolean checkTestNG) {
        return AssertHint.create(expression2, (? super String methodName) -> "assertEquals".equals(methodName) ? Integer.valueOf(2) : null, checkTestNG);
    }

    public static AssertHint createAssertTrueFalseHint(PsiMethodCallExpression expression2, boolean checkTestNG) {
        return AssertHint.create(expression2, (? super String methodName) -> "assertTrue".equals(methodName) || "assertFalse".equals(methodName) ? Integer.valueOf(1) : null, checkTestNG);
    }

    public static AssertHint create(PsiMethodCallExpression expression2, Function<? super String, Integer> methodNameToParamCount, boolean checkTestNG) {
        int argumentIndex;
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        Integer minimumParamCount = methodNameToParamCount.apply(methodName);
        if (minimumParamCount == null) {
            return null;
        }
        JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method == null || method.hasModifierProperty("private") || !resolveResult.isValidResult()) {
            return null;
        }
        boolean messageOnLastPosition = AssertHint.isMessageOnLastPosition(method, checkTestNG);
        boolean messageOnFirstPosition = AssertHint.isMessageOnFirstPosition(method, checkTestNG);
        if (!messageOnFirstPosition && !messageOnLastPosition) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        if (parameters2.length < minimumParamCount) {
            return null;
        }
        PsiExpressionList argumentList = expression2.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        PsiExpression message2 = null;
        if (messageOnFirstPosition) {
            if (parameters2.length > 0 && parameters2[0].getType().equalsToText("java.lang.String") && parameters2.length > minimumParamCount) {
                argumentIndex = 1;
                message2 = arguments[0];
            } else {
                argumentIndex = 0;
            }
        } else {
            int lastParameterIdx;
            argumentIndex = 0;
            if (parameters2.length > minimumParamCount && minimumParamCount >= 0 && parameters2[lastParameterIdx = parameters2.length - 1].getType() instanceof PsiClassType) {
                message2 = arguments[lastParameterIdx];
            }
        }
        return new AssertHint(argumentIndex, messageOnFirstPosition, message2, method);
    }

    public static AssertHint create(PsiMethodReferenceExpression methodExpression, Function<? super String, Integer> methodNameToParamCount, boolean checkTestNG) {
        String methodName = methodExpression.getReferenceName();
        Integer minimumParamCount = methodNameToParamCount.apply(methodName);
        if (minimumParamCount == null) {
            return null;
        }
        JavaResolveResult resolveResult = methodExpression.advancedResolve(false);
        PsiElement element = resolveResult.getElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)element;
        if (method.hasModifierProperty("private") || !resolveResult.isValidResult()) {
            return null;
        }
        boolean messageOnLastPosition = AssertHint.isMessageOnLastPosition(method, checkTestNG);
        boolean messageOnFirstPosition = AssertHint.isMessageOnFirstPosition(method, checkTestNG);
        if (!messageOnFirstPosition && !messageOnLastPosition) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        PsiParameter[] parameters2 = parameterList.getParameters();
        if (parameters2.length != minimumParamCount) {
            return null;
        }
        return new AssertHint(0, messageOnFirstPosition, null, method);
    }

    public static boolean isMessageOnFirstPosition(PsiMethod method, boolean checkTestNG) {
        PsiClass containingClass = method.getContainingClass();
        String qualifiedName = containingClass.getQualifiedName();
        if (checkTestNG) {
            return "org.testng.AssertJUnit".equals(qualifiedName) || "org.testng.Assert".equals(qualifiedName) && "fail".equals(method.getName());
        }
        return "junit.framework.Assert".equals(qualifiedName) || "org.junit.Assert".equals(qualifiedName) || "junit.framework.TestCase".equals(qualifiedName) || "org.junit.Assume".equals(qualifiedName);
    }

    public static boolean isMessageOnLastPosition(PsiMethod method, boolean checkTestNG) {
        PsiClass containingClass = method.getContainingClass();
        String qualifiedName = containingClass.getQualifiedName();
        if (checkTestNG) {
            return "org.testng.Assert".equals(qualifiedName) && !"fail".equals(method.getName());
        }
        return "org.junit.jupiter.api.Assertions".equals(qualifiedName) || "org.junit.jupiter.api.Assumptions".equals(qualifiedName);
    }

    public static String areExpectedActualTypesCompatible(PsiMethodCallExpression expression2, boolean checkTestNG) {
        int argIndex;
        AssertHint assertHint = AssertHint.createAssertEqualsHint(expression2, checkTestNG);
        if (assertHint == null) {
            return null;
        }
        PsiExpression[] arguments = expression2.getArgumentList().getExpressions();
        PsiType type1 = arguments[argIndex = assertHint.getArgIndex()].getType();
        if (type1 == null) {
            return null;
        }
        PsiType type2 = arguments[argIndex + 1].getType();
        if (type2 == null) {
            return null;
        }
        PsiParameter[] parameters2 = assertHint.getMethod().getParameterList().getParameters();
        PsiType parameterType1 = parameters2[argIndex].getType();
        PsiType parameterType2 = parameters2[argIndex + 1].getType();
        PsiClassType objectType = TypeUtils.getObjectType((PsiElement)expression2);
        if (!objectType.equals((Object)parameterType1) || !objectType.equals((Object)parameterType2)) {
            return null;
        }
        if (TypeUtils.areConvertible(type1, type2) || TypeUtils.mayBeEqualByContract(type1, type2)) {
            return null;
        }
        String comparedTypeText = type1.getPresentableText();
        String comparisonTypeText = type2.getPresentableText();
        return InspectionGadgetsBundle.message("assertequals.between.inconvertible.types.problem.descriptor", StringUtil.escapeXml((String)comparedTypeText), StringUtil.escapeXml((String)comparisonTypeText));
    }

    public static class JUnitCommonAssertNames {
        @NonNls
        public static final Map<String, Integer> ASSERT_METHOD_2_PARAMETER_COUNT;

        static {
            HashMap<String, Integer> map = new HashMap<String, Integer>(13);
            map.put("assertArrayEquals", 2);
            map.put("assertEquals", 2);
            map.put("assertNotEquals", 2);
            map.put("assertFalse", 1);
            map.put("assumeFalse", 1);
            map.put("assertNotNull", 1);
            map.put("assertNotSame", 2);
            map.put("assertNull", 1);
            map.put("assertSame", 2);
            map.put("assertThat", 2);
            map.put("assertTrue", 1);
            map.put("assumeTrue", 1);
            map.put("fail", 0);
            ASSERT_METHOD_2_PARAMETER_COUNT = Collections.unmodifiableMap(map);
        }
    }
}

