/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;

abstract class AbstractReplaceWithAnotherMethodCallFix
extends InspectionGadgetsFix {
    AbstractReplaceWithAnotherMethodCallFix() {
    }

    protected abstract String getMethodName();

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor2) {
        PsiElement methodNameElement = descriptor2.getPsiElement();
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)methodNameElement.getParent();
        assert (methodExpression != null);
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        CommentTracker commentTracker = new CommentTracker();
        if (qualifier == null) {
            PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, this.getMethodName(), commentTracker);
        } else {
            String qualifierText = commentTracker.text((PsiElement)qualifier);
            PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, qualifierText + '.' + this.getMethodName(), commentTracker);
        }
    }
}

