/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.threading.ThreadingUtils;
import java.util.function.Predicate;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhileLoopSpinsOnFieldInspection
extends BaseInspection {
    private static final CallMatcher THREAD_ON_SPIN_WAIT = CallMatcher.staticCall("java.lang.Thread", "onSpinWait");
    public boolean ignoreNonEmtpyLoops = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.display.name", new Object[0]);
        if (string == null) {
            WhileLoopSpinsOnFieldInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.problem.descriptor", new Object[0]);
        if (string == null) {
            WhileLoopSpinsOnFieldInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SpinLoopFix((PsiField)infos[0], (Boolean)infos[1]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("while.loop.spins.on.field.ignore.non.empty.loops.option", new Object[0]), (InspectionProfileEntry)this, "ignoreNonEmtpyLoops");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WhileLoopSpinsOnFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SpinLoopFix
    extends InspectionGadgetsFix {
        private final SmartPsiElementPointer<PsiField> myFieldPointer;
        private final String myFieldName;
        private final boolean myAddOnSpinWait;
        private final boolean myAddVolatile;

        SpinLoopFix(PsiField field, boolean addOnSpinWait) {
            this.myFieldPointer = SmartPointerManager.getInstance((Project)field.getProject()).createSmartPsiElementPointer((PsiElement)field);
            this.myFieldName = field.getName();
            this.myAddOnSpinWait = addOnSpinWait;
            this.myAddVolatile = !field.hasModifierProperty("volatile");
        }

        @Nls
        @NotNull
        public String getName() {
            if (this.myAddOnSpinWait && this.myAddVolatile) {
                String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.fix.volatile.spinwait", this.myFieldName);
                if (string == null) {
                    SpinLoopFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (this.myAddOnSpinWait) {
                String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.fix.spinwait", new Object[0]);
                if (string == null) {
                    SpinLoopFix.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.fix.volatile", this.myFieldName);
            if (string == null) {
                SpinLoopFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.fix.family.name", new Object[0]);
            if (string == null) {
                SpinLoopFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor2) {
            if (this.myAddVolatile) {
                SpinLoopFix.addVolatile((PsiField)this.myFieldPointer.getElement());
            }
            if (this.myAddOnSpinWait) {
                SpinLoopFix.addOnSpinWait(descriptor2.getStartElement());
            }
        }

        private static void addOnSpinWait(PsiElement element) {
            PsiLoopStatement loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class);
            if (loop == null) {
                return;
            }
            PsiStatement body2 = loop.getBody();
            if (body2 == null) {
                return;
            }
            PsiStatement spinCall = JavaPsiFacade.getElementFactory((Project)element.getProject()).createStatementFromText("java.lang.Thread.onSpinWait();", element);
            if (body2 instanceof PsiBlockStatement) {
                PsiCodeBlock block = ((PsiBlockStatement)body2).getCodeBlock();
                block.addAfter((PsiElement)spinCall, null);
            } else {
                BlockUtils.addBefore(body2, spinCall);
            }
            CodeStyleManager.getInstance((Project)element.getProject()).reformat((PsiElement)loop);
        }

        private static void addVolatile(PsiField field) {
            if (field == null) {
                return;
            }
            PsiModifierList list = field.getModifierList();
            if (list == null) {
                return;
            }
            list.setModifierProperty("volatile", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection$SpinLoopFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class WhileLoopSpinsOnFieldVisitor
    extends BaseInspectionVisitor {
        private WhileLoopSpinsOnFieldVisitor() {
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            boolean shouldAddSpinWait;
            PsiExpressionStatement onlyExpr;
            if (statement == null) {
                WhileLoopSpinsOnFieldVisitor.$$$reportNull$$$0(0);
            }
            super.visitWhileStatement(statement);
            PsiStatement body2 = statement.getBody();
            boolean empty = ControlFlowUtils.statementIsEmpty(body2);
            if (!(!WhileLoopSpinsOnFieldInspection.this.ignoreNonEmtpyLoops || empty || (onlyExpr = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(body2), PsiExpressionStatement.class)) != null && THREAD_ON_SPIN_WAIT.matches(onlyExpr.getExpression()))) {
                return;
            }
            PsiExpression condition2 = statement.getCondition();
            PsiField field = this.getFieldIfSimpleFieldComparison(condition2);
            if (field == null) {
                return;
            }
            if (body2 != null && (VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)body2) || this.containsCall((PsiElement)body2, ThreadingUtils::isWaitCall))) {
                return;
            }
            boolean java9 = PsiUtil.isLanguageLevel9OrHigher((PsiElement)field);
            boolean bl = shouldAddSpinWait = java9 && empty && !this.containsCall((PsiElement)body2, THREAD_ON_SPIN_WAIT);
            if (field.hasModifierProperty("volatile") && !shouldAddSpinWait) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, field, shouldAddSpinWait);
        }

        private boolean containsCall(@Nullable PsiElement element, final Predicate<? super PsiMethodCallExpression> predicate) {
            if (element == null) {
                return false;
            }
            final boolean[] result = new boolean[1];
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                    super.visitMethodCallExpression(expression2);
                    if (predicate.test(expression2)) {
                        result[0] = true;
                        this.stopWalking();
                    }
                }
            });
            return result[0];
        }

        @Nullable
        private PsiField getFieldIfSimpleFieldComparison(PsiExpression condition2) {
            PsiPrefixExpression prefixExpression;
            IElementType type2;
            if ((condition2 = PsiUtil.deparenthesizeExpression((PsiExpression)condition2)) == null) {
                return null;
            }
            PsiField field = this.getFieldIfSimpleFieldAccess(condition2);
            if (field != null) {
                return field;
            }
            if (condition2 instanceof PsiPrefixExpression && !(type2 = (prefixExpression = (PsiPrefixExpression)condition2).getOperationTokenType()).equals(JavaTokenType.PLUSPLUS) && !type2.equals(JavaTokenType.MINUSMINUS)) {
                PsiExpression operand2 = prefixExpression.getOperand();
                return this.getFieldIfSimpleFieldComparison(operand2);
            }
            if (condition2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
                PsiExpression lOperand = binaryExpression.getLOperand();
                PsiExpression rOperand = binaryExpression.getROperand();
                if (ExpressionUtils.isLiteral(rOperand)) {
                    return this.getFieldIfSimpleFieldComparison(lOperand);
                }
                if (ExpressionUtils.isLiteral(lOperand)) {
                    return this.getFieldIfSimpleFieldComparison(rOperand);
                }
                return null;
            }
            return null;
        }

        @Nullable
        private PsiField getFieldIfSimpleFieldAccess(PsiExpression expression2) {
            if ((expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)expression2)) == null) {
                return null;
            }
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression2;
            PsiExpression qualifierExpression2 = reference.getQualifierExpression();
            if (qualifierExpression2 != null) {
                return null;
            }
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)referent;
            if (field.hasModifierProperty("volatile") && !PsiUtil.isLanguageLevel9OrHigher((PsiElement)field)) {
                return null;
            }
            return field;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection$WhileLoopSpinsOnFieldVisitor", "visitWhileStatement"));
        }
    }
}

