/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.adapter;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.siyeh.ipp.base.PsiElementPredicate;

class AdapterToListenerPredicate
implements PsiElementPredicate {
    AdapterToListenerPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiJavaCodeReferenceElement[] implementsReferences;
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceList)) {
            return false;
        }
        PsiReferenceList referenceList = (PsiReferenceList)parent;
        if (PsiReferenceList.Role.EXTENDS_LIST != referenceList.getRole()) {
            return false;
        }
        PsiElement grandParent = referenceList.getParent();
        if (!(grandParent instanceof PsiClass)) {
            return false;
        }
        PsiJavaCodeReferenceElement[] referenceElements = referenceList.getReferenceElements();
        if (referenceElements.length != 1) {
            return false;
        }
        PsiJavaCodeReferenceElement referenceElement = referenceElements[0];
        PsiElement target = referenceElement.resolve();
        if (!(target instanceof PsiClass)) {
            return false;
        }
        PsiClass aClass = (PsiClass)target;
        String className = aClass.getName();
        if (!className.endsWith("Adapter")) {
            return false;
        }
        if (!aClass.hasModifierProperty("abstract")) {
            return false;
        }
        PsiReferenceList implementsList = aClass.getImplementsList();
        if (implementsList == null) {
            return false;
        }
        for (PsiJavaCodeReferenceElement implementsReference : implementsReferences = implementsList.getReferenceElements()) {
            PsiClass implementsClass;
            PsiElement implementsTarget;
            String name2 = implementsReference.getReferenceName();
            if (name2 == null || !name2.endsWith("Listener") || !((implementsTarget = implementsReference.resolve()) instanceof PsiClass) || !(implementsClass = (PsiClass)implementsTarget).isInterface()) continue;
            return true;
        }
        return false;
    }
}

