/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.ReverseForLoopDirectionPredicate;
import org.jetbrains.annotations.NotNull;

public class ReverseForLoopDirectionIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ReverseForLoopDirectionPredicate reverseForLoopDirectionPredicate = new ReverseForLoopDirectionPredicate();
        if (reverseForLoopDirectionPredicate == null) {
            ReverseForLoopDirectionIntention.$$$reportNull$$$0(0);
        }
        return reverseForLoopDirectionPredicate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processIntention(@NotNull PsiElement element) {
        IElementType tokenType;
        PsiForStatement forStatement;
        PsiDeclarationStatement initialization;
        if (element == null) {
            ReverseForLoopDirectionIntention.$$$reportNull$$$0(1);
        }
        if ((initialization = (PsiDeclarationStatement)(forStatement = (PsiForStatement)element.getParent()).getInitialization()) == null) {
            return;
        }
        PsiBinaryExpression condition2 = (PsiBinaryExpression)forStatement.getCondition();
        if (condition2 == null) {
            return;
        }
        PsiLocalVariable variable = (PsiLocalVariable)initialization.getDeclaredElements()[0];
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return;
        }
        PsiExpression lhs = condition2.getLOperand();
        PsiExpression rhs = condition2.getROperand();
        if (rhs == null) {
            return;
        }
        PsiExpressionStatement update2 = (PsiExpressionStatement)forStatement.getUpdate();
        if (update2 == null) {
            return;
        }
        PsiExpression updateExpression = update2.getExpression();
        String variableName = variable.getName();
        StringBuilder newUpdateText = new StringBuilder();
        if (updateExpression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)updateExpression;
            tokenType = prefixExpression.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS == tokenType) {
                newUpdateText.append("--");
            } else {
                if (JavaTokenType.MINUSMINUS != tokenType) return;
                newUpdateText.append("++");
            }
            newUpdateText.append(variableName);
        } else {
            if (!(updateExpression instanceof PsiPostfixExpression)) return;
            newUpdateText.append(variableName);
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)updateExpression;
            tokenType = postfixExpression.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS == tokenType) {
                newUpdateText.append("--");
            } else {
                if (JavaTokenType.MINUSMINUS != tokenType) return;
                newUpdateText.append("++");
            }
        }
        Project project = element.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        IElementType sign = condition2.getOperationTokenType();
        String negatedSign = ComparisonUtils.getNegatedComparison(sign);
        StringBuilder conditionText = new StringBuilder();
        StringBuilder newInitializerText = new StringBuilder();
        if (VariableAccessUtils.evaluatesToVariable(lhs, (PsiVariable)variable)) {
            conditionText.append(variableName);
            conditionText.append(negatedSign);
            if (sign == JavaTokenType.GE) {
                conditionText.append(ReverseForLoopDirectionIntention.incrementExpression(initializer, true));
            } else if (sign == JavaTokenType.LE) {
                conditionText.append(ReverseForLoopDirectionIntention.incrementExpression(initializer, false));
            } else {
                conditionText.append(initializer.getText());
            }
            if (sign == JavaTokenType.LT) {
                newInitializerText.append(ReverseForLoopDirectionIntention.incrementExpression(rhs, false));
            } else if (sign == JavaTokenType.GT) {
                newInitializerText.append(ReverseForLoopDirectionIntention.incrementExpression(rhs, true));
            } else {
                newInitializerText.append(rhs.getText());
            }
        } else {
            if (!VariableAccessUtils.evaluatesToVariable(rhs, (PsiVariable)variable)) return;
            if (sign == JavaTokenType.LE) {
                conditionText.append(ReverseForLoopDirectionIntention.incrementExpression(initializer, true));
            } else if (sign == JavaTokenType.GE) {
                conditionText.append(ReverseForLoopDirectionIntention.incrementExpression(initializer, false));
            } else {
                conditionText.append(initializer.getText());
            }
            conditionText.append(negatedSign);
            conditionText.append(variableName);
            if (sign == JavaTokenType.GT) {
                newInitializerText.append(ReverseForLoopDirectionIntention.incrementExpression(lhs, false));
            } else if (sign == JavaTokenType.LT) {
                newInitializerText.append(ReverseForLoopDirectionIntention.incrementExpression(lhs, true));
            } else {
                newInitializerText.append(lhs.getText());
            }
        }
        PsiExpression newInitializer = factory.createExpressionFromText(newInitializerText.toString(), element);
        variable.setInitializer(newInitializer);
        PsiExpression newCondition = factory.createExpressionFromText(conditionText.toString(), element);
        condition2.replace((PsiElement)newCondition);
        PsiExpression newUpdate = factory.createExpressionFromText(newUpdateText.toString(), element);
        updateExpression.replace((PsiElement)newUpdate);
    }

    private static String incrementExpression(PsiExpression expression2, boolean positive) {
        return JavaPsiMathUtil.add(expression2, positive ? 1 : -1, new CommentTracker());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/forloop/ReverseForLoopDirectionIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/forloop/ReverseForLoopDirectionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

