/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PathQuery;
import org.jetbrains.builtInWebServer.PrefixlessWebServerRootsProvider;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J*\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/builtInWebServer/ArtifactWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/PrefixlessWebServerRootsProvider;", "()V", "getPathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "resolve", "path", "", "resolver", "Lorg/jetbrains/builtInWebServer/FileResolver;", "pathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "intellij.java.compiler.impl"})
public final class ArtifactWebServerRootsProvider
extends PrefixlessWebServerRootsProvider {
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project, @NotNull FileResolver resolver, @NotNull PathQuery pathQuery) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        Intrinsics.checkParameterIsNotNull((Object)pathQuery, (String)"pathQuery");
        if (!pathQuery.getSearchInArtifacts()) {
            return null;
        }
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactManager, (String)"ArtifactManager.getInstance(project)");
        Artifact[] artifactArray = artifactManager.getArtifacts();
        int n = artifactArray.length;
        for (int i = 0; i < n; ++i) {
            VirtualFile root;
            Artifact artifact;
            Artifact artifact2 = artifact = artifactArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)artifact2, (String)"artifact");
            VirtualFile virtualFile = artifact2.getOutputFile();
            if (virtualFile == null) {
                continue;
            }
            VirtualFile virtualFile2 = root = virtualFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"root");
            return FileResolver.DefaultImpls.resolve$default((FileResolver)resolver, (String)path, (VirtualFile)virtualFile2, null, (boolean)false, (PathQuery)pathQuery, (int)12, null);
        }
        return null;
    }

    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactManager, (String)"ArtifactManager.getInstance(project)");
        Artifact[] artifactArray = artifactManager.getArtifacts();
        int n = artifactArray.length;
        for (int i = 0; i < n; ++i) {
            VirtualFile root;
            Artifact artifact;
            Artifact artifact2 = artifact = artifactArray[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)artifact2, (String)"artifact");
            if (artifact2.getOutputFile() == null) {
                continue;
            }
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) continue;
            VirtualFile virtualFile = root;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
            return new PathInfo(null, file, virtualFile, null, false, false, 56, null);
        }
        return null;
    }
}

