/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\b'\u0018\u0000 +2\u00020\u0001:\u0001+B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bH\u0002JM\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u001a\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001e\u0018\u00010\u001dH\u0000\u00a2\u0006\u0002\b\u001fJ\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\f0!H\u0002J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120\u000bJ\u0010\u0010$\u001a\u0004\u0018\u00010\f2\u0006\u0010%\u001a\u00020\"J\u0016\u0010&\u001a\u00020\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014J\u000e\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\"J\u000e\u0010*\u001a\u00020\b2\u0006\u0010%\u001a\u00020\"R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006,"}, d2={"Lcom/android/tools/lint/client/api/IssueRegistry;", "", "()V", "api", "", "getApi", "()I", "isUpToDate", "", "()Z", "issues", "", "Lcom/android/tools/lint/detector/api/Issue;", "getIssues", "()Ljava/util/List;", "minApi", "getMinApi", "createCategoryList", "Lcom/android/tools/lint/detector/api/Category;", "createDetectors", "Lcom/android/tools/lint/detector/api/Detector;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "scope", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "scopeToDetectors", "", "", "createDetectors$lint_api", "createIdToIssueMap", "", "", "getCategories", "getIssue", "id", "getIssueCapacity", "getIssuesForScope", "isCategoryName", "name", "isIssueId", "Companion", "lint-api"})
@Beta
public abstract class IssueRegistry {
    private final int api = -1;
    private final boolean isUpToDate = true;
    private static volatile List<Category> categories;
    private static volatile Map<String, Issue> idToIssue;
    private static Map<EnumSet<Scope>, List<Issue>> scopeIssues;
    private static final Implementation DUMMY_IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue PARSER_ERROR;
    @JvmField
    @NotNull
    public static final Issue LINT_ERROR;
    @JvmField
    @NotNull
    public static final Issue CANCELLED;
    @JvmField
    @NotNull
    public static final Issue BASELINE;
    @JvmField
    @NotNull
    public static final Issue OBSOLETE_LINT_CHECK;
    public static final Companion Companion;

    public int getApi() {
        return this.api;
    }

    public int getMinApi() {
        return this.getApi();
    }

    @NotNull
    public abstract List<Issue> getIssues();

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    protected int getIssueCapacity(@NotNull EnumSet<Scope> scope) {
        Intrinsics.checkParameterIsNotNull(scope, (String)"scope");
        return 20;
    }

    @NotNull
    protected List<Issue> getIssuesForScope(@NotNull EnumSet<Scope> scope) {
        Intrinsics.checkParameterIsNotNull(scope, (String)"scope");
        List list2 = (List)IssueRegistry.Companion.getScopeIssues().get(scope);
        if (list2 == null) {
            List issues = this.getIssues();
            if (Intrinsics.areEqual(scope, Scope.ALL)) {
                list2 = issues;
            } else {
                list2 = new ArrayList(this.getIssueCapacity(scope));
                for (Issue issue : issues) {
                    if (!issue.getImplementation().isAdequate(scope)) continue;
                    ((ArrayList)list2).add(issue);
                }
            }
            IssueRegistry.Companion.getScopeIssues().put(scope, list2);
        }
        return list2;
    }

    @NotNull
    public final List<Detector> createDetectors$lint_api(@NotNull LintClient client, @NotNull Configuration configuration, @NotNull EnumSet<Scope> scope, @Nullable Map<Scope, List<Detector>> scopeToDetectors) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(scope, (String)"scope");
        List<Issue> issues = this.getIssuesForScope(scope);
        if (issues.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        HashSet<Class<? extends Detector>> detectorClasses = new HashSet<Class<? extends Detector>>();
        HashMap detectorToScope = new HashMap();
        for (Issue issue : issues) {
            Class<? extends Detector> detectorClass;
            Implementation implementation = issue.getImplementation();
            Intrinsics.checkExpressionValueIsNotNull(implementation.getDetectorClass(), (String)"implementation.detectorClass");
            EnumSet<Scope> issueScope = implementation.getScope();
            if (!detectorClasses.contains(detectorClass)) {
                if (!configuration.isEnabled(issue)) continue;
                boolean bl = implementation.isAdequate(scope);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                detectorClass = client.replaceDetector(detectorClass);
                detectorClasses.add(detectorClass);
            }
            if (scopeToDetectors == null) continue;
            EnumSet s = (EnumSet)detectorToScope.get(detectorClass);
            if (s == null) {
                detectorToScope.put(detectorClass, issueScope);
                continue;
            }
            EnumSet<Scope> enumSet = issueScope;
            Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"issueScope");
            if (s.containsAll((Collection)enumSet)) continue;
            EnumSet union = EnumSet.copyOf(s);
            union.addAll(issueScope);
            detectorToScope.put(detectorClass, union);
        }
        ArrayList<Detector> detectors = new ArrayList<Detector>(detectorClasses.size());
        for (Class clazz : detectorClasses) {
            try {
                EnumSet union;
                Detector detector = (Detector)clazz.newInstance();
                detectors.add(detector);
                if (scopeToDetectors == null) continue;
                if ((EnumSet)detectorToScope.get(clazz) == null) {
                    continue;
                }
                for (Scope s : union) {
                    List list2 = scopeToDetectors.get((Object)s);
                    if (list2 == null) {
                        list2 = new ArrayList();
                        Scope scope2 = s;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)scope2), (String)"s");
                        scopeToDetectors.put(scope2, list2);
                    }
                    Detector detector2 = detector;
                    Intrinsics.checkExpressionValueIsNotNull((Object)detector2, (String)"detector");
                    list2.add(detector2);
                }
            }
            catch (Throwable t) {
                Object[] objectArray = new Object[1];
                Class clazz2 = clazz;
                Intrinsics.checkExpressionValueIsNotNull((Object)clazz2, (String)"clz");
                String string = clazz2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"clz.name");
                objectArray[0] = string;
                client.log(t, "Can't initialize detector %1$s", objectArray);
            }
        }
        return detectors;
    }

    public final boolean isIssueId(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return this.getIssue(id) != null;
    }

    public final boolean isCategoryName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        for (Category category : this.getCategories()) {
            if (!Intrinsics.areEqual((Object)category.getName(), (Object)name) && !Intrinsics.areEqual((Object)category.getFullName(), (Object)name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Category> getCategories() {
        List<Category> categories = IssueRegistry.Companion.getCategories();
        if (categories == null) {
            Class<IssueRegistry> clazz = IssueRegistry.class;
            synchronized (clazz) {
                categories = IssueRegistry.Companion.getCategories();
                if (categories == null) {
                    categories = Collections.unmodifiableList(this.createCategoryList());
                    IssueRegistry.Companion.setCategories(categories);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        List<Category> list2 = categories;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        return list2;
    }

    private final List<Category> createCategoryList() {
        HashSet categorySet = Sets.newHashSetWithExpectedSize((int)20);
        for (Issue issue : this.getIssues()) {
            categorySet.add(issue.getCategory());
        }
        ArrayList sorted = new ArrayList(categorySet);
        Collections.sort(sorted);
        return sorted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Issue getIssue(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Map<String, Issue> map = IssueRegistry.Companion.getIdToIssue();
        if (map == null) {
            Class<IssueRegistry> clazz = IssueRegistry.class;
            synchronized (clazz) {
                map = IssueRegistry.Companion.getIdToIssue();
                if (map == null) {
                    map = this.createIdToIssueMap();
                    IssueRegistry.Companion.setIdToIssue(map);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        Map<String, Issue> map2 = map;
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        return (Issue)map2.get(id);
    }

    private final Map<String, Issue> createIdToIssueMap() {
        List<Issue> issues = this.getIssues();
        HashMap map = Maps.newHashMapWithExpectedSize((int)(issues.size() + 2));
        for (Issue issue : issues) {
            map.put(issue.getId(), issue);
        }
        map.put(PARSER_ERROR.getId(), PARSER_ERROR);
        map.put(LINT_ERROR.getId(), LINT_ERROR);
        map.put(BASELINE.getId(), BASELINE);
        map.put(OBSOLETE_LINT_CHECK.getId(), OBSOLETE_LINT_CHECK);
        HashMap hashMap = map;
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"map");
        return hashMap;
    }

    protected IssueRegistry() {
    }

    static {
        Companion = new Companion(null);
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap()");
        scopeIssues = hashMap;
        DUMMY_IMPLEMENTATION = new Implementation(Detector.class, EnumSet.noneOf(Scope.class));
        PARSER_ERROR = Issue.Companion.create("ParserError", "Parser Errors", "Lint will ignore any files that contain fatal parsing errors. These may contain other errors, or contain code which affects issues in other files.", Category.LINT, 10, Severity.ERROR, IssueRegistry.Companion.getDUMMY_IMPLEMENTATION());
        LINT_ERROR = Issue.Companion.create("LintError", "Lint Failure", "This issue type represents a problem running lint itself. Examples include failure to find bytecode for source files (which means certain detectors could not be run), parsing errors in lint configuration files, etc.\nThese errors are not errors in your own code, but they are shown to make it clear that some checks were not completed.", Category.LINT, 10, Severity.ERROR, IssueRegistry.Companion.getDUMMY_IMPLEMENTATION());
        CANCELLED = Issue.Companion.create("LintCanceled", "Lint Canceled", "Lint canceled by user; the issue report may not be complete.", Category.LINT, 0, Severity.INFORMATIONAL, IssueRegistry.Companion.getDUMMY_IMPLEMENTATION());
        BASELINE = Issue.Companion.create("LintBaseline", "Baseline Issues", "Lint can be configured with a \"baseline\"; a set of current issues found in a codebase, which future runs of lint will silently ignore. Only new issues not found in the baseline are reported.\n\nNote that while opening files in the IDE, baseline issues are not filtered out; the purpose of baselines is to allow you to get started using lint and break the build on all newly introduced errors, without having to go back and fix the entire codebase up front. However, when you open up existing files you still want to be aware of and fix issues as you come across them.\n\nThis issue type is used to emit two types of informational messages in reports: first, whether any issues were filtered out so you don't have a false sense of security if you forgot that you've checked in a baseline file, and second, whether any issues in the baseline file appear to have been fixed such that you can stop filtering them out and get warned if the issues are re-introduced.", Category.LINT, 10, Severity.INFORMATIONAL, IssueRegistry.Companion.getDUMMY_IMPLEMENTATION());
        OBSOLETE_LINT_CHECK = Issue.Companion.create("ObsoleteLintCustomCheck", "Obsolete custom lint check", "Lint can be extended with \"custom checks\": additional checks implemented by developers and libraries to for example enforce specific API usages required by a library or a company coding style guideline.\n\nThe Lint APIs are not yet stable, so these checks may either cause a performance, degradation, or stop working, or provide wrong results.\n\nThis warning flags custom lint checks that are found to be using obsolete APIs and will need to be updated to run in the current lint environment.\nIt may also flag issues found to be using a **newer** version of the API, meaning that you need to use a newer version of lint (or Android Studio or Gradle plugin etc) to work with these checks.", Category.LINT, 10, Severity.WARNING, IssueRegistry.Companion.getDUMMY_IMPLEMENTATION());
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010!\u001a\u00020\"R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R,\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR2\u0010\u001b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000e0\u001cX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001a\u00a8\u0006#"}, d2={"Lcom/android/tools/lint/client/api/IssueRegistry$Companion;", "", "()V", "BASELINE", "Lcom/android/tools/lint/detector/api/Issue;", "CANCELLED", "DUMMY_IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getDUMMY_IMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "LINT_ERROR", "OBSOLETE_LINT_CHECK", "PARSER_ERROR", "categories", "", "Lcom/android/tools/lint/detector/api/Category;", "getCategories", "()Ljava/util/List;", "setCategories", "(Ljava/util/List;)V", "idToIssue", "", "", "getIdToIssue", "()Ljava/util/Map;", "setIdToIssue", "(Ljava/util/Map;)V", "scopeIssues", "", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "getScopeIssues", "setScopeIssues", "reset", "", "lint-api"})
    public static final class Companion {
        private final List<Category> getCategories() {
            return categories;
        }

        private final void setCategories(List<Category> list2) {
            categories = list2;
        }

        private final Map<String, Issue> getIdToIssue() {
            return idToIssue;
        }

        private final void setIdToIssue(Map<String, Issue> map) {
            idToIssue = map;
        }

        private final Map<EnumSet<Scope>, List<Issue>> getScopeIssues() {
            return scopeIssues;
        }

        private final void setScopeIssues(Map<EnumSet<Scope>, List<Issue>> map) {
            scopeIssues = map;
        }

        private final Implementation getDUMMY_IMPLEMENTATION() {
            return DUMMY_IMPLEMENTATION;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void reset() {
            Class<IssueRegistry> clazz = IssueRegistry.class;
            synchronized (clazz) {
                Companion.setIdToIssue(null);
                Companion.setCategories(null);
                HashMap hashMap = Maps.newHashMap();
                Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap()");
                Companion.setScopeIssues(hashMap);
                Unit unit = Unit.INSTANCE;
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$setScopeIssues$p(Companion $this, @NotNull Map map) {
            $this.setScopeIssues(map);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

