/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslCommandLineConfigurator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.ProcessOutputCatcher;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;

public class NodeCommandLineUtil {
    public static final String INSPECT = "--inspect";
    public static final String INSPECT_BRK = "--inspect-brk";
    public static final String INSPECT_EQ = "--inspect=";
    public static final String INSPECT_BRK_EQ = "--inspect-brk=";
    public static final String DEBUG = "--debug";
    public static final String DEBUG_BRK = "--debug-brk";
    public static final String DEBUG_EQ = "--debug=";
    public static final String DEBUG_BRK_EQ = "--debug-brk=";
    public static final String EXPOSE_DEBUG_AS_V8DEBUG = "--expose_debug_as=v8debug";
    private static final Key<Boolean> USE_WIP_CONNECTION = Key.create((String)"USE_WIP_CONNECTION");
    private static final Key<Boolean> USE_TERMINAL_CONSOLE = Key.create((String)"USE_TERMINAL_CONSOLE");

    private NodeCommandLineUtil() {
    }

    @NotNull
    public static ProcessOutput execute(@NotNull GeneralCommandLine commandLine, long timeoutMillis) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(0);
        }
        ProcessOutput processOutput = NodeCommandLineUtil.execute(commandLine, null, timeoutMillis);
        if (processOutput == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(1);
        }
        return processOutput;
    }

    @NotNull
    public static ProcessOutput execute(@NotNull GeneralCommandLine commandLine, @Nullable ProgressIndicator indicator, long timeoutMillis) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(2);
        }
        commandLine.setCharset(StandardCharsets.UTF_8);
        KillableColoredProcessHandler processHandler = NodeCommandLineUtil.createKillableColoredProcessHandler(commandLine, false);
        processHandler.setShouldDestroyProcessRecursively(true);
        processHandler.setShouldKillProcessSoftly(true);
        ProcessOutputCatcher outputCatcher = new ProcessOutputCatcher((BaseOSProcessHandler)processHandler);
        ProcessOutput processOutput = outputCatcher.run(indicator, timeoutMillis);
        if (processOutput == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(3);
        }
        return processOutput;
    }

    @NotNull
    public static KillableColoredProcessHandler createKillableColoredProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withSoftKillOnWindows) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(4);
        }
        boolean useWinp = SystemInfo.isWin10OrNewer || Registry.is((String)"nodejs.use.winp.on.older.windows.versions", (boolean)false);
        final boolean wsl = WslCommandLineConfigurator.isWslConfigured(commandLine);
        KillableColoredProcessHandler handler = new KillableColoredProcessHandler(commandLine, withSoftKillOnWindows && !useWinp){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = wsl ? BaseOutputReader.Options.BLOCKING : super.readerOptions();
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil$1", "readerOptions"));
            }
        };
        handler.setShouldKillProcessSoftlyWithWinP(withSoftKillOnWindows && useWinp);
        if (wsl) {
            WSLUtil.addInputCloseListener((ProcessHandler)handler);
        }
        KillableColoredProcessHandler killableColoredProcessHandler = handler;
        if (killableColoredProcessHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(5);
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    public static CapturingProcessHandler createCapturingProcessHandler(@NotNull GeneralCommandLine commandLine) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(6);
        }
        final boolean wsl = WslCommandLineConfigurator.isWslConfigured(commandLine);
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = wsl ? BaseOutputReader.Options.BLOCKING : super.readerOptions();
                if (options == null) {
                    2.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil$2", "readerOptions"));
            }
        };
        if (wsl) {
            WSLUtil.addInputCloseListener((ProcessHandler)handler);
        }
        CapturingProcessHandler capturingProcessHandler = handler;
        if (capturingProcessHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(7);
        }
        return capturingProcessHandler;
    }

    public static void configureUsefulEnvironment(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(8);
        }
        Map env = commandLine.getEnvironment();
        env.putIfAbsent("DEBUG_COLORS", "true");
        env.putIfAbsent("COLORTERM", "true");
        env.putIfAbsent("FORCE_COLOR", "true");
        env.putIfAbsent("npm_config_color", "always");
        env.putIfAbsent("MOCHA_COLORS", "1");
        env.putIfAbsent("ELECTRON_NO_ATTACH_CONSOLE", "true");
    }

    @Deprecated
    public static void addDebugParameters(@NotNull GeneralCommandLine commandLine, int debugPort) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(9);
        }
        if (debugPort > 0) {
            commandLine.addParameter(DEBUG_BRK_EQ + debugPort);
            commandLine.addParameter(EXPOSE_DEBUG_AS_V8DEBUG);
        }
    }

    @Deprecated
    public static void addNodeOptions(@NotNull GeneralCommandLine commandLine, @NotNull List<String> nodeOptions, int debugPort, @NotNull NodeJsInterpreter interpreter, boolean preferWipProtocol) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(10);
        }
        if (nodeOptions == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(11);
        }
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(12);
        }
        NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, nodeOptions, debugPort, true, interpreter, preferWipProtocol);
    }

    public static void addNodeOptionsForDebugging(@NotNull GeneralCommandLine commandLine, @NotNull List<String> nodeOptions, int debugPort, boolean breakAtStartOfUserScript, @NotNull NodeJsInterpreter interpreter, boolean preferWipProtocol) throws com.intellij.execution.ExecutionException {
        List<String> transformedOptions;
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(13);
        }
        if (nodeOptions == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(14);
        }
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(15);
        }
        NodeCommandLineUtil.useInspectorProtocol(commandLine, NodeCommandLineUtil.indexOfInspectOption(transformedOptions = NodeCommandLineUtil.transformNodeOptionsForDebugging(nodeOptions, debugPort, breakAtStartOfUserScript, interpreter, preferWipProtocol)) != -1);
        commandLine.addParameters(transformedOptions);
    }

    public static int indexOfInspectOption(@NotNull List<String> options) {
        if (options == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(16);
        }
        return ContainerUtil.indexOf(options, NodeCommandLineUtil::isInspectOption);
    }

    public static boolean shouldUseInspectorProtocol(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(17);
        }
        return Boolean.TRUE.equals(commandLine.getUserData(USE_WIP_CONNECTION));
    }

    public static void useInspectorProtocol(@NotNull GeneralCommandLine commandLine, boolean useInspectorProtocol) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(18);
        }
        commandLine.putUserData(USE_WIP_CONNECTION, (Object)useInspectorProtocol);
    }

    @NotNull
    private static List<String> transformNodeOptionsForDebugging(@NotNull List<String> nodeOptions, int debugPort, boolean breakAtStartOfUserScript, @NotNull NodeJsInterpreter interpreter, boolean preferInspectorProtocol) throws com.intellij.execution.ExecutionException {
        boolean useInspectorProtocol;
        if (nodeOptions == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(19);
        }
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(20);
        }
        if (debugPort == -1) {
            List<String> list = nodeOptions;
            if (list == null) {
                NodeCommandLineUtil.$$$reportNull$$$0(21);
            }
            return list;
        }
        boolean hasInspectOption = false;
        boolean hasV8DebugOption = false;
        ArrayList<String> resultOptions = new ArrayList<String>();
        for (String option : nodeOptions) {
            boolean isInspectOption = NodeCommandLineUtil.isInspectOption(option);
            hasInspectOption |= isInspectOption;
            boolean isV8DebugOption = NodeCommandLineUtil.isV8DebugOption(option);
            hasV8DebugOption |= isV8DebugOption;
            if (option == null || isInspectOption || isV8DebugOption) continue;
            resultOptions.add(option);
        }
        SemVer version = null;
        if (hasInspectOption) {
            useInspectorProtocol = true;
        } else if (hasV8DebugOption) {
            useInspectorProtocol = false;
        } else {
            if (NodeCommandLineUtil.shouldUseInspectorProtocolRegardlessOfVersion(interpreter)) {
                version = interpreter instanceof NodeJsRemoteInterpreter ? new SemVer("7.0.0", 7, 0, 0) : new SemVer("8.0.0", 8, 0, 0);
            } else {
                Promise<SemVer> versionPromise = interpreter.provideCachedVersionOrFetch();
                try {
                    version = (SemVer)versionPromise.blockingGet(1500, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    throw new com.intellij.execution.ExecutionException(e.getCause());
                }
                catch (TimeoutException e) {
                    throw new com.intellij.execution.ExecutionException((Throwable)e);
                }
            }
            boolean bl = version == null ? preferInspectorProtocol : (useInspectorProtocol = version.getMajor() >= 8 || version.getMajor() >= 7 && preferInspectorProtocol);
        }
        if (useInspectorProtocol) {
            if (breakAtStartOfUserScript) {
                if (version == null || version.isGreaterOrEqualThan(7, 6, 0)) {
                    resultOptions.add(INSPECT_BRK_EQ + debugPort);
                } else {
                    resultOptions.add(INSPECT_EQ + debugPort);
                    resultOptions.add(DEBUG_BRK);
                }
            } else {
                resultOptions.add(INSPECT_EQ + debugPort);
            }
        } else {
            resultOptions.add((breakAtStartOfUserScript ? DEBUG_BRK_EQ : DEBUG_EQ) + debugPort);
            resultOptions.add(EXPOSE_DEBUG_AS_V8DEBUG);
        }
        ArrayList<String> arrayList = resultOptions;
        if (arrayList == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    public static Vm initRemoteVmConnectionSync(@NotNull RemoteVmConnection<?> connection, int debugPort) throws com.intellij.execution.ExecutionException {
        Vm vm;
        if (connection == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(23);
        }
        InetAddress addr = NodeCommandLineUtil.getNodeLoopbackAddress();
        InetSocketAddress address = new InetSocketAddress(addr, debugPort);
        try {
            Promise vmPromise = connection.open(address);
            vm = (Vm)Objects.requireNonNull(vmPromise.blockingGet(30, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            throw new com.intellij.execution.ExecutionException("Cannot connect to VM " + address, (Throwable)e);
        }
        if (vm == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(24);
        }
        return vm;
    }

    @NotNull
    public static InetAddress getNodeLoopbackAddress() throws com.intellij.execution.ExecutionException {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByAddress("localhost", new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            throw new com.intellij.execution.ExecutionException("Cannot get 127.0.0.1 IPv4", (Throwable)e);
        }
        if (inetAddress == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(25);
        }
        return inetAddress;
    }

    private static boolean shouldUseInspectorProtocolRegardlessOfVersion(@NotNull NodeJsInterpreter interpreter) {
        if (interpreter == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(26);
        }
        return interpreter instanceof NodeJsRemoteInterpreter || interpreter instanceof NodeJsLocalInterpreter && ((NodeJsLocalInterpreter)interpreter).isElectron();
    }

    private static boolean isInspectOption(@Nullable String option) {
        if (option == null) {
            return false;
        }
        return option.equals(INSPECT) || option.equals(INSPECT_BRK) || option.startsWith(INSPECT_EQ) || option.startsWith(INSPECT_BRK_EQ);
    }

    private static boolean isV8DebugOption(@Nullable String option) {
        if (option == null) {
            return false;
        }
        return option.equals(DEBUG) || option.equals(DEBUG_BRK) || option.startsWith(DEBUG_EQ) || option.startsWith(DEBUG_BRK_EQ);
    }

    @NotNull
    public static OSProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, boolean withSoftKillOnWindows) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(27);
        }
        Object handler = commandLine instanceof PtyCommandLine && USE_TERMINAL_CONSOLE.get((UserDataHolder)commandLine) == Boolean.TRUE ? NodeCommandLineUtil.createTerminalProcessHandler(commandLine) : NodeCommandLineUtil.createKillableColoredProcessHandler(commandLine, withSoftKillOnWindows);
        NodeCommandLineUtil.transferUseInspectorProtocol(commandLine, (ProcessHandler)handler);
        KillableColoredProcessHandler killableColoredProcessHandler = handler;
        if (killableColoredProcessHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(28);
        }
        return killableColoredProcessHandler;
    }

    public static void transferUseInspectorProtocol(@NotNull GeneralCommandLine commandLine, @NotNull ProcessHandler createdProcessHandler) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(29);
        }
        if (createdProcessHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(30);
        }
        createdProcessHandler.putUserData(USE_WIP_CONNECTION, (Object)NodeCommandLineUtil.shouldUseInspectorProtocol(commandLine));
    }

    @NotNull
    private static OSProcessHandler createTerminalProcessHandler(@NotNull GeneralCommandLine commandLine) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(31);
        }
        OSProcessHandler processHandler = new OSProcessHandler(commandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = new BaseOutputReader.Options(){

                    public BaseDataReader.SleepingPolicy policy() {
                        return BaseDataReader.SleepingPolicy.BLOCKING;
                    }

                    public boolean splitToLines() {
                        return false;
                    }

                    public boolean withSeparators() {
                        return true;
                    }
                };
                if (options == null) {
                    3.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeCommandLineUtil$3", "readerOptions"));
            }
        };
        processHandler.putUserData(USE_TERMINAL_CONSOLE, (Object)true);
        OSProcessHandler oSProcessHandler = processHandler;
        if (oSProcessHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(32);
        }
        return oSProcessHandler;
    }

    public static boolean shouldUseTerminalConsole(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(33);
        }
        return USE_TERMINAL_CONSOLE.get((UserDataHolder)processHandler) == Boolean.TRUE && TerminalExecutionConsole.isAcceptable((ProcessHandler)processHandler);
    }

    @NotNull
    public static ConsoleView createConsole(@NotNull ProcessHandler processHandler, @NotNull Project project, boolean readOnly) {
        if (processHandler == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(34);
        }
        if (project == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(35);
        }
        if (NodeCommandLineUtil.shouldUseTerminalConsole(processHandler)) {
            TerminalExecutionConsole terminalExecutionConsole = new TerminalExecutionConsole(project, processHandler);
            if (terminalExecutionConsole == null) {
                NodeCommandLineUtil.$$$reportNull$$$0(36);
            }
            return terminalExecutionConsole;
        }
        ConsoleViewImpl consoleViewImpl = new ConsoleViewImpl(project, GlobalSearchScope.allScope((Project)project), readOnly, true);
        if (consoleViewImpl == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(37);
        }
        return consoleViewImpl;
    }

    public static boolean shouldUseWipConnection(@Nullable ProcessHandler processHandler) {
        return processHandler != null && Boolean.TRUE.equals(processHandler.getUserData(USE_WIP_CONNECTION));
    }

    public static String formatErrorMessage(@NotNull GeneralCommandLine commandLine, @NotNull ProcessOutput output) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(38);
        }
        if (output == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(39);
        }
        StringBuilder buf = new StringBuilder(commandLine.getCommandLineString());
        if (output.getStderr().length() > 0) {
            buf.append("\n\n");
            buf.append("Standard error:\n").append(output.getStderr());
        }
        if (output.getStdout().length() > 0) {
            buf.append("\n\n");
            buf.append("Standard output:\n").append(output.getStdout());
        }
        buf.append("\n\n");
        buf.append(IdeBundle.message((String)"finished.with.exit.code.text.message", (Object[])new Object[]{output.getExitCode()}));
        return buf.toString();
    }

    @NotNull
    public static GeneralCommandLine createCommandLine() {
        GeneralCommandLine generalCommandLine = NodeCommandLineUtil.createCommandLine(null);
        if (generalCommandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(40);
        }
        return generalCommandLine;
    }

    @NotNull
    public static GeneralCommandLine createCommandLine(@Nullable Boolean usePtyWithTerminalConsole) {
        if (usePtyWithTerminalConsole == Boolean.TRUE || usePtyWithTerminalConsole == null && Registry.is((String)"nodejs.console.use.terminal")) {
            PtyCommandLine commandLine = new PtyCommandLine();
            if (!SystemInfo.isWindows) {
                commandLine.getEnvironment().put("TERM", "xterm-256color");
            }
            commandLine.withConsoleMode(false);
            commandLine.withInitialColumns(120);
            commandLine.putUserData(USE_TERMINAL_CONSOLE, (Object)true);
            PtyCommandLine ptyCommandLine = commandLine;
            if (ptyCommandLine == null) {
                NodeCommandLineUtil.$$$reportNull$$$0(41);
            }
            return ptyCommandLine;
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        if (generalCommandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(42);
        }
        return generalCommandLine;
    }

    public static boolean isTerminalCommandLine(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            NodeCommandLineUtil.$$$reportNull$$$0(43);
        }
        return commandLine instanceof PtyCommandLine && USE_TERMINAL_CONSOLE.get((UserDataHolder)commandLine) == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeCommandLineUtil";
                break;
            }
            case 11: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeOptions";
                break;
            }
            case 12: 
            case 15: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdProcessHandler";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeCommandLineUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createKillableColoredProcessHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCapturingProcessHandler";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "transformNodeOptionsForDebugging";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "initRemoteVmConnectionSync";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeLoopbackAddress";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalProcessHandler";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createKillableColoredProcessHandler";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCapturingProcessHandler";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureUsefulEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addDebugParameters";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addNodeOptions";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addNodeOptionsForDebugging";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "indexOfInspectOption";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseInspectorProtocol";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "useInspectorProtocol";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "transformNodeOptionsForDebugging";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "initRemoteVmConnectionSync";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseInspectorProtocolRegardlessOfVersion";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "transferUseInspectorProtocol";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalProcessHandler";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseTerminalConsole";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isTerminalCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

