/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryUtil;
import com.intellij.javascript.nodejs.library.core.NodeCoreSourcesFetchSession;
import com.intellij.javascript.nodejs.library.core.NodeTypingsDownloader;
import com.intellij.javascript.nodejs.library.core.NodeTypingsInfo;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeCoreLibraryConfigurator {
    static final Logger LOG = Logger.getInstance(NodeCoreLibraryConfigurator.class);
    private static final String NODE_CORE_LIBRARY_CONFIGURED_VERSION = "javascript.nodejs.core.library.configured.version";
    private final Project myProject;
    private final NodeCoreLibraryManager myCoreLibraryManager;
    volatile List<VirtualFile> myTestCoreModuleFiles;

    public NodeCoreLibraryConfigurator(@NotNull Project project, @NotNull NodeCoreLibraryManager coreLibraryManager) {
        if (project == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(0);
        }
        if (coreLibraryManager == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myCoreLibraryManager = coreLibraryManager;
    }

    @NotNull
    public static NodeCoreLibraryConfigurator getInstance(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(2);
        }
        NodeCoreLibraryConfigurator nodeCoreLibraryConfigurator = (NodeCoreLibraryConfigurator)ServiceManager.getService((Project)project, NodeCoreLibraryConfigurator.class);
        if (nodeCoreLibraryConfigurator == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(3);
        }
        return nodeCoreLibraryConfigurator;
    }

    @Nullable
    public SemVer getConfiguredCoreLibraryVersion() {
        String value = this.getConfiguredCoreLibraryVersionStr();
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return null;
        }
        return SemVer.parseFromText((String)value);
    }

    @NotNull
    String getConfiguredCoreLibraryVersionStr() {
        String value = PropertiesComponent.getInstance((Project)this.myProject).getValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION);
        String string = StringUtil.notNullize((String)value);
        if (string == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void setCoreLibraryConfigured(@NotNull String version) {
        if (version == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(5);
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION, version, null);
    }

    @NotNull
    public NodeCoreLibraryManager getCoreLibraryManager() {
        NodeCoreLibraryManager nodeCoreLibraryManager = this.myCoreLibraryManager;
        if (nodeCoreLibraryManager == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(6);
        }
        return nodeCoreLibraryManager;
    }

    private void configure(@NotNull NodeJsInterpreter interpreter, @NotNull SemVer version, @NotNull List<VirtualFile> rootsToAssociateWith, @Nullable Runnable onDone) {
        if (interpreter == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(7);
        }
        if (version == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(8);
        }
        if (rootsToAssociateWith == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(9);
        }
        try {
            String versionStr = version.getRawVersion();
            File nodeVersionDir = NodeCoreLibraryConfigurator.getNodeVersionDir(versionStr);
            FileUtil.delete((File)nodeVersionDir);
            File coreModulesSrcDir = NodeCoreLibraryConfigurator.getCoreModulesSrcDir(versionStr);
            FileUtil.createDirectory((File)coreModulesSrcDir);
            File typingsDir = NodeCoreLibraryConfigurator.getTypingsDir(versionStr);
            FileUtil.createDirectory((File)typingsDir);
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            NodeTypingsDownloader downloader = new NodeTypingsDownloader(interpreter, version, NpmManager.getInstance(this.myProject).getPackage(interpreter), typingsDir);
            Future<NodeTypingsInfo> typingsInfoFuture = downloader.download(indicator);
            NodeCoreSourcesFetchSession session = new NodeCoreSourcesFetchSession(this.myProject, interpreter, coreModulesSrcDir);
            session.fetchSourcesSync();
            try {
                typingsInfoFuture.get(60L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOG.warn("Cannot download @types/node", (Throwable)e);
            }
            this.setCoreLibraryConfigured(versionStr);
            NodeCoreLibraryConfigurator.refresh(nodeVersionDir, () -> {
                if (rootsToAssociateWith == null) {
                    NodeCoreLibraryConfigurator.$$$reportNull$$$0(30);
                }
                this.scheduleLibrariesUpdate(true, rootsToAssociateWith, onDone);
            });
        }
        catch (ExecutionException | IOException e) {
            LOG.warn("Cannot configure Node.js Core library", e);
            this.scheduleLibrariesUpdate(false, rootsToAssociateWith, onDone);
        }
    }

    private static void refresh(@NotNull File nodeVersionDir, @NotNull Runnable finishRunnable) {
        if (nodeVersionDir == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(10);
        }
        if (finishRunnable == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(11);
        }
        TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
            if (nodeVersionDir == null) {
                NodeCoreLibraryConfigurator.$$$reportNull$$$0(27);
            }
            if (finishRunnable == null) {
                NodeCoreLibraryConfigurator.$$$reportNull$$$0(28);
            }
            WriteAction.run(() -> {
                VirtualFile nodeVersionVirtualDir;
                if (nodeVersionDir == null) {
                    NodeCoreLibraryConfigurator.$$$reportNull$$$0(29);
                }
                if ((nodeVersionVirtualDir = VfsUtil.findFileByIoFile((File)nodeVersionDir, (boolean)true)) == null) {
                    LOG.warn("Cannot find " + nodeVersionDir.getAbsolutePath() + ", refresh skipped");
                } else {
                    LOG.debug("Refreshing " + nodeVersionVirtualDir.getPath());
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{nodeVersionVirtualDir});
                }
            });
            finishRunnable.run();
        });
    }

    private void scheduleLibrariesUpdate(boolean success, @NotNull List<VirtualFile> rootsToAssociateWith, @Nullable Runnable onDone) {
        if (rootsToAssociateWith == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(12);
        }
        TransactionGuard.submitTransaction((Disposable)this.myProject, () -> {
            if (rootsToAssociateWith == null) {
                NodeCoreLibraryConfigurator.$$$reportNull$$$0(26);
            }
            WriteAction.run(() -> {
                boolean changed = NodeCoreLibraryUtil.removeOldLibraries(this.myProject);
                if (success || changed) {
                    JSLibraryManager.getInstance(this.myProject).commitChanges();
                }
            });
            if (success) {
                this.associateWith(rootsToAssociateWith);
                WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true));
            }
            if (onDone != null) {
                onDone.run();
            }
        });
    }

    private void associateWith(@NotNull List<VirtualFile> rootsToAssociateWith) {
        if (rootsToAssociateWith == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(13);
        }
        JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(this.myProject);
        for (VirtualFile root : rootsToAssociateWith) {
            libraryMappings.associate(root, "Node.js Core", true);
            LOG.info("Library 'Node.js Core' have been associated with " + (root == null ? "project" : root.getPath()));
        }
    }

    @NotNull
    static File getNodeVersionDir(@NotNull String versionStr) {
        if (versionStr == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(14);
        }
        File file2 = new File(JSUtils.getConfigJavaScriptDirPath() + File.separatorChar + "nodejs" + File.separatorChar + versionStr);
        if (file2 == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(15);
        }
        return file2;
    }

    @NotNull
    static File getCoreModulesSrcDir(@NotNull String versionStr) {
        if (versionStr == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(16);
        }
        File file2 = new File(NodeCoreLibraryConfigurator.getNodeVersionDir(versionStr), "core-modules");
        if (file2 == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(17);
        }
        return file2;
    }

    @NotNull
    static File getTypingsDir(@NotNull String versionStr) {
        if (versionStr == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(18);
        }
        File file2 = new File(NodeCoreLibraryConfigurator.getNodeVersionDir(versionStr), "node-typings");
        if (file2 == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(19);
        }
        return file2;
    }

    public void setCoreModulesForTests(VirtualFile ... testCoreModuleFiles) {
        if (testCoreModuleFiles == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(20);
        }
        this.myTestCoreModuleFiles = Arrays.asList(testCoreModuleFiles);
        JSLibraryManager.getInstance(this.myProject).commitChanges();
    }

    public void removeAllCoreModulesForTests() {
        this.myTestCoreModuleFiles = null;
        JSLibraryManager.getInstance(this.myProject).commitChanges();
    }

    public void configureAndAssociateWithProject(@NotNull NodeJsInterpreter interpreter, @NotNull SemVer version, @Nullable Runnable onDone) {
        if (interpreter == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(21);
        }
        if (version == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(22);
        }
        this.configureAndAssociateWith(interpreter, version, Collections.singletonList(null), onDone);
    }

    public void configureAndAssociateWith(final @NotNull NodeJsInterpreter interpreter, final @NotNull SemVer version, final @NotNull List<VirtualFile> rootsToAssociateWith, final @Nullable Runnable onDone) {
        if (interpreter == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(23);
        }
        if (version == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(24);
        }
        if (rootsToAssociateWith == null) {
            NodeCoreLibraryConfigurator.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        new Task.Backgroundable(this.myProject, "Configuring Node.js Coding Assistance...", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                NodeCoreLibraryConfigurator.this.configure(interpreter, version, rootsToAssociateWith, onDone);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryConfigurator$1", "run"));
            }
        }.queue();
    }

    public void disable() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String version = this.getConfiguredCoreLibraryVersionStr();
        if (StringUtil.isNotEmpty((String)version)) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                PropertiesComponent.getInstance((Project)this.myProject).unsetValue(NODE_CORE_LIBRARY_CONFIGURED_VERSION);
                JSLibraryManager.getInstance(this.myProject).commitChanges();
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 15: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 15: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLibraryManager";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryConfigurator";
                break;
            }
            case 5: 
            case 8: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 7: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 25: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToAssociateWith";
                break;
            }
            case 10: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeVersionDir";
                break;
            }
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishRunnable";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionStr";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCoreModuleFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryConfigurator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredCoreLibraryVersionStr";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoreLibraryManager";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeVersionDir";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoreModulesSrcDir";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypingsDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 15: 
            case 17: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCoreLibraryConfigured";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scheduleLibrariesUpdate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "associateWith";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNodeVersionDir";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCoreModulesSrcDir";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypingsDir";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setCoreModulesForTests";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "configureAndAssociateWithProject";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "configureAndAssociateWith";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleLibrariesUpdate$5";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$refresh$2";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$configure$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 15: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

