/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInjectionController {
    private static final String EXTERNAL_FRAGMENT = "EXTERNAL_FRAGMENT";
    public static final List<Class<? extends PsiElement>> ELEMENTS_TO_INJECT_IN = ContainerUtil.list((Object[])new Class[]{JSLiteralExpression.class});

    private JSInjectionController() {
    }

    public static boolean willInjectJs(@NotNull PsiElement host) {
        JSExpression[] args;
        PsiElement hostParent;
        JSReferenceExpression expression;
        JSQualifiedName name;
        if (host == null) {
            JSInjectionController.$$$reportNull$$$0(0);
        }
        JSQualifiedName jSQualifiedName = name = (expression = JSUtils.getMethodNameIfInsideCall(hostParent = host.getParent())) != null ? JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)expression) : null;
        return name != null && ("setInterval".equals(name.getName()) || "setTimeout".equals(name.getName())) && (name.getParent() == null || name.getParent().getParent() == null && "window".equals(name.getParent().getName())) && hostParent instanceof JSArgumentList && (args = ((JSArgumentList)hostParent).getArguments()).length > 0 && args[0] == host;
    }

    public static boolean willInjectCss(@NotNull PsiElement languageInjectionHost) {
        JSLiteralExpression jsLiteralExpression;
        if (languageInjectionHost == null) {
            JSInjectionController.$$$reportNull$$$0(1);
        }
        JSLiteralExpression jSLiteralExpression = jsLiteralExpression = languageInjectionHost instanceof JSLiteralExpression ? (JSLiteralExpression)languageInjectionHost : null;
        if (jsLiteralExpression == null) {
            return false;
        }
        if (JavaScriptReferenceContributor.isLiteralInCssContext((PsiElement)jsLiteralExpression, false)) {
            return JSInjectionController.checkValidAndNontrivialCss(JSInjectionController.getQuotedLiteralText(jsLiteralExpression));
        }
        return false;
    }

    private static boolean checkValidAndNontrivialCss(String text) {
        if (StringUtil.containsChar((String)text, (char)'?')) {
            return false;
        }
        if (StringUtil.containsChar((String)text, (char)'%')) {
            return false;
        }
        if (text.contains("##")) {
            return false;
        }
        if (StringUtil.containsChar((String)text, (char)'#')) {
            int diesIndex = text.indexOf(35);
            while (diesIndex == 0 || diesIndex > 0 && (text.charAt(diesIndex - 1) == '\'' || text.charAt(diesIndex - 1) != '=')) {
                diesIndex = text.indexOf(35, diesIndex + 1);
            }
            if (diesIndex >= 0) {
                return false;
            }
        }
        if (text.contains("[]")) {
            return false;
        }
        int eqPos = text.indexOf(61);
        if (eqPos != -1) {
            int valuePos;
            for (valuePos = eqPos + 1; valuePos < text.length() && Character.isWhitespace(text.charAt(valuePos)); ++valuePos) {
            }
            if (valuePos < text.length() && Character.isDigit(text.charAt(valuePos))) {
                return false;
            }
        }
        return !JavaScriptReferenceContributor.isSimpleCss(text);
    }

    public static boolean willInjectHtml(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionController.$$$reportNull$$$0(2);
        }
        if (DialectDetector.isActionScript(topElement)) {
            return false;
        }
        if (!topElement.textContains('<')) {
            return false;
        }
        String text = JSInjectionController.getConcatenationText(JSInjectionController.getConcatenationParts(topElement));
        int length = text.length();
        int tagStart = text.indexOf(60);
        return tagStart >= 0 && (tagStart < length - 1 && Character.isLetter(text.charAt(tagStart + 1)) || tagStart < length - 2 && text.charAt(tagStart + 1) == '/' && Character.isLetter(text.charAt(tagStart + 2)) || tagStart < length - 3 && text.charAt(tagStart + 1) == '!' && text.charAt(tagStart + 2) == '-' && text.charAt(tagStart + 3) == '-' || tagStart < length - 2 && text.charAt(tagStart + 1) == '!' && (text.charAt(tagStart + 2) == 'd' || text.charAt(tagStart + 2) == 'D')) && text.indexOf(62, tagStart) > 0 && !JSInjectionController.hasOuterLanguage(topElement);
    }

    protected static boolean hasOuterLanguage(PsiElement host) {
        final Ref result2 = Ref.create((Object)false);
        host.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof OuterLanguageElement) {
                    result2.set((Object)true);
                    this.stopWalking();
                    return;
                }
                super.visitElement(element);
            }
        });
        return (Boolean)result2.get();
    }

    @NotNull
    public static PsiElement getTopElement(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            JSInjectionController.$$$reportNull$$$0(3);
        }
        PsiLanguageInjectionHost parent = host;
        while (parent.getParent() instanceof JSBinaryExpression && ((JSBinaryExpression)parent.getParent()).getOperationSign() == JSTokenTypes.PLUS || parent.getParent() instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = parent;
        if (psiLanguageInjectionHost == null) {
            JSInjectionController.$$$reportNull$$$0(4);
        }
        return psiLanguageInjectionHost;
    }

    @NotNull
    public static List<JSLiteralExpression> getConcatenationParts(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionController.$$$reportNull$$$0(5);
        }
        if (topElement instanceof JSLiteralExpression) {
            List<JSLiteralExpression> list = Collections.singletonList((JSLiteralExpression)topElement);
            if (list == null) {
                JSInjectionController.$$$reportNull$$$0(6);
            }
            return list;
        }
        final ArrayList results = ContainerUtil.newArrayList();
        topElement.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof JSBinaryExpression && ((JSBinaryExpression)element).getOperationSign() == JSTokenTypes.PLUS || element instanceof JSParenthesizedExpression) {
                    super.visitElement(element);
                }
            }

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                if (node.isQuotedLiteral()) {
                    results.add(node);
                }
            }
        });
        ArrayList arrayList = results;
        if (arrayList == null) {
            JSInjectionController.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public static String getConcatenationText(@NotNull List<? extends JSLiteralExpression> parts) {
        if (parts == null) {
            JSInjectionController.$$$reportNull$$$0(8);
        }
        String string = StringUtil.join(parts, JSInjectionController::getQuotedLiteralText, (String)"");
        if (string == null) {
            JSInjectionController.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getConcatenationText(@NotNull PsiElement topElement) {
        if (topElement == null) {
            JSInjectionController.$$$reportNull$$$0(10);
        }
        String string = JSInjectionController.getConcatenationText(JSInjectionController.getConcatenationParts(topElement));
        if (string == null) {
            JSInjectionController.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static List<PlaceInfo> getConcatenationPlaces(@NotNull List<JSLiteralExpression> parts) {
        if (parts == null) {
            JSInjectionController.$$$reportNull$$$0(12);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (JSLiteralExpression literalExpression : parts) {
            result2.addAll(JSInjectionController.getQuotedLiteralPlaces(literalExpression));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSInjectionController.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static List<PlaceInfo> injectInQuotedLiteral(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull JSLiteralExpression literalExpression, @Nullable String prefix, @Nullable String suffix) {
        List<PlaceInfo> places;
        if (registrar == null) {
            JSInjectionController.$$$reportNull$$$0(14);
        }
        if (language == null) {
            JSInjectionController.$$$reportNull$$$0(15);
        }
        if (literalExpression == null) {
            JSInjectionController.$$$reportNull$$$0(16);
        }
        if (!(places = JSInjectionController.getQuotedLiteralPlaces(literalExpression)).isEmpty()) {
            registrar.startInjecting(language);
            JSInjectionController.injectForPlaces(registrar, places, prefix, suffix);
            registrar.doneInjecting();
        }
        List<PlaceInfo> list = places;
        if (list == null) {
            JSInjectionController.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public static List<PlaceInfo> concatenationAwareInject(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull List<JSLiteralExpression> parts, @NotNull PsiElement contextElement, @Nullable String prefix, @Nullable String suffix) {
        List<PlaceInfo> places;
        if (registrar == null) {
            JSInjectionController.$$$reportNull$$$0(18);
        }
        if (language == null) {
            JSInjectionController.$$$reportNull$$$0(19);
        }
        if (parts == null) {
            JSInjectionController.$$$reportNull$$$0(20);
        }
        if (contextElement == null) {
            JSInjectionController.$$$reportNull$$$0(21);
        }
        if ((places = JSInjectionController.getConcatenationPlaces(parts)).isEmpty()) {
            List<PlaceInfo> list = Collections.emptyList();
            if (list == null) {
                JSInjectionController.$$$reportNull$$$0(22);
            }
            return list;
        }
        if (!ContainerUtil.exists(places, place -> {
            if (contextElement == null) {
                JSInjectionController.$$$reportNull$$$0(33);
            }
            return PsiTreeUtil.isAncestor((PsiElement)contextElement, (PsiElement)place.getHost(), (boolean)false);
        })) {
            List<PlaceInfo> list = Collections.emptyList();
            if (list == null) {
                JSInjectionController.$$$reportNull$$$0(23);
            }
            return list;
        }
        registrar.startInjecting(language);
        JSInjectionController.injectForPlaces(registrar, places, prefix, suffix);
        registrar.doneInjecting();
        List<PlaceInfo> list = places;
        if (list == null) {
            JSInjectionController.$$$reportNull$$$0(24);
        }
        return list;
    }

    private static void injectForPlaces(@NotNull MultiHostRegistrar registrar, @NotNull List<PlaceInfo> places, @Nullable String prefix, @Nullable String suffix) {
        if (registrar == null) {
            JSInjectionController.$$$reportNull$$$0(25);
        }
        if (places == null) {
            JSInjectionController.$$$reportNull$$$0(26);
        }
        boolean first = true;
        Iterator<PlaceInfo> iterator = places.iterator();
        while (iterator.hasNext()) {
            PlaceInfo place = iterator.next();
            String placePrefix = place.getPrefix();
            String placeSuffix = place.getSuffix();
            if (first && prefix != null) {
                placePrefix = placePrefix == null ? prefix : prefix + placePrefix;
            }
            first = false;
            if (!iterator.hasNext() && suffix != null) {
                placeSuffix = placeSuffix == null ? suffix : placeSuffix + suffix;
            }
            registrar.addPlace(placePrefix, placeSuffix, place.getHost(), place.getRange());
        }
    }

    @NotNull
    public static String getQuotedLiteralText(@NotNull JSLiteralExpression literalExpression) {
        if (literalExpression == null) {
            JSInjectionController.$$$reportNull$$$0(27);
        }
        String text = literalExpression.getText();
        StringBuilder result2 = new StringBuilder();
        for (PlaceInfo place : JSInjectionController.getQuotedLiteralPlaces(literalExpression)) {
            if (place.getPrefix() != null) {
                result2.append(place.getPrefix());
            }
            result2.append(text, place.getRange().getStartOffset(), place.getRange().getEndOffset());
            if (place.getSuffix() == null) continue;
            result2.append(place.getSuffix());
        }
        String string = result2.toString();
        if (string == null) {
            JSInjectionController.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public static List<PlaceInfo> getQuotedLiteralPlaces(@NotNull JSLiteralExpression literalExpression) {
        if (literalExpression == null) {
            JSInjectionController.$$$reportNull$$$0(29);
        }
        if (literalExpression instanceof JSStringTemplateExpression) {
            JSStringTemplateExpression templateExpression = (JSStringTemplateExpression)literalExpression;
            TextRange[] ranges = templateExpression.getStringRanges();
            if (ranges.length > 0) {
                ArrayList<PlaceInfo> result2 = new ArrayList<PlaceInfo>(ranges.length);
                ASTNode quotedLiteralNode = literalExpression.getNode();
                ASTNode backquote = quotedLiteralNode.findChildByType(JSTokenTypes.BACKQUOTE);
                int backquoteOffset = backquote != null ? backquote.getStartOffset() - quotedLiteralNode.getStartOffset() : -1;
                for (int i = 0; i < ranges.length; ++i) {
                    TextRange range = ranges[i];
                    String prefix = i == 0 && range.getStartOffset() > backquoteOffset + 1 ? EXTERNAL_FRAGMENT : null;
                    String suffix = i < ranges.length - 1 || range.getEndOffset() < literalExpression.getTextLength() - 1 ? EXTERNAL_FRAGMENT : null;
                    result2.add(new PlaceInfo(prefix, range, suffix, (PsiLanguageInjectionHost)literalExpression));
                }
                ArrayList<PlaceInfo> arrayList = result2;
                if (arrayList == null) {
                    JSInjectionController.$$$reportNull$$$0(30);
                }
                return arrayList;
            }
            if (!ArrayUtil.isEmpty((Object[])templateExpression.getArguments())) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    JSInjectionController.$$$reportNull$$$0(31);
                }
                return list;
            }
        }
        int endOffset = Math.max(literalExpression.getTextLength() - 1, 1);
        List<PlaceInfo> list = Collections.singletonList(new PlaceInfo(null, TextRange.create((int)1, (int)endOffset), null, (PsiLanguageInjectionHost)literalExpression));
        if (list == null) {
            JSInjectionController.$$$reportNull$$$0(32);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageInjectionHost";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topElement";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSInjectionController";
                break;
            }
            case 8: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 14: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 16: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 21: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "places";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSInjectionController";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenationParts";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenationText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenationPlaces";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "injectInQuotedLiteral";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "concatenationAwareInject";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuotedLiteralText";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuotedLiteralPlaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "willInjectJs";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "willInjectCss";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "willInjectHtml";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTopElement";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenationParts";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenationText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConcatenationPlaces";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "injectInQuotedLiteral";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "concatenationAwareInject";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "injectForPlaces";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getQuotedLiteralText";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getQuotedLiteralPlaces";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$concatenationAwareInject$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PlaceInfo {
        private final String myPrefix;
        private final TextRange myRange;
        private final String mySuffix;
        private final PsiLanguageInjectionHost myHost;

        public PlaceInfo(@Nullable String prefix, @NotNull TextRange range, @Nullable String suffix, @NotNull PsiLanguageInjectionHost host) {
            if (range == null) {
                PlaceInfo.$$$reportNull$$$0(0);
            }
            if (host == null) {
                PlaceInfo.$$$reportNull$$$0(1);
            }
            this.myPrefix = prefix;
            this.myRange = range;
            this.mySuffix = suffix;
            this.myHost = host;
        }

        @Nullable
        public String getPrefix() {
            return this.myPrefix;
        }

        @Nullable
        public String getSuffix() {
            return this.mySuffix;
        }

        @NotNull
        public TextRange getRange() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                PlaceInfo.$$$reportNull$$$0(2);
            }
            return textRange;
        }

        @NotNull
        public PsiLanguageInjectionHost getHost() {
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
            if (psiLanguageInjectionHost == null) {
                PlaceInfo.$$$reportNull$$$0(3);
            }
            return psiLanguageInjectionHost;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/JSInjectionController$PlaceInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/JSInjectionController$PlaceInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHost";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

