/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptResolveProcessor<T extends ResultSink>
extends TypeScriptQualifiedItemProcessor<T> {
    private final boolean myStrictTypeContext;
    private final boolean myStrictTypeContainerContext;
    private final boolean myPlaceIsRuntimeOnly;

    public TypeScriptResolveProcessor(ResultSink sink, PsiFile containingFile, PsiElement _place) {
        super(sink, containingFile);
        JSReferenceExpression topRefExpression;
        this.myStrictTypeContext = _place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)_place);
        boolean bl = this.myPlaceIsRuntimeOnly = !this.myStrictTypeContext && TypeScriptPsiUtil.isPlaceRuntimeOnly(_place, false);
        this.myStrictTypeContainerContext = !this.myStrictTypeContext ? (topRefExpression = TypeScriptResolveProcessor.getTopRefExpression(_place)) != null && JSResolveUtil.isExprInStrictTypeContext(topRefExpression) : false;
    }

    public TypeScriptResolveProcessor(String referenceName, PsiFile containingFile, JSExpression _place) {
        this(new ResolveResultSink((PsiElement)_place, referenceName), containingFile, (PsiElement)_place);
    }

    @Nullable
    private static JSReferenceExpression getTopRefExpression(@Nullable PsiElement _place) {
        JSReferenceExpression result2 = null;
        while (_place instanceof JSReferenceExpression) {
            result2 = (JSReferenceExpression)_place;
            _place = _place.getParent();
        }
        return result2;
    }

    @Override
    protected boolean needProcessTypeMembers(PsiElement element, PsiElement clazz) {
        if (clazz instanceof TypeScriptModule) {
            String moduleName = ((TypeScriptModule)clazz).getName();
            String elementName = null;
            if (element instanceof PsiNamedElement) {
                elementName = ((PsiNamedElement)element).getName();
            } else if (element instanceof JSReferenceExpression) {
                elementName = ((JSReferenceExpression)element).getReferenceName();
            }
            if (Comparing.equal((String)elementName, (String)moduleName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isSpecifierAcceptable(ES6ImportExportSpecifier specifier) {
        if (this.myStrictTypeContext || this.myStrictTypeContainerContext) {
            return TypeScriptPsiUtil.referencesNamedTypeContainer(specifier);
        }
        return super.isSpecifierAcceptable(specifier);
    }

    @Override
    public ResolveResult[] getResultsAsResolveResults() {
        ResolveResult[] results = super.getResultsAsResolveResults();
        return this.filterByTypeContext(results);
    }

    @NotNull
    public ResolveResult[] filterByTypeContext(@NotNull ResolveResult[] results) {
        if (results == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(0);
        }
        if (!this.myPlaceIsRuntimeOnly) {
            if (results == null) {
                TypeScriptResolveProcessor.$$$reportNull$$$0(1);
            }
            return results;
        }
        ResolveResult[] resolveResultArray = TypeScriptPsiUtil.removeCompileTimeTypes(results);
        if (resolveResultArray == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(3);
        }
        if (state == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(4);
        }
        if (this.myStrictTypeContext && !TypeScriptPsiUtil.isNamedTypeDefinition(element)) {
            return true;
        }
        if (this.myStrictTypeContainerContext && !TypeScriptPsiUtil.isNamedTypeContainerDefinition(element)) {
            return true;
        }
        if (this.myPlaceIsRuntimeOnly && element instanceof TypeScriptCompileTimeType) {
            return true;
        }
        return super.execute(element, state);
    }

    @Override
    protected boolean executeAcceptedElement(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(5);
        }
        if (state == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(6);
        }
        if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadDeclaration()) {
            return true;
        }
        if (element instanceof TypeScriptIndexSignature && this.myName != null && ((TypeScriptIndexSignature)element).getIndexSignatureKind() == JSRecordType.IndexSignatureKind.STRING) {
            return ((ResultSink)this.getResultSink()).addResult(element, state, this.getPlaceTopParent());
        }
        return super.executeAcceptedElement(element, state);
    }

    public boolean isStrictTypeContext() {
        return this.myStrictTypeContext;
    }

    @Override
    @Nullable
    protected PsiElement getConstructor(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptResolveProcessor.$$$reportNull$$$0(7);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByTypeContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterByTypeContext";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeAcceptedElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

