/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class JSSuperMethodUtil {
    private JSSuperMethodUtil() {
    }

    @Nullable
    public static JSFunction checkSuperMethod(JSFunction method, String actionTitle, String questionText) {
        JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)method);
        if (jsClass == null) {
            return method;
        }
        Map<JSClass, JSPsiElementBase> map = JSInheritanceUtil.findDeclaringClassesMap((JSQualifiedNamedElement)method);
        if (map.size() == 0) {
            return method;
        }
        if (map.size() != 1 && DialectDetector.isTypeScript((PsiElement)method)) {
            return null;
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(map.entrySet());
        assert (item != null);
        JSClass baseClass = (JSClass)item.getKey();
        if (baseClass != null && jsClass != baseClass) {
            String methodDesc = "'" + JSFormatUtil.formatMethod(method, 257, 2) + "'";
            String message = JSBundle.message((String)(baseClass.isInterface() ? "find.usages.of.base.interface" : "find.usages.of.base.class"), (Object[])new Object[]{methodDesc, new JSNamedElementPresenter((PsiElement)jsClass).describeWithQualifiedName(), new JSNamedElementPresenter((PsiElement)baseClass).describeWithQualifiedName(), questionText});
            String messageToShow = StringUtil.escapeXml((String)message).replaceAll("&#39;", "'");
            int choice = Messages.showYesNoCancelDialog((Project)method.getProject(), (String)messageToShow, (String)actionTitle, (Icon)Messages.getQuestionIcon());
            switch (choice) {
                case 0: {
                    return (JSFunction)ObjectUtils.tryCast(item.getValue(), JSFunction.class);
                }
                case 1: {
                    return method;
                }
            }
            return null;
        }
        return method;
    }
}

