/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertForEachToForOfIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    private static final TokenSet PRIMITIVES = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.DOT, JSTokenTypes.ELVIS, JSElementTypes.DOT_SHARP, JSTokenTypes.COMMA, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.LPAR, JSTokenTypes.RPAR});

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ES6ConvertForEachToForOfIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ES6ConvertForEachToForOfIntention.$$$reportNull$$$0(1);
        }
        return super.isAvailable(project, editor, element) && ES6CoolRefactoring.isEs6Compatible(element) && ES6ConvertForEachToForOfIntention.isAvailable(element);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            ES6ConvertForEachToForOfIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ES6ConvertForEachToForOfIntention.$$$reportNull$$$0(3);
        }
        JSCallExpression callExpression = ES6ConvertForEachToForOfIntention.findFunctionCall(element);
        assert (callExpression != null);
        PsiElement jsStatement = JSUtils.getParentSkipParentheses((PsiElement)callExpression);
        assert (jsStatement != null);
        JSFunction function = ES6ConvertForEachToForOfIntention.getFunction(callExpression);
        assert (function != null);
        String loopVariableText = function.getParameters().length > 0 ? function.getParameters()[0].getText() : "ignored";
        JSExpression collectionExpression = ((JSReferenceExpression)callExpression.getMethodExpression()).getQualifier();
        assert (collectionExpression != null);
        String text = String.format("for (const %s of %s) {}", loopVariableText, collectionExpression.getText());
        JSForInStatement forInStatement = JSChangeUtil.createStatementPsiFromTextWithContext(text, (PsiElement)callExpression, JSForInStatement.class);
        assert (forInStatement != null);
        JSBlockStatement forOfBlockBody = (JSBlockStatement)forInStatement.getBody();
        assert (forOfBlockBody != null);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)function);
        if (callExpression.getArguments()[0] instanceof JSReferenceExpression) {
            String callText = String.format("%s(%s)%s", callExpression.getArguments()[0].getText(), loopVariableText, semicolon);
            JSStatement callStatement = JSChangeUtil.createStatementPsiFromTextWithContext(callText, (PsiElement)callExpression, JSStatement.class);
            assert (callStatement != null);
            JSChangeUtil.doAddAfter((PsiElement)forOfBlockBody, (PsiElement)callStatement, forOfBlockBody.getFirstChild());
        } else {
            forOfBlockBody = JSFunctionsRefactoringUtil.moveFunctionBody(function, forOfBlockBody);
            for (JSReturnStatement returnStatement : ES6ConvertForEachToForOfIntention.getReturnStatements(forOfBlockBody)) {
                JSExpression returnExpression = returnStatement.getExpression();
                if (returnExpression == null) {
                    JSStatement breakStatement = JSChangeUtil.createStatementPsiFromTextWithContext("break" + semicolon, (PsiElement)returnStatement, JSStatement.class);
                    returnStatement.replace(breakStatement);
                    continue;
                }
                JSStatement expressionStatement = JSChangeUtil.createStatementPsiFromTextWithContext(returnExpression.getText() + semicolon, (PsiElement)returnStatement, JSStatement.class);
                returnStatement.replace(expressionStatement);
            }
        }
        jsStatement.replace((PsiElement)forInStatement);
    }

    private static boolean isAvailable(@NotNull PsiElement element) {
        JSCallExpression callExpression;
        if (element == null) {
            ES6ConvertForEachToForOfIntention.$$$reportNull$$$0(4);
        }
        if ((callExpression = ES6ConvertForEachToForOfIntention.findFunctionCall(element)) != null && ES6ConvertForEachToForOfIntention.isForEachCall(callExpression) && JSUtils.getParentSkipParentheses((PsiElement)callExpression) instanceof JSStatement) {
            JSFunction function = ES6ConvertForEachToForOfIntention.getFunction(callExpression);
            return function != null && function.getParameters().length <= 1;
        }
        return false;
    }

    @Nullable
    private static JSFunction getFunction(@NotNull JSCallExpression callExpression) {
        JSExpression argument;
        if (callExpression == null) {
            ES6ConvertForEachToForOfIntention.$$$reportNull$$$0(5);
        }
        if ((argument = callExpression.getArguments()[0]) instanceof JSFunctionExpression) {
            return (JSFunction)argument;
        }
        if (argument instanceof JSReferenceExpression) {
            return JSPsiImplUtils.getPossibleFunction(((JSReferenceExpression)argument).resolve());
        }
        return null;
    }

    private static boolean isForEachCall(@NotNull JSCallExpression callExpression) {
        JSExpression methodExpression;
        if (callExpression == null) {
            ES6ConvertForEachToForOfIntention.$$$reportNull$$$0(6);
        }
        return (methodExpression = callExpression.getMethodExpression()) instanceof JSReferenceExpression && "forEach".equals(((JSReferenceExpression)methodExpression).getReferenceName()) && ((JSReferenceExpression)methodExpression).getQualifier() != null && callExpression.getArguments().length == 1;
    }

    @NotNull
    private static Collection<JSReturnStatement> getReturnStatements(@NotNull JSBlockStatement forOfBlockBody) {
        if (forOfBlockBody == null) {
            ES6ConvertForEachToForOfIntention.$$$reportNull$$$0(7);
        }
        final ArrayList<JSReturnStatement> returnStatements = new ArrayList<JSReturnStatement>();
        forOfBlockBody.accept((PsiElementVisitor)new JSRecursiveWalkingElementSkippingNestedFunctionsVisitor(){

            @Override
            protected boolean skipLambdas() {
                return true;
            }

            public void visitJSReturnStatement(JSReturnStatement node) {
                super.visitJSReturnStatement(node);
                returnStatements.add(node);
            }
        });
        ArrayList<JSReturnStatement> arrayList = returnStatements;
        if (arrayList == null) {
            ES6ConvertForEachToForOfIntention.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    private static JSCallExpression findFunctionCall(@NotNull PsiElement element) {
        PsiElement call;
        if (element == null) {
            ES6ConvertForEachToForOfIntention.$$$reportNull$$$0(9);
        }
        if (element instanceof JSCallExpression) {
            return (JSCallExpression)element;
        }
        if (PRIMITIVES.contains(element.getNode().getElementType()) || JSTokenTypes.OPERATIONS.contains(element.getNode().getElementType())) {
            element = element.getParent();
        }
        if (element.getNode().getElementType() == JSTokenTypes.IDENTIFIER) {
            element = element.getParent();
        }
        if (JSTokenTypes.LITERALS.contains(element.getNode().getElementType()) && element.getParent() instanceof JSLiteralExpression) {
            element = element.getParent();
        }
        while (element instanceof JSExpression && !(element instanceof JSReferenceExpression)) {
            element = element.getParent();
        }
        if (element instanceof JSReferenceExpression && (call = JSResolveUtil.getTopReferenceParent(element)) instanceof JSCallExpression) {
            return (JSCallExpression)call;
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.for.each.to.for.of.intention.text", (Object[])new Object[0]);
        if (string == null) {
            ES6ConvertForEachToForOfIntention.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.for.each.to.for.of.intention.family", (Object[])new Object[0]);
        if (string == null) {
            ES6ConvertForEachToForOfIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forOfBlockBody";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ConvertForEachToForOfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertForEachToForOfIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnStatements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFunction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isForEachCall";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReturnStatements";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

