/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSContextualUnionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCompositeTypeImpl
extends JSCompositeTypeBaseImpl
implements JSUnionType {
    public static final int TYPES_NUMBER_LIMIT = 5;
    private final boolean myAnyType;

    @Contract(value="!null -> !null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType) {
        return JSCompositeTypeImpl.optimizeTypeIfComposite(currentType, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE);
    }

    @NotNull
    public static JSType optimizeTypeForSubstitute(@NotNull JSType currentType, @Nullable PsiElement context) {
        if (currentType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(0);
        }
        JSType jSType = JSCompositeTypeImpl.optimizeTypeIfComposite(currentType, context == null || TypeScriptConfigUtil.strictNullChecks(context) ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE : JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED);
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(1);
        }
        return jSType;
    }

    @Contract(value="!null,_->!null")
    public static JSType optimizeTypeIfComposite(@Nullable JSType currentType, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind) {
        if (targetKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(2);
        }
        if (currentType instanceof JSDistributedType && targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE) {
            currentType = ((JSDistributedType)currentType).distributeType();
        }
        if (!(currentType instanceof JSUnionOrIntersectionType)) {
            return currentType;
        }
        JSUnionOrIntersectionType unionOrIntersection = (JSUnionOrIntersectionType)currentType;
        return JSCompositeTypeImpl.optimizeTypeIfUnionOrIntersection(unionOrIntersection, targetKind);
    }

    @Contract(value="!null,_ -> !null")
    private static JSType optimizeTypeIfUnionOrIntersection(@NotNull JSUnionOrIntersectionType currentType, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind) {
        Set<JSUnionOrIntersectionType.OptimizedKind> currentOptimized;
        if (currentType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(3);
        }
        if (targetKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(4);
        }
        boolean allowResolve = targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE;
        Set<JSUnionOrIntersectionType.OptimizedKind> set = currentOptimized = allowResolve ? currentType.getResolvedOptimized() : Collections.emptySet();
        if (JSCompositeTypeImpl.isResolvedOptimizedAcceptable(currentOptimized, targetKind)) {
            return currentType;
        }
        boolean isUnion = currentType.isUnionType();
        boolean isWeakType = !currentType.getSource().isStrict() || !currentType.isTypeScript();
        List<JSType> originalTypes = currentType.getTypes();
        List<JSType> results = JSCompositeTypeImpl.flattenAndDeduplicate(originalTypes, currentOptimized, targetKind, isUnion);
        if (results.size() == 1) {
            return results.get(0);
        }
        JSTypeSource source = currentType.getSource();
        if (results.isEmpty()) {
            return isWeakType ? JSAnyType.get(currentType.getSourceElement(), false) : new TypeScriptNeverJSTypeImpl(source);
        }
        if (isUnion) {
            JSUnionOrIntersectionType result2;
            JSUnionOrIntersectionType jSUnionOrIntersectionType = result2 = ContainerUtil.equalsIdentity(results, originalTypes) ? currentType : new JSCompositeTypeImpl(source, results);
            if (allowResolve) {
                JSCompositeTypeImpl.saveResolveOptimized(result2, targetKind);
            }
            return result2;
        }
        return JSCompositeTypeImpl.normalizeAndOptimizeIntersection(currentType, results, targetKind, source);
    }

    @NotNull
    private static JSType normalizeAndOptimizeIntersection(@NotNull JSUnionOrIntersectionType currentType, @NotNull List<JSType> results, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind, @NotNull JSTypeSource source) {
        boolean isContextual;
        boolean allowResolve;
        JSType normalized;
        if (currentType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(5);
        }
        if (results == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(6);
        }
        if (targetKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(7);
        }
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(8);
        }
        if ((normalized = JSIntersectionTypeImpl.normalizeIfPossible((allowResolve = targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE) ? StreamEx.of(results).map(el -> TypeScriptTypeRelations.expandAliasesRecursive(el)).toList() : results, source, allowResolve, !(isContextual = currentType instanceof JSContextualUnionTypeImpl))) != null) {
            JSType jSType = JSCompositeTypeImpl.optimizeTypeIfComposite(normalized, targetKind);
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(9);
            }
            return jSType;
        }
        JSType jSType = JSCompositeTypeImpl.setTargetAndReturnIntersection(currentType, results, targetKind, source, isContextual);
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @NotNull
    private static JSType setTargetAndReturnIntersection(@NotNull JSUnionOrIntersectionType currentType, @NotNull List<JSType> results, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind, @NotNull JSTypeSource source, boolean isContextual) {
        JSUnionOrIntersectionType result2;
        if (currentType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(11);
        }
        if (results == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(12);
        }
        if (targetKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(13);
        }
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(14);
        }
        JSUnionOrIntersectionType jSUnionOrIntersectionType = result2 = ContainerUtil.equalsIdentity(results, currentType.getTypes()) ? currentType : JSCompositeTypeImpl.createIntersectionLikeType(results, source, isContextual);
        if (targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE) {
            JSCompositeTypeImpl.saveResolveOptimized(currentType, targetKind);
        }
        JSUnionOrIntersectionType jSUnionOrIntersectionType2 = result2;
        if (jSUnionOrIntersectionType2 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(15);
        }
        return jSUnionOrIntersectionType2;
    }

    @NotNull
    private static JSUnionOrIntersectionType createIntersectionLikeType(@NotNull List<JSType> results, @NotNull JSTypeSource source, boolean isContextual) {
        if (results == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(16);
        }
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(17);
        }
        JSIntersectionTypeImpl jSIntersectionTypeImpl = isContextual ? new JSContextualUnionTypeImpl(source, results) : new JSIntersectionTypeImpl(source, results);
        if (jSIntersectionTypeImpl == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(18);
        }
        return jSIntersectionTypeImpl;
    }

    @NotNull
    static List<JSType> flattenAndDeduplicate(@NotNull Collection<? extends JSType> originalNestedTypes, @NotNull Set<JSUnionOrIntersectionType.OptimizedKind> currentOptimized, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind, boolean isUnion) {
        List types;
        boolean allowResolve;
        if (originalNestedTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(19);
        }
        if (currentOptimized == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(20);
        }
        if (targetKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(21);
        }
        boolean bl = allowResolve = targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE;
        List list = !currentOptimized.isEmpty() ? (originalNestedTypes instanceof List ? (List)originalNestedTypes : ContainerUtil.newArrayList(originalNestedTypes)) : (types = ((StreamEx)JSCompositeTypeImpl.flattenTypesStream((StreamEx<? extends JSType>)StreamEx.of(originalNestedTypes).map(el -> JSCompositeTypeImpl.getTypeOfType(el, allowResolve)), isUnion ? JSUnionType.class : JSIntersectionType.class).filter(el -> isUnion ? !JSCompositeTypeImpl.isEmptyType(el) : el != null)).toList());
        if (!(targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED && targetKind != JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_FALSY || types.isEmpty())) {
            types = ((StreamEx)StreamEx.of((Collection)types).filter(el -> {
                if (targetKind == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(98);
                }
                return targetKind == JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_FALSY ? !JSTypeCastUtil.isFalsy(el) : !JSCompositeTypeImpl.isNullOrUndefinedType(el);
            })).toList();
        }
        if (types.size() <= 1) {
            List list2 = types;
            if (list2 == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(22);
            }
            return list2;
        }
        List<JSType> list3 = allowResolve ? JSCompositeTypeImpl.deduplicate(types, isUnion) : JSCompositeTypeImpl.deduplicateNoResolve(types, isUnion);
        if (list3 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(23);
        }
        return list3;
    }

    @NotNull
    private static List<JSType> deduplicate(@NotNull List<JSType> types, boolean isUnion) {
        if (types == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(24);
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)types.size());
        TObjectIntHashMap indexes = new TObjectIntHashMap();
        JSUnknownType hasUnknown = null;
        for (JSType newType : types) {
            if (newType instanceof JSUnknownType) {
                if (isUnion) {
                    List<JSType> list = Collections.singletonList(newType);
                    if (list == null) {
                        JSCompositeTypeImpl.$$$reportNull$$$0(25);
                    }
                    return list;
                }
                hasUnknown = (JSUnknownType)newType;
                continue;
            }
            if (newType instanceof TypeScriptNeverJSTypeImpl && !isUnion) {
                List<JSType> list = Collections.singletonList(newType);
                if (list == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(26);
                }
                return list;
            }
            JSType forChecking = JSCompositeTypeImpl.toTypeForCheckingDuplication(newType);
            JSResolvedTypeId id = forChecking.getResolvedTypeId();
            if (!indexes.containsKey((Object)id)) {
                indexes.put((Object)id, result2.size());
                result2.add(newType);
                continue;
            }
            int oldIndex = indexes.get((Object)id);
            JSType oldType = (JSType)result2.get(oldIndex);
            JSType replacement = JSCompositeTypeImpl.getReplacementType(oldType, newType);
            if (replacement == oldType) continue;
            result2.set(oldIndex, replacement);
        }
        if (result2.isEmpty() && hasUnknown != null) {
            List<Object> list = Collections.singletonList(hasUnknown);
            if (list == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(27);
            }
            return list;
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @NotNull
    private static JSType getReplacementType(@NotNull JSType oldType, @NotNull JSType newType) {
        if (oldType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(29);
        }
        if (newType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(30);
        }
        if (oldType instanceof JSDecoratedTypeImpl) {
            if (!(newType instanceof JSDecoratedTypeImpl)) {
                JSType jSType = newType;
                if (jSType == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(31);
                }
                return jSType;
            }
            if (newType.getResolvedTypeId().equals(oldType.getResolvedTypeId())) {
                JSType jSType = oldType;
                if (jSType == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(32);
                }
                return jSType;
            }
            JSDecoratedTypeImpl oldDecorated = (JSDecoratedTypeImpl)oldType;
            JSDecoratedTypeImpl newDecorated = (JSDecoratedTypeImpl)newType;
            Collection resultDecorators = ContainerUtil.intersection(oldDecorated.getDecorations(), newDecorated.getDecorations());
            if (resultDecorators.isEmpty()) {
                JSType jSType = oldDecorated.getOriginalType();
                if (jSType == null) {
                    JSCompositeTypeImpl.$$$reportNull$$$0(33);
                }
                return jSType;
            }
            JSDecoratedTypeImpl jSDecoratedTypeImpl = new JSDecoratedTypeImpl(oldDecorated.getSource(), oldDecorated.getOriginalType(), EnumSet.copyOf(resultDecorators));
            if (jSDecoratedTypeImpl == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(34);
            }
            return jSDecoratedTypeImpl;
        }
        JSType jSType = oldType;
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(35);
        }
        return jSType;
    }

    private static JSType toTypeForCheckingDuplication(@NotNull JSType type) {
        if (type == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(36);
        }
        if (type instanceof JSDecoratedTypeImpl) {
            return ((JSDecoratedTypeImpl)type).getOriginalType();
        }
        return type;
    }

    @NotNull
    private static List<JSType> deduplicateNoResolve(@NotNull List<JSType> types, boolean isUnion) {
        if (types == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(37);
        }
        ProcessingContext context = new ProcessingContext();
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)types.size());
        JSUnknownType hasUnknown = null;
        for (JSType fromCompare : types) {
            if (fromCompare instanceof JSUnknownType) {
                if (isUnion) {
                    List<JSType> list = Collections.singletonList(fromCompare);
                    if (list == null) {
                        JSCompositeTypeImpl.$$$reportNull$$$0(38);
                    }
                    return list;
                }
                hasUnknown = (JSUnknownType)fromCompare;
                continue;
            }
            if (!result2.stream().noneMatch(resultedType -> fromCompare.isEquivalentTo(resultedType, context, false))) continue;
            result2.add(fromCompare);
        }
        if (result2.isEmpty() && hasUnknown != null) {
            List<Object> list = Collections.singletonList(hasUnknown);
            if (list == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(39);
            }
            return list;
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    private static boolean isResolvedOptimizedAcceptable(@NotNull Set<JSUnionOrIntersectionType.OptimizedKind> currentOptimized, @NotNull JSUnionOrIntersectionType.OptimizedKind targetKind) {
        if (currentOptimized == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(41);
        }
        if (targetKind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(42);
        }
        return currentOptimized.contains((Object)targetKind);
    }

    @Deprecated
    @NotNull
    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable JSTypeSource source, boolean allowResolve) {
        if (type1 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(43);
        }
        if (type2 == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(44);
        }
        if (type1 == type2) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(45);
            }
            return jSType;
        }
        if (type1 instanceof JSAnyType) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(46);
            }
            return jSType;
        }
        if (type2 instanceof JSAnyType) {
            JSType jSType = type2;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(47);
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type1) || JSCompositeTypeImpl.isNullOrUndefinedType(type1)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(48);
            }
            return jSType;
        }
        if (JSCompositeTypeImpl.isEmptyType(type2) || JSCompositeTypeImpl.isNullOrUndefinedType(type2)) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(49);
            }
            return jSType;
        }
        if (!allowResolve && type1 instanceof JSNamedType && type2 instanceof JSNamedType && type1.getTypeText().equals(type2.getTypeText())) {
            JSType jSType = type1;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(50);
            }
            return jSType;
        }
        List<JSType> allCommonTypes = JSCompositeTypeImpl.flattenTypes(Stream.of(type1, type2), JSCompositeTypeImpl.class);
        if (source == null) {
            source = type1 instanceof JSCompositeTypeImpl || !(type2 instanceof JSCompositeTypeImpl) ? type1.getSource() : type2.getSource();
        }
        JSType jSType = JSCompositeTypeImpl.getCommonType(allCommonTypes, source, allowResolve);
        if (jSType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(51);
        }
        return jSType;
    }

    @NotNull
    public static JSType getCommonType(@NotNull Collection<? extends JSType> allCommonTypes, @NotNull JSTypeSource source, boolean allowResolve) {
        if (allCommonTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(52);
        }
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(53);
        }
        JSUnionOrIntersectionType.OptimizedKind target = !allowResolve ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE : (source.isTypeScript() ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE : JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED);
        List<JSType> types = JSCompositeTypeImpl.flattenAndDeduplicate(allCommonTypes, Collections.emptySet(), target, true);
        if (types.size() == 0) {
            TypeScriptNeverJSTypeImpl typeScriptNeverJSTypeImpl = new TypeScriptNeverJSTypeImpl(source);
            if (typeScriptNeverJSTypeImpl == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(54);
            }
            return typeScriptNeverJSTypeImpl;
        }
        if (types.size() == 1) {
            JSType jSType = types.get(0);
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(55);
            }
            return jSType;
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(source, types);
        if (jSCompositeTypeImpl == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(56);
        }
        return jSCompositeTypeImpl;
    }

    private static void saveResolveOptimized(@NotNull JSUnionOrIntersectionType type, @NotNull JSUnionOrIntersectionType.OptimizedKind kind) {
        EnumSet<JSUnionOrIntersectionType.OptimizedKind> flag;
        if (type == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(57);
        }
        if (kind == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(58);
        }
        if ((flag = (EnumSet<JSUnionOrIntersectionType.OptimizedKind>)type.getResolvedFlag(KEY_RESOLVE_OPTIMIZED)) == null) {
            flag = EnumSet.of(kind);
            type.setResolvedFlag(KEY_RESOLVE_OPTIMIZED, flag);
        } else {
            flag.add(kind);
        }
    }

    public JSCompositeTypeImpl(@NotNull JSTypeSource source, @NotNull List<? extends JSType> _types) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(59);
        }
        if (_types == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(60);
        }
        super(source, _types);
        this.myAnyType = this.getTypes().stream().anyMatch(el -> el instanceof JSAnyType);
    }

    public JSCompositeTypeImpl(@NotNull JSTypeSource source, JSType ... _types) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(61);
        }
        super(source, _types);
        this.myAnyType = this.getTypes().stream().anyMatch(el -> el instanceof JSAnyType);
    }

    protected JSCompositeTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(62);
        }
        if (inputStream == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(63);
        }
        super(source, inputStream);
        this.myAnyType = this.getTypes().stream().anyMatch(el -> el instanceof JSAnyType);
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if ("|" == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(64);
        }
        return "|";
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(65);
        }
        if (processingContext == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(66);
        }
        if (this.isAnyType()) {
            return true;
        }
        if (this.anyNestedTypeEqualsTo(elementType = TypeScriptTypeRelations.getAsUnionTypeIfEnumWithLiterals(elementType), processingContext)) {
            return true;
        }
        boolean processingInProgress = JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext);
        if (elementType instanceof JSUnionType) {
            boolean checkAll = this.isTypeScript() && this.isSourceStrict() && elementType.isSourceStrict() || processingInProgress;
            return JSTypeCastUtil.checkAssignableComposite(this, (JSUnionType)elementType, processingContext, checkAll);
        }
        return this.anyNestedTypeIsAssignableTo(elementType, processingContext);
    }

    private boolean anyNestedTypeIsAssignableTo(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(67);
        }
        for (JSType t : this.getTypes()) {
            if (JSCompositeTypeImpl.isEmptyType(t) || JSCompositeTypeImpl.isNullOrUndefinedType(t) || !t.isDirectlyAssignableType(elementType, processingContext)) continue;
            return true;
        }
        return false;
    }

    private boolean anyNestedTypeEqualsTo(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(68);
        }
        JSType regularLiteralType = TypeScriptTypeRelations.getRegularTypeOfLiteralType(elementType);
        return this.getTypes().stream().anyMatch(type -> type != null && TypeScriptTypeRelations.getRegularTypeOfLiteralType(type).isEquivalentTo(regularLiteralType, processingContext));
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource, boolean sourceOnly) {
        if (transformedTypes == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(69);
        }
        if (newSource == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(70);
        }
        if (sourceOnly) {
            JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(newSource, transformedTypes);
            if (jSCompositeTypeImpl == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(71);
            }
            return jSCompositeTypeImpl;
        }
        JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(newSource, JSCompositeTypeImpl.flattenTypes((Stream<? extends JSType>)StreamEx.of(transformedTypes), this.getClass()));
        if (jSCompositeTypeImpl == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(72);
        }
        return jSCompositeTypeImpl;
    }

    @Override
    @NotNull
    protected JSType substituteCompositeImpl() {
        JSType result2 = this.getSimpleCompositeTypeResult();
        if (result2 != null) {
            JSType jSType = result2;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(73);
            }
            return jSType;
        }
        JSType rawTypeToProcess = JSCompositeTypeImpl.optimizeTypeForSubstitute(this, this.getSourceElement());
        if (!(rawTypeToProcess instanceof JSCompositeTypeImpl)) {
            JSType jSType = rawTypeToProcess;
            if (jSType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(74);
            }
            return jSType;
        }
        JSCompositeTypeImpl typeToProcess = (JSCompositeTypeImpl)rawTypeToProcess;
        Collection<JSRecordType> resolvedTypes = typeToProcess.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            JSAnyType jSAnyType = JSAnyType.get(this.getSource().getSourceElement(), this.getSource().isStrict());
            if (jSAnyType == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(75);
            }
            return jSAnyType;
        }
        JSRecordType item = (JSRecordType)ContainerUtil.getFirstItem(resolvedTypes);
        resolvedTypes.remove(item);
        assert (item != null);
        ArrayList resultMembers = ContainerUtil.newArrayList();
        for (JSRecordType.TypeMember member : item.getTypeMembers()) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            this.addCommonPropertyMember(resolvedTypes, resultMembers, (JSRecordType.PropertySignature)member);
        }
        this.addCommonCallSignatureMembers(resolvedTypes, resultMembers, item.getCallSignatures());
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), resultMembers);
        if (jSRecordTypeImpl == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(76);
        }
        return jSRecordTypeImpl;
    }

    private void addCommonCallSignatureMembers(@NotNull Collection<JSRecordType> typesToMerge, @NotNull List<JSRecordType.TypeMember> resultMembers, @NotNull List<JSRecordType.CallSignature> callSignatures) {
        if (typesToMerge == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(77);
        }
        if (resultMembers == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(78);
        }
        if (callSignatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(79);
        }
        if (callSignatures.isEmpty()) {
            return;
        }
        PsiElement element = this.getSource().getSourceElement();
        if (element == null || !element.isValid()) {
            return;
        }
        ProgressManager.checkCanceled();
        List toProcessNewSignatures = ContainerUtil.newSmartList();
        List toProcessCallSignatures = ContainerUtil.newSmartList();
        for (JSRecordType.CallSignature signature : callSignatures) {
            (signature.hasNew() ? toProcessNewSignatures : toProcessCallSignatures).add(signature);
        }
        boolean collectNew = !toProcessNewSignatures.isEmpty();
        boolean collectCall = !toProcessCallSignatures.isEmpty();
        List<List<JSRecordType.CallSignature>> newTable = collectNew ? JSCompositeTypeImpl.createTable(toProcessNewSignatures) : ContainerUtil.emptyList();
        List<List<JSRecordType.CallSignature>> callTable = collectCall ? JSCompositeTypeImpl.createTable(toProcessCallSignatures) : ContainerUtil.emptyList();
        for (JSRecordType type : typesToMerge) {
            List signatures = type.getCallSignatures();
            if (collectCall) {
                collectCall = JSCompositeTypeImpl.addToTable(callTable, signatures, false);
            }
            if (!collectNew) continue;
            collectNew = JSCompositeTypeImpl.addToTable(newTable, signatures, true);
        }
        int before = resultMembers.size();
        if (collectCall) {
            resultMembers.addAll(JSCompositeTypeImpl.getUnionSignatures(callTable, element));
        }
        if (collectNew) {
            resultMembers.addAll(JSCompositeTypeImpl.getUnionSignatures(newTable, element));
        }
        if ((collectCall || collectNew) && before == resultMembers.size()) {
            resultMembers.addAll(TypeScriptUtil.getFunctionTypeMembers(this.getSource().getSourceElement()).getTypeMembers());
        }
    }

    private static boolean addToTable(@NotNull List<List<JSRecordType.CallSignature>> callTable, @NotNull List<JSRecordType.CallSignature> signatures, boolean b) {
        if (callTable == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(80);
        }
        if (signatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(81);
        }
        List<JSRecordType.CallSignature> collected = JSCompositeTypeImpl.getSignaturesWithKind(signatures, b);
        callTable.add(collected);
        return !collected.isEmpty();
    }

    @NotNull
    private static List<JSRecordType.CallSignature> getSignaturesWithKind(@NotNull List<JSRecordType.CallSignature> signatures, boolean hasNew) {
        if (signatures == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(82);
        }
        List list = ContainerUtil.filter(signatures, el -> el.hasNew() == hasNew);
        if (list == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(83);
        }
        return list;
    }

    private static List<List<JSRecordType.CallSignature>> createTable(@NotNull List<JSRecordType.CallSignature> value) {
        if (value == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(84);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.add(value);
        return result2;
    }

    @NotNull
    public static List<JSRecordType.CallSignature> getUnionSignatures(@NotNull List<? extends List<JSRecordType.CallSignature>> signatureTable, @NotNull PsiElement context) {
        DialectOptionHolder holder;
        if (signatureTable == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(85);
        }
        if (context == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(86);
        }
        if ((holder = DialectDetector.dialectOfElement(context)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSCompositeTypeImpl.$$$reportNull$$$0(87);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (int i = 0; i < signatureTable.size(); ++i) {
            List<JSRecordType.CallSignature> signatures = signatureTable.get(i);
            for (JSRecordType.CallSignature signature : signatures) {
                if (!result2.isEmpty() && TypeScriptSignatureChooser.findMatchedSignature(result2, signature, false, true) != null) continue;
                List<JSRecordType.CallSignature> matchingSignatures = TypeScriptSignatureChooser.findMatchingSignatures(signatureTable, signature, i);
                if (matchingSignatures.size() > 1) {
                    JSRecordType.CallSignature callSignature = matchingSignatures.get(0);
                    JSFunctionType type = callSignature.getFunctionType();
                    for (JSRecordType.CallSignature matchingSignature : matchingSignatures) {
                        JSFunctionType commonFunctionType;
                        JSFunctionType candidate = matchingSignature.getFunctionType();
                        if (type != candidate && (commonFunctionType = JSCompositeTypeImpl.getCommonFunctionType(type, candidate, holder)) != null) {
                            type = commonFunctionType;
                        }
                        result2.add(new JSRecordTypeImpl.CallSignatureImpl(callSignature.hasNew(), type));
                    }
                    continue;
                }
                result2.addAll(matchingSignatures);
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(88);
        }
        return arrayList;
    }

    @Nullable
    private static JSFunctionType getCommonFunctionType(@NotNull JSFunctionType lType, @NotNull JSFunctionType rType, @NotNull DialectOptionHolder holder) {
        if (lType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(89);
        }
        if (rType == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(90);
        }
        if (holder == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(91);
        }
        if (rType.isEquivalentTo((JSType)lType, null)) {
            return lType;
        }
        int count = JSCompositeTypeImpl.getIntersectionParameters(lType, rType);
        if (count == -1) {
            return null;
        }
        List lParameters = lType.getParameters();
        List rParameters = rType.getParameters();
        ArrayList resultParameters = ContainerUtil.newArrayList();
        int lLength = lParameters.size();
        int rLength = rParameters.size();
        for (int i = 0; i < count; ++i) {
            JSType rParameterType;
            JSParameterTypeDecorator lDecorator = lLength > i ? (JSParameterTypeDecorator)lParameters.get(i) : null;
            JSParameterTypeDecorator rDecorator = rLength > i ? (JSParameterTypeDecorator)rParameters.get(i) : null;
            JSType lParameterType = lDecorator == null || lDecorator.isRest() && rDecorator != null && !rDecorator.isRest() ? JSCompositeTypeImpl.getRestComponentType(lParameters) : lDecorator.getType();
            JSType jSType = rParameterType = rDecorator == null || rDecorator.isRest() && lDecorator != null && !lDecorator.isRest() ? JSCompositeTypeImpl.getRestComponentType(rParameters) : rDecorator.getType();
            if (lDecorator == null) {
                lDecorator = rDecorator;
            }
            if (rDecorator == null) {
                rDecorator = lDecorator;
            }
            if (rDecorator == null) {
                Logger.getInstance(JSCompositeTypeImpl.class).error("Incorrect state in signature merging \nltype: " + lType.getTypeText() + "\nrtype: " + rType.getTypeText());
                return null;
            }
            JSType parameterType = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, lParameterType, rParameterType);
            boolean isOptional = lDecorator.isOptional() && rDecorator.isOptional();
            boolean explicit = rDecorator.isExplicitlyDeclared() && lDecorator.isExplicitlyDeclared();
            boolean isRest = lDecorator.isRest() && rDecorator.isRest();
            resultParameters.add(new JSParameterTypeDecoratorImpl(parameterType, isOptional, isRest, explicit));
        }
        JSType lReturnType = lType.getReturnType();
        JSType rReturnType = rType.getReturnType();
        JSType resultReturn = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, lReturnType, rReturnType);
        return new JSFunctionTypeImpl(lType.getSource(), resultParameters, resultReturn);
    }

    private static int getIntersectionParameters(JSFunctionType commonCurrent, JSFunctionType type) {
        int min2;
        List commonCurrentParameters = commonCurrent.getParameters();
        List typeParameters = type.getParameters();
        int max1 = TypeScriptSignatureChooser.getMaxArgumentCount(commonCurrentParameters);
        int max2 = TypeScriptSignatureChooser.getMaxArgumentCount(typeParameters);
        int commonMaxLength = Math.min(max1, max2);
        int min1 = TypeScriptSignatureChooser.getMinArgumentCount(commonCurrentParameters);
        int commonMinLength = Math.max(min1, min2 = TypeScriptSignatureChooser.getMinArgumentCount(typeParameters));
        if (commonMinLength > commonMaxLength) {
            return -1;
        }
        if (commonMaxLength == commonMinLength) {
            return commonMaxLength;
        }
        return commonMaxLength == Integer.MAX_VALUE ? Math.min(commonCurrentParameters.size(), typeParameters.size()) : commonMaxLength;
    }

    @Nullable
    private static JSType getRestComponentType(@NotNull List<JSParameterTypeDecorator> parameters) {
        int size;
        if (parameters == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(92);
        }
        if ((size = parameters.size()) == 0) {
            return null;
        }
        JSParameterTypeDecorator last = parameters.get(size - 1);
        return last.isRest() && last.getType() != null ? JSTypeUtils.getIndexableComponentType(last.getType()) : null;
    }

    @Nullable
    private static JSType getCommonTypeWithDialect(@Nullable DialectOptionHolder holder, @Nullable JSType lType, @Nullable JSType rType) {
        JSType parameterType = null;
        if (lType != null && rType != null) {
            parameterType = JSTypeUtils.getCommonType(lType, rType, holder, true);
        }
        return parameterType != null ? parameterType : (lType == null ? rType : lType);
    }

    private void addCommonPropertyMember(@NotNull Collection<JSRecordType> typesToMerge, @NotNull List<JSRecordType.TypeMember> resultMembers, @NotNull JSRecordType.PropertySignature currentProperty) {
        if (typesToMerge == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(93);
        }
        if (resultMembers == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(94);
        }
        if (currentProperty == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(95);
        }
        ProgressManager.checkCanceled();
        JSType commonType = null;
        String memberName = currentProperty.getMemberName();
        JSRecordType.MemberSource source = currentProperty.getMemberSource();
        ArrayList allProps = ContainerUtil.newArrayList((Iterable)source.getAllSourceElements());
        for (JSRecordType resolvedType : typesToMerge) {
            JSRecordType.PropertySignature signature = resolvedType.findPropertySignature(memberName);
            if (signature == null) {
                return;
            }
            commonType = this.getCommonPropertyType(signature, currentProperty, commonType);
            allProps.addAll(signature.getMemberSource().getAllSourceElements());
        }
        String name = currentProperty.getMemberName();
        boolean optional = currentProperty.isOptional();
        resultMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(name, commonType, optional, JSRecordMemberSourceFactory.createSource(allProps, JSRecordType.MemberSourceKind.Union)));
    }

    @Nullable
    private JSType getCommonPropertyType(@NotNull JSRecordType.PropertySignature typeMember, @NotNull JSRecordType.PropertySignature currentProperty, @Nullable JSType commonType) {
        if (typeMember == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(96);
        }
        if (currentProperty == null) {
            JSCompositeTypeImpl.$$$reportNull$$$0(97);
        }
        if (currentProperty.isEquivalentTo((JSRecordType.TypeMember)typeMember, true)) {
            return commonType == null ? currentProperty.getType() : commonType;
        }
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (StringUtil.equals((CharSequence)currentProperty.getMemberName(), (CharSequence)typeMember.getMemberName())) {
            JSType type1 = currentProperty.getType();
            JSType type2 = typeMember.getType();
            DialectOptionHolder holder = sourceElement == null ? null : DialectDetector.dialectOfElement(sourceElement);
            JSType typeToUse = (JSType)ObjectUtils.coalesce((Object)commonType, (Object)type1);
            commonType = JSCompositeTypeImpl.getCommonTypeWithDialect(holder, typeToUse, type2);
        }
        return commonType;
    }

    @Override
    @NotNull
    public final boolean isAnyType() {
        return this.myAnyType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 15: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 64: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 87: 
            case 88: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 15: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 64: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 87: 
            case 88: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 15: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 64: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 87: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 13: 
            case 21: 
            case 42: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetKind";
                break;
            }
            case 6: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 8: 
            case 14: 
            case 17: 
            case 53: 
            case 59: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalNestedTypes";
                break;
            }
            case 20: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentOptimized";
                break;
            }
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 36: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allCommonTypes";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_types";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 65: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 77: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesToMerge";
                break;
            }
            case 78: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultMembers";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignatures";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callTable";
                break;
            }
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatures";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureTable";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentProperty";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeTypeForSubstitute";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeAndOptimizeIntersection";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setTargetAndReturnIntersection";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntersectionLikeType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenAndDeduplicate";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicate";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementType";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicateNoResolve";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonType";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompositeImpl";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesWithKind";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionSignatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeForSubstitute";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 15: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 64: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 87: 
            case 88: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeIfComposite";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeIfUnionOrIntersection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "normalizeAndOptimizeIntersection";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTargetAndReturnIntersection";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createIntersectionLikeType";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "flattenAndDeduplicate";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "deduplicate";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "toTypeForCheckingDuplication";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "deduplicateNoResolve";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isResolvedOptimizedAcceptable";
                break;
            }
            case 43: 
            case 44: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getCommonType";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "saveResolveOptimized";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "anyNestedTypeIsAssignableTo";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "anyNestedTypeEqualsTo";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "addCommonCallSignatureMembers";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addToTable";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getSignaturesWithKind";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getUnionSignatures";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getCommonFunctionType";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getRestComponentType";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "addCommonPropertyMember";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getCommonPropertyType";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "lambda$flattenAndDeduplicate$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 15: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 56: 
            case 64: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 87: 
            case 88: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

