/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspectionSuppressor;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceFileCommandCache;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceToolWindowInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceAnnotatorCheckerProvider;
import com.intellij.lang.typescript.compiler.TypeScriptToolWindowProvider;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceQueueImpl;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerState;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFixSet;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptSuppressByCommentFix;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptLanguageServiceCacheImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptServiceStandardOutputProtocol;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.CompletionDetailsRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SemanticDiagnosticsSyncRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SuggestionDiagnosticsSyncRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.SyntacticDiagnosticsSyncRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandSetRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileFileArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetProjectErrCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadFileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCompletionResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsImpl;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.update.Update;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServerServiceImpl
extends TypeScriptCompilerService {
    public static final String BODY_FIELD = "body";
    public static final String GENERATED_FILES_FIELD = "generatedFiles";
    public static final String PROCESSED_FILES_FIELD = "processedFiles";
    public static final int NO_FIX_CODE = -1;
    public static final String DIAGNOSTICS_FIELD = "diagnostics";
    protected volatile int[] myErrorCodeFixes;
    @NotNull
    protected final TypeScriptCompilerSettings mySettings;
    private final JSLanguageServiceFileCommandCache myQuickFixCache;
    @NotNull
    private final Condition<VirtualFile> myFileFilter;
    @NotNull
    private final JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> myCompletionDefaultProcessor;

    public TypeScriptServerServiceImpl(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(1);
        }
        this(project, settings, "Console");
    }

    protected TypeScriptServerServiceImpl(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings, @NotNull String consoleId) {
        if (project == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(3);
        }
        if (consoleId == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(4);
        }
        super(project, consoleId);
        this.myErrorCodeFixes = new int[0];
        this.myCompletionDefaultProcessor = (serviceObject, answer) -> {
            JsonObject element = answer.getElement();
            try {
                TypeScriptCompletionResponse response = (TypeScriptCompletionResponse)this.getGson().fromJson((JsonElement)element, TypeScriptCompletionResponse.class);
                if (response == null || response.body == null) {
                    return ContainerUtil.emptyList();
                }
                return ContainerUtil.newArrayList((Object[])response.body);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
                return ContainerUtil.emptyList();
            }
        };
        this.mySettings = settings;
        this.myQuickFixCache = new JSLanguageServiceFileCommandCache(this);
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(project);
        this.myFileFilter = service == null ? TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE : virtualFile -> {
            if (project == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(119);
            }
            if (!TypeScriptLanguageServiceUtil.IS_VALID_FILE_FOR_SERVICE.value(virtualFile)) {
                return false;
            }
            if (TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value(virtualFile)) {
                return true;
            }
            FileType type = virtualFile.getFileType();
            if (!DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type)) {
                return false;
            }
            return (Boolean)ReadAction.compute(() -> {
                if (project == null) {
                    TypeScriptServerServiceImpl.$$$reportNull$$$0(120);
                }
                if (DumbService.isDumb((Project)project)) {
                    return false;
                }
                List<TypeScriptConfig> configFiles = service.getConfigFiles();
                if (configFiles.isEmpty() || configFiles.stream().noneMatch(el -> el.allowJs())) {
                    return false;
                }
                TypeScriptConfig config2 = TypeScriptConfigUtil.getNearestParentConfig(virtualFile, configFiles);
                return config2 != null && config2.allowJs();
            });
        };
    }

    @Override
    public void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean command) {
        if (command == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(5);
        }
        if (!this.isServiceCreated()) {
            return;
        }
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process != null) {
            String path = command.getCompilerId();
            if (StringUtil.isEmpty((String)path)) {
                this.sendCommand(new TypeScriptReloadProjectsCommand());
            } else {
                TypeScriptFileWithConfigArgs args = new TypeScriptFileWithConfigArgs();
                args.projectFileName = LocalFilePath.create(path);
                this.sendCommand(new TypeScriptReloadProjectsCommand(args));
            }
            process.resetCaches();
        }
    }

    @Override
    protected void processVfsChangesForFiles(@NotNull List<VirtualFile> files) {
        if (files == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(6);
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.isReCompileOnChanges()) {
            this.addToCompileQueueWithUpdate(files);
        } else {
            TypeScriptServerState serverState = this.getServerStateIfStarted();
            if (serverState != null) {
                files.forEach(el -> serverState.addFileToVfsQueue((VirtualFile)el));
            }
        }
    }

    private void addToCompileQueueWithUpdate(@NotNull List<VirtualFile> files) {
        if (files == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(7);
        }
        ReadAction.run(() -> {
            if (files == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(118);
            }
            this.addToCompileQueueWithUpdateImpl(files);
        });
    }

    private void addToCompileQueueWithUpdateImpl(@NotNull List<VirtualFile> files) {
        if (files == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.isReCompileOnChanges() || !this.isEnabled()) {
            return;
        }
        List<String> fileNames = this.getFileNames(files);
        if (fileNames.isEmpty()) {
            return;
        }
        TypeScriptServerState serverState = this.getServerStateIfStarted();
        if (serverState != null) {
            serverState.addToCompileQueue(new Update(new TypeScriptCompileUpdater(), 10){

                public void run() {
                    if (TypeScriptServerServiceImpl.this.isServiceCreated()) {
                        JSLanguageServiceUpdateContext context = (JSLanguageServiceUpdateContext)ReadAction.compute(() -> JSHighlightingInfoBuilder.createUpdateContext(TypeScriptServerServiceImpl.this.myProject, TypeScriptServerServiceImpl.this.getAcceptableFilesFilter()));
                        TypeScriptServerServiceImpl.this.update(context);
                    }
                }
            });
        }
        this.addToCompileQueue(fileNames);
    }

    @Override
    @Nullable
    protected TypeScriptLanguageServiceQueueImpl getProcess() {
        return (TypeScriptLanguageServiceQueueImpl)super.getProcess();
    }

    @NotNull
    private List<String> getFileNames(@NotNull List<VirtualFile> files) {
        if (files == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(9);
        }
        GlobalSearchScope scope = this.getScope();
        List list = ContainerUtil.mapNotNull(files, el -> {
            if (el.isInLocalFileSystem() && el.isValid() && scope.accept(el) && null == el.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER)) {
                return TypeScriptCompilerConfigUtil.normalizeNameAndPath(el);
            }
            return null;
        });
        if (list == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    public Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> updateAndGetCompletionItems(@NotNull VirtualFile virtualFile, @NotNull PsiFile file2, @NotNull Document document, int positionInFileOffset) {
        if (virtualFile == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(12);
        }
        if (document == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process == null) {
            return null;
        }
        JSLanguageServiceUpdateContext context = JSHighlightingInfoBuilder.createUpdateContext(file2.getProject(), this.getAcceptableFilesFilter());
        TypeScriptCompletionsRequestArgs args = new TypeScriptCompletionsRequestArgs();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, virtualFile, document, positionInFileOffset);
        JSLanguageServiceSimpleCommand completionCommand = this.createCompletionCommand(args, virtualFile, file2);
        this.update(context);
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> completionProcessor = this.createCompletionProcessor();
        return process.execute(completionCommand, completionProcessor);
    }

    @Override
    @Nullable
    public Future<List<TypeScriptCompletionResponse.CompletionEntryDetail>> getDetailedCompletionItems(@NotNull VirtualFile virtualFile, @NotNull List<TypeScriptCompletionResponse.CompletionEntryDetail> items, @NotNull Document document, int positionInFileOffset) {
        if (virtualFile == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(14);
        }
        if (items == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(15);
        }
        if (document == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process == null) {
            return null;
        }
        List<String> names = items.stream().map(el -> el.name).collect(Collectors.toList());
        CompletionDetailsRequest request = new CompletionDetailsRequest(names);
        TypeScriptLanguageServiceUtil.fillFilePosition((TypeScriptFileLocationRequestArgs)request.arguments, virtualFile, document, positionInFileOffset);
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> completionProcessor = this.createCompletionProcessor();
        return process.execute(request, completionProcessor);
    }

    @Override
    @Nullable
    public TypeScriptServerServiceSettings getServiceSettings() {
        return null;
    }

    @NotNull
    protected JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> createCompletionProcessor() {
        JSLanguageServiceCommandProcessor<List<TypeScriptCompletionResponse.CompletionEntryDetail>> jSLanguageServiceCommandProcessor = this.myCompletionDefaultProcessor;
        if (jSLanguageServiceCommandProcessor == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(17);
        }
        return jSLanguageServiceCommandProcessor;
    }

    @NotNull
    protected JSLanguageServiceSimpleCommand createCompletionCommand(@NotNull TypeScriptCompletionsRequestArgs args, @NotNull VirtualFile virtualFile, @NotNull PsiFile file2) {
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(18);
        }
        if (virtualFile == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(20);
        }
        TypeScriptCompletionsCommand typeScriptCompletionsCommand = new TypeScriptCompletionsCommand(args);
        if (typeScriptCompletionsCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(21);
        }
        return typeScriptCompletionsCommand;
    }

    @Override
    @Nullable
    public Future<Boolean> update(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(22);
        }
        return this.updateImpl(context);
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceResultContainer> compileFileAndGetErrors(@NotNull VirtualFile file2) {
        TypeScriptLanguageServiceQueueImpl process;
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(23);
        }
        if ((process = this.getProcess()) == null || !TypeScriptServerServiceImpl.checkState(process)) {
            return null;
        }
        String path = file2.getPath();
        if (TypeScriptUtil.isDefinitionFile(path) || !TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)file2)) {
            return null;
        }
        TypeScriptServerServiceImpl.setUpdateForVfsChangedFiles(process);
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.includeErrors = true;
        args.force = true;
        args.file = LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(file2));
        this.setMacroParamsIfNeed(args, file2);
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        return process.execute(command, this.createCompileResultProcessor());
    }

    private static void setUpdateForVfsChangedFiles(@NotNull TypeScriptLanguageServiceQueueImpl process) {
        TypeScriptServerState state;
        Set<VirtualFile> files;
        if (process == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(24);
        }
        if ((files = (state = process.getServerState()).getVfsChangedFiles()).isEmpty()) {
            return;
        }
        files.forEach(el -> {
            if (process == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(117);
            }
            process.executeNoBlocking(new TypeScriptReloadFileCommand((VirtualFile)el), null);
        });
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull TypeScriptConfig config2) {
        TypeScriptLanguageServiceQueueImpl process;
        if (config2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(25);
        }
        if ((process = this.getProcess()) == null || !TypeScriptServerServiceImpl.checkState(process)) {
            return null;
        }
        TypeScriptServerServiceImpl.setUpdateForVfsChangedFiles(process);
        TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
        args.includeErrors = true;
        args.force = true;
        args.projectFileName = LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(config2.getConfigFile()));
        return process.execute(new TypeScriptCompileCommand(args), this.createCompileResultProcessor());
    }

    @Override
    public void closeLastEditor(@NotNull VirtualFile file2) {
        VirtualFile mainFile;
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(26);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(this.myProject)) {
            return;
        }
        if (!TypeScriptLanguageServiceUtil.isServiceEnabled(this.myProject) || !this.isServiceCreated()) {
            return;
        }
        if (this.mySettings.useMainFile() && file2.equals(mainFile = this.getMainFile())) {
            return;
        }
        String normalizeNameAndPath = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file2);
        TypeScriptFileObject arguments = new TypeScriptFileObject();
        TypeScriptCloseEditorCommand command = new TypeScriptCloseEditorCommand(arguments, file2);
        arguments.file = LocalFilePath.create(normalizeNameAndPath);
        this.sendCommand(command);
    }

    @Override
    @NotNull
    public Collection<? extends IntentionAction> getServiceFixes(@NotNull PsiFile file2, PsiElement element, @NotNull JSAnnotationError result2) {
        boolean isIntention;
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(27);
        }
        if (result2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(28);
        }
        if (!(result2 instanceof TypeScriptLanguageServiceAnnotationResult)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(29);
            }
            return list;
        }
        int code = ((TypeScriptLanguageServiceAnnotationResult)result2).getErrorCode();
        if (code == -1) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(30);
            }
            return list;
        }
        int[] codes = this.myErrorCodeFixes;
        boolean bl = isIntention = result2.getCategory() == "hide";
        if (codes.length > 0 && Arrays.stream(codes).anyMatch(el -> el == code) && file2.getVirtualFile() != null) {
            TypeScriptSuppressByCommentFix suppressByCommentFix;
            TypeScriptLanguageServiceFixSet set = new TypeScriptLanguageServiceFixSet(file2.getProject(), this.myQuickFixCache, file2.getVirtualFile(), (TypeScriptLanguageServiceAnnotationResult)result2);
            ArrayList resultActions = ContainerUtil.newArrayList();
            resultActions.addAll(set.getFixes());
            if (!isIntention && (suppressByCommentFix = this.getSuppressAction(element)) != null) {
                resultActions.add(suppressByCommentFix);
            }
            ArrayList arrayList = resultActions;
            if (arrayList == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(31);
            }
            return arrayList;
        }
        List list = isIntention ? ContainerUtil.emptyList() : ContainerUtil.createMaybeSingletonList((Object)this.getSuppressAction(element));
        if (list == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(32);
        }
        return list;
    }

    @Nullable
    public TypeScriptSuppressByCommentFix getSuppressAction(@Nullable PsiElement element) {
        if (element != null) {
            Class<? extends JSSuppressionHolder> aClass = JSInspectionSuppressor.getHolderClass(element);
            return new TypeScriptSuppressByCommentFix(aClass);
        }
        return null;
    }

    @Override
    public void openEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(33);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(this.myProject)) {
            return;
        }
        if (!TypeScriptLanguageServiceUtil.isServiceEnabled(this.myProject) || !this.isServiceCreated()) {
            return;
        }
        TypeScriptOpenEditorCommand command = TypeScriptServerServiceImpl.createOpenEditorCommand(this.myProject, file2);
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process == null) {
            return;
        }
        process.executeNoBlocking(command, null, (Consumer<? super JSLanguageServiceObject>)((Consumer)el -> {
            if (file2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(116);
            }
            this.addToCompileQueueWithUpdate(Collections.singletonList(file2));
        }));
    }

    @Override
    public boolean checkCanUseService() {
        return this.getCanStartProcessState() != ThreeState.NO && (this.mySettings.isRecompileOnChanges() || this.myFailCount.get() < (long)this.getAliveCheckCount());
    }

    @Override
    public JSLanguageServiceQueue getLSProcess() {
        return super.getLSProcess();
    }

    @Override
    @Nullable
    public Future<List<JSAnnotationError>> highlight(@NotNull PsiFile file2, @NotNull JSFileHighlightingInfo info) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(34);
        }
        if (info == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(35);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<VirtualFile> configs = TypeScriptServerServiceImpl.getChangedConfigs();
        if (configs != null && !configs.isEmpty()) {
            this.saveChangedConfigsAndRestartHighlighting(file2, configs);
            return null;
        }
        return this.updateFilesAndGetErrors(info);
    }

    @Override
    public boolean canHighlight(@NotNull PsiFile file2) {
        DialectOptionHolder holder;
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(36);
        }
        if ((holder = DialectDetector.dialectOfElement((PsiElement)file2)) == null || !holder.isTypeScript && !holder.isJavaScript()) {
            return false;
        }
        TypeScriptAnnotatorCheckerProvider provider2 = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)file2);
        if (!(provider2 instanceof TypeScriptLanguageServiceAnnotatorCheckerProvider)) {
            return false;
        }
        if (holder.isTypeScript) {
            return true;
        }
        TypeScriptConfig configForPsiFile = TypeScriptConfigUtil.getConfigForPsiFile(file2);
        return configForPsiFile != null && configForPsiFile.allowJs();
    }

    @Override
    @NotNull
    public Condition<VirtualFile> getAcceptableFilesFilter() {
        Condition<VirtualFile> condition = this.myFileFilter;
        if (condition == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(37);
        }
        return condition;
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        NodeJsInterpreter interpreter = TypeScriptLanguageServiceUtil.getNodeInterpreter(this.myProject);
        boolean hasInterpreter = interpreter != null;
        ThreeState prevValue = this.getCanStartProcessState();
        this.setCanStartProcessState(ThreeState.fromBoolean((boolean)hasInterpreter));
        if (!hasInterpreter) {
            this.showInterpreterError(prevValue);
            return null;
        }
        Ref serviceRef = Ref.create();
        Condition expiredConditionForReadyConsumer = el -> {
            JSLanguageServiceQueue service = (JSLanguageServiceQueue)serviceRef.get();
            if (service == null) {
                return false;
            }
            return !service.isValid();
        };
        Consumer<JsonObject> readyConsumer = this.createReadyConsumer((Condition<Object>)expiredConditionForReadyConsumer);
        JSLanguageServiceProtocol protocol = this.createProtocol(readyConsumer, this.getServicePath());
        if (protocol == null) {
            return null;
        }
        boolean setActive = this.myFailCount.get() == 0L;
        JSLanguageServiceQueue.ServiceInfoReporter errorReporter = this.myToolWindowManager != null ? new JSLanguageServiceToolWindowInfoReporter(this.myProject, this.getProcessName(), this.myToolWindowManager, setActive) : this.myDefaultReporter;
        Consumer<JSLanguageServiceQueue> initializer = this.getInitializedCallback();
        TypeScriptLanguageServiceQueueImpl service = null;
        try {
            String tsServicePath = TypeScriptServiceDirectoryWatcher.getService(this.myProject).calcServiceDirectoryAndRefresh();
            ProgressManager.checkCanceled();
            service = new TypeScriptLanguageServiceQueueImpl(this.myProject, protocol, this.myProcessConnector, errorReporter, new TypeScriptLanguageServiceCacheImpl(this.myProject), tsServicePath);
            serviceRef.set((Object)service);
            initializer.consume((Object)service);
            JSLanguageServiceQueue.LOGGER.trace("New service queue was created and initialized: " + service.hashCode());
            return service;
        }
        catch (Error | RuntimeException error) {
            if (service != null) {
                Disposer.dispose(service);
            }
            throw error;
        }
    }

    @NotNull
    private String getServicePath() {
        String string = TypeScriptServiceDirectoryWatcher.getService(this.myProject).calcServiceDirectoryAndRefresh();
        if (string == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    private Consumer<JsonObject> createReadyConsumer(Condition<Object> expiredCondition) {
        Consumer consumer = el -> {
            try {
                JsonElement codes;
                JsonObject message = el.getAsJsonObject("message");
                if (message == null) {
                    JSLanguageServiceQueue.LOGGER.error("No ready message");
                    return;
                }
                JsonPrimitive version = message.getAsJsonPrimitive("version");
                String versionAsString = TypeScriptLanguageServiceUtil.getNormalizedVersionString(version.getAsString());
                if (this.myToolWindowManager != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.myToolWindowManager.setName(versionAsString), expiredCondition);
                }
                if ((codes = message.get("supportedErrorCodes")) != null && codes.isJsonArray()) {
                    JsonArray array = codes.getAsJsonArray();
                    int[] result2 = new int[array.size()];
                    int i = 0;
                    for (JsonElement element : array) {
                        if (element.isJsonPrimitive()) {
                            JsonPrimitive primitive = element.getAsJsonPrimitive();
                            try {
                                if (primitive.isNumber()) {
                                    result2[i++] = primitive.getAsInt();
                                    continue;
                                }
                                if (!primitive.isString()) continue;
                                result2[i++] = Integer.valueOf(primitive.getAsString());
                            }
                            catch (Exception e) {
                                result2[i++] = -1;
                            }
                            continue;
                        }
                        result2[i++] = -1;
                    }
                    this.myErrorCodeFixes = result2;
                }
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        };
        if (consumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(39);
        }
        return consumer;
    }

    @Nullable
    protected JSLanguageServiceProtocol createProtocol(Consumer<?> readyConsumer, @NotNull String tsServicePath) {
        if (tsServicePath == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(40);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new TypeScriptServiceStandardOutputProtocol(this.myProject, this.mySettings, readyConsumer, this.createEventConsumer(), "typescript", tsServicePath);
    }

    @NotNull
    protected Consumer<JSLanguageServiceAnswer> createEventConsumer() {
        Consumer consumer = el -> {
            TypeScriptServerState serverState = this.getServerStateIfStarted();
            if (serverState == null) {
                return;
            }
            serverState.processEvent((JSLanguageServiceAnswer)el);
        };
        if (consumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(41);
        }
        return consumer;
    }

    @Override
    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return TypeScriptToolWindowProvider.getToolWindow(project);
    }

    @Override
    protected boolean needInitToolWindow() {
        return this.isEnabled();
    }

    @NotNull
    protected Consumer<JSLanguageServiceQueue> getInitializedCallback() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Map<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> commands = this.getInitialCommands();
        Consumer consumer = service -> ReadAction.run(() -> TypeScriptServerServiceImpl.sendInitialState(service, commands));
        if (consumer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(42);
        }
        return consumer;
    }

    private static void sendInitialState(@NotNull JSLanguageServiceQueue service, @NotNull Map<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> initialCommands) {
        if (service == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(43);
        }
        if (initialCommands == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(44);
        }
        JSLanguageServiceQueue.LOGGER.trace("Send initial state for " + service.hashCode());
        initialCommands.forEach((command, consumer) -> {
            if (service == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(115);
            }
            service.executeNoBlocking((JSLanguageServiceCommand)command, null, (Consumer<? super JSLanguageServiceObject>)consumer);
        });
    }

    @NotNull
    protected Map<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> getInitialCommands() {
        VirtualFile mainFile;
        ArrayList toProcess = ContainerUtil.newArrayList();
        VirtualFile virtualFile = mainFile = this.isMainFileContext() ? this.getMainFile() : null;
        if (mainFile != null) {
            toProcess.add(mainFile);
        }
        toProcess.addAll(JSHighlightingInfoBuilder.getFilteredOpenedFiles(this.myProject, this.getAcceptableFilesFilter()).keySet());
        if (toProcess.isEmpty()) {
            Map<JSLanguageServiceSimpleCommand, Consumer<JSLanguageServiceObject>> map = Collections.emptyMap();
            if (map == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(45);
            }
            return map;
        }
        HashMap commandsToConsumers = ContainerUtil.newHashMap();
        for (VirtualFile vFile : toProcess) {
            TypeScriptOpenEditorCommand command = TypeScriptServerServiceImpl.createOpenEditorCommand(this.myProject, vFile);
            Consumer consumer = serviceObject -> ReadAction.run(() -> {
                PsiFile file2;
                if (vFile.isValid() && !this.myProject.isDisposed() && (file2 = PsiManager.getInstance((Project)this.myProject).findFile(vFile)) != null) {
                    DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file2);
                }
            });
            commandsToConsumers.put(command, consumer);
        }
        HashMap hashMap = commandsToConsumers;
        if (hashMap == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(46);
        }
        return hashMap;
    }

    @Nullable
    private static Collection<VirtualFile> getChangedConfigs() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager manager = FileDocumentManager.getInstance();
        List changedConfigs = null;
        for (Document document : manager.getUnsavedDocuments()) {
            VirtualFile docFile = manager.getFile(document);
            if (docFile == null || !TypeScriptCompilerConfigUtil.isConfig(docFile, docFile.getFileType())) continue;
            if (changedConfigs == null) {
                changedConfigs = ContainerUtil.newSmartList();
            }
            changedConfigs.add(docFile);
        }
        return changedConfigs;
    }

    private void saveChangedConfigsAndRestartHighlighting(@NotNull PsiFile file2, @NotNull Collection<VirtualFile> configs) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(47);
        }
        if (configs == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(48);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (configs == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(113);
            }
            if (file2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(114);
            }
            for (VirtualFile config2 : configs) {
                Document document = FileDocumentManager.getInstance().getDocument(config2);
                if (document == null) continue;
                FileDocumentManager.getInstance().saveDocument(document);
            }
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(file2);
        }, this.myProject.getDisposed());
    }

    private boolean isEnabled() {
        return !this.myProject.isDefault() && !this.myProject.isDisposed() && this.mySettings.useService();
    }

    @Nullable
    public TypeScriptServerState getServerStateIfStarted() {
        if (this.isServiceCreated()) {
            TypeScriptLanguageServiceQueueImpl process = this.getProcess();
            if (!TypeScriptServerServiceImpl.checkState(process)) {
                return null;
            }
            return process.getServerState();
        }
        return null;
    }

    @Override
    public void flushCompileQueue() {
        TypeScriptServerState serverState = this.getServerStateIfStarted();
        if (serverState != null) {
            serverState.flushCompileQueue();
        }
    }

    private void flushProjectErrorsQueue() {
        TypeScriptServerState serverState = this.getServerStateIfStarted();
        if (serverState != null) {
            serverState.flushProjectErrorsQueue();
        }
    }

    public void flushQueues() {
        this.flushCompileQueue();
        this.flushProjectErrorsQueue();
    }

    @NotNull
    private static TypeScriptOpenEditorCommand createOpenEditorCommand(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(49);
        }
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(50);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        FileDocumentManager instance = FileDocumentManager.getInstance();
        Document document = instance.getDocument(file2);
        String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName(project, file2);
        if (document == null) {
            TypeScriptOpenEditorCommand typeScriptOpenEditorCommand;
            block6: {
                try {
                    String content = StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)file2));
                    int lineCount = StringUtil.countNewLines((CharSequence)content) + 1;
                    long contentLength = content.length();
                    int index = content.lastIndexOf(10);
                    typeScriptOpenEditorCommand = new TypeScriptOpenEditorCommand(file2, -1L, contentLength, lineCount, index == -1 ? 0 : index, null, projectFileName);
                    if (typeScriptOpenEditorCommand != null) break block6;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                TypeScriptServerServiceImpl.$$$reportNull$$$0(51);
            }
            return typeScriptOpenEditorCommand;
        }
        int lineCount = document.getLineCount();
        long contentLength = document.getTextLength();
        String content = instance.isDocumentUnsaved(document) ? document.getText() : null;
        int lastLineStartOffset = lineCount == 0 ? 0 : document.getLineStartOffset(lineCount - 1);
        TypeScriptOpenEditorCommand typeScriptOpenEditorCommand = new TypeScriptOpenEditorCommand(file2, -1L, contentLength, lineCount, lastLineStartOffset, content, projectFileName);
        if (typeScriptOpenEditorCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(52);
        }
        return typeScriptOpenEditorCommand;
    }

    @NotNull
    private JSLanguageServiceCommandProcessor<JSLanguageServiceResultContainer> createCompileResultProcessor() {
        JSLanguageServiceCommandProcessor<JSLanguageServiceResultContainer> jSLanguageServiceCommandProcessor = (serviceObject, answer) -> {
            List<String> emittedFiles;
            JsonObject element = answer.getElement();
            JsonElement body = element.get(BODY_FIELD);
            if (body == null || !body.isJsonObject()) {
                return null;
            }
            JsonObject bodyObject = body.getAsJsonObject();
            List<String> list = emittedFiles = bodyObject.has(GENERATED_FILES_FIELD) ? TypeScriptCompilerConfigUtil.jsonArrayToStringArray((JsonElement)bodyObject.getAsJsonArray(GENERATED_FILES_FIELD)) : ContainerUtil.emptyList();
            if (!emittedFiles.isEmpty()) {
                TypeScriptCompilerConfigUtil.refreshFiles(this.myProject, emittedFiles);
            }
            List<String> processedFiles = bodyObject.has(PROCESSED_FILES_FIELD) ? TypeScriptCompilerConfigUtil.jsonArrayToStringArray((JsonElement)bodyObject.getAsJsonArray(PROCESSED_FILES_FIELD)) : ContainerUtil.emptyList();
            List<JSAnnotationError> results = TypeScriptServerServiceImpl.parseAnnotationResult(this.getGson(), (JsonElement)bodyObject);
            return new JSLanguageServiceResultContainer(results, processedFiles, emittedFiles);
        };
        if (jSLanguageServiceCommandProcessor == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(53);
        }
        return jSLanguageServiceCommandProcessor;
    }

    @Nullable
    private Future<List<JSAnnotationError>> updateFilesAndGetErrors(@NotNull JSFileHighlightingInfo info) {
        TypeScriptLanguageServiceQueueImpl process;
        if (info == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(54);
        }
        if ((process = this.getProcess()) == null) {
            return null;
        }
        this.updateImpl(info.updateContext);
        VirtualFile file2 = info.file;
        final String path = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file2);
        if (path == null) {
            return null;
        }
        String config2 = this.getConfigForFile(file2);
        Collection<JSLanguageServiceCacheableCommand> commands = this.createGetErrCommand(file2, path);
        if (commands.isEmpty()) {
            return null;
        }
        ArrayList futures = ContainerUtil.newArrayList();
        for (JSLanguageServiceCacheableCommand command : commands) {
            CompletableFuture<List<JSAnnotationError>> result2 = process.executeWithCache(command, new JSLanguageServiceCacheableCommandProcessor<List<JSAnnotationError>>(){

                @Override
                public List<JSAnnotationError> process(@NotNull JSLanguageServiceCacheableCommand command, @NotNull JSLanguageServiceObject object, @NotNull JSLanguageServiceAnswer answer) {
                    if (command == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (object == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (answer == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return TypeScriptServerServiceImpl.this.parseGetErrorResult(answer, path);
                }

                @Override
                @NotNull
                public List<JSAnnotationError> processFromCache(@NotNull JSLanguageServiceCacheableCommand command, @NotNull List<JSAnnotationError> result2) {
                    if (command == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (result2 == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    List<JSAnnotationError> list = result2;
                    if (list == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 5: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 5: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "command";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "object";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "answer";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "result";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$2";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "processFromCache";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "process";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "processFromCache";
                            break;
                        }
                        case 5: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 5: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            if (result2 == null) continue;
            futures.add(result2);
        }
        CompletionStage result3 = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(el -> {
            LinkedHashSet annotations = ContainerUtil.newLinkedHashSet((Iterable)futures.stream().flatMap(future -> future.getNow(ContainerUtil.emptyList()).stream()).collect(Collectors.toList()));
            this.appendGlobalErrors(process, config2, annotations, file2);
            ArrayList list = ContainerUtil.newArrayList((Iterable)annotations);
            if (!this.mySettings.isShowAllProjectErrors() && TypeScriptServerServiceImpl.checkState(process)) {
                this.updateErrorsForCurrentSelectedEditor(file2, list);
            }
            return list;
        });
        if (this.mySettings.isShowAllProjectErrors()) {
            this.queueProjectErrorsTask(process, this.createProjectCommand(file2, path), file2);
        }
        return result3;
    }

    @NotNull
    protected List<JSAnnotationError> parseGetErrorResult(@NotNull JSLanguageServiceAnswer answer, String path) {
        JsonObject element;
        JsonElement bodyProperty;
        if (answer == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(55);
        }
        if ((bodyProperty = (element = answer.getElement()).get(BODY_FIELD)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(56);
            }
            return list;
        }
        if (bodyProperty.isJsonArray()) {
            List<JSAnnotationError> list = TypeScriptServerServiceImpl.parseDiagnosticsForFile(path, (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[])this.getGson().fromJson(bodyProperty, TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[].class));
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(57);
            }
            return list;
        }
        List<JSAnnotationError> list = TypeScriptServerServiceImpl.parseAnnotationResult(this.getGson(), bodyProperty);
        if (list == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(58);
        }
        return list;
    }

    @NotNull
    private Gson getGson() {
        Gson gson = JSLanguageServiceUtil.getGson(this);
        if (gson == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(59);
        }
        return gson;
    }

    @NotNull
    protected JSLanguageServiceCommand createProjectCommand(@NotNull VirtualFile file2, @NotNull String path) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(60);
        }
        if (path == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(61);
        }
        TypeScriptGetProjectErrCommand typeScriptGetProjectErrCommand = new TypeScriptGetProjectErrCommand(path);
        if (typeScriptGetProjectErrCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(62);
        }
        return typeScriptGetProjectErrCommand;
    }

    @Nullable
    private Future<Boolean> updateImpl(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(63);
        }
        TypeScriptLanguageServiceUpdateCommand command = this.getUpdateFilesCommand(context);
        TypeScriptLanguageServiceQueueImpl process = this.getProcess();
        if (process == null) {
            return null;
        }
        process.executeNoBlocking(command, null, (Consumer<? super JSLanguageServiceObject>)((Consumer)serviceObject -> {
            if (!this.isReCompileOnChanges() || !this.isEnabled()) {
                return;
            }
            List<VirtualFile> files = TypeScriptServerServiceImpl.getFilesToCompileFromServiceObject(serviceObject);
            this.addToCompileQueueWithUpdate(files);
        }));
        return null;
    }

    @NotNull
    private static List<VirtualFile> getFilesToCompileFromServiceObject(@NotNull JSLanguageServiceObject object) {
        if (object == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(64);
        }
        if (object instanceof TypeScriptFileObject) {
            LocalFilePath file2 = ((TypeScriptFileObject)object).file;
            List list = ContainerUtil.createMaybeSingletonList((Object)LocalFileSystem.getInstance().findFileByPath(file2.getPath()));
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(65);
            }
            return list;
        }
        if (object instanceof TypeScriptCommandSetRequest) {
            ArrayList result2 = ContainerUtil.newArrayList();
            ((TypeScriptCommandSetRequest)object).nestedRequests.forEach((obj, command) -> result2.addAll(TypeScriptServerServiceImpl.getFilesToCompileFromServiceObject(obj)));
            ArrayList arrayList = result2;
            if (arrayList == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(66);
            }
            return arrayList;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(67);
        }
        return list;
    }

    @NotNull
    protected TypeScriptLanguageServiceUpdateCommand getUpdateFilesCommand(@NotNull JSLanguageServiceUpdateContext context) {
        if (context == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(68);
        }
        HashMap timestamps = ContainerUtil.newHashMap();
        context.getTimestamps().forEach((el, value) -> timestamps.put(el, value));
        HashMap contents = ContainerUtil.newHashMap();
        context.getOpenContents().forEach((el, value) -> contents.put(el, value));
        context.getUnsavedContents().forEach((el, value) -> contents.put(el, value));
        TypeScriptLanguageServiceUpdateCommand typeScriptLanguageServiceUpdateCommand = new TypeScriptLanguageServiceUpdateCommand(timestamps, contents);
        if (typeScriptLanguageServiceUpdateCommand == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(69);
        }
        return typeScriptLanguageServiceUpdateCommand;
    }

    @NotNull
    private GlobalSearchScope getScope() {
        GlobalSearchScope globalSearchScope = ScopeChooserUtils.findScopeByName((Project)this.myProject, (String)this.mySettings.getScopeName());
        if (globalSearchScope == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(70);
        }
        return globalSearchScope;
    }

    @NotNull
    protected Collection<JSLanguageServiceCacheableCommand> createGetErrCommand(@NotNull VirtualFile file2, @NotNull String path) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(71);
        }
        if (path == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(72);
        }
        String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName(this.myProject, file2);
        SyntacticDiagnosticsSyncRequest syntactic = new SyntacticDiagnosticsSyncRequest(path, projectFileName);
        SemanticDiagnosticsSyncRequest semantic = new SemanticDiagnosticsSyncRequest(path, projectFileName);
        SuggestionDiagnosticsSyncRequest suggestion = new SuggestionDiagnosticsSyncRequest(path, projectFileName);
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new JSLanguageServiceCacheableCommand[]{semantic, syntactic, suggestion});
        if (arrayList == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(73);
        }
        return arrayList;
    }

    protected boolean isMainFileContext() {
        return TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings) && !StringUtil.isEmpty((String)this.mySettings.getMainFilePath());
    }

    @NotNull
    private static List<JSAnnotationError> parseAnnotationResult(@NotNull Gson gson, @NotNull JsonElement bodyProperty) {
        if (gson == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(74);
        }
        if (bodyProperty == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(75);
        }
        if (!bodyProperty.isJsonObject()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(76);
            }
            return list;
        }
        TypeScriptDiagnosticsResponse result2 = (TypeScriptDiagnosticsResponse)gson.fromJson(bodyProperty, TypeScriptDiagnosticsResponse.class);
        LinkedHashSet results = ContainerUtil.newLinkedHashSet();
        if (result2 == null || result2.infos == null || result2.infos.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(77);
            }
            return list;
        }
        for (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo body : result2.infos) {
            results.addAll(TypeScriptServerServiceImpl.parseDiagnosticsForFile(LocalFilePath.getPath(body.file), body.diagnostics));
        }
        ImmutableList immutableList = ContainerUtil.immutableList((List)ContainerUtil.newArrayList((Iterable)results));
        if (immutableList == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(78);
        }
        return immutableList;
    }

    @NotNull
    private static List<JSAnnotationError> parseDiagnosticsForFile(@Nullable String fileName, @Nullable TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[] diagnostics) {
        if (diagnostics == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(79);
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics diagnostic : diagnostics) {
            result2.add(TypeScriptLanguageServiceAnnotationResult.buildAnnotation(fileName, diagnostic));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(80);
        }
        return arrayList;
    }

    private void addToCompileQueue(@NotNull Collection<String> fileNames) {
        if (fileNames == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(81);
        }
        this.getCompileArguments(fileNames).forEach(this::queueCompileTask);
    }

    @NotNull
    private Collection<TypeScriptCompileFileArgs> getCompileArguments(@NotNull Collection<String> fileNames) {
        if (fileNames == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(82);
        }
        if (!fileNames.isEmpty()) {
            if (!TypeScriptLanguageServiceUtil.shouldUseMainFile(this.mySettings)) {
                Collection collection = fileNames.stream().filter(el -> !TypeScriptUtil.isDefinitionFile(el)).map(el -> {
                    VirtualFile configFile = (VirtualFile)ReadAction.compute(() -> {
                        TypeScriptConfig config2;
                        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(el);
                        if (path != null && (config2 = TypeScriptConfigUtil.getConfigForFile(this.myProject, path)) != null) {
                            return config2.getConfigFile();
                        }
                        return null;
                    });
                    TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
                    args.file = LocalFilePath.create(el);
                    if (configFile != null) {
                        args.projectFileName = LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(configFile));
                    }
                    return args;
                }).collect(Collectors.toList());
                if (collection == null) {
                    TypeScriptServerServiceImpl.$$$reportNull$$$0(83);
                }
                return collection;
            }
            String path = this.mySettings.getMainFilePath();
            if (!StringUtil.isEmpty((String)path)) {
                TypeScriptCompileFileArgs args = new TypeScriptCompileFileArgs();
                args.file = LocalFilePath.create(FileUtil.toSystemDependentName((String)path));
                args.force = true;
                List<TypeScriptCompileFileArgs> list = Collections.singletonList(args);
                if (list == null) {
                    TypeScriptServerServiceImpl.$$$reportNull$$$0(84);
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(85);
        }
        return list;
    }

    private boolean isReCompileOnChanges() {
        return this.mySettings.isRecompileOnChanges();
    }

    private void queueProjectErrorsTask(@NotNull TypeScriptLanguageServiceQueueImpl process, final @NotNull JSLanguageServiceCommand args, final @NotNull VirtualFile file2) {
        if (process == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(86);
        }
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(87);
        }
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(88);
        }
        if (!TypeScriptServerServiceImpl.checkState(process)) {
            return;
        }
        TypeScriptServerState serverState = process.getServerState();
        serverState.addToProjectErrorsQueue(new Update(args){

            public void run() {
                TypeScriptServerServiceImpl.this.updateProjectErrors(args, file2);
            }
        });
    }

    private void queueCompileTask(final @NotNull TypeScriptCompileFileArgs args) {
        VirtualFile path;
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(89);
        }
        if (!((path = LocalFileSystem.getInstance().findFileByPath(args.file.getPath())) != null && this.getScope().contains(path) && TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)path) && path.isValid())) {
            return;
        }
        this.setMacroParamsIfNeed(args, path);
        TypeScriptServerState serverState = this.getServerStateIfStarted();
        if (serverState != null) {
            serverState.addToCompileQueue(new Update(args){

                public void run() {
                    if (!path.isValid()) {
                        return;
                    }
                    TypeScriptServerServiceImpl.this.sendCompileCommand(args);
                }
            });
        }
    }

    private void setMacroParamsIfNeed(@NotNull TypeScriptCompileFileArgs args, @NotNull VirtualFile path) {
        String outDir;
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(90);
        }
        if (path == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(91);
        }
        if (this.mySettings.useDeprecatedSettings() && this.mySettings.isHasOutDirectory() && !StringUtil.isEmpty((String)(outDir = this.mySettings.getOutDirectory())) && outDir.contains("$")) {
            Pair<String, String> info = JSHighlightingInfoBuilder.getModuleInfo(this.myProject, path);
            args.contentRootForMacro = LocalFilePath.create((String)info.first);
            args.sourceRootForMacro = LocalFilePath.create((String)info.second);
        }
    }

    private void updateProjectErrors(@NotNull JSLanguageServiceCommand command, @NotNull VirtualFile file2) {
        TypeScriptLanguageServiceQueueImpl process;
        if (command == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(92);
        }
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(93);
        }
        if (!TypeScriptServerServiceImpl.checkState(process = this.getProcess())) {
            return;
        }
        TypeScriptServerState serverState = process.getServerState();
        ConcurrentList answers = ContainerUtil.createConcurrentList();
        Consumer tracker = el -> answers.add(el);
        serverState.registerEventTracker("syntaxDiag", (Consumer<JSLanguageServiceAnswer>)tracker);
        serverState.registerEventTracker("semanticDiag", (Consumer<JSLanguageServiceAnswer>)tracker);
        LinkedHashSet results = ContainerUtil.newLinkedHashSet();
        String config2 = this.getConfigForFile(file2);
        Consumer processor = answer -> {
            boolean isRemoved;
            if (file2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(112);
            }
            if (!(isRemoved = serverState.removeEventTracker("syntaxDiag", (Consumer<JSLanguageServiceAnswer>)tracker) & serverState.removeEventTracker("semanticDiag", (Consumer<JSLanguageServiceAnswer>)tracker))) {
                return;
            }
            this.appendGlobalErrors(process, config2, results, file2);
            results.addAll(TypeScriptServerServiceImpl.convertEventsToAnnotations((List<JSLanguageServiceAnswer>)answers, JSLanguageServiceUtil.getGson(this)));
            if (TypeScriptServerServiceImpl.checkState(process)) {
                this.updateErrorsForCurrentSelectedEditor(file2, ContainerUtil.newArrayList((Iterable)results));
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            process.execute(command, (obj, answer) -> {
                processor.consume((Object)answer);
                return null;
            });
        } else {
            process.executeNoBlocking(command, (Consumer<? super JSLanguageServiceAnswer>)processor);
        }
    }

    @Nullable
    protected String getConfigForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(94);
        }
        return (String)ReadAction.compute(() -> {
            if (file2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(111);
            }
            return TypeScriptCompilerConfigUtil.getConfigIdForFile(this.myProject, file2);
        });
    }

    private void appendGlobalErrors(@NotNull TypeScriptLanguageServiceQueueImpl process, @Nullable String config2, @NotNull Collection<JSAnnotationError> results, @NotNull VirtualFile file2) {
        if (process == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(95);
        }
        if (results == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(96);
        }
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(97);
        }
        if (this.isMainFileContext()) {
            VirtualFile mainFile = this.getMainFile();
            if (mainFile != null) {
                ReadAction.run(() -> {
                    if (file2 == null) {
                        TypeScriptServerServiceImpl.$$$reportNull$$$0(109);
                    }
                    if (results == null) {
                        TypeScriptServerServiceImpl.$$$reportNull$$$0(110);
                    }
                    if (DumbService.isDumb((Project)this.myProject)) {
                        return;
                    }
                    TypeScriptImportGraph graph = new TypeScriptImportGraph(new TypeScriptFileImportsImpl(this.myProject, mainFile));
                    if (!graph.containsFile(file2)) {
                        results.add(new TypeScriptLanguageServiceAnnotationResult("File was not processed because there is no a reference from main file", TypeScriptCompilerConfigUtil.normalizeNameAndPath(file2)));
                    }
                });
            }
            return;
        }
        if (config2 == null && !this.skipConfigNotFoundError(file2)) {
            results.add(new TypeScriptLanguageServiceAnnotationResult("Cannot find parent 'tsconfig.json'", TypeScriptCompilerConfigUtil.normalizeNameAndPath(file2)));
        }
        if (config2 == null) {
            return;
        }
        TypeScriptServerState serverState = process.getServerState();
        JSLanguageServiceAnswer configErrors = serverState.getConfigDiagnostics(config2);
        if (configErrors == null) {
            return;
        }
        JsonObject body = configErrors.getElement().get(BODY_FIELD).getAsJsonObject();
        JsonElement diags = body.get(DIAGNOSTICS_FIELD);
        if (diags == null) {
            return;
        }
        TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[] diagnostics = (TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[])this.getGson().fromJson(diags, TypeScriptDiagnosticsResponse.DiagnosticsResponseDiagnostics[].class);
        results.addAll(TypeScriptServerServiceImpl.parseDiagnosticsForFile(config2, diagnostics));
    }

    @Nullable
    private VirtualFile getMainFile() {
        String mainPath = this.mySettings.getMainFilePath();
        return StringUtil.isEmpty((String)mainPath) ? null : LocalFileSystem.getInstance().findFileByPath(mainPath);
    }

    protected boolean skipConfigNotFoundError(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(98);
        }
        return !StringUtil.isEmpty((String)this.mySettings.getDefaultServiceOptions()) || this.mySettings.useDeprecatedSettings() || this.mySettings.useMainFile() || !TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)file2);
    }

    private static List<JSAnnotationError> convertEventsToAnnotations(@NotNull List<JSLanguageServiceAnswer> answers, @NotNull Gson gson) {
        if (answers == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(99);
        }
        if (gson == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(100);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (JSLanguageServiceAnswer answer : answers) {
            JsonObject element = answer.getElement();
            JsonElement body = element.get(BODY_FIELD);
            if (body == null) continue;
            TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo responseInfo = (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo)gson.fromJson(body, TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo.class);
            result2.addAll(TypeScriptServerServiceImpl.parseDiagnosticsForFile(LocalFilePath.getPath(responseInfo.file), responseInfo.diagnostics));
        }
        return ContainerUtil.immutableList((List)ContainerUtil.sorted((Collection)result2, Comparator.comparing(el -> el.getAbsoluteFilePath())));
    }

    private void updateErrorsForCurrentSelectedEditor(@NotNull VirtualFile file2, @Nullable List<JSAnnotationError> results) {
        if (file2 == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(101);
        }
        Runnable runnable = () -> {
            VirtualFile editorFile;
            if (file2 == null) {
                TypeScriptServerServiceImpl.$$$reportNull$$$0(108);
            }
            if (!this.myProject.isOpen() || this.myProject.isDisposed() || !this.isServiceCreated()) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            if (editor instanceof EditorEx && file2.equals(editorFile = ((EditorEx)editor).getVirtualFile())) {
                this.getDefaultReporter().logCurrentErrors(results == null ? ContainerUtil.emptyList() : results);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ReadAction.run(() -> runnable.run());
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, this.myProject.getDisposed());
        }
    }

    protected static boolean checkState(@Nullable JSLanguageServiceQueue process) {
        if (process == null) {
            return false;
        }
        return process.isValid();
    }

    private void showInterpreterError(@NotNull ThreeState prevValue) {
        if (prevValue == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(102);
        }
        if (prevValue != this.getCanStartProcessState()) {
            Runnable runnable = () -> ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myToolWindowManager != null) {
                    this.myToolWindowManager.logCurrentErrors((List<JSAnnotationError>)JSLanguageServiceAnnotationResult.buildError(JSBundle.message((String)"javascript.service.node.error", (Object[])new Object[0])), this.mySettings.isRecompileOnChanges() || this.mySettings.useServiceForProjectsWithoutConfig());
                }
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }, this.myProject.getDisposed());
            if (this.myProject.isOpen()) {
                StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(runnable);
            }
        }
    }

    @Override
    @NotNull
    protected String getProcessName() {
        if ("TypeScript" == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(103);
        }
        return "TypeScript";
    }

    private void sendCompileCommand(@NotNull TypeScriptCompileFileArgs args) {
        TypeScriptLanguageServiceQueueImpl process;
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(104);
        }
        if (!TypeScriptServerServiceImpl.checkState(process = this.getProcess())) {
            return;
        }
        this.sendCompile(args, process);
    }

    @Override
    protected boolean checkServiceQueueAliveUnderLock(@NotNull JSLanguageServiceExecutor serviceQueue) {
        if (serviceQueue == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(105);
        }
        if (!super.checkServiceQueueAliveUnderLock(serviceQueue)) {
            return false;
        }
        TypeScriptServerState serverState = ((TypeScriptLanguageServiceQueueImpl)serviceQueue).getServerState();
        return serverState.isServiceValid();
    }

    private void sendCompile(@NotNull TypeScriptCompileFileArgs args, @NotNull JSLanguageServiceQueue process) {
        if (args == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(106);
        }
        if (process == null) {
            TypeScriptServerServiceImpl.$$$reportNull$$$0(107);
        }
        TypeScriptCompileCommand command = new TypeScriptCompileCommand(args);
        Consumer consumer = answer -> {
            JsonObject element = answer.getElement();
            JsonElement jsonElement = element.get(BODY_FIELD);
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                return;
            }
            TypeScriptCompilerConfigUtil.processEmitFilesAfterCompiling(this.myProject, jsonElement.getAsJsonObject(), GENERATED_FILES_FIELD);
        };
        process.executeNoBlocking(command, (Consumer<? super JSLanguageServiceAnswer>)consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 17: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 103: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 17: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 103: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleId";
                break;
            }
            case 5: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: 
            case 17: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl";
                break;
            }
            case 11: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 12: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 36: 
            case 47: 
            case 50: 
            case 60: 
            case 71: 
            case 88: 
            case 93: 
            case 94: 
            case 97: 
            case 98: 
            case 101: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 114: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 18: 
            case 87: 
            case 89: 
            case 90: 
            case 104: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 22: 
            case 63: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 24: 
            case 86: 
            case 95: 
            case 107: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 35: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsServicePath";
                break;
            }
            case 43: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialCommands";
                break;
            }
            case 48: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 61: 
            case 72: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 74: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gson";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyProperty";
                break;
            }
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 96: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answers";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevValue";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionProcessor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionCommand";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceFixes";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptableFilesFilter";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getServicePath";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createReadyConsumer";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createEventConsumer";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializedCallback";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialCommands";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpenEditorCommand";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompileResultProcessor";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGetErrorResult";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getGson";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectCommand";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToCompileFromServiceObject";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateFilesCommand";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "createGetErrCommand";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAnnotationResult";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDiagnosticsForFile";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompileArguments";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sendCleanCommandToCompiler";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processVfsChangesForFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addToCompileQueueWithUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addToCompileQueueWithUpdateImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileNames";
                break;
            }
            case 10: 
            case 17: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 103: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateAndGetCompletionItems";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDetailedCompletionItems";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionCommand";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "compileFileAndGetErrors";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setUpdateForVfsChangedFiles";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "compileConfigProjectAndGetErrors";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "closeLastEditor";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getServiceFixes";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "canHighlight";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createProtocol";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "sendInitialState";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "saveChangedConfigsAndRestartHighlighting";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createOpenEditorCommand";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "updateFilesAndGetErrors";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "parseGetErrorResult";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createProjectCommand";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToCompileFromServiceObject";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateFilesCommand";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createGetErrCommand";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "parseAnnotationResult";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addToCompileQueue";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getCompileArguments";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "queueProjectErrorsTask";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "queueCompileTask";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "setMacroParamsIfNeed";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "updateProjectErrors";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForFile";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "appendGlobalErrors";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "skipConfigNotFoundError";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "convertEventsToAnnotations";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "updateErrorsForCurrentSelectedEditor";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "showInterpreterError";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "sendCompileCommand";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceQueueAliveUnderLock";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "sendCompile";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateErrorsForCurrentSelectedEditor$38";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "lambda$appendGlobalErrors$36";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getConfigForFile$35";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateProjectErrors$33";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "lambda$saveChangedConfigsAndRestartHighlighting$20";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sendInitialState$17";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openEditor$10";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setUpdateForVfsChangedFiles$8";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addToCompileQueueWithUpdate$5";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$3";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 17: 
            case 21: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 73: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 103: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeScriptCompileUpdater {
        private TypeScriptCompileUpdater() {
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }
    }
}

