/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModuleReferenceBase;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u0002J\u0011\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\rH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\rH\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010$\u001a\u00020!H\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010\u00142\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u001a\u0010(\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u001a\u0010*\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0014H\u0002J\"\u0010,\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020!H\u0002J\"\u0010/\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u00142\u0006\u0010.\u001a\u00020!H\u0002J\u001a\u00101\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u00102\u001a\u00020!H\u0002J\u001a\u00103\u001a\u0004\u0018\u00010\u00142\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u001a\u00104\u001a\u0004\u0018\u00010\u00142\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u001a\u00105\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u001a\u00106\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0010\u00107\u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u001e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00140=H\u0016J\u0018\u0010>\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0014J\u0014\u0010?\u001a\u0004\u0018\u00010\u00142\b\u0010@\u001a\u0004\u0018\u00010\u0014H\u0002J\u001a\u0010A\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010B\u001a\u00020\u000bH\u0002J\u0012\u0010C\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u001a\u0010D\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0014H\u0002J\u001a\u0010E\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0014H\u0002R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/lang/typescript/tsconfig/TypeScriptFileImportsResolverImpl;", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptFileImportsResolver;", "project", "Lcom/intellij/openapi/project/Project;", "resolveContext", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptImportResolveContext;", "nodeProcessor", "Lcom/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/tsconfig/TypeScriptImportResolveContext;Lcom/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor;)V", "extensions", "", "", "fileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/tsconfig/TypeScriptImportResolveContext;Lcom/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor;[Ljava/lang/String;Ljava/util/Collection;)V", "[Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "classicNameResolver", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleName", "containingFile", "findRootDirWithLongestPrefix", "candidate", "directory", "getBaseUrl", "getExtensionsWithDot", "()[Ljava/lang/String;", "getPathMappings", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "getRootDirs", "hasPathMappings", "", "isClassic", "isExternalModuleNameRelative", "isUnknown", "loadModuleFromFile", "relativePath", "containingDirectory", "loadModuleFromNodeModules", "loadModuleFromNodeModulesAtTypes", "loadModuleFromNodeModulesFolder", "nodeModulesFolder", "loadModuleFromNodeModulesOneLevel", "nodeModulesDirectory", "typesOnly", "loadModuleFromNodeModulesWorker", "toSearchDir", "loadNodeModuleFromDirectory", "considerPackageJson", "loader", "nodeLoadModuleByRelativeName", "nodeModuleNameResolver", "nodeModuleNameResolverWorker", "pathEndsWithDirectorySeparator", "processAllFilesInScope", "", "includeScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "processor", "Lcom/intellij/util/Processor;", "resolveFileModule", "toPreferredFileModule", "file", "tryAddingExtensions", "name", "tryLoadModuleUsingBaseUrl", "tryLoadModuleUsingOptionalResolutionSettings", "tryLoadModuleUsingRootDirs", "intellij.javascript.impl"})
public class TypeScriptFileImportsResolverImpl
implements TypeScriptFileImportsResolver {
    @NotNull
    private final Project project;
    private final TypeScriptImportResolveContext resolveContext;
    private final NodeModuleDirectorySearchProcessor nodeProcessor;
    private final String[] extensions;
    private final Collection<FileType> fileTypes;

    @Override
    @NotNull
    public final String[] getExtensionsWithDot() {
        return this.extensions;
    }

    @Override
    public void processAllFilesInScope(@NotNull GlobalSearchScope includeScope, @NotNull Processor<VirtualFile> processor) {
        Intrinsics.checkParameterIsNotNull((Object)includeScope, (String)"includeScope");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        for (FileType type : this.fileTypes) {
            ProgressManager.checkCanceled();
            FileTypeIndex.processFiles((FileType)type, processor, (GlobalSearchScope)includeScope);
        }
    }

    @Override
    @Nullable
    public final VirtualFile resolveFileModule(@NotNull String moduleName, @NotNull VirtualFile containingFile) {
        VirtualFile result2;
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Intrinsics.checkParameterIsNotNull((Object)containingFile, (String)"containingFile");
        ProgressManager.checkCanceled();
        VirtualFile virtualFile = containingFile.getParent();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile containingDirectory = virtualFile;
        if ((this.isClassic() || this.isUnknown()) && ((result2 = this.classicNameResolver(moduleName, containingFile)) != null || this.isClassic())) {
            return this.toPreferredFileModule(result2);
        }
        return this.toPreferredFileModule(this.nodeModuleNameResolver(moduleName, containingDirectory));
    }

    private final VirtualFile toPreferredFileModule(VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        return this.resolveContext.preserveSymlinks() ? file2 : JSModuleReferenceBase.getCanonicalPreferredFile(this.project, file2);
    }

    private final VirtualFile nodeModuleNameResolverWorker(String moduleName, VirtualFile containingDirectory) {
        VirtualFile optionalResolved = this.tryLoadModuleUsingOptionalResolutionSettings(moduleName, containingDirectory);
        if (optionalResolved != null) {
            return optionalResolved;
        }
        if (!this.isExternalModuleNameRelative(moduleName)) {
            VirtualFile candidate = this.loadModuleFromNodeModules(moduleName, containingDirectory);
            if (candidate != null) {
                return candidate;
            }
        } else {
            VirtualFile candidate = this.nodeLoadModuleByRelativeName(moduleName, containingDirectory);
            if (candidate != null) {
                return candidate;
            }
        }
        return this.loadModuleFromFile(moduleName, containingDirectory);
    }

    private final VirtualFile findRootDirWithLongestPrefix(String candidate, VirtualFile directory) {
        VirtualFile matchedRootDir = null;
        String matchedNormalizedPrefix = null;
        for (VirtualFile rootDir : this.getRootDirs()) {
            String rootDirPath = rootDir.getPath() + '/';
            boolean isLongestMatchingPrefix = StringsKt.startsWith$default((String)candidate, (String)rootDirPath, (boolean)false, (int)2, null) && (matchedNormalizedPrefix == null || matchedNormalizedPrefix.length() < rootDirPath.length());
            if (!isLongestMatchingPrefix) continue;
            matchedRootDir = rootDir;
            matchedNormalizedPrefix = rootDirPath;
        }
        return matchedRootDir;
    }

    private final boolean isClassic() {
        return this.resolveContext.moduleResolution() == TypeScriptConfig.ModuleResolution.CLASSIC;
    }

    private final boolean isUnknown() {
        return this.resolveContext.moduleResolution() == TypeScriptConfig.ModuleResolution.UNKNOWN;
    }

    private final boolean hasPathMappings() {
        return !this.resolveContext.pathsMappings().isEmpty();
    }

    private final VirtualFile getBaseUrl() {
        return this.resolveContext.baseUrl();
    }

    private final Collection<VirtualFile> getRootDirs() {
        Collection<VirtualFile> collection = this.resolveContext.rootDirs();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"resolveContext.rootDirs()");
        return collection;
    }

    private final Collection<JSModulePathSubstitution> getPathMappings() {
        Collection<JSModulePathSubstitution> collection = this.resolveContext.pathsMappings();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"resolveContext.pathsMappings()");
        return collection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isExternalModuleNameRelative(String moduleName) {
        String path = FileUtil.toSystemIndependentName((String)moduleName);
        if (Intrinsics.areEqual((Object)path, (Object)".")) return true;
        if (Intrinsics.areEqual((Object)path, (Object)"..")) return true;
        String string = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
        if (StringsKt.startsWith$default((String)string, (String)"./", (boolean)false, (int)2, null)) return true;
        if (StringsKt.startsWith$default((String)path, (String)"../", (boolean)false, (int)2, null)) return true;
        if (!TypeScriptConfigUtil.isRootDiskPath(moduleName)) return false;
        return true;
    }

    private final boolean pathEndsWithDirectorySeparator(String moduleName) {
        return StringsKt.endsWith$default((String)moduleName, (String)"/", (boolean)false, (int)2, null);
    }

    private final VirtualFile classicNameResolver(String moduleName, VirtualFile containingFile) {
        VirtualFile containingDirectory;
        VirtualFile virtualFile = containingDirectory = containingFile.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"containingDirectory");
        VirtualFile optionalResolved = this.tryLoadModuleUsingOptionalResolutionSettings(moduleName, virtualFile);
        if (optionalResolved != null) {
            return optionalResolved;
        }
        if (!this.isExternalModuleNameRelative(moduleName)) {
            VirtualFile iteratedOverParent = TypeScriptUtil.calcFileByReferencePath(this.project, containingFile, moduleName);
            if (iteratedOverParent != null) {
                return iteratedOverParent;
            }
            return this.loadModuleFromNodeModulesAtTypes(moduleName, containingDirectory);
        }
        return this.loadModuleFromFile(moduleName, containingDirectory);
    }

    private final VirtualFile nodeModuleNameResolver(String moduleName, VirtualFile containingDirectory) {
        return this.nodeModuleNameResolverWorker(moduleName, containingDirectory);
    }

    private final VirtualFile tryLoadModuleUsingOptionalResolutionSettings(String moduleName, VirtualFile containingDirectory) {
        if (this.isExternalModuleNameRelative(moduleName)) {
            return this.tryLoadModuleUsingRootDirs(moduleName, containingDirectory);
        }
        return this.tryLoadModuleUsingBaseUrl(moduleName);
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile tryLoadModuleUsingBaseUrl(String moduleName) {
        Collection<JSModulePathSubstitution> mappings;
        Pair<JSModulePathSubstitution, String> matchedElement;
        VirtualFile virtualFile = this.getBaseUrl();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile baseUrl = virtualFile;
        if (this.hasPathMappings() && (matchedElement = JSPathMappingsUtil.findMaxElementByPaths(moduleName, mappings = this.getPathMappings())) != null) {
            Object item$iv$iv2;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            JSModulePathSubstitution matchedPattern = (JSModulePathSubstitution)matchedElement.getFirst();
            String matchedStar = (String)matchedElement.getSecond();
            Collection<String> forFileReference = JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, true);
            Collection<String> forExactReference = JSPathMappingsUtil.getMappings(matchedPattern, matchedStar, false);
            if (forExactReference.isEmpty() && forFileReference.isEmpty()) {
                return null;
            }
            Collection<String> collection = forExactReference;
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"forExactReference");
            Collection<String> collection2 = forFileReference;
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"forFileReference");
            Iterable iterable = CollectionsKt.plus(collection, (Iterable)collection2);
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv2;
                Collection collection3 = destination$iv$iv;
                String string2 = JSPathMappingsUtil.replaceStarForMapping((String)it, matchedStar);
                collection3.add(string2);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            item$iv$iv2 = $receiver$iv$iv$iv.iterator();
            while (item$iv$iv2.hasNext()) {
                VirtualFile virtualFile2;
                String it;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = item$iv$iv2.next();
                String string = it = (String)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                if (this.loader(string, baseUrl) == null) continue;
                VirtualFile it$iv$iv = virtualFile2;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            iterator = $receiver$iv.iterator();
            if (iterator.hasNext()) {
                Object element$iv = iterator.next();
                VirtualFile it = (VirtualFile)element$iv;
                return it;
            }
        }
        return this.loader(moduleName, baseUrl);
    }

    private final VirtualFile loadModuleFromNodeModules(String moduleName, VirtualFile containingFile) {
        return this.loadModuleFromNodeModulesWorker(moduleName, containingFile, false);
    }

    private final VirtualFile tryLoadModuleUsingRootDirs(String moduleName, VirtualFile directory) {
        String candidatePath;
        Collection<VirtualFile> rootDirs = this.getRootDirs();
        if (rootDirs.isEmpty()) {
            return null;
        }
        String string = candidatePath = JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(directory, moduleName);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"candidatePath");
        VirtualFile rootDir = this.findRootDirWithLongestPrefix(string, directory);
        if (rootDir != null) {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            VirtualFile defaultFile = this.loader(moduleName, directory);
            if (defaultFile != null) {
                return defaultFile;
            }
            Object object = candidatePath;
            int n = rootDir.getPath().length() + 1;
            String string2 = ((String)object).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            String suffix = string2;
            object = rootDirs;
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                if (!(rootDir != it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                VirtualFile virtualFile;
                Object element$iv$iv = element$iv$iv$iv;
                VirtualFile it = (VirtualFile)element$iv$iv;
                if (this.loader(suffix, it) == null) continue;
                VirtualFile it$iv$iv = virtualFile;
                destination$iv$iv.add(it$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            iterator = $receiver$iv.iterator();
            if (iterator.hasNext()) {
                Object element$iv = iterator.next();
                VirtualFile it = (VirtualFile)element$iv;
                return it;
            }
        }
        return null;
    }

    private final VirtualFile loader(String relativePath, VirtualFile directory) {
        if (this.isClassic()) {
            return this.loadModuleFromFile(relativePath, directory);
        }
        return this.nodeLoadModuleByRelativeName(relativePath, directory);
    }

    private final VirtualFile loadModuleFromFile(String relativePath, VirtualFile containingDirectory) {
        VirtualFile exactFile;
        String name;
        VirtualFile directory;
        String path;
        if (StringsKt.endsWith$default((String)relativePath, (String)"/", (boolean)false, (int)2, null)) {
            return null;
        }
        String string = path = JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(containingDirectory, relativePath);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
        int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)string, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (lastIndexOf >= 0) {
            String string2 = path;
            int n = 0;
            String string3 = string2.substring(n, lastIndexOf);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String directoryPath = string3;
            VirtualFile virtualFile = containingDirectory.getFileSystem().findFileByPath(directoryPath);
            if (virtualFile == null) {
                return null;
            }
            directory = virtualFile;
            string2 = path;
            n = lastIndexOf + 1;
            String string4 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            name = string4;
        } else {
            name = relativePath;
            directory = containingDirectory;
        }
        VirtualFile candidate = this.tryAddingExtensions(directory, name);
        if (candidate != null && !candidate.isDirectory()) {
            return candidate;
        }
        if (TypeScriptFileImportsResolver.hasJsExtension(name)) {
            String nameWithoutExtension;
            String string5 = nameWithoutExtension = FileUtil.getNameWithoutExtension((String)name);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"nameWithoutExtension");
            VirtualFile tsCandidateForJSFile = this.tryAddingExtensions(directory, string5);
            if (tsCandidateForJSFile != null && !tsCandidateForJSFile.isDirectory()) {
                return tsCandidateForJSFile;
            }
        }
        if ((exactFile = directory.findChild(name)) != null && !exactFile.isDirectory()) {
            return exactFile;
        }
        return null;
    }

    private final VirtualFile tryAddingExtensions(VirtualFile directory, String name) {
        String[] $receiver$iv;
        String[] stringArray = $receiver$iv = this.extensions;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = stringArray[i];
            VirtualFile candidate = directory.findChild(name + it);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private final VirtualFile loadNodeModuleFromDirectory(VirtualFile directory, boolean considerPackageJson) {
        ResolvedModuleInfo resolvedModuleInfo = this.nodeProcessor.loadDirectory(null, directory, ModuleType.NODE_MODULES_DIR, considerPackageJson);
        return resolvedModuleInfo != null ? resolvedModuleInfo.getModuleMainFile() : null;
    }

    private final VirtualFile nodeLoadModuleByRelativeName(String relativePath, VirtualFile containingDirectory) {
        VirtualFile directoryCandidate;
        VirtualFile candidate;
        if (!this.pathEndsWithDirectorySeparator(relativePath) && (candidate = this.loadModuleFromFile(relativePath, containingDirectory)) != null) {
            return candidate;
        }
        VirtualFile virtualFile = JSPathMappingsUtil.getPathRelativeBaseUrl(containingDirectory, relativePath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = directoryCandidate = virtualFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"directoryCandidate");
        return this.loadNodeModuleFromDirectory(virtualFile2, true);
    }

    private final VirtualFile loadModuleFromNodeModulesAtTypes(String moduleName, VirtualFile containingDirectory) {
        return this.loadModuleFromNodeModulesWorker(moduleName, containingDirectory, true);
    }

    private final VirtualFile loadModuleFromNodeModulesWorker(String moduleName, VirtualFile toSearchDir, boolean typesOnly) {
        VirtualFile startDir = toSearchDir;
        while (startDir != null) {
            VirtualFile parent;
            VirtualFile nodeModulesDirectory = startDir.findChild("node_modules");
            if (nodeModulesDirectory == null) {
                nodeModulesDirectory = NodeModuleUtil.findUpClosestNodeModulesResolveRoot(startDir);
            }
            if (nodeModulesDirectory == null) break;
            VirtualFile candidate = this.loadModuleFromNodeModulesOneLevel(moduleName, nodeModulesDirectory, typesOnly);
            if (candidate != null) {
                return candidate;
            }
            if (nodeModulesDirectory.getParent() == null) {
                return null;
            }
            startDir = parent.getParent();
        }
        return null;
    }

    private final VirtualFile loadModuleFromNodeModulesOneLevel(String moduleName, VirtualFile nodeModulesDirectory, boolean typesOnly) {
        VirtualFile moduleFile;
        VirtualFile virtualFile = moduleFile = typesOnly ? null : this.loadModuleFromNodeModulesFolder(moduleName, nodeModulesDirectory);
        if (moduleFile != null) {
            return moduleFile;
        }
        VirtualFile virtualFile2 = nodeModulesDirectory.findChild("@types");
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile typesDirectory = virtualFile2;
        String moduleNameForProcessing = moduleName;
        if (StringsKt.startsWith$default((String)moduleName, (String)"@", (boolean)false, (int)2, null)) {
            int firstSeparatorIndex = StringsKt.indexOf$default((CharSequence)moduleName, (char)'/', (int)0, (boolean)false, (int)6, null);
            int length = moduleName.length();
            if (firstSeparatorIndex != -1 && length > firstSeparatorIndex) {
                String string;
                int endOfScopedModule = StringsKt.indexOf$default((CharSequence)moduleName, (char)'/', (int)(firstSeparatorIndex + 1), (boolean)false, (int)4, null);
                if (endOfScopedModule == -1) {
                    endOfScopedModule = length;
                }
                String string2 = moduleName;
                int n = 1;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, endOfScopedModule);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String packageName = StringUtil.replace((String)string4, (String)"/", (String)"__");
                if (endOfScopedModule == length - 1) {
                    string = "";
                } else {
                    String string5;
                    String string6 = string5 = moduleName;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(endOfScopedModule);
                    string = string7;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                }
                String suffix = string;
                moduleNameForProcessing = packageName + suffix;
            }
        }
        VirtualFile virtualFile3 = typesDirectory;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"typesDirectory");
        return this.loadModuleFromNodeModulesFolder(moduleNameForProcessing, virtualFile3);
    }

    private final VirtualFile loadModuleFromNodeModulesFolder(String moduleName, VirtualFile nodeModulesFolder) {
        VirtualFile directoryCandidate;
        VirtualFile exactFile = this.loadModuleFromFile(moduleName, nodeModulesFolder);
        if (exactFile != null) {
            return exactFile;
        }
        VirtualFile virtualFile = JSPathMappingsUtil.getPathRelativeBaseUrl(nodeModulesFolder, moduleName);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = directoryCandidate = virtualFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"directoryCandidate");
        return this.loadNodeModuleFromDirectory(virtualFile2, true);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public TypeScriptFileImportsResolverImpl(@NotNull Project project, @NotNull TypeScriptImportResolveContext resolveContext, @NotNull NodeModuleDirectorySearchProcessor nodeProcessor, @NotNull String[] extensions, @NotNull Collection<? extends FileType> fileTypes) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)resolveContext, (String)"resolveContext");
        Intrinsics.checkParameterIsNotNull((Object)nodeProcessor, (String)"nodeProcessor");
        Intrinsics.checkParameterIsNotNull((Object)extensions, (String)"extensions");
        Intrinsics.checkParameterIsNotNull(fileTypes, (String)"fileTypes");
        this.project = project;
        this.resolveContext = resolveContext;
        this.nodeProcessor = nodeProcessor;
        this.extensions = extensions;
        this.fileTypes = fileTypes;
    }

    public TypeScriptFileImportsResolverImpl(@NotNull Project project, @NotNull TypeScriptImportResolveContext resolveContext, @NotNull NodeModuleDirectorySearchProcessor nodeProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)resolveContext, (String)"resolveContext");
        Intrinsics.checkParameterIsNotNull((Object)nodeProcessor, (String)"nodeProcessor");
        Intrinsics.checkExpressionValueIsNotNull((Object)TypeScriptFileImportsResolver.TS_EXTENSIONS, (String)"TypeScriptFileImportsResolver.TS_EXTENSIONS");
        Collection<FileType> collection = TypeScriptUtil.TYPESCRIPT_FILE_TYPES;
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"TypeScriptUtil.TYPESCRIPT_FILE_TYPES");
        this(project, resolveContext, nodeProcessor, TypeScriptFileImportsResolver.TS_EXTENSIONS, collection);
    }
}

