/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Vr2dDisplayProperties;
import android.app.VrStateCallback;
import android.os.Handler;
import android.os.RemoteException;
import android.service.vr.IPersistentVrStateCallbacks;
import android.service.vr.IVrManager;
import android.service.vr.IVrStateCallbacks;
import android.util.ArrayMap;
import java.util.Map;

public class VrManager {
    private final IVrManager mService;
    private Map<VrStateCallback, CallbackEntry> mCallbackMap = new ArrayMap<VrStateCallback, CallbackEntry>();

    public VrManager(IVrManager service) {
        this.mService = service;
    }

    public void registerVrStateCallback(VrStateCallback callback, Handler handler) {
        if (callback == null || this.mCallbackMap.containsKey(callback)) {
            return;
        }
        CallbackEntry entry = new CallbackEntry(callback, handler);
        this.mCallbackMap.put(callback, entry);
        try {
            this.mService.registerListener(entry.mStateCallback);
            this.mService.registerPersistentVrStateListener(entry.mPersistentStateCallback);
        }
        catch (RemoteException e) {
            try {
                this.unregisterVrStateCallback(callback);
            }
            catch (Exception ignore) {
                e.rethrowFromSystemServer();
            }
        }
    }

    public void unregisterVrStateCallback(VrStateCallback callback) {
        CallbackEntry entry = this.mCallbackMap.remove(callback);
        if (entry != null) {
            try {
                this.mService.unregisterListener(entry.mStateCallback);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            try {
                this.mService.unregisterPersistentVrStateListener(entry.mPersistentStateCallback);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public boolean getVrModeEnabled() {
        try {
            return this.mService.getVrModeState();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public boolean getPersistentVrModeEnabled() {
        try {
            return this.mService.getPersistentVrModeEnabled();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public void setPersistentVrModeEnabled(boolean enabled) {
        try {
            this.mService.setPersistentVrModeEnabled(enabled);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void setVr2dDisplayProperties(Vr2dDisplayProperties vr2dDisplayProp) {
        try {
            this.mService.setVr2dDisplayProperties(vr2dDisplayProp);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    private static class CallbackEntry {
        final IVrStateCallbacks mStateCallback = new IVrStateCallbacks.Stub(){

            @Override
            public void onVrStateChanged(boolean enabled) {
                mHandler.post(() -> mCallback.onVrStateChanged(enabled));
            }
        };
        final IPersistentVrStateCallbacks mPersistentStateCallback = new IPersistentVrStateCallbacks.Stub(){

            @Override
            public void onPersistentVrStateChanged(boolean enabled) {
                mHandler.post(() -> mCallback.onPersistentVrStateChanged(enabled));
            }
        };
        final VrStateCallback mCallback;
        final Handler mHandler;

        CallbackEntry(VrStateCallback callback, Handler handler) {
            this.mCallback = callback;
            this.mHandler = handler;
        }
    }
}

