/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.app.admin.NetworkEvent;
import android.os.Parcel;
import android.os.Parcelable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ConnectEvent
extends NetworkEvent
implements Parcelable {
    private final String ipAddress;
    private final int port;
    public static final Parcelable.Creator<ConnectEvent> CREATOR = new Parcelable.Creator<ConnectEvent>(){

        @Override
        public ConnectEvent createFromParcel(Parcel in) {
            if (in.readInt() != 2) {
                return null;
            }
            return new ConnectEvent(in);
        }

        public ConnectEvent[] newArray(int size) {
            return new ConnectEvent[size];
        }
    };

    public ConnectEvent(String ipAddress, int port, String packageName, long timestamp) {
        super(packageName, timestamp);
        this.ipAddress = ipAddress;
        this.port = port;
    }

    private ConnectEvent(Parcel in) {
        this.ipAddress = in.readString();
        this.port = in.readInt();
        this.packageName = in.readString();
        this.timestamp = in.readLong();
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.ipAddress);
        }
        catch (UnknownHostException e) {
            return InetAddress.getLoopbackAddress();
        }
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return String.format("ConnectEvent(%s, %d, %d, %s)", this.ipAddress, this.port, this.timestamp, this.packageName);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(2);
        out.writeString(this.ipAddress);
        out.writeInt(this.port);
        out.writeString(this.packageName);
        out.writeLong(this.timestamp);
    }
}

