/*
 * Decompiled with CFR 0.152.
 */
package android.app.timezone;

import android.app.timezone.Utils;
import android.os.Parcel;
import android.os.Parcelable;

public class DistroFormatVersion
implements Parcelable {
    private final int mMajorVersion;
    private final int mMinorVersion;
    public static final Parcelable.Creator<DistroFormatVersion> CREATOR = new Parcelable.Creator<DistroFormatVersion>(){

        @Override
        public DistroFormatVersion createFromParcel(Parcel in) {
            int majorVersion = in.readInt();
            int minorVersion = in.readInt();
            return new DistroFormatVersion(majorVersion, minorVersion);
        }

        public DistroFormatVersion[] newArray(int size) {
            return new DistroFormatVersion[size];
        }
    };

    public DistroFormatVersion(int majorVersion, int minorVersion) {
        this.mMajorVersion = Utils.validateVersion("major", majorVersion);
        this.mMinorVersion = Utils.validateVersion("minor", minorVersion);
    }

    public int getMajorVersion() {
        return this.mMajorVersion;
    }

    public int getMinorVersion() {
        return this.mMinorVersion;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mMajorVersion);
        out.writeInt(this.mMinorVersion);
    }

    public boolean supports(DistroFormatVersion distroFormatVersion) {
        return this.mMajorVersion == distroFormatVersion.mMajorVersion && this.mMinorVersion <= distroFormatVersion.mMinorVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistroFormatVersion that = (DistroFormatVersion)o;
        if (this.mMajorVersion != that.mMajorVersion) {
            return false;
        }
        return this.mMinorVersion == that.mMinorVersion;
    }

    public int hashCode() {
        int result = this.mMajorVersion;
        result = 31 * result + this.mMinorVersion;
        return result;
    }

    public String toString() {
        return "DistroFormatVersion{mMajorVersion=" + this.mMajorVersion + ", mMinorVersion=" + this.mMinorVersion + '}';
    }
}

