/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.content.ContentResolver;
import android.database.CharArrayBuffer;
import android.database.ContentObservable;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.os.Bundle;
import android.os.UserHandle;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCursor
implements CrossProcessCursor {
    private static final String TAG = "Cursor";
    protected HashMap<Long, Map<String, Object>> mUpdatedRows;
    protected int mRowIdColumnIndex;
    protected Long mCurrentRowID;
    @Deprecated
    protected int mPos = -1;
    @Deprecated
    protected boolean mClosed;
    @Deprecated
    protected ContentResolver mContentResolver;
    private Uri mNotifyUri;
    private final Object mSelfObserverLock = new Object();
    private ContentObserver mSelfObserver;
    private boolean mSelfObserverRegistered;
    private final DataSetObservable mDataSetObservable = new DataSetObservable();
    private final ContentObservable mContentObservable = new ContentObservable();
    private Bundle mExtras = Bundle.EMPTY;

    @Override
    public abstract int getCount();

    @Override
    public abstract String[] getColumnNames();

    @Override
    public abstract String getString(int var1);

    @Override
    public abstract short getShort(int var1);

    @Override
    public abstract int getInt(int var1);

    @Override
    public abstract long getLong(int var1);

    @Override
    public abstract float getFloat(int var1);

    @Override
    public abstract double getDouble(int var1);

    @Override
    public abstract boolean isNull(int var1);

    @Override
    public int getType(int column) {
        return 3;
    }

    @Override
    public byte[] getBlob(int column) {
        throw new UnsupportedOperationException("getBlob is not supported");
    }

    @Override
    public CursorWindow getWindow() {
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    @Override
    public void deactivate() {
        this.onDeactivateOrClose();
    }

    protected void onDeactivateOrClose() {
        if (this.mSelfObserver != null) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            this.mSelfObserverRegistered = false;
        }
        this.mDataSetObservable.notifyInvalidated();
    }

    @Override
    public boolean requery() {
        if (this.mSelfObserver != null && !this.mSelfObserverRegistered) {
            this.mContentResolver.registerContentObserver(this.mNotifyUri, true, this.mSelfObserver);
            this.mSelfObserverRegistered = true;
        }
        this.mDataSetObservable.notifyChanged();
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() {
        this.mClosed = true;
        this.mContentObservable.unregisterAll();
        this.onDeactivateOrClose();
    }

    @Override
    public boolean onMove(int oldPosition, int newPosition) {
        return true;
    }

    @Override
    public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        String result = this.getString(columnIndex);
        if (result != null) {
            char[] data = buffer.data;
            if (data == null || data.length < result.length()) {
                buffer.data = result.toCharArray();
            } else {
                result.getChars(0, result.length(), data, 0);
            }
            buffer.sizeCopied = result.length();
        } else {
            buffer.sizeCopied = 0;
        }
    }

    @Override
    public int getPosition() {
        return this.mPos;
    }

    @Override
    public boolean moveToPosition(int position) {
        int count = this.getCount();
        if (position >= count) {
            this.mPos = count;
            return false;
        }
        if (position < 0) {
            this.mPos = -1;
            return false;
        }
        if (position == this.mPos) {
            return true;
        }
        boolean result = this.onMove(this.mPos, position);
        this.mPos = !result ? -1 : position;
        return result;
    }

    @Override
    public void fillWindow(int position, CursorWindow window) {
        DatabaseUtils.cursorFillWindow(this, position, window);
    }

    @Override
    public boolean move(int offset) {
        return this.moveToPosition(this.mPos + offset);
    }

    @Override
    public boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    @Override
    public boolean moveToLast() {
        return this.moveToPosition(this.getCount() - 1);
    }

    @Override
    public boolean moveToNext() {
        return this.moveToPosition(this.mPos + 1);
    }

    @Override
    public boolean moveToPrevious() {
        return this.moveToPosition(this.mPos - 1);
    }

    @Override
    public boolean isFirst() {
        return this.mPos == 0 && this.getCount() != 0;
    }

    @Override
    public boolean isLast() {
        int cnt = this.getCount();
        return this.mPos == cnt - 1 && cnt != 0;
    }

    @Override
    public boolean isBeforeFirst() {
        if (this.getCount() == 0) {
            return true;
        }
        return this.mPos == -1;
    }

    @Override
    public boolean isAfterLast() {
        if (this.getCount() == 0) {
            return true;
        }
        return this.mPos == this.getCount();
    }

    @Override
    public int getColumnIndex(String columnName) {
        int periodIndex = columnName.lastIndexOf(46);
        if (periodIndex != -1) {
            Exception e = new Exception();
            Log.e(TAG, "requesting column name with table name -- " + columnName, e);
            columnName = columnName.substring(periodIndex + 1);
        }
        String[] columnNames = this.getColumnNames();
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            if (!columnNames[i].equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getColumnIndexOrThrow(String columnName) {
        int index = this.getColumnIndex(columnName);
        if (index < 0) {
            String availableColumns = "";
            try {
                availableColumns = Arrays.toString(this.getColumnNames());
            }
            catch (Exception e) {
                Log.d(TAG, "Cannot collect column names for debug purposes", e);
            }
            throw new IllegalArgumentException("column '" + columnName + "' does not exist. Available columns: " + availableColumns);
        }
        return index;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumnNames()[columnIndex];
    }

    @Override
    public void registerContentObserver(ContentObserver observer) {
        this.mContentObservable.registerObserver(observer);
    }

    @Override
    public void unregisterContentObserver(ContentObserver observer) {
        if (!this.mClosed) {
            this.mContentObservable.unregisterObserver(observer);
        }
    }

    @Override
    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver(observer);
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChange(boolean selfChange) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mContentObservable.dispatchChange(selfChange, null);
            if (this.mNotifyUri != null && selfChange) {
                this.mContentResolver.notifyChange(this.mNotifyUri, this.mSelfObserver);
            }
        }
    }

    @Override
    public void setNotificationUri(ContentResolver cr, Uri notifyUri) {
        this.setNotificationUri(cr, notifyUri, UserHandle.myUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotificationUri(ContentResolver cr, Uri notifyUri, int userHandle) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mNotifyUri = notifyUri;
            this.mContentResolver = cr;
            if (this.mSelfObserver != null) {
                this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            }
            this.mSelfObserver = new SelfContentObserver(this);
            this.mContentResolver.registerContentObserver(this.mNotifyUri, true, this.mSelfObserver, userHandle);
            this.mSelfObserverRegistered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uri getNotificationUri() {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            return this.mNotifyUri;
        }
    }

    @Override
    public boolean getWantsAllOnMoveCalls() {
        return false;
    }

    @Override
    public void setExtras(Bundle extras) {
        this.mExtras = extras == null ? Bundle.EMPTY : extras;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public Bundle respond(Bundle extras) {
        return Bundle.EMPTY;
    }

    @Deprecated
    protected boolean isFieldUpdated(int columnIndex) {
        return false;
    }

    @Deprecated
    protected Object getUpdatedField(int columnIndex) {
        return null;
    }

    protected void checkPosition() {
        if (-1 == this.mPos || this.getCount() == this.mPos) {
            throw new CursorIndexOutOfBoundsException(this.mPos, this.getCount());
        }
    }

    protected void finalize() {
        if (this.mSelfObserver != null && this.mSelfObserverRegistered) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
        }
        try {
            if (!this.mClosed) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static class SelfContentObserver
    extends ContentObserver {
        WeakReference<AbstractCursor> mCursor;

        public SelfContentObserver(AbstractCursor cursor) {
            super(null);
            this.mCursor = new WeakReference<AbstractCursor>(cursor);
        }

        @Override
        public boolean deliverSelfNotifications() {
            return false;
        }

        @Override
        public void onChange(boolean selfChange) {
            AbstractCursor cursor = (AbstractCursor)this.mCursor.get();
            if (cursor != null) {
                cursor.onChange(false);
            }
        }
    }
}

