/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleNativeHeap
extends ChunkHandler {
    public static final int CHUNK_NHGT = DdmHandleNativeHeap.type("NHGT");
    private static DdmHandleNativeHeap mInstance = new DdmHandleNativeHeap();

    private DdmHandleNativeHeap() {
    }

    public static void register() {
        DdmServer.registerHandler(CHUNK_NHGT, mInstance);
    }

    @Override
    public void connected() {
    }

    @Override
    public void disconnected() {
    }

    @Override
    public Chunk handleChunk(Chunk request) {
        Log.i("ddm-nativeheap", "Handling " + DdmHandleNativeHeap.name(request.type) + " chunk");
        int type = request.type;
        if (type == CHUNK_NHGT) {
            return this.handleNHGT(request);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name(type));
    }

    private Chunk handleNHGT(Chunk request) {
        byte[] data = this.getLeakInfo();
        if (data != null) {
            Log.i("ddm-nativeheap", "Sending " + data.length + " bytes");
            return new Chunk(ChunkHandler.type("NHGT"), data, 0, data.length);
        }
        return DdmHandleNativeHeap.createFailChunk(1, "Something went wrong");
    }

    private byte[] getLeakInfo() {
        return (byte[])OverrideMethod.invokeA("android.ddm.DdmHandleNativeHeap#getLeakInfo()[B", true, this);
    }
}

