/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.BaseCanvas_Delegate;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.DrawFilter_Delegate;
import android.graphics.Matrix_Delegate;
import android.graphics.Paint_Delegate;
import android.graphics.Path_Delegate;
import android.graphics.Rect;
import android.graphics.RectF;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.GcSnapshot;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import libcore.util.NativeAllocationRegistry_Delegate;

public final class Canvas_Delegate
extends BaseCanvas_Delegate {
    private static long sFinalizer = -1L;
    private DrawFilter_Delegate mDrawFilter = null;

    public static Canvas_Delegate getDelegate(Canvas canvas) {
        return (Canvas_Delegate)sManager.getDelegate(canvas.getNativeCanvasWrapper());
    }

    public static Canvas_Delegate getDelegate(long native_canvas) {
        return (Canvas_Delegate)sManager.getDelegate(native_canvas);
    }

    @Override
    public GcSnapshot getSnapshot() {
        return this.mSnapshot;
    }

    public DrawFilter_Delegate getDrawFilter() {
        return this.mDrawFilter;
    }

    @LayoutlibDelegate
    static void nFreeCaches() {
    }

    @LayoutlibDelegate
    static void nFreeTextLayoutCaches() {
    }

    @LayoutlibDelegate
    static long nInitRaster(Bitmap bitmap) {
        long nativeBitmapOrZero = 0L;
        if (bitmap != null) {
            nativeBitmapOrZero = bitmap.getNativeInstance();
        }
        if (nativeBitmapOrZero > 0L) {
            Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(nativeBitmapOrZero);
            Canvas_Delegate newDelegate = new Canvas_Delegate(bitmapDelegate);
            return sManager.addNewDelegate(newDelegate);
        }
        Canvas_Delegate newDelegate = new Canvas_Delegate();
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    public static void nSetBitmap(long canvas, Bitmap bitmap) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(canvas);
        Bitmap_Delegate bitmapDelegate = Bitmap_Delegate.getDelegate(bitmap);
        if (canvasDelegate == null || bitmapDelegate == null) {
            return;
        }
        canvasDelegate.mBitmap = bitmapDelegate;
        canvasDelegate.mSnapshot = GcSnapshot.createDefaultSnapshot(bitmapDelegate);
    }

    @LayoutlibDelegate
    public static boolean nIsOpaque(long nativeCanvas) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return false;
        }
        return canvasDelegate.mBitmap.getConfig() == Bitmap.Config.RGB_565;
    }

    @LayoutlibDelegate
    public static int nGetWidth(long nativeCanvas) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.mBitmap.getImage().getWidth();
    }

    @LayoutlibDelegate
    public static int nGetHeight(long nativeCanvas) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.mBitmap.getImage().getHeight();
    }

    @LayoutlibDelegate
    public static int nSave(long nativeCanvas, int saveFlags) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.save(saveFlags);
    }

    @LayoutlibDelegate
    public static int nSaveLayer(long nativeCanvas, float l, float t, float r, float b, long paint, int layerFlags) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        Paint_Delegate paintDelegate = Paint_Delegate.getDelegate(paint);
        if (paintDelegate == null) {
            return 0;
        }
        return canvasDelegate.saveLayer(new RectF(l, t, r, b), paintDelegate, layerFlags);
    }

    @LayoutlibDelegate
    public static int nSaveLayerAlpha(long nativeCanvas, float l, float t, float r, float b, int alpha, int layerFlags) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.saveLayerAlpha(new RectF(l, t, r, b), alpha, layerFlags);
    }

    @LayoutlibDelegate
    public static boolean nRestore(long nativeCanvas) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return false;
        }
        canvasDelegate.restore();
        return true;
    }

    @LayoutlibDelegate
    public static void nRestoreToCount(long nativeCanvas, int saveCount) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.restoreTo(saveCount);
    }

    @LayoutlibDelegate
    public static int nGetSaveCount(long nativeCanvas) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return 0;
        }
        return canvasDelegate.getSnapshot().size();
    }

    @LayoutlibDelegate
    public static void nTranslate(long nativeCanvas, float dx, float dy) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.getSnapshot().translate(dx, dy);
    }

    @LayoutlibDelegate
    public static void nScale(long nativeCanvas, float sx, float sy) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.getSnapshot().scale(sx, sy);
    }

    @LayoutlibDelegate
    public static void nRotate(long nativeCanvas, float degrees) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.getSnapshot().rotate(Math.toRadians(degrees));
    }

    @LayoutlibDelegate
    public static void nSkew(long nativeCanvas, float kx, float ky) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        GcSnapshot g = canvasDelegate.getSnapshot();
        AffineTransform currentTx = g.getTransform();
        float[] mtx = Matrix_Delegate.getSkew(kx, ky);
        AffineTransform matrixTx = Matrix_Delegate.getAffineTransform(mtx);
        currentTx.preConcatenate(matrixTx);
        g.setTransform(currentTx);
    }

    @LayoutlibDelegate
    public static void nConcat(long nCanvas, long nMatrix) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(nMatrix);
        if (matrixDelegate == null) {
            return;
        }
        GcSnapshot snapshot = canvasDelegate.getSnapshot();
        AffineTransform currentTx = snapshot.getTransform();
        AffineTransform matrixTx = matrixDelegate.getAffineTransform();
        currentTx.concatenate(matrixTx);
        snapshot.setTransform(currentTx);
    }

    @LayoutlibDelegate
    public static void nSetMatrix(long nCanvas, long nMatrix) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return;
        }
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(nMatrix);
        if (matrixDelegate == null) {
            return;
        }
        GcSnapshot snapshot = canvasDelegate.getSnapshot();
        AffineTransform matrixTx = matrixDelegate.getAffineTransform();
        snapshot.setTransform(matrixTx);
        if (matrixDelegate.hasPerspective()) {
            assert (false);
            Bridge.getLog().fidelityWarning("matrix.affine", "android.graphics.Canvas#setMatrix(android.graphics.Matrix) only supports affine transformations.", null, null);
        }
    }

    @LayoutlibDelegate
    public static boolean nClipRect(long nCanvas, float left, float top, float right, float bottom, int regionOp) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nCanvas);
        if (canvasDelegate == null) {
            return false;
        }
        return canvasDelegate.clipRect(left, top, right, bottom, regionOp);
    }

    @LayoutlibDelegate
    public static boolean nClipPath(long nativeCanvas, long nativePath, int regionOp) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return true;
        }
        Path_Delegate pathDelegate = Path_Delegate.getDelegate(nativePath);
        if (pathDelegate == null) {
            return true;
        }
        return canvasDelegate.mSnapshot.clip(pathDelegate.getJavaShape(), regionOp);
    }

    @LayoutlibDelegate
    public static void nSetDrawFilter(long nativeCanvas, long nativeFilter) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return;
        }
        canvasDelegate.mDrawFilter = DrawFilter_Delegate.getDelegate(nativeFilter);
        if (canvasDelegate.mDrawFilter != null && !canvasDelegate.mDrawFilter.isSupported()) {
            Bridge.getLog().fidelityWarning("drawfilter", canvasDelegate.mDrawFilter.getSupportMessage(), null, null);
        }
    }

    @LayoutlibDelegate
    public static boolean nGetClipBounds(long nativeCanvas, Rect bounds) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(nativeCanvas);
        if (canvasDelegate == null) {
            return false;
        }
        Rectangle rect = canvasDelegate.getSnapshot().getClip().getBounds();
        if (rect != null && !rect.isEmpty()) {
            bounds.left = rect.x;
            bounds.top = rect.y;
            bounds.right = rect.x + rect.width;
            bounds.bottom = rect.y + rect.height;
            return true;
        }
        return false;
    }

    @LayoutlibDelegate
    public static void nGetMatrix(long canvas, long matrix) {
        Canvas_Delegate canvasDelegate = Canvas_Delegate.getDelegate(canvas);
        if (canvasDelegate == null) {
            return;
        }
        Matrix_Delegate matrixDelegate = Matrix_Delegate.getDelegate(matrix);
        if (matrixDelegate == null) {
            return;
        }
        AffineTransform transform = canvasDelegate.getSnapshot().getTransform();
        matrixDelegate.set(Matrix_Delegate.makeValues(transform));
    }

    @LayoutlibDelegate
    public static boolean nQuickReject(long nativeCanvas, long path) {
        return false;
    }

    @LayoutlibDelegate
    public static boolean nQuickReject(long nativeCanvas, float left, float top, float right, float bottom) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LayoutlibDelegate
    static long nGetNativeFinalizer() {
        Class<Canvas_Delegate> clazz = Canvas_Delegate.class;
        synchronized (Canvas_Delegate.class) {
            if (sFinalizer == -1L) {
                sFinalizer = NativeAllocationRegistry_Delegate.createFinalizer(nativePtr -> {
                    Canvas_Delegate delegate = Canvas_Delegate.getDelegate(nativePtr);
                    if (delegate != null) {
                        delegate.dispose();
                    }
                    sManager.removeJavaReferenceFor(nativePtr);
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sFinalizer;
        }
    }

    private Canvas_Delegate(Bitmap_Delegate bitmap) {
        super(bitmap);
    }

    private Canvas_Delegate() {
    }
}

