/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.number.AffixPatternUtils;
import android.icu.impl.number.FormatQuantity4;
import android.icu.impl.number.Properties;
import android.icu.impl.number.formatters.PaddingFormat;
import android.icu.text.DecimalFormatSymbols;
import java.math.BigDecimal;

public class PatternString {
    public static final int IGNORE_ROUNDING_NEVER = 0;
    public static final int IGNORE_ROUNDING_IF_CURRENCY = 1;
    public static final int IGNORE_ROUNDING_ALWAYS = 2;

    public static Properties parseToProperties(String pattern, int ignoreRounding) {
        Properties properties = new Properties();
        LdmlDecimalPatternParser.parse(pattern, properties, ignoreRounding);
        return properties;
    }

    public static Properties parseToProperties(String pattern) {
        return PatternString.parseToProperties(pattern, 0);
    }

    public static void parseToExistingProperties(String pattern, Properties properties, int ignoreRounding) {
        LdmlDecimalPatternParser.parse(pattern, properties, ignoreRounding);
    }

    public static void parseToExistingProperties(String pattern, Properties properties) {
        PatternString.parseToExistingProperties(pattern, properties, 0);
    }

    public static String propertiesToString(Properties properties) {
        int grouping2;
        int grouping1;
        int grouping;
        StringBuilder sb = new StringBuilder();
        int dosMax = 100;
        int groupingSize = Math.min(properties.getSecondaryGroupingSize(), dosMax);
        int firstGroupingSize = Math.min(properties.getGroupingSize(), dosMax);
        int paddingWidth = Math.min(properties.getFormatWidth(), dosMax);
        PaddingFormat.PadPosition paddingLocation = properties.getPadPosition();
        String paddingString = properties.getPadString();
        int minInt = Math.max(Math.min(properties.getMinimumIntegerDigits(), dosMax), 0);
        int maxInt = Math.min(properties.getMaximumIntegerDigits(), dosMax);
        int minFrac = Math.max(Math.min(properties.getMinimumFractionDigits(), dosMax), 0);
        int maxFrac = Math.min(properties.getMaximumFractionDigits(), dosMax);
        int minSig = Math.min(properties.getMinimumSignificantDigits(), dosMax);
        int maxSig = Math.min(properties.getMaximumSignificantDigits(), dosMax);
        boolean alwaysShowDecimal = properties.getDecimalSeparatorAlwaysShown();
        int exponentDigits = Math.min(properties.getMinimumExponentDigits(), dosMax);
        boolean exponentShowPlusSign = properties.getExponentSignAlwaysShown();
        String pp = properties.getPositivePrefix();
        String ppp = properties.getPositivePrefixPattern();
        String ps = properties.getPositiveSuffix();
        String psp = properties.getPositiveSuffixPattern();
        String np = properties.getNegativePrefix();
        String npp = properties.getNegativePrefixPattern();
        String ns = properties.getNegativeSuffix();
        String nsp = properties.getNegativeSuffixPattern();
        if (ppp != null) {
            sb.append(ppp);
        }
        AffixPatternUtils.escape(pp, sb);
        int afterPrefixPos = sb.length();
        if (groupingSize != Math.min(dosMax, -1) && firstGroupingSize != Math.min(dosMax, -1) && groupingSize != firstGroupingSize) {
            grouping = groupingSize;
            grouping1 = groupingSize;
            grouping2 = firstGroupingSize;
        } else if (groupingSize != Math.min(dosMax, -1)) {
            grouping = groupingSize;
            grouping1 = 0;
            grouping2 = groupingSize;
        } else if (firstGroupingSize != Math.min(dosMax, -1)) {
            grouping = groupingSize;
            grouping1 = 0;
            grouping2 = firstGroupingSize;
        } else {
            grouping = 0;
            grouping1 = 0;
            grouping2 = 0;
        }
        int groupingLength = grouping1 + grouping2 + 1;
        BigDecimal roundingInterval = properties.getRoundingIncrement();
        StringBuilder digitsString = new StringBuilder();
        int digitsStringScale = 0;
        if (maxSig != Math.min(dosMax, -1)) {
            while (digitsString.length() < minSig) {
                digitsString.append('@');
            }
            while (digitsString.length() < maxSig) {
                digitsString.append('#');
            }
        } else if (roundingInterval != Properties.DEFAULT_ROUNDING_INCREMENT) {
            digitsStringScale = -roundingInterval.scale();
            String str = roundingInterval.scaleByPowerOfTen(roundingInterval.scale()).toPlainString();
            if (str.charAt(0) == '\'') {
                digitsString.append(str, 1, str.length());
            } else {
                digitsString.append(str);
            }
        }
        while (digitsString.length() + digitsStringScale < minInt) {
            digitsString.insert(0, '0');
        }
        while (-digitsStringScale < minFrac) {
            digitsString.append('0');
            --digitsStringScale;
        }
        int m0 = Math.max(groupingLength, digitsString.length() + digitsStringScale);
        m0 = maxInt != dosMax ? Math.max(maxInt, m0) - 1 : m0 - 1;
        int mN = maxFrac != dosMax ? Math.min(-maxFrac, digitsStringScale) : digitsStringScale;
        for (int magnitude = m0; magnitude >= mN; --magnitude) {
            int di = digitsString.length() + digitsStringScale - magnitude - 1;
            if (di < 0 || di >= digitsString.length()) {
                sb.append('#');
            } else {
                sb.append(digitsString.charAt(di));
            }
            if (magnitude > grouping2 && grouping > 0 && (magnitude - grouping2) % grouping == 0) {
                sb.append(',');
                continue;
            }
            if (magnitude > 0 && magnitude == grouping2) {
                sb.append(',');
                continue;
            }
            if (magnitude != 0 || !alwaysShowDecimal && mN >= 0) continue;
            sb.append('.');
        }
        if (exponentDigits != Math.min(dosMax, -1)) {
            sb.append('E');
            if (exponentShowPlusSign) {
                sb.append('+');
            }
            for (int i = 0; i < exponentDigits; ++i) {
                sb.append('0');
            }
        }
        int beforeSuffixPos = sb.length();
        if (psp != null) {
            sb.append(psp);
        }
        AffixPatternUtils.escape(ps, sb);
        if (paddingWidth != 0) {
            while (paddingWidth - sb.length() > 0) {
                sb.insert(afterPrefixPos, '#');
                ++beforeSuffixPos;
            }
            switch (paddingLocation) {
                case BEFORE_PREFIX: {
                    int addedLength = PatternString.escapePaddingString(paddingString, sb, 0);
                    sb.insert(0, '*');
                    afterPrefixPos += addedLength + 1;
                    beforeSuffixPos += addedLength + 1;
                    break;
                }
                case AFTER_PREFIX: {
                    int addedLength = PatternString.escapePaddingString(paddingString, sb, afterPrefixPos);
                    sb.insert(afterPrefixPos, '*');
                    afterPrefixPos += addedLength + 1;
                    beforeSuffixPos += addedLength + 1;
                    break;
                }
                case BEFORE_SUFFIX: {
                    PatternString.escapePaddingString(paddingString, sb, beforeSuffixPos);
                    sb.insert(beforeSuffixPos, '*');
                    break;
                }
                case AFTER_SUFFIX: {
                    sb.append('*');
                    PatternString.escapePaddingString(paddingString, sb, sb.length());
                }
            }
        }
        if (np != null || ns != null || npp == null && nsp != null || npp != null && (npp.length() != 1 || npp.charAt(0) != '-' || nsp.length() != 0)) {
            sb.append(';');
            if (npp != null) {
                sb.append(npp);
            }
            AffixPatternUtils.escape(np, sb);
            sb.append(sb, afterPrefixPos, beforeSuffixPos);
            if (nsp != null) {
                sb.append(nsp);
            }
            AffixPatternUtils.escape(ns, sb);
        }
        return sb.toString();
    }

    private static int escapePaddingString(CharSequence input, StringBuilder output, int startIndex) {
        if (input == null || input.length() == 0) {
            input = " ";
        }
        int startLength = output.length();
        if (input.length() == 1) {
            if (input.equals("'")) {
                output.insert(startIndex, "''");
            } else {
                output.insert(startIndex, input);
            }
        } else {
            output.insert(startIndex, '\'');
            int offset = 1;
            for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                if (ch == '\'') {
                    output.insert(startIndex + offset, "''");
                    offset += 2;
                    continue;
                }
                output.insert(startIndex + offset, ch);
                ++offset;
            }
            output.insert(startIndex + offset, '\'');
        }
        return output.length() - startLength;
    }

    @Deprecated
    public static String convertLocalized(String input, DecimalFormatSymbols symbols, boolean toLocalized) {
        int i;
        if (input == null) {
            return null;
        }
        String[][] table = new String[21][2];
        int standIdx = toLocalized ? 0 : 1;
        int localIdx = toLocalized ? 1 : 0;
        table[0][standIdx] = "%";
        table[0][localIdx] = symbols.getPercentString();
        table[1][standIdx] = "\u2030";
        table[1][localIdx] = symbols.getPerMillString();
        table[2][standIdx] = ".";
        table[2][localIdx] = symbols.getDecimalSeparatorString();
        table[3][standIdx] = ",";
        table[3][localIdx] = symbols.getGroupingSeparatorString();
        table[4][standIdx] = "-";
        table[4][localIdx] = symbols.getMinusSignString();
        table[5][standIdx] = "+";
        table[5][localIdx] = symbols.getPlusSignString();
        table[6][standIdx] = ";";
        table[6][localIdx] = Character.toString(symbols.getPatternSeparator());
        table[7][standIdx] = "@";
        table[7][localIdx] = Character.toString(symbols.getSignificantDigit());
        table[8][standIdx] = "E";
        table[8][localIdx] = symbols.getExponentSeparator();
        table[9][standIdx] = "*";
        table[9][localIdx] = Character.toString(symbols.getPadEscape());
        table[10][standIdx] = "#";
        table[10][localIdx] = Character.toString(symbols.getDigit());
        for (i = 0; i < 10; ++i) {
            table[11 + i][standIdx] = Character.toString((char)(48 + i));
            table[11 + i][localIdx] = symbols.getDigitStringsLocal()[i];
        }
        for (i = 0; i < table.length; ++i) {
            table[i][localIdx] = table[i][localIdx].replace('\'', '\u2019');
        }
        StringBuilder result = new StringBuilder();
        int state = 0;
        block2: for (int offset = 0; offset < input.length(); ++offset) {
            char ch = input.charAt(offset);
            if (ch == '\'') {
                if (state == 0) {
                    result.append('\'');
                    state = 1;
                    continue;
                }
                if (state == 1) {
                    result.append('\'');
                    state = 0;
                    continue;
                }
                if (state == 2) {
                    state = 3;
                    continue;
                }
                if (state == 3) {
                    result.append('\'');
                    result.append('\'');
                    state = 1;
                    continue;
                }
                if (state == 4) {
                    state = 5;
                    continue;
                }
                assert (state == 5);
                result.append('\'');
                result.append('\'');
                state = 4;
                continue;
            }
            if (state == 0 || state == 3 || state == 4) {
                for (String[] pair : table) {
                    if (!input.regionMatches(offset, pair[0], 0, pair[0].length())) continue;
                    offset += pair[0].length() - 1;
                    if (state == 3 || state == 4) {
                        result.append('\'');
                        state = 0;
                    }
                    result.append(pair[1]);
                    continue block2;
                }
                for (String[] pair : table) {
                    if (!input.regionMatches(offset, pair[1], 0, pair[1].length())) continue;
                    if (state == 0) {
                        result.append('\'');
                        state = 4;
                    }
                    result.append(ch);
                    continue block2;
                }
                if (state == 3 || state == 4) {
                    result.append('\'');
                    state = 0;
                }
                result.append(ch);
                continue;
            }
            assert (state == 1 || state == 2 || state == 5);
            result.append(ch);
            state = 2;
        }
        if (state == 3 || state == 4) {
            result.append('\'');
            state = 0;
        }
        if (state != 0) {
            throw new IllegalArgumentException("Malformed localized pattern: unterminated quote");
        }
        return result.toString();
    }

    static class LdmlDecimalPatternParser {
        LdmlDecimalPatternParser() {
        }

        static void parse(String pattern, Properties properties, int ignoreRounding) {
            if (pattern == null || pattern.length() == 0) {
                properties.clear();
                return;
            }
            ParserState state = new ParserState(pattern);
            PatternParseResult result = new PatternParseResult();
            LdmlDecimalPatternParser.consumePattern(state, result);
            result.saveToProperties(properties, ignoreRounding);
        }

        private static void consumePattern(ParserState state, PatternParseResult result) {
            LdmlDecimalPatternParser.consumeSubpattern(state, result.positive);
            if (state.peek() == 59) {
                state.next();
                result.negative = new SubpatternParseResult();
                LdmlDecimalPatternParser.consumeSubpattern(state, result.negative);
            }
            if (state.peek() != -1) {
                throw state.toParseException("Found unquoted special character");
            }
        }

        private static void consumeSubpattern(ParserState state, SubpatternParseResult result) {
            LdmlDecimalPatternParser.consumePadding(state, result, PaddingFormat.PadPosition.BEFORE_PREFIX);
            LdmlDecimalPatternParser.consumeAffix(state, result, result.prefix);
            LdmlDecimalPatternParser.consumePadding(state, result, PaddingFormat.PadPosition.AFTER_PREFIX);
            LdmlDecimalPatternParser.consumeFormat(state, result);
            LdmlDecimalPatternParser.consumeExponent(state, result);
            LdmlDecimalPatternParser.consumePadding(state, result, PaddingFormat.PadPosition.BEFORE_SUFFIX);
            LdmlDecimalPatternParser.consumeAffix(state, result, result.suffix);
            LdmlDecimalPatternParser.consumePadding(state, result, PaddingFormat.PadPosition.AFTER_SUFFIX);
        }

        private static void consumePadding(ParserState state, SubpatternParseResult result, PaddingFormat.PadPosition paddingLocation) {
            if (state.peek() != 42) {
                return;
            }
            result.paddingLocation = paddingLocation;
            state.next();
            LdmlDecimalPatternParser.consumeLiteral(state, result.padding);
        }

        private static void consumeAffix(ParserState state, SubpatternParseResult result, StringBuilder destination) {
            while (true) {
                switch (state.peek()) {
                    case -1: 
                    case 35: 
                    case 42: 
                    case 44: 
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 59: 
                    case 64: {
                        return;
                    }
                    case 37: {
                        result.hasPercentSign = true;
                        break;
                    }
                    case 8240: {
                        result.hasPerMilleSign = true;
                        break;
                    }
                    case 164: {
                        result.hasCurrencySign = true;
                    }
                }
                LdmlDecimalPatternParser.consumeLiteral(state, destination);
            }
        }

        private static void consumeLiteral(ParserState state, StringBuilder destination) {
            if (state.peek() == -1) {
                throw state.toParseException("Expected unquoted literal but found EOL");
            }
            if (state.peek() == 39) {
                destination.appendCodePoint(state.next());
                while (state.peek() != 39) {
                    if (state.peek() == -1) {
                        throw state.toParseException("Expected quoted literal but found EOL");
                    }
                    destination.appendCodePoint(state.next());
                }
                destination.appendCodePoint(state.next());
            } else {
                destination.appendCodePoint(state.next());
            }
        }

        private static void consumeFormat(ParserState state, SubpatternParseResult result) {
            LdmlDecimalPatternParser.consumeIntegerFormat(state, result);
            if (state.peek() == 46) {
                state.next();
                result.hasDecimal = true;
                ++result.paddingWidth;
                LdmlDecimalPatternParser.consumeFractionFormat(state, result);
            }
        }

        private static void consumeIntegerFormat(ParserState state, SubpatternParseResult result) {
            boolean seenSignificantDigitMarker = false;
            boolean seenDigit = false;
            while (true) {
                switch (state.peek()) {
                    case 44: {
                        ++result.paddingWidth;
                        result.groupingSizes[2] = result.groupingSizes[1];
                        result.groupingSizes[1] = result.groupingSizes[0];
                        result.groupingSizes[0] = 0;
                        break;
                    }
                    case 35: {
                        if (seenDigit) {
                            throw state.toParseException("# cannot follow 0 before decimal point");
                        }
                        ++result.paddingWidth;
                        result.groupingSizes[0] = result.groupingSizes[0] + 1;
                        result.totalIntegerDigits = result.totalIntegerDigits + (seenSignificantDigitMarker ? 0 : 1);
                        result.maximumSignificantDigits = result.maximumSignificantDigits + (seenSignificantDigitMarker ? 1 : 0);
                        result.rounding.appendDigit((byte)0, 0, true);
                        break;
                    }
                    case 64: {
                        seenSignificantDigitMarker = true;
                        if (seenDigit) {
                            throw state.toParseException("Cannot mix 0 and @");
                        }
                        ++result.paddingWidth;
                        result.groupingSizes[0] = result.groupingSizes[0] + 1;
                        ++result.totalIntegerDigits;
                        ++result.minimumSignificantDigits;
                        ++result.maximumSignificantDigits;
                        result.rounding.appendDigit((byte)0, 0, true);
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        seenDigit = true;
                        if (seenSignificantDigitMarker) {
                            throw state.toParseException("Cannot mix @ and 0");
                        }
                        ++result.paddingWidth;
                        result.groupingSizes[0] = result.groupingSizes[0] + 1;
                        ++result.totalIntegerDigits;
                        ++result.minimumIntegerDigits;
                        result.rounding.appendDigit((byte)(state.peek() - 48), 0, true);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                state.next();
            }
        }

        private static void consumeFractionFormat(ParserState state, SubpatternParseResult result) {
            int zeroCounter = 0;
            boolean seenHash = false;
            while (true) {
                switch (state.peek()) {
                    case 35: {
                        seenHash = true;
                        ++result.paddingWidth;
                        ++result.maximumFractionDigits;
                        ++zeroCounter;
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        if (seenHash) {
                            throw state.toParseException("0 cannot follow # after decimal point");
                        }
                        ++result.paddingWidth;
                        ++result.minimumFractionDigits;
                        ++result.maximumFractionDigits;
                        if (state.peek() == 48) {
                            ++zeroCounter;
                            break;
                        }
                        result.rounding.appendDigit((byte)(state.peek() - 48), zeroCounter, false);
                        zeroCounter = 0;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                state.next();
            }
        }

        private static void consumeExponent(ParserState state, SubpatternParseResult result) {
            if (state.peek() != 69) {
                return;
            }
            state.next();
            ++result.paddingWidth;
            if (state.peek() == 43) {
                state.next();
                result.exponentShowPlusSign = true;
                ++result.paddingWidth;
            }
            while (state.peek() == 48) {
                state.next();
                ++result.exponentDigits;
                ++result.paddingWidth;
            }
        }

        private static class ParserState {
            final String pattern;
            int offset;

            ParserState(String pattern) {
                this.pattern = pattern;
                this.offset = 0;
            }

            int peek() {
                if (this.offset == this.pattern.length()) {
                    return -1;
                }
                return this.pattern.codePointAt(this.offset);
            }

            int next() {
                int codePoint = this.peek();
                this.offset += Character.charCount(codePoint);
                return codePoint;
            }

            IllegalArgumentException toParseException(String message) {
                StringBuilder sb = new StringBuilder();
                sb.append("Malformed pattern for ICU DecimalFormat: \"");
                sb.append(this.pattern);
                sb.append("\": ");
                sb.append(message);
                sb.append(" at position ");
                sb.append(this.offset);
                return new IllegalArgumentException(sb.toString());
            }
        }

        private static class SubpatternParseResult {
            int[] groupingSizes = new int[]{0, -1, -1};
            int minimumIntegerDigits = 0;
            int totalIntegerDigits = 0;
            int minimumFractionDigits = 0;
            int maximumFractionDigits = 0;
            int minimumSignificantDigits = 0;
            int maximumSignificantDigits = 0;
            boolean hasDecimal = false;
            int paddingWidth = 0;
            PaddingFormat.PadPosition paddingLocation = null;
            FormatQuantity4 rounding = new FormatQuantity4();
            boolean exponentShowPlusSign = false;
            int exponentDigits = 0;
            boolean hasPercentSign = false;
            boolean hasPerMilleSign = false;
            boolean hasCurrencySign = false;
            StringBuilder padding = new StringBuilder();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();

            private SubpatternParseResult() {
            }
        }

        private static class PatternParseResult {
            SubpatternParseResult positive = new SubpatternParseResult();
            SubpatternParseResult negative = null;

            private PatternParseResult() {
            }

            void saveToProperties(Properties properties, int _ignoreRounding) {
                int minFrac;
                int minInt;
                boolean ignoreRounding;
                if (_ignoreRounding == 0) {
                    ignoreRounding = false;
                } else if (_ignoreRounding == 1) {
                    ignoreRounding = this.positive.hasCurrencySign;
                } else {
                    assert (_ignoreRounding == 2);
                    ignoreRounding = true;
                }
                if (this.positive.groupingSizes[1] != -1) {
                    properties.setGroupingSize(this.positive.groupingSizes[0]);
                } else {
                    properties.setGroupingSize(-1);
                }
                if (this.positive.groupingSizes[2] != -1) {
                    properties.setSecondaryGroupingSize(this.positive.groupingSizes[1]);
                } else {
                    properties.setSecondaryGroupingSize(-1);
                }
                if (this.positive.totalIntegerDigits == 0 && this.positive.maximumFractionDigits > 0) {
                    minInt = 0;
                    minFrac = Math.max(1, this.positive.minimumFractionDigits);
                } else if (this.positive.minimumIntegerDigits == 0 && this.positive.minimumFractionDigits == 0) {
                    minInt = 1;
                    minFrac = 0;
                } else {
                    minInt = this.positive.minimumIntegerDigits;
                    minFrac = this.positive.minimumFractionDigits;
                }
                if (this.positive.minimumSignificantDigits > 0) {
                    properties.setMinimumFractionDigits(-1);
                    properties.setMaximumFractionDigits(-1);
                    properties.setRoundingIncrement(Properties.DEFAULT_ROUNDING_INCREMENT);
                    properties.setMinimumSignificantDigits(this.positive.minimumSignificantDigits);
                    properties.setMaximumSignificantDigits(this.positive.maximumSignificantDigits);
                } else if (!this.positive.rounding.isZero()) {
                    if (!ignoreRounding) {
                        properties.setMinimumFractionDigits(minFrac);
                        properties.setMaximumFractionDigits(this.positive.maximumFractionDigits);
                        properties.setRoundingIncrement(this.positive.rounding.toBigDecimal());
                    } else {
                        properties.setMinimumFractionDigits(-1);
                        properties.setMaximumFractionDigits(-1);
                        properties.setRoundingIncrement(Properties.DEFAULT_ROUNDING_INCREMENT);
                    }
                    properties.setMinimumSignificantDigits(-1);
                    properties.setMaximumSignificantDigits(-1);
                } else {
                    if (!ignoreRounding) {
                        properties.setMinimumFractionDigits(minFrac);
                        properties.setMaximumFractionDigits(this.positive.maximumFractionDigits);
                        properties.setRoundingIncrement(Properties.DEFAULT_ROUNDING_INCREMENT);
                    } else {
                        properties.setMinimumFractionDigits(-1);
                        properties.setMaximumFractionDigits(-1);
                        properties.setRoundingIncrement(Properties.DEFAULT_ROUNDING_INCREMENT);
                    }
                    properties.setMinimumSignificantDigits(-1);
                    properties.setMaximumSignificantDigits(-1);
                }
                if (this.positive.hasDecimal && this.positive.maximumFractionDigits == 0) {
                    properties.setDecimalSeparatorAlwaysShown(true);
                } else {
                    properties.setDecimalSeparatorAlwaysShown(false);
                }
                if (this.positive.exponentDigits > 0) {
                    properties.setExponentSignAlwaysShown(this.positive.exponentShowPlusSign);
                    properties.setMinimumExponentDigits(this.positive.exponentDigits);
                    if (this.positive.minimumSignificantDigits == 0) {
                        properties.setMinimumIntegerDigits(this.positive.minimumIntegerDigits);
                        properties.setMaximumIntegerDigits(this.positive.totalIntegerDigits);
                    } else {
                        properties.setMinimumIntegerDigits(1);
                        properties.setMaximumIntegerDigits(-1);
                    }
                } else {
                    properties.setExponentSignAlwaysShown(false);
                    properties.setMinimumExponentDigits(-1);
                    properties.setMinimumIntegerDigits(minInt);
                    properties.setMaximumIntegerDigits(-1);
                }
                if (this.positive.padding.length() > 0) {
                    int paddingWidth = this.positive.paddingWidth + AffixPatternUtils.unescapedLength(this.positive.prefix) + AffixPatternUtils.unescapedLength(this.positive.suffix);
                    properties.setFormatWidth(paddingWidth);
                    if (this.positive.padding.length() == 1) {
                        properties.setPadString(this.positive.padding.toString());
                    } else if (this.positive.padding.length() == 2) {
                        if (this.positive.padding.charAt(0) == '\'') {
                            properties.setPadString("'");
                        } else {
                            properties.setPadString(this.positive.padding.toString());
                        }
                    } else {
                        properties.setPadString(this.positive.padding.subSequence(1, this.positive.padding.length() - 1).toString());
                    }
                    assert (this.positive.paddingLocation != null);
                    properties.setPadPosition(this.positive.paddingLocation);
                } else {
                    properties.setFormatWidth(0);
                    properties.setPadString(Properties.DEFAULT_PAD_STRING);
                    properties.setPadPosition(Properties.DEFAULT_PAD_POSITION);
                }
                properties.setPositivePrefixPattern(this.positive.prefix.toString());
                properties.setPositiveSuffixPattern(this.positive.suffix.toString());
                if (this.negative != null) {
                    properties.setNegativePrefixPattern(this.negative.prefix.toString());
                    properties.setNegativeSuffixPattern(this.negative.suffix.toString());
                } else {
                    properties.setNegativePrefixPattern(null);
                    properties.setNegativeSuffixPattern(null);
                }
                if (this.positive.hasPercentSign) {
                    properties.setMagnitudeMultiplier(2);
                } else if (this.positive.hasPerMilleSign) {
                    properties.setMagnitudeMultiplier(3);
                } else {
                    properties.setMagnitudeMultiplier(0);
                }
            }
        }
    }
}

