/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityThread;
import android.media.DeniedByServerException;
import android.media.NotProvisionedException;
import android.media.ResourceBusyException;
import android.media.UnsupportedSchemeException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class MediaDrm {
    private static final String TAG = "MediaDrm";
    private static final String PERMISSION = "android.permission.ACCESS_DRM_CERTIFICATES";
    private EventHandler mEventHandler;
    private EventHandler mOnKeyStatusChangeEventHandler;
    private EventHandler mOnExpirationUpdateEventHandler;
    private OnEventListener mOnEventListener;
    private OnKeyStatusChangeListener mOnKeyStatusChangeListener;
    private OnExpirationUpdateListener mOnExpirationUpdateListener;
    private long mNativeContext;
    public static final int CERTIFICATE_TYPE_NONE = 0;
    public static final int CERTIFICATE_TYPE_X509 = 1;
    public static final int EVENT_PROVISION_REQUIRED = 1;
    public static final int EVENT_KEY_REQUIRED = 2;
    public static final int EVENT_KEY_EXPIRED = 3;
    public static final int EVENT_VENDOR_DEFINED = 4;
    public static final int EVENT_SESSION_RECLAIMED = 5;
    private static final int DRM_EVENT = 200;
    private static final int EXPIRATION_UPDATE = 201;
    private static final int KEY_STATUS_CHANGE = 202;
    public static final int KEY_TYPE_STREAMING = 1;
    public static final int KEY_TYPE_OFFLINE = 2;
    public static final int KEY_TYPE_RELEASE = 3;
    public static final String PROPERTY_VENDOR = "vendor";
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_ALGORITHMS = "algorithms";
    public static final String PROPERTY_DEVICE_UNIQUE_ID = "deviceUniqueId";

    public static boolean isCryptoSchemeSupported(UUID uuid) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), null);
    }

    public static boolean isCryptoSchemeSupported(UUID uuid, String mimeType) {
        return MediaDrm.isCryptoSchemeSupportedNative(MediaDrm.getByteArrayFromUUID(uuid), mimeType);
    }

    private static byte[] getByteArrayFromUUID(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] uuidBytes = new byte[16];
        for (int i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
            uuidBytes[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    private static boolean isCryptoSchemeSupportedNative(byte[] byArray, String string2) {
        return OverrideMethod.invokeI("android.media.MediaDrm#isCryptoSchemeSupportedNative([BLjava/lang/String;)Z", true, null) != 0;
    }

    public MediaDrm(UUID uuid) throws UnsupportedSchemeException {
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.native_setup(new WeakReference<MediaDrm>(this), MediaDrm.getByteArrayFromUUID(uuid), ActivityThread.currentOpPackageName());
    }

    public void setOnExpirationUpdateListener(OnExpirationUpdateListener listener, Handler handler) {
        if (listener != null) {
            Looper looper;
            Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
            if (looper != null && (this.mEventHandler == null || this.mEventHandler.getLooper() != looper)) {
                this.mEventHandler = new EventHandler(this, looper);
            }
        }
        this.mOnExpirationUpdateListener = listener;
    }

    public void setOnKeyStatusChangeListener(OnKeyStatusChangeListener listener, Handler handler) {
        if (listener != null) {
            Looper looper;
            Looper looper2 = looper = handler != null ? handler.getLooper() : Looper.myLooper();
            if (looper != null && (this.mEventHandler == null || this.mEventHandler.getLooper() != looper)) {
                this.mEventHandler = new EventHandler(this, looper);
            }
        }
        this.mOnKeyStatusChangeListener = listener;
    }

    public void setOnEventListener(OnEventListener listener) {
        this.mOnEventListener = listener;
    }

    private List<KeyStatus> keyStatusListFromParcel(Parcel parcel) {
        int nelems = parcel.readInt();
        ArrayList<KeyStatus> keyStatusList = new ArrayList<KeyStatus>(nelems);
        while (nelems-- > 0) {
            byte[] keyId = parcel.createByteArray();
            int keyStatusCode = parcel.readInt();
            keyStatusList.add(new KeyStatus(keyId, keyStatusCode));
        }
        return keyStatusList;
    }

    private static void postEventFromNative(Object mediadrm_ref, int what, int eventType, int extra, Object obj) {
        MediaDrm md = (MediaDrm)((WeakReference)mediadrm_ref).get();
        if (md == null) {
            return;
        }
        if (md.mEventHandler != null) {
            Message m = md.mEventHandler.obtainMessage(what, eventType, extra, obj);
            md.mEventHandler.sendMessage(m);
        }
    }

    public byte[] openSession() throws NotProvisionedException, ResourceBusyException {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#openSession()[B", true, this);
    }

    public void closeSession(byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#closeSession([B)V", true, this);
    }

    public KeyRequest getKeyRequest(byte[] byArray, byte[] byArray2, String string2, int n, HashMap<String, String> hashMap) throws NotProvisionedException {
        return (KeyRequest)OverrideMethod.invokeA("android.media.MediaDrm#getKeyRequest([B[BLjava/lang/String;ILjava/util/HashMap;)Landroid/media/MediaDrm$KeyRequest;", true, this);
    }

    public byte[] provideKeyResponse(byte[] byArray, byte[] byArray2) throws NotProvisionedException, DeniedByServerException {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#provideKeyResponse([B[B)[B", true, this);
    }

    public void restoreKeys(byte[] byArray, byte[] byArray2) {
        OverrideMethod.invokeV("android.media.MediaDrm#restoreKeys([B[B)V", true, this);
    }

    public void removeKeys(byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#removeKeys([B)V", true, this);
    }

    public HashMap<String, String> queryKeyStatus(byte[] byArray) {
        return (HashMap)OverrideMethod.invokeA("android.media.MediaDrm#queryKeyStatus([B)Ljava/util/HashMap;", true, this);
    }

    public ProvisionRequest getProvisionRequest() {
        return this.getProvisionRequestNative(0, "");
    }

    private ProvisionRequest getProvisionRequestNative(int n, String string2) {
        return (ProvisionRequest)OverrideMethod.invokeA("android.media.MediaDrm#getProvisionRequestNative(ILjava/lang/String;)Landroid/media/MediaDrm$ProvisionRequest;", true, this);
    }

    public void provideProvisionResponse(byte[] response) throws DeniedByServerException {
        this.provideProvisionResponseNative(response);
    }

    private Certificate provideProvisionResponseNative(byte[] byArray) throws DeniedByServerException {
        return (Certificate)OverrideMethod.invokeA("android.media.MediaDrm#provideProvisionResponseNative([B)Landroid/media/MediaDrm$Certificate;", true, this);
    }

    public List<byte[]> getSecureStops() {
        return (List)OverrideMethod.invokeA("android.media.MediaDrm#getSecureStops()Ljava/util/List;", true, this);
    }

    public byte[] getSecureStop(byte[] byArray) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#getSecureStop([B)[B", true, this);
    }

    public void releaseSecureStops(byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#releaseSecureStops([B)V", true, this);
    }

    public void releaseAllSecureStops() {
        OverrideMethod.invokeV("android.media.MediaDrm#releaseAllSecureStops()V", true, this);
    }

    public String getPropertyString(String string2) {
        return (String)OverrideMethod.invokeA("android.media.MediaDrm#getPropertyString(Ljava/lang/String;)Ljava/lang/String;", true, this);
    }

    public byte[] getPropertyByteArray(String string2) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#getPropertyByteArray(Ljava/lang/String;)[B", true, this);
    }

    public void setPropertyString(String string2, String string3) {
        OverrideMethod.invokeV("android.media.MediaDrm#setPropertyString(Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    public void setPropertyByteArray(String string2, byte[] byArray) {
        OverrideMethod.invokeV("android.media.MediaDrm#setPropertyByteArray(Ljava/lang/String;[B)V", true, this);
    }

    private static void setCipherAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
        OverrideMethod.invokeV("android.media.MediaDrm#setCipherAlgorithmNative(Landroid/media/MediaDrm;[BLjava/lang/String;)V", true, null);
    }

    private static void setMacAlgorithmNative(MediaDrm mediaDrm, byte[] byArray, String string2) {
        OverrideMethod.invokeV("android.media.MediaDrm#setMacAlgorithmNative(Landroid/media/MediaDrm;[BLjava/lang/String;)V", true, null);
    }

    private static byte[] encryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#encryptNative(Landroid/media/MediaDrm;[B[B[B[B)[B", true, null);
    }

    private static byte[] decryptNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#decryptNative(Landroid/media/MediaDrm;[B[B[B[B)[B", true, null);
    }

    private static byte[] signNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#signNative(Landroid/media/MediaDrm;[B[B[B)[B", true, null);
    }

    private static boolean verifyNative(MediaDrm mediaDrm, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        return OverrideMethod.invokeI("android.media.MediaDrm#verifyNative(Landroid/media/MediaDrm;[B[B[B[B)Z", true, null) != 0;
    }

    public CryptoSession getCryptoSession(byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
        return new CryptoSession(sessionId, cipherAlgorithm, macAlgorithm);
    }

    public CertificateRequest getCertificateRequest(int certType, String certAuthority) {
        ProvisionRequest provisionRequest = this.getProvisionRequestNative(certType, certAuthority);
        return new CertificateRequest(provisionRequest.getData(), provisionRequest.getDefaultUrl());
    }

    public Certificate provideCertificateResponse(byte[] response) throws DeniedByServerException {
        return this.provideProvisionResponseNative(response);
    }

    private static byte[] signRSANative(MediaDrm mediaDrm, byte[] byArray, String string2, byte[] byArray2, byte[] byArray3) {
        return (byte[])OverrideMethod.invokeA("android.media.MediaDrm#signRSANative(Landroid/media/MediaDrm;[BLjava/lang/String;[B[B)[B", true, null);
    }

    public byte[] signRSA(byte[] sessionId, String algorithm, byte[] wrappedKey, byte[] message) {
        return MediaDrm.signRSANative(this, sessionId, algorithm, wrappedKey, message);
    }

    protected void finalize() {
        this.native_finalize();
    }

    public void release() {
        OverrideMethod.invokeV("android.media.MediaDrm#release()V", true, this);
    }

    private static void native_init() {
        OverrideMethod.invokeV("android.media.MediaDrm#native_init()V", true, null);
    }

    private void native_setup(Object object, byte[] byArray, String string2) {
        OverrideMethod.invokeV("android.media.MediaDrm#native_setup(Ljava/lang/Object;[BLjava/lang/String;)V", true, this);
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.MediaDrm#native_finalize()V", true, this);
    }

    static {
        System.loadLibrary("media_jni");
        MediaDrm.native_init();
    }

    public static class Certificate {
        private byte[] mWrappedKey;
        private byte[] mCertificateData;

        Certificate() {
        }

        public byte[] getWrappedPrivateKey() {
            if (this.mWrappedKey == null) {
                throw new RuntimeException("Cerfificate is not initialized");
            }
            return this.mWrappedKey;
        }

        public byte[] getContent() {
            if (this.mCertificateData == null) {
                throw new RuntimeException("Cerfificate is not initialized");
            }
            return this.mCertificateData;
        }
    }

    public static class CertificateRequest {
        private byte[] mData;
        private String mDefaultUrl;

        CertificateRequest(byte[] data, String defaultUrl) {
            this.mData = data;
            this.mDefaultUrl = defaultUrl;
        }

        public byte[] getData() {
            return this.mData;
        }

        public String getDefaultUrl() {
            return this.mDefaultUrl;
        }
    }

    public class CryptoSession {
        private byte[] mSessionId;

        CryptoSession(byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
            this.mSessionId = sessionId;
            MediaDrm.setCipherAlgorithmNative(MediaDrm.this, sessionId, cipherAlgorithm);
            MediaDrm.setMacAlgorithmNative(MediaDrm.this, sessionId, macAlgorithm);
        }

        public byte[] encrypt(byte[] keyid, byte[] input, byte[] iv) {
            return MediaDrm.encryptNative(MediaDrm.this, this.mSessionId, keyid, input, iv);
        }

        public byte[] decrypt(byte[] keyid, byte[] input, byte[] iv) {
            return MediaDrm.decryptNative(MediaDrm.this, this.mSessionId, keyid, input, iv);
        }

        public byte[] sign(byte[] keyid, byte[] message) {
            return MediaDrm.signNative(MediaDrm.this, this.mSessionId, keyid, message);
        }

        public boolean verify(byte[] keyid, byte[] message, byte[] signature) {
            return MediaDrm.verifyNative(MediaDrm.this, this.mSessionId, keyid, message, signature);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ArrayProperty {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StringProperty {
    }

    public static class ProvisionRequest {
        private byte[] mData;
        private String mDefaultUrl;

        ProvisionRequest() {
        }

        public byte[] getData() {
            if (this.mData == null) {
                throw new RuntimeException("ProvisionRequest is not initialized");
            }
            return this.mData;
        }

        public String getDefaultUrl() {
            if (this.mDefaultUrl == null) {
                throw new RuntimeException("ProvisionRequest is not initialized");
            }
            return this.mDefaultUrl;
        }
    }

    public static class KeyRequest {
        private byte[] mData;
        private String mDefaultUrl;
        private int mRequestType;
        public static final int REQUEST_TYPE_INITIAL = 0;
        public static final int REQUEST_TYPE_RENEWAL = 1;
        public static final int REQUEST_TYPE_RELEASE = 2;

        KeyRequest() {
        }

        public byte[] getData() {
            if (this.mData == null) {
                throw new RuntimeException("KeyRequest is not initialized");
            }
            return this.mData;
        }

        public String getDefaultUrl() {
            if (this.mDefaultUrl == null) {
                throw new RuntimeException("KeyRequest is not initialized");
            }
            return this.mDefaultUrl;
        }

        public int getRequestType() {
            return this.mRequestType;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RequestType {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface KeyType {
    }

    private class EventHandler
    extends Handler {
        private MediaDrm mMediaDrm;

        public EventHandler(MediaDrm md, Looper looper) {
            super(looper);
            this.mMediaDrm = md;
        }

        @Override
        public void handleMessage(Message msg) {
            if (this.mMediaDrm.mNativeContext == 0L) {
                Log.w(MediaDrm.TAG, "MediaDrm went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 200: {
                    if (MediaDrm.this.mOnEventListener != null && msg.obj != null && msg.obj instanceof Parcel) {
                        byte[] data;
                        Parcel parcel = (Parcel)msg.obj;
                        byte[] sessionId = parcel.createByteArray();
                        if (sessionId.length == 0) {
                            sessionId = null;
                        }
                        if ((data = parcel.createByteArray()).length == 0) {
                            data = null;
                        }
                        Log.i(MediaDrm.TAG, "Drm event (" + msg.arg1 + "," + msg.arg2 + ")");
                        MediaDrm.this.mOnEventListener.onEvent(this.mMediaDrm, sessionId, msg.arg1, msg.arg2, data);
                    }
                    return;
                }
                case 202: {
                    Parcel parcel;
                    byte[] sessionId;
                    if (MediaDrm.this.mOnKeyStatusChangeListener != null && msg.obj != null && msg.obj instanceof Parcel && (sessionId = (parcel = (Parcel)msg.obj).createByteArray()).length > 0) {
                        List keyStatusList = MediaDrm.this.keyStatusListFromParcel(parcel);
                        boolean hasNewUsableKey = parcel.readInt() != 0;
                        Log.i(MediaDrm.TAG, "Drm key status changed");
                        MediaDrm.this.mOnKeyStatusChangeListener.onKeyStatusChange(this.mMediaDrm, sessionId, keyStatusList, hasNewUsableKey);
                    }
                    return;
                }
                case 201: {
                    Parcel parcel;
                    byte[] sessionId;
                    if (MediaDrm.this.mOnExpirationUpdateListener != null && msg.obj != null && msg.obj instanceof Parcel && (sessionId = (parcel = (Parcel)msg.obj).createByteArray()).length > 0) {
                        long expirationTime = parcel.readLong();
                        Log.i(MediaDrm.TAG, "Drm key expiration update: " + expirationTime);
                        MediaDrm.this.mOnExpirationUpdateListener.onExpirationUpdate(this.mMediaDrm, sessionId, expirationTime);
                    }
                    return;
                }
            }
            Log.e(MediaDrm.TAG, "Unknown message type " + msg.what);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DrmEvent {
    }

    public static interface OnEventListener {
        public void onEvent(MediaDrm var1, byte[] var2, int var3, int var4, byte[] var5);
    }

    public static class KeyStatus {
        private final byte[] mKeyId;
        private final int mStatusCode;
        public static final int STATUS_USABLE = 0;
        public static final int STATUS_EXPIRED = 1;
        public static final int STATUS_OUTPUT_NOT_ALLOWED = 2;
        public static final int STATUS_PENDING = 3;
        public static final int STATUS_INTERNAL_ERROR = 4;

        KeyStatus(byte[] keyId, int statusCode) {
            this.mKeyId = keyId;
            this.mStatusCode = statusCode;
        }

        public int getStatusCode() {
            return this.mStatusCode;
        }

        public byte[] getKeyId() {
            return this.mKeyId;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface KeyStatusCode {
        }
    }

    public static interface OnKeyStatusChangeListener {
        public void onKeyStatusChange(MediaDrm var1, byte[] var2, List<KeyStatus> var3, boolean var4);
    }

    public static interface OnExpirationUpdateListener {
        public void onExpirationUpdate(MediaDrm var1, byte[] var2, long var3);
    }

    public static class MediaDrmStateException
    extends IllegalStateException {
        private final int mErrorCode;
        private final String mDiagnosticInfo;

        public MediaDrmStateException(int errorCode, String detailMessage) {
            super(detailMessage);
            this.mErrorCode = errorCode;
            String sign = errorCode < 0 ? "neg_" : "";
            this.mDiagnosticInfo = "android.media.MediaDrm.error_" + sign + Math.abs(errorCode);
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }

        public String getDiagnosticInfo() {
            return this.mDiagnosticInfo;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CertificateType {
    }
}

