/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.MatchAllNetworkSpecifier;
import android.net.NetworkSpecifier;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.BitUtils;
import com.android.internal.util.Preconditions;
import java.util.Objects;
import java.util.StringJoiner;

public class NetworkCapabilities
implements Parcelable {
    private static final String TAG = "NetworkCapabilities";
    private long mNetworkCapabilities;
    public static final int NET_CAPABILITY_MMS = 0;
    public static final int NET_CAPABILITY_SUPL = 1;
    public static final int NET_CAPABILITY_DUN = 2;
    public static final int NET_CAPABILITY_FOTA = 3;
    public static final int NET_CAPABILITY_IMS = 4;
    public static final int NET_CAPABILITY_CBS = 5;
    public static final int NET_CAPABILITY_WIFI_P2P = 6;
    public static final int NET_CAPABILITY_IA = 7;
    public static final int NET_CAPABILITY_RCS = 8;
    public static final int NET_CAPABILITY_XCAP = 9;
    public static final int NET_CAPABILITY_EIMS = 10;
    public static final int NET_CAPABILITY_NOT_METERED = 11;
    public static final int NET_CAPABILITY_INTERNET = 12;
    public static final int NET_CAPABILITY_NOT_RESTRICTED = 13;
    public static final int NET_CAPABILITY_TRUSTED = 14;
    public static final int NET_CAPABILITY_NOT_VPN = 15;
    public static final int NET_CAPABILITY_VALIDATED = 16;
    public static final int NET_CAPABILITY_CAPTIVE_PORTAL = 17;
    public static final int NET_CAPABILITY_FOREGROUND = 18;
    private static final int MIN_NET_CAPABILITY = 0;
    private static final int MAX_NET_CAPABILITY = 18;
    private static final long MUTABLE_CAPABILITIES = 475136L;
    private static final long NON_REQUESTABLE_CAPABILITIES = 458752L;
    private static final long DEFAULT_CAPABILITIES = 57344L;
    @VisibleForTesting
    static final long RESTRICTED_CAPABILITIES = 1980L;
    @VisibleForTesting
    static final long UNRESTRICTED_CAPABILITIES = 4163L;
    private long mTransportTypes;
    public static final int TRANSPORT_CELLULAR = 0;
    public static final int TRANSPORT_WIFI = 1;
    public static final int TRANSPORT_BLUETOOTH = 2;
    public static final int TRANSPORT_ETHERNET = 3;
    public static final int TRANSPORT_VPN = 4;
    public static final int TRANSPORT_WIFI_AWARE = 5;
    public static final int TRANSPORT_LOWPAN = 6;
    public static final int MIN_TRANSPORT = 0;
    public static final int MAX_TRANSPORT = 6;
    private static final String[] TRANSPORT_NAMES = new String[]{"CELLULAR", "WIFI", "BLUETOOTH", "ETHERNET", "VPN", "WIFI_AWARE", "LOWPAN"};
    private int mLinkUpBandwidthKbps;
    private int mLinkDownBandwidthKbps;
    private NetworkSpecifier mNetworkSpecifier = null;
    public static final int SIGNAL_STRENGTH_UNSPECIFIED = Integer.MIN_VALUE;
    private int mSignalStrength;
    public static final Parcelable.Creator<NetworkCapabilities> CREATOR = new Parcelable.Creator<NetworkCapabilities>(){

        @Override
        public NetworkCapabilities createFromParcel(Parcel in) {
            NetworkCapabilities netCap = new NetworkCapabilities();
            netCap.mNetworkCapabilities = in.readLong();
            netCap.mTransportTypes = in.readLong();
            netCap.mLinkUpBandwidthKbps = in.readInt();
            netCap.mLinkDownBandwidthKbps = in.readInt();
            netCap.mNetworkSpecifier = (NetworkSpecifier)in.readParcelable(null);
            netCap.mSignalStrength = in.readInt();
            return netCap;
        }

        public NetworkCapabilities[] newArray(int size) {
            return new NetworkCapabilities[size];
        }
    };

    public NetworkCapabilities() {
        this.clearAll();
        this.mNetworkCapabilities = 57344L;
    }

    public NetworkCapabilities(NetworkCapabilities nc) {
        if (nc != null) {
            this.mNetworkCapabilities = nc.mNetworkCapabilities;
            this.mTransportTypes = nc.mTransportTypes;
            this.mLinkUpBandwidthKbps = nc.mLinkUpBandwidthKbps;
            this.mLinkDownBandwidthKbps = nc.mLinkDownBandwidthKbps;
            this.mNetworkSpecifier = nc.mNetworkSpecifier;
            this.mSignalStrength = nc.mSignalStrength;
        }
    }

    public void clearAll() {
        this.mTransportTypes = 0L;
        this.mNetworkCapabilities = 0L;
        this.mLinkDownBandwidthKbps = 0;
        this.mLinkUpBandwidthKbps = 0;
        this.mNetworkSpecifier = null;
        this.mSignalStrength = Integer.MIN_VALUE;
    }

    public NetworkCapabilities addCapability(int capability) {
        if (capability < 0 || capability > 18) {
            throw new IllegalArgumentException("NetworkCapability out of range");
        }
        this.mNetworkCapabilities |= (long)(1 << capability);
        return this;
    }

    public NetworkCapabilities removeCapability(int capability) {
        if (capability < 0 || capability > 18) {
            throw new IllegalArgumentException("NetworkCapability out of range");
        }
        this.mNetworkCapabilities &= (long)(~(1 << capability));
        return this;
    }

    public int[] getCapabilities() {
        return BitUtils.unpackBits(this.mNetworkCapabilities);
    }

    public boolean hasCapability(int capability) {
        if (capability < 0 || capability > 18) {
            return false;
        }
        return (this.mNetworkCapabilities & (long)(1 << capability)) != 0L;
    }

    private void combineNetCapabilities(NetworkCapabilities nc) {
        this.mNetworkCapabilities |= nc.mNetworkCapabilities;
    }

    public String describeFirstNonRequestableCapability() {
        if (this.hasCapability(16)) {
            return "NET_CAPABILITY_VALIDATED";
        }
        if (this.hasCapability(17)) {
            return "NET_CAPABILITY_CAPTIVE_PORTAL";
        }
        if (this.hasCapability(18)) {
            return "NET_CAPABILITY_FOREGROUND";
        }
        if ((this.mNetworkCapabilities & 0x70000L) != 0L) {
            return "unknown non-requestable capabilities " + Long.toHexString(this.mNetworkCapabilities);
        }
        if (this.mLinkUpBandwidthKbps != 0 || this.mLinkDownBandwidthKbps != 0) {
            return "link bandwidth";
        }
        if (this.hasSignalStrength()) {
            return "signalStrength";
        }
        return null;
    }

    private boolean satisfiedByNetCapabilities(NetworkCapabilities nc, boolean onlyImmutable) {
        long networkCapabilities = this.mNetworkCapabilities;
        if (onlyImmutable) {
            networkCapabilities &= 0xFFFFFFFFFFF8BFFFL;
        }
        return (nc.mNetworkCapabilities & networkCapabilities) == networkCapabilities;
    }

    public boolean equalsNetCapabilities(NetworkCapabilities nc) {
        return nc.mNetworkCapabilities == this.mNetworkCapabilities;
    }

    private boolean equalsNetCapabilitiesRequestable(NetworkCapabilities that) {
        return (this.mNetworkCapabilities & 0xFFFFFFFFFFF8FFFFL) == (that.mNetworkCapabilities & 0xFFFFFFFFFFF8FFFFL);
    }

    public void maybeMarkCapabilitiesRestricted() {
        boolean hasRestrictedCapabilities;
        boolean hasUnrestrictedCapabilities = (this.mNetworkCapabilities & 0x1043L) != 0L;
        boolean bl = hasRestrictedCapabilities = (this.mNetworkCapabilities & 0x7BCL) != 0L;
        if (hasRestrictedCapabilities && !hasUnrestrictedCapabilities) {
            this.removeCapability(13);
        }
    }

    public static boolean isValidTransport(int transportType) {
        return 0 <= transportType && transportType <= 6;
    }

    public NetworkCapabilities addTransportType(int transportType) {
        NetworkCapabilities.checkValidTransportType(transportType);
        this.mTransportTypes |= (long)(1 << transportType);
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    public NetworkCapabilities removeTransportType(int transportType) {
        NetworkCapabilities.checkValidTransportType(transportType);
        this.mTransportTypes &= (long)(~(1 << transportType));
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    public int[] getTransportTypes() {
        return BitUtils.unpackBits(this.mTransportTypes);
    }

    public boolean hasTransport(int transportType) {
        return NetworkCapabilities.isValidTransport(transportType) && (this.mTransportTypes & (long)(1 << transportType)) != 0L;
    }

    private void combineTransportTypes(NetworkCapabilities nc) {
        this.mTransportTypes |= nc.mTransportTypes;
    }

    private boolean satisfiedByTransportTypes(NetworkCapabilities nc) {
        return this.mTransportTypes == 0L || (this.mTransportTypes & nc.mTransportTypes) != 0L;
    }

    public boolean equalsTransportTypes(NetworkCapabilities nc) {
        return nc.mTransportTypes == this.mTransportTypes;
    }

    public void setLinkUpstreamBandwidthKbps(int upKbps) {
        this.mLinkUpBandwidthKbps = upKbps;
    }

    public int getLinkUpstreamBandwidthKbps() {
        return this.mLinkUpBandwidthKbps;
    }

    public void setLinkDownstreamBandwidthKbps(int downKbps) {
        this.mLinkDownBandwidthKbps = downKbps;
    }

    public int getLinkDownstreamBandwidthKbps() {
        return this.mLinkDownBandwidthKbps;
    }

    private void combineLinkBandwidths(NetworkCapabilities nc) {
        this.mLinkUpBandwidthKbps = Math.max(this.mLinkUpBandwidthKbps, nc.mLinkUpBandwidthKbps);
        this.mLinkDownBandwidthKbps = Math.max(this.mLinkDownBandwidthKbps, nc.mLinkDownBandwidthKbps);
    }

    private boolean satisfiedByLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps <= nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps <= nc.mLinkDownBandwidthKbps;
    }

    private boolean equalsLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps == nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps == nc.mLinkDownBandwidthKbps;
    }

    public NetworkCapabilities setNetworkSpecifier(NetworkSpecifier networkSpecifier) {
        if (networkSpecifier != null && Long.bitCount(this.mTransportTypes) != 1) {
            throw new IllegalStateException("Must have a single transport specified to use setNetworkSpecifier");
        }
        this.mNetworkSpecifier = networkSpecifier;
        return this;
    }

    public NetworkSpecifier getNetworkSpecifier() {
        return this.mNetworkSpecifier;
    }

    private void combineSpecifiers(NetworkCapabilities nc) {
        if (this.mNetworkSpecifier != null && !this.mNetworkSpecifier.equals(nc.mNetworkSpecifier)) {
            throw new IllegalStateException("Can't combine two networkSpecifiers");
        }
        this.setNetworkSpecifier(nc.mNetworkSpecifier);
    }

    private boolean satisfiedBySpecifier(NetworkCapabilities nc) {
        return this.mNetworkSpecifier == null || this.mNetworkSpecifier.satisfiedBy(nc.mNetworkSpecifier) || nc.mNetworkSpecifier instanceof MatchAllNetworkSpecifier;
    }

    private boolean equalsSpecifier(NetworkCapabilities nc) {
        return Objects.equals(this.mNetworkSpecifier, nc.mNetworkSpecifier);
    }

    public void setSignalStrength(int signalStrength) {
        this.mSignalStrength = signalStrength;
    }

    public boolean hasSignalStrength() {
        return this.mSignalStrength > Integer.MIN_VALUE;
    }

    public int getSignalStrength() {
        return this.mSignalStrength;
    }

    private void combineSignalStrength(NetworkCapabilities nc) {
        this.mSignalStrength = Math.max(this.mSignalStrength, nc.mSignalStrength);
    }

    private boolean satisfiedBySignalStrength(NetworkCapabilities nc) {
        return this.mSignalStrength <= nc.mSignalStrength;
    }

    private boolean equalsSignalStrength(NetworkCapabilities nc) {
        return this.mSignalStrength == nc.mSignalStrength;
    }

    public void combineCapabilities(NetworkCapabilities nc) {
        this.combineNetCapabilities(nc);
        this.combineTransportTypes(nc);
        this.combineLinkBandwidths(nc);
        this.combineSpecifiers(nc);
        this.combineSignalStrength(nc);
    }

    private boolean satisfiedByNetworkCapabilities(NetworkCapabilities nc, boolean onlyImmutable) {
        return !(nc == null || !this.satisfiedByNetCapabilities(nc, onlyImmutable) || !this.satisfiedByTransportTypes(nc) || !onlyImmutable && !this.satisfiedByLinkBandwidths(nc) || !this.satisfiedBySpecifier(nc) || !onlyImmutable && !this.satisfiedBySignalStrength(nc));
    }

    public boolean satisfiedByNetworkCapabilities(NetworkCapabilities nc) {
        return this.satisfiedByNetworkCapabilities(nc, false);
    }

    public boolean satisfiedByImmutableNetworkCapabilities(NetworkCapabilities nc) {
        return this.satisfiedByNetworkCapabilities(nc, true);
    }

    public String describeImmutableDifferences(NetworkCapabilities that) {
        Object after;
        Object before;
        if (that == null) {
            return "other NetworkCapabilities was null";
        }
        StringJoiner joiner = new StringJoiner(", ");
        long mask = -477185L;
        long oldImmutableCapabilities = this.mNetworkCapabilities & 0xFFFFFFFFFFF8B7FFL;
        long newImmutableCapabilities = that.mNetworkCapabilities & 0xFFFFFFFFFFF8B7FFL;
        if (oldImmutableCapabilities != newImmutableCapabilities) {
            before = NetworkCapabilities.capabilityNamesOf(BitUtils.unpackBits(oldImmutableCapabilities));
            after = NetworkCapabilities.capabilityNamesOf(BitUtils.unpackBits(newImmutableCapabilities));
            joiner.add(String.format("immutable capabilities changed: %s -> %s", before, after));
        }
        if (!this.equalsSpecifier(that)) {
            before = this.getNetworkSpecifier();
            after = that.getNetworkSpecifier();
            joiner.add(String.format("specifier changed: %s -> %s", before, after));
        }
        if (!this.equalsTransportTypes(that)) {
            before = NetworkCapabilities.transportNamesOf(this.getTransportTypes());
            after = NetworkCapabilities.transportNamesOf(that.getTransportTypes());
            joiner.add(String.format("transports changed: %s -> %s", before, after));
        }
        return joiner.toString();
    }

    public boolean equalRequestableCapabilities(NetworkCapabilities nc) {
        if (nc == null) {
            return false;
        }
        return this.equalsNetCapabilitiesRequestable(nc) && this.equalsTransportTypes(nc) && this.equalsSpecifier(nc);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NetworkCapabilities)) {
            return false;
        }
        NetworkCapabilities that = (NetworkCapabilities)obj;
        return this.equalsNetCapabilities(that) && this.equalsTransportTypes(that) && this.equalsLinkBandwidths(that) && this.equalsSignalStrength(that) && this.equalsSpecifier(that);
    }

    public int hashCode() {
        return (int)(this.mNetworkCapabilities & 0xFFFFFFFFFFFFFFFFL) + (int)(this.mNetworkCapabilities >> 32) * 3 + (int)(this.mTransportTypes & 0xFFFFFFFFFFFFFFFFL) * 5 + (int)(this.mTransportTypes >> 32) * 7 + this.mLinkUpBandwidthKbps * 11 + this.mLinkDownBandwidthKbps * 13 + Objects.hashCode(this.mNetworkSpecifier) * 17 + this.mSignalStrength * 19;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mNetworkCapabilities);
        dest.writeLong(this.mTransportTypes);
        dest.writeInt(this.mLinkUpBandwidthKbps);
        dest.writeInt(this.mLinkDownBandwidthKbps);
        dest.writeParcelable((Parcelable)((Object)this.mNetworkSpecifier), flags);
        dest.writeInt(this.mSignalStrength);
    }

    public String toString() {
        int[] types = this.getTransportTypes();
        String transports = types.length > 0 ? " Transports: " + NetworkCapabilities.transportNamesOf(types) : "";
        types = this.getCapabilities();
        String capabilities = types.length > 0 ? " Capabilities: " : "";
        int i = 0;
        while (i < types.length) {
            capabilities = capabilities + NetworkCapabilities.capabilityNameOf(types[i]);
            if (++i >= types.length) continue;
            capabilities = capabilities + "&";
        }
        String upBand = this.mLinkUpBandwidthKbps > 0 ? " LinkUpBandwidth>=" + this.mLinkUpBandwidthKbps + "Kbps" : "";
        String dnBand = this.mLinkDownBandwidthKbps > 0 ? " LinkDnBandwidth>=" + this.mLinkDownBandwidthKbps + "Kbps" : "";
        String specifier = this.mNetworkSpecifier == null ? "" : " Specifier: <" + this.mNetworkSpecifier + ">";
        String signalStrength = this.hasSignalStrength() ? " SignalStrength: " + this.mSignalStrength : "";
        return "[" + transports + capabilities + upBand + dnBand + specifier + signalStrength + "]";
    }

    public static String capabilityNamesOf(int[] capabilities) {
        StringJoiner joiner = new StringJoiner("|");
        if (capabilities != null) {
            for (int c : capabilities) {
                joiner.add(NetworkCapabilities.capabilityNameOf(c));
            }
        }
        return joiner.toString();
    }

    public static String capabilityNameOf(int capability) {
        switch (capability) {
            case 0: {
                return "MMS";
            }
            case 1: {
                return "SUPL";
            }
            case 2: {
                return "DUN";
            }
            case 3: {
                return "FOTA";
            }
            case 4: {
                return "IMS";
            }
            case 5: {
                return "CBS";
            }
            case 6: {
                return "WIFI_P2P";
            }
            case 7: {
                return "IA";
            }
            case 8: {
                return "RCS";
            }
            case 9: {
                return "XCAP";
            }
            case 10: {
                return "EIMS";
            }
            case 11: {
                return "NOT_METERED";
            }
            case 12: {
                return "INTERNET";
            }
            case 13: {
                return "NOT_RESTRICTED";
            }
            case 14: {
                return "TRUSTED";
            }
            case 15: {
                return "NOT_VPN";
            }
            case 16: {
                return "VALIDATED";
            }
            case 17: {
                return "CAPTIVE_PORTAL";
            }
            case 18: {
                return "FOREGROUND";
            }
        }
        return Integer.toString(capability);
    }

    public static String transportNamesOf(int[] types) {
        StringJoiner joiner = new StringJoiner("|");
        if (types != null) {
            for (int t : types) {
                joiner.add(NetworkCapabilities.transportNameOf(t));
            }
        }
        return joiner.toString();
    }

    public static String transportNameOf(int transport) {
        if (!NetworkCapabilities.isValidTransport(transport)) {
            return "UNKNOWN";
        }
        return TRANSPORT_NAMES[transport];
    }

    private static void checkValidTransportType(int transport) {
        Preconditions.checkArgument(NetworkCapabilities.isValidTransport(transport), "Invalid TransportType " + transport);
    }
}

