/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.net.NetworkSpecifier;
import android.net.wifi.aware.DiscoverySessionCallback;
import android.net.wifi.aware.PublishConfig;
import android.net.wifi.aware.SubscribeConfig;
import android.net.wifi.aware.WifiAwareManager;
import android.net.wifi.aware.WifiAwareUtils;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;

public class WifiAwareSession
implements AutoCloseable {
    private static final String TAG = "WifiAwareSession";
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private final WeakReference<WifiAwareManager> mMgr;
    private final Binder mBinder;
    private final int mClientId;
    private boolean mTerminated = true;
    private final CloseGuard mCloseGuard = CloseGuard.get();

    public WifiAwareSession(WifiAwareManager manager, Binder binder, int clientId) {
        this.mMgr = new WeakReference<WifiAwareManager>(manager);
        this.mBinder = binder;
        this.mClientId = clientId;
        this.mTerminated = false;
        this.mCloseGuard.open("close");
    }

    @Override
    public void close() {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w(TAG, "destroy: called post GC on WifiAwareManager");
            return;
        }
        mgr.disconnect(this.mClientId, this.mBinder);
        this.mTerminated = true;
        this.mMgr.clear();
        this.mCloseGuard.close();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (!this.mTerminated) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void publish(PublishConfig publishConfig, DiscoverySessionCallback callback, Handler handler) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "publish: called post GC on WifiAwareManager");
            return;
        }
        if (this.mTerminated) {
            Log.e(TAG, "publish: called after termination");
            return;
        }
        mgr.publish(this.mClientId, handler == null ? Looper.getMainLooper() : handler.getLooper(), publishConfig, callback);
    }

    public void subscribe(SubscribeConfig subscribeConfig, DiscoverySessionCallback callback, Handler handler) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "publish: called post GC on WifiAwareManager");
            return;
        }
        if (this.mTerminated) {
            Log.e(TAG, "publish: called after termination");
            return;
        }
        mgr.subscribe(this.mClientId, handler == null ? Looper.getMainLooper() : handler.getLooper(), subscribeConfig, callback);
    }

    public NetworkSpecifier createNetworkSpecifierOpen(int role, byte[] peer) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "createNetworkSpecifierOpen: called post GC on WifiAwareManager");
            return null;
        }
        if (this.mTerminated) {
            Log.e(TAG, "createNetworkSpecifierOpen: called after termination");
            return null;
        }
        return mgr.createNetworkSpecifier(this.mClientId, role, peer, null, null);
    }

    public NetworkSpecifier createNetworkSpecifierPassphrase(int role, byte[] peer, String passphrase) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "createNetworkSpecifierPassphrase: called post GC on WifiAwareManager");
            return null;
        }
        if (this.mTerminated) {
            Log.e(TAG, "createNetworkSpecifierPassphrase: called after termination");
            return null;
        }
        if (!WifiAwareUtils.validatePassphrase(passphrase)) {
            throw new IllegalArgumentException("Passphrase must meet length requirements");
        }
        return mgr.createNetworkSpecifier(this.mClientId, role, peer, null, passphrase);
    }

    public NetworkSpecifier createNetworkSpecifierPmk(int role, byte[] peer, byte[] pmk) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e(TAG, "createNetworkSpecifierPmk: called post GC on WifiAwareManager");
            return null;
        }
        if (this.mTerminated) {
            Log.e(TAG, "createNetworkSpecifierPmk: called after termination");
            return null;
        }
        if (!WifiAwareUtils.validatePmk(pmk)) {
            throw new IllegalArgumentException("PMK must 32 bytes");
        }
        return mgr.createNetworkSpecifier(this.mClientId, role, peer, pmk, null);
    }
}

