/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemProperties;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;

public class Trace {
    private static final String TAG = "Trace";
    public static final long TRACE_TAG_NEVER = 0L;
    public static final long TRACE_TAG_ALWAYS = 1L;
    public static final long TRACE_TAG_GRAPHICS = 2L;
    public static final long TRACE_TAG_INPUT = 4L;
    public static final long TRACE_TAG_VIEW = 8L;
    public static final long TRACE_TAG_WEBVIEW = 16L;
    public static final long TRACE_TAG_WINDOW_MANAGER = 32L;
    public static final long TRACE_TAG_ACTIVITY_MANAGER = 64L;
    public static final long TRACE_TAG_SYNC_MANAGER = 128L;
    public static final long TRACE_TAG_AUDIO = 256L;
    public static final long TRACE_TAG_VIDEO = 512L;
    public static final long TRACE_TAG_CAMERA = 1024L;
    public static final long TRACE_TAG_HAL = 2048L;
    public static final long TRACE_TAG_APP = 4096L;
    public static final long TRACE_TAG_RESOURCES = 8192L;
    public static final long TRACE_TAG_DALVIK = 16384L;
    public static final long TRACE_TAG_RS = 32768L;
    public static final long TRACE_TAG_BIONIC = 65536L;
    public static final long TRACE_TAG_POWER = 131072L;
    public static final long TRACE_TAG_PACKAGE_MANAGER = 262144L;
    public static final long TRACE_TAG_SYSTEM_SERVER = 524288L;
    public static final long TRACE_TAG_DATABASE = 0x100000L;
    public static final long TRACE_TAG_NETWORK = 0x200000L;
    public static final long TRACE_TAG_ADB = 0x400000L;
    private static final long TRACE_TAG_NOT_READY = Long.MIN_VALUE;
    private static final int MAX_SECTION_NAME_LEN = 127;
    private static volatile long sEnabledTags = Long.MIN_VALUE;
    private static int sZygoteDebugFlags = 0;

    private static long nativeGetEnabledTags() {
        return OverrideMethod.invokeL("android.os.Trace#nativeGetEnabledTags()J", true, null);
    }

    private static void nativeSetAppTracingAllowed(boolean bl) {
        OverrideMethod.invokeV("android.os.Trace#nativeSetAppTracingAllowed(Z)V", true, null);
    }

    private static void nativeSetTracingEnabled(boolean bl) {
        OverrideMethod.invokeV("android.os.Trace#nativeSetTracingEnabled(Z)V", true, null);
    }

    @FastNative
    private static void nativeTraceCounter(long l, String string2, int n) {
        OverrideMethod.invokeV("android.os.Trace#nativeTraceCounter(JLjava/lang/String;I)V", true, null);
    }

    @FastNative
    private static void nativeTraceBegin(long l, String string2) {
        OverrideMethod.invokeV("android.os.Trace#nativeTraceBegin(JLjava/lang/String;)V", true, null);
    }

    @FastNative
    private static void nativeTraceEnd(long l) {
        OverrideMethod.invokeV("android.os.Trace#nativeTraceEnd(J)V", true, null);
    }

    @FastNative
    private static void nativeAsyncTraceBegin(long l, String string2, int n) {
        OverrideMethod.invokeV("android.os.Trace#nativeAsyncTraceBegin(JLjava/lang/String;I)V", true, null);
    }

    @FastNative
    private static void nativeAsyncTraceEnd(long l, String string2, int n) {
        OverrideMethod.invokeV("android.os.Trace#nativeAsyncTraceEnd(JLjava/lang/String;I)V", true, null);
    }

    private Trace() {
    }

    private static long cacheEnabledTags() {
        long tags;
        sEnabledTags = tags = Trace.nativeGetEnabledTags();
        return tags;
    }

    public static boolean isTagEnabled(long traceTag) {
        long tags = sEnabledTags;
        if (tags == Long.MIN_VALUE) {
            tags = Trace.cacheEnabledTags();
        }
        return (tags & traceTag) != 0L;
    }

    public static void traceCounter(long traceTag, String counterName, int counterValue) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceCounter(traceTag, counterName, counterValue);
        }
    }

    public static void setAppTracingAllowed(boolean allowed) {
        Trace.nativeSetAppTracingAllowed(allowed);
        Trace.cacheEnabledTags();
    }

    public static void setTracingEnabled(boolean enabled, int debugFlags) {
        Trace.nativeSetTracingEnabled(enabled);
        sZygoteDebugFlags = debugFlags;
        Trace.cacheEnabledTags();
    }

    public static void traceBegin(long traceTag, String methodName) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceBegin(traceTag, methodName);
        }
    }

    public static void traceEnd(long traceTag) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeTraceEnd(traceTag);
        }
    }

    public static void asyncTraceBegin(long traceTag, String methodName, int cookie) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeAsyncTraceBegin(traceTag, methodName, cookie);
        }
    }

    public static void asyncTraceEnd(long traceTag, String methodName, int cookie) {
        if (Trace.isTagEnabled(traceTag)) {
            Trace.nativeAsyncTraceEnd(traceTag, methodName, cookie);
        }
    }

    public static void beginSection(String sectionName) {
        if (Trace.isTagEnabled(4096L)) {
            if (sectionName.length() > 127) {
                throw new IllegalArgumentException("sectionName is too long");
            }
            Trace.nativeTraceBegin(4096L, sectionName);
        }
    }

    public static void endSection() {
        if (Trace.isTagEnabled(4096L)) {
            Trace.nativeTraceEnd(4096L);
        }
    }

    static {
        SystemProperties.addChangeCallback(() -> {
            Trace.cacheEnabledTags();
            if ((sZygoteDebugFlags & 0x100) != 0) {
                Trace.traceCounter(1L, "java_debuggable", 1);
            }
        });
    }
}

