/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

public abstract class VibrationEffect
implements Parcelable {
    private static final int PARCEL_TOKEN_ONE_SHOT = 1;
    private static final int PARCEL_TOKEN_WAVEFORM = 2;
    private static final int PARCEL_TOKEN_EFFECT = 3;
    public static final int DEFAULT_AMPLITUDE = -1;
    public static final int EFFECT_CLICK = 0;
    public static final int EFFECT_DOUBLE_CLICK = 1;
    public static final int EFFECT_TICK = 2;
    public static final Parcelable.Creator<VibrationEffect> CREATOR = new Parcelable.Creator<VibrationEffect>(){

        @Override
        public VibrationEffect createFromParcel(Parcel in) {
            int token = in.readInt();
            if (token == 1) {
                return new OneShot(in);
            }
            if (token == 2) {
                return new Waveform(in);
            }
            if (token == 3) {
                return new Prebaked(in);
            }
            throw new IllegalStateException("Unexpected vibration event type token in parcel.");
        }

        public VibrationEffect[] newArray(int size) {
            return new VibrationEffect[size];
        }
    };

    public static VibrationEffect createOneShot(long milliseconds, int amplitude) {
        OneShot effect = new OneShot(milliseconds, amplitude);
        ((VibrationEffect)effect).validate();
        return effect;
    }

    public static VibrationEffect createWaveform(long[] timings, int repeat) {
        int[] amplitudes = new int[timings.length];
        for (int i = 0; i < timings.length / 2; ++i) {
            amplitudes[i * 2 + 1] = -1;
        }
        return VibrationEffect.createWaveform(timings, amplitudes, repeat);
    }

    public static VibrationEffect createWaveform(long[] timings, int[] amplitudes, int repeat) {
        Waveform effect = new Waveform(timings, amplitudes, repeat);
        ((VibrationEffect)effect).validate();
        return effect;
    }

    public static VibrationEffect get(int effectId) {
        return VibrationEffect.get(effectId, true);
    }

    public static VibrationEffect get(int effectId, boolean fallback) {
        Prebaked effect = new Prebaked(effectId, fallback);
        ((VibrationEffect)effect).validate();
        return effect;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public abstract void validate();

    public static class Prebaked
    extends VibrationEffect
    implements Parcelable {
        private int mEffectId;
        private boolean mFallback;
        public static final Parcelable.Creator<Prebaked> CREATOR = new Parcelable.Creator<Prebaked>(){

            @Override
            public Prebaked createFromParcel(Parcel in) {
                in.readInt();
                return new Prebaked(in);
            }

            public Prebaked[] newArray(int size) {
                return new Prebaked[size];
            }
        };

        public Prebaked(Parcel in) {
            this(in.readInt(), in.readByte() != 0);
        }

        public Prebaked(int effectId, boolean fallback) {
            this.mEffectId = effectId;
            this.mFallback = fallback;
        }

        public int getId() {
            return this.mEffectId;
        }

        public boolean shouldFallback() {
            return this.mFallback;
        }

        @Override
        public void validate() {
            switch (this.mEffectId) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown prebaked effect type (value=" + this.mEffectId + ")");
                }
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof Prebaked)) {
                return false;
            }
            Prebaked other = (Prebaked)o;
            return this.mEffectId == other.mEffectId && this.mFallback == other.mFallback;
        }

        public int hashCode() {
            return this.mEffectId;
        }

        public String toString() {
            return "Prebaked{mEffectId=" + this.mEffectId + ", mFallback=" + this.mFallback + "}";
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(3);
            out.writeInt(this.mEffectId);
            out.writeByte((byte)(this.mFallback ? 1 : 0));
        }
    }

    public static class Waveform
    extends VibrationEffect
    implements Parcelable {
        private long[] mTimings;
        private int[] mAmplitudes;
        private int mRepeat;
        public static final Parcelable.Creator<Waveform> CREATOR = new Parcelable.Creator<Waveform>(){

            @Override
            public Waveform createFromParcel(Parcel in) {
                in.readInt();
                return new Waveform(in);
            }

            public Waveform[] newArray(int size) {
                return new Waveform[size];
            }
        };

        public Waveform(Parcel in) {
            this(in.createLongArray(), in.createIntArray(), in.readInt());
        }

        public Waveform(long[] timings, int[] amplitudes, int repeat) {
            this.mTimings = new long[timings.length];
            System.arraycopy(timings, 0, this.mTimings, 0, timings.length);
            this.mAmplitudes = new int[amplitudes.length];
            System.arraycopy(amplitudes, 0, this.mAmplitudes, 0, amplitudes.length);
            this.mRepeat = repeat;
        }

        public long[] getTimings() {
            return this.mTimings;
        }

        public int[] getAmplitudes() {
            return this.mAmplitudes;
        }

        public int getRepeatIndex() {
            return this.mRepeat;
        }

        @Override
        public void validate() {
            if (this.mTimings.length != this.mAmplitudes.length) {
                throw new IllegalArgumentException("timing and amplitude arrays must be of equal length (timings.length=" + this.mTimings.length + ", amplitudes.length=" + this.mAmplitudes.length + ")");
            }
            if (!Waveform.hasNonZeroEntry(this.mTimings)) {
                throw new IllegalArgumentException("at least one timing must be non-zero (timings=" + Arrays.toString(this.mTimings) + ")");
            }
            for (long timing : this.mTimings) {
                if (timing >= 0L) continue;
                throw new IllegalArgumentException("timings must all be >= 0 (timings=" + Arrays.toString(this.mTimings) + ")");
            }
            for (int amplitude : this.mAmplitudes) {
                if (amplitude >= -1 && amplitude <= 255) continue;
                throw new IllegalArgumentException("amplitudes must all be DEFAULT_AMPLITUDE or between 0 and 255 (amplitudes=" + Arrays.toString(this.mAmplitudes) + ")");
            }
            if (this.mRepeat < -1 || this.mRepeat >= this.mTimings.length) {
                throw new IllegalArgumentException("repeat index must be within the bounds of the timings array (timings.length=" + this.mTimings.length + ", index=" + this.mRepeat + ")");
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof Waveform)) {
                return false;
            }
            Waveform other = (Waveform)o;
            return Arrays.equals(this.mTimings, other.mTimings) && Arrays.equals(this.mAmplitudes, other.mAmplitudes) && this.mRepeat == other.mRepeat;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * Arrays.hashCode(this.mTimings);
            result = 37 * Arrays.hashCode(this.mAmplitudes);
            result = 37 * this.mRepeat;
            return result;
        }

        public String toString() {
            return "Waveform{mTimings=" + Arrays.toString(this.mTimings) + ", mAmplitudes=" + Arrays.toString(this.mAmplitudes) + ", mRepeat=" + this.mRepeat + "}";
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(2);
            out.writeLongArray(this.mTimings);
            out.writeIntArray(this.mAmplitudes);
            out.writeInt(this.mRepeat);
        }

        private static boolean hasNonZeroEntry(long[] vals) {
            for (long val : vals) {
                if (val == 0L) continue;
                return true;
            }
            return false;
        }
    }

    public static class OneShot
    extends VibrationEffect
    implements Parcelable {
        private long mTiming;
        private int mAmplitude;
        public static final Parcelable.Creator<OneShot> CREATOR = new Parcelable.Creator<OneShot>(){

            @Override
            public OneShot createFromParcel(Parcel in) {
                in.readInt();
                return new OneShot(in);
            }

            public OneShot[] newArray(int size) {
                return new OneShot[size];
            }
        };

        public OneShot(Parcel in) {
            this(in.readLong(), in.readInt());
        }

        public OneShot(long milliseconds, int amplitude) {
            this.mTiming = milliseconds;
            this.mAmplitude = amplitude;
        }

        public long getTiming() {
            return this.mTiming;
        }

        public int getAmplitude() {
            return this.mAmplitude;
        }

        @Override
        public void validate() {
            if (this.mAmplitude < -1 || this.mAmplitude == 0 || this.mAmplitude > 255) {
                throw new IllegalArgumentException("amplitude must either be DEFAULT_AMPLITUDE, or between 1 and 255 inclusive (amplitude=" + this.mAmplitude + ")");
            }
            if (this.mTiming <= 0L) {
                throw new IllegalArgumentException("timing must be positive (timing=" + this.mTiming + ")");
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof OneShot)) {
                return false;
            }
            OneShot other = (OneShot)o;
            return other.mTiming == this.mTiming && other.mAmplitude == this.mAmplitude;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * (int)this.mTiming;
            result = 37 * this.mAmplitude;
            return result;
        }

        public String toString() {
            return "OneShot{mTiming=" + this.mTiming + ", mAmplitude=" + this.mAmplitude + "}";
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(1);
            out.writeLong(this.mTiming);
            out.writeInt(this.mAmplitude);
        }
    }
}

