/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.os.LocaleList;
import android.text.AndroidBidi;
import android.text.Hyphenator;
import android.text.Layout;
import android.text.MeasuredText;
import android.text.Spanned;
import android.text.StaticLayout_Delegate;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextLine;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.TabStopSpan;
import android.util.Log;
import android.util.Pools;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;

public class StaticLayout
extends Layout {
    static final String TAG = "StaticLayout";
    private int mLineCount;
    private int mTopPadding;
    private int mBottomPadding;
    private int mColumns;
    private int mEllipsizedWidth;
    private boolean mEllipsized;
    private int mMaxLineHeight = -1;
    private TextPaint mWorkPaint = new TextPaint();
    private static final int COLUMNS_NORMAL = 5;
    private static final int COLUMNS_ELLIPSIZE = 7;
    private static final int START = 0;
    private static final int DIR = 0;
    private static final int TAB = 0;
    private static final int TOP = 1;
    private static final int DESCENT = 2;
    private static final int EXTRA = 3;
    private static final int HYPHEN = 4;
    private static final int ELLIPSIS_START = 5;
    private static final int ELLIPSIS_COUNT = 6;
    private int[] mLines;
    private Layout.Directions[] mLineDirections;
    private int mMaximumVisibleLineCount = Integer.MAX_VALUE;
    private static final int START_MASK = 0x1FFFFFFF;
    private static final int DIR_SHIFT = 30;
    private static final int TAB_MASK = 0x20000000;
    private static final int HYPHEN_MASK = 255;
    private static final int TAB_INCREMENT = 20;
    private static final char CHAR_NEW_LINE = '\n';
    private static final double EXTRA_ROUNDING = 0.5;
    private static final int DEFAULT_MAX_LINE_HEIGHT = -1;
    private int[] mLeftIndents;
    private int[] mRightIndents;

    public StaticLayout(CharSequence source, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(source, 0, source.length(), paint, width, align, spacingmult, spacingadd, includepad);
    }

    public StaticLayout(CharSequence source, TextPaint paint, int width, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad) {
        this(source, 0, source.length(), paint, width, align, textDir, spacingmult, spacingadd, includepad);
    }

    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(source, bufstart, bufend, paint, outerwidth, align, spacingmult, spacingadd, includepad, null, 0);
    }

    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad) {
        this(source, bufstart, bufend, paint, outerwidth, align, textDir, spacingmult, spacingadd, includepad, null, 0, Integer.MAX_VALUE);
    }

    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        this(source, bufstart, bufend, paint, outerwidth, align, TextDirectionHeuristics.FIRSTSTRONG_LTR, spacingmult, spacingadd, includepad, ellipsize, ellipsizedWidth, Integer.MAX_VALUE);
    }

    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth, int maxLines) {
        super(ellipsize == null ? source : (source instanceof Spanned ? new Layout.SpannedEllipsizer(source) : new Layout.Ellipsizer(source)), paint, outerwidth, align, textDir, spacingmult, spacingadd);
        Builder b = Builder.obtain(source, bufstart, bufend, paint, outerwidth).setAlignment(align).setTextDirection(textDir).setLineSpacing(spacingadd, spacingmult).setIncludePad(includepad).setEllipsizedWidth(ellipsizedWidth).setEllipsize(ellipsize).setMaxLines(maxLines);
        if (ellipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = ellipsizedWidth;
            e.mMethod = ellipsize;
            this.mEllipsizedWidth = ellipsizedWidth;
            this.mColumns = 7;
        } else {
            this.mColumns = 5;
            this.mEllipsizedWidth = outerwidth;
        }
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2);
        this.mLines = ArrayUtils.newUnpaddedIntArray(2 * this.mColumns);
        this.mMaximumVisibleLineCount = maxLines;
        this.generate(b, b.mIncludePad, b.mIncludePad);
        Builder.recycle(b);
    }

    StaticLayout(CharSequence text) {
        super(text, null, 0, null, 0.0f, 0.0f);
        this.mColumns = 7;
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2);
        this.mLines = ArrayUtils.newUnpaddedIntArray(2 * this.mColumns);
    }

    private StaticLayout(Builder b) {
        super(b.mEllipsize == null ? b.mText : (b.mText instanceof Spanned ? new Layout.SpannedEllipsizer(b.mText) : new Layout.Ellipsizer(b.mText)), b.mPaint, b.mWidth, b.mAlignment, b.mSpacingMult, b.mSpacingAdd);
        if (b.mEllipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = b.mEllipsizedWidth;
            e.mMethod = b.mEllipsize;
            this.mEllipsizedWidth = b.mEllipsizedWidth;
            this.mColumns = 7;
        } else {
            this.mColumns = 5;
            this.mEllipsizedWidth = b.mWidth;
        }
        this.mLineDirections = ArrayUtils.newUnpaddedArray(Layout.Directions.class, 2);
        this.mLines = ArrayUtils.newUnpaddedIntArray(2 * this.mColumns);
        this.mMaximumVisibleLineCount = b.mMaxLines;
        this.mLeftIndents = b.mLeftIndents;
        this.mRightIndents = b.mRightIndents;
        this.setJustificationMode(b.mJustificationMode);
        this.generate(b, b.mIncludePad, b.mIncludePad);
    }

    void generate(Builder b, boolean includepad, boolean trackpad) {
        int[] indents;
        CharSequence source = b.mText;
        int bufStart = b.mStart;
        int bufEnd = b.mEnd;
        TextPaint paint = b.mPaint;
        int outerWidth = b.mWidth;
        TextDirectionHeuristic textDir = b.mTextDir;
        boolean fallbackLineSpacing = b.mFallbackLineSpacing;
        float spacingmult = b.mSpacingMult;
        float spacingadd = b.mSpacingAdd;
        float ellipsizedWidth = b.mEllipsizedWidth;
        TextUtils.TruncateAt ellipsize = b.mEllipsize;
        boolean addLastLineSpacing = b.mAddLastLineLineSpacing;
        LineBreaks lineBreaks = new LineBreaks();
        int[] spanEndCache = new int[4];
        int[] fmCache = new int[16];
        b.setLocales(paint.getTextLocales());
        this.mLineCount = 0;
        this.mEllipsized = false;
        this.mMaxLineHeight = this.mMaximumVisibleLineCount < 1 ? 0 : -1;
        int v = 0;
        boolean needMultiply = spacingmult != 1.0f || spacingadd != 0.0f;
        Paint.FontMetricsInt fm = b.mFontMetricsInt;
        int[] chooseHtv = null;
        MeasuredText measured = b.mMeasuredText;
        Spanned spanned = null;
        if (source instanceof Spanned) {
            spanned = (Spanned)source;
        }
        if (this.mLeftIndents != null || this.mRightIndents != null) {
            int i;
            int leftLen = this.mLeftIndents == null ? 0 : this.mLeftIndents.length;
            int rightLen = this.mRightIndents == null ? 0 : this.mRightIndents.length;
            int indentsLen = Math.max(leftLen, rightLen);
            indents = new int[indentsLen];
            for (i = 0; i < leftLen; ++i) {
                indents[i] = this.mLeftIndents[i];
            }
            for (i = 0; i < rightLen; ++i) {
                int n = i;
                indents[n] = indents[n] + this.mRightIndents[i];
            }
        } else {
            indents = null;
        }
        int paraStart = bufStart;
        while (paraStart <= bufEnd) {
            boolean ellipsisMayBeApplied;
            TabStopSpan[] spans;
            int paraEnd = TextUtils.indexOf(source, '\n', paraStart, bufEnd);
            paraEnd = paraEnd < 0 ? bufEnd : ++paraEnd;
            int firstWidthLineCount = 1;
            int firstWidth = outerWidth;
            int restWidth = outerWidth;
            LineHeightSpan[] chooseHt = null;
            if (spanned != null) {
                int i;
                LeadingMarginSpan[] sp = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LeadingMarginSpan.class);
                for (i = 0; i < sp.length; ++i) {
                    LeadingMarginSpan lms = sp[i];
                    firstWidth -= sp[i].getLeadingMargin(true);
                    restWidth -= sp[i].getLeadingMargin(false);
                    if (!(lms instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    LeadingMarginSpan.LeadingMarginSpan2 lms2 = (LeadingMarginSpan.LeadingMarginSpan2)lms;
                    firstWidthLineCount = Math.max(firstWidthLineCount, lms2.getLeadingMarginLineCount());
                }
                chooseHt = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LineHeightSpan.class);
                if (chooseHt.length == 0) {
                    chooseHt = null;
                } else {
                    if (chooseHtv == null || chooseHtv.length < chooseHt.length) {
                        chooseHtv = ArrayUtils.newUnpaddedIntArray(chooseHt.length);
                    }
                    for (i = 0; i < chooseHt.length; ++i) {
                        int o = spanned.getSpanStart(chooseHt[i]);
                        chooseHtv[i] = o < paraStart ? this.getLineTop(this.getLineForOffset(o)) : v;
                    }
                }
            }
            measured.setPara(source, paraStart, paraEnd, textDir, b);
            char[] chs = measured.mChars;
            float[] widths = measured.mWidths;
            byte[] chdirs = measured.mLevels;
            int dir = measured.mDir;
            boolean easy = measured.mEasy;
            int[] variableTabStops = null;
            if (spanned != null && (spans = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, TabStopSpan.class)).length > 0) {
                int[] stops = new int[spans.length];
                for (int i = 0; i < spans.length; ++i) {
                    stops[i] = spans[i].getTabStop();
                }
                Arrays.sort(stops, 0, stops.length);
                variableTabStops = stops;
            }
            StaticLayout.nSetupParagraph(b.mNativePtr, chs, paraEnd - paraStart, firstWidth, firstWidthLineCount, restWidth, variableTabStops, 20, b.mBreakStrategy, b.mHyphenationFrequency, b.mJustificationMode != 0, indents, this.mLineCount);
            int fmCacheCount = 0;
            int spanEndCacheCount = 0;
            int spanStart = paraStart;
            while (spanStart < paraEnd) {
                int spanLen;
                int spanEnd;
                int[] grow;
                if (fmCacheCount * 4 >= fmCache.length) {
                    grow = new int[fmCacheCount * 4 * 2];
                    System.arraycopy(fmCache, 0, grow, 0, fmCacheCount * 4);
                    fmCache = grow;
                }
                if (spanEndCacheCount >= spanEndCache.length) {
                    grow = new int[spanEndCacheCount * 2];
                    System.arraycopy(spanEndCache, 0, grow, 0, spanEndCacheCount);
                    spanEndCache = grow;
                }
                if (spanned == null) {
                    spanEnd = paraEnd;
                    spanLen = spanEnd - spanStart;
                    measured.addStyleRun(paint, spanLen, fm);
                } else {
                    spanEnd = spanned.nextSpanTransition(spanStart, paraEnd, MetricAffectingSpan.class);
                    spanLen = spanEnd - spanStart;
                    MetricAffectingSpan[] spans2 = spanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                    spans2 = TextUtils.removeEmptySpans(spans2, spanned, MetricAffectingSpan.class);
                    measured.addStyleRun(paint, spans2, spanLen, fm);
                }
                fmCache[fmCacheCount * 4 + 0] = fm.top;
                fmCache[fmCacheCount * 4 + 1] = fm.bottom;
                fmCache[fmCacheCount * 4 + 2] = fm.ascent;
                fmCache[fmCacheCount * 4 + 3] = fm.descent;
                ++fmCacheCount;
                spanEndCache[spanEndCacheCount] = spanEnd;
                ++spanEndCacheCount;
                spanStart = spanEnd;
            }
            StaticLayout.nGetWidths(b.mNativePtr, widths);
            int breakCount = StaticLayout.nComputeLineBreaks(b.mNativePtr, lineBreaks, lineBreaks.breaks, lineBreaks.widths, lineBreaks.ascents, lineBreaks.descents, lineBreaks.flags, lineBreaks.breaks.length);
            int[] breaks = lineBreaks.breaks;
            float[] lineWidths = lineBreaks.widths;
            float[] ascents = lineBreaks.ascents;
            float[] descents = lineBreaks.descents;
            int[] flags = lineBreaks.flags;
            int remainingLineCount = this.mMaximumVisibleLineCount - this.mLineCount;
            boolean bl = ellipsisMayBeApplied = ellipsize != null && (ellipsize == TextUtils.TruncateAt.END || this.mMaximumVisibleLineCount == 1 && ellipsize != TextUtils.TruncateAt.MARQUEE);
            if (0 < remainingLineCount && remainingLineCount < breakCount && ellipsisMayBeApplied) {
                float width = 0.0f;
                int flag = 0;
                for (int i = remainingLineCount - 1; i < breakCount; ++i) {
                    if (i == breakCount - 1) {
                        width += lineWidths[i];
                    } else {
                        int j;
                        int n = j = i == 0 ? 0 : breaks[i - 1];
                        while (j < breaks[i]) {
                            width += widths[j];
                            ++j;
                        }
                    }
                    flag |= flags[i] & 0x20000000;
                }
                breaks[remainingLineCount - 1] = breaks[breakCount - 1];
                lineWidths[remainingLineCount - 1] = width;
                flags[remainingLineCount - 1] = flag;
                breakCount = remainingLineCount;
            }
            int here = paraStart;
            int fmTop = 0;
            int fmBottom = 0;
            int fmAscent = 0;
            int fmDescent = 0;
            int fmCacheIndex = 0;
            int spanEndCacheIndex = 0;
            int breakIndex = 0;
            int spanStart2 = paraStart;
            while (spanStart2 < paraEnd) {
                int spanEnd = spanEndCache[spanEndCacheIndex++];
                fm.top = fmCache[fmCacheIndex * 4 + 0];
                fm.bottom = fmCache[fmCacheIndex * 4 + 1];
                fm.ascent = fmCache[fmCacheIndex * 4 + 2];
                fm.descent = fmCache[fmCacheIndex * 4 + 3];
                ++fmCacheIndex;
                if (fm.top < fmTop) {
                    fmTop = fm.top;
                }
                if (fm.ascent < fmAscent) {
                    fmAscent = fm.ascent;
                }
                if (fm.descent > fmDescent) {
                    fmDescent = fm.descent;
                }
                if (fm.bottom > fmBottom) {
                    fmBottom = fm.bottom;
                }
                while (breakIndex < breakCount && paraStart + breaks[breakIndex] < spanStart2) {
                    ++breakIndex;
                }
                while (breakIndex < breakCount && paraStart + breaks[breakIndex] <= spanEnd) {
                    int endPos = paraStart + breaks[breakIndex];
                    boolean moreChars = endPos < bufEnd;
                    int ascent = fallbackLineSpacing ? Math.min(fmAscent, Math.round(ascents[breakIndex])) : fmAscent;
                    int descent = fallbackLineSpacing ? Math.max(fmDescent, Math.round(descents[breakIndex])) : fmDescent;
                    v = this.out(source, here, endPos, ascent, descent, fmTop, fmBottom, v, spacingmult, spacingadd, chooseHt, chooseHtv, fm, flags[breakIndex], needMultiply, chdirs, dir, easy, bufEnd, includepad, trackpad, addLastLineSpacing, chs, widths, paraStart, ellipsize, ellipsizedWidth, lineWidths[breakIndex], paint, moreChars);
                    if (endPos < spanEnd) {
                        fmTop = fm.top;
                        fmBottom = fm.bottom;
                        fmAscent = fm.ascent;
                        fmDescent = fm.descent;
                    } else {
                        fmDescent = 0;
                        fmAscent = 0;
                        fmBottom = 0;
                        fmTop = 0;
                    }
                    here = endPos;
                    ++breakIndex;
                    if (this.mLineCount < this.mMaximumVisibleLineCount || !this.mEllipsized) continue;
                    return;
                }
                spanStart2 = spanEnd;
            }
            if (paraEnd == bufEnd) break;
            paraStart = paraEnd;
        }
        if ((bufEnd == bufStart || source.charAt(bufEnd - 1) == '\n') && this.mLineCount < this.mMaximumVisibleLineCount) {
            measured.setPara(source, bufEnd, bufEnd, textDir, b);
            paint.getFontMetricsInt(fm);
            v = this.out(source, bufEnd, bufEnd, fm.ascent, fm.descent, fm.top, fm.bottom, v, spacingmult, spacingadd, null, null, fm, 0, needMultiply, measured.mLevels, measured.mDir, measured.mEasy, bufEnd, includepad, trackpad, addLastLineSpacing, null, null, bufStart, ellipsize, ellipsizedWidth, 0.0f, paint, false);
        }
    }

    private int out(CharSequence text, int start, int end, int above, int below, int top, int bottom, int v, float spacingmult, float spacingadd, LineHeightSpan[] chooseHt, int[] chooseHtv, Paint.FontMetricsInt fm, int flags, boolean needMultiply, byte[] chdirs, int dir, boolean easy, int bufEnd, boolean includePad, boolean trackPad, boolean addLastLineLineSpacing, char[] chs, float[] widths, int widthStart, TextUtils.TruncateAt ellipsize, float ellipsisWidth, float textWidth, TextPaint paint, boolean moreChars) {
        double ex;
        boolean lastLine;
        boolean currentLineIsTheLastVisibleOne;
        Object[] grow;
        int j = this.mLineCount;
        int off = j * this.mColumns;
        int want = off + this.mColumns + 1;
        int[] lines = this.mLines;
        if (want >= lines.length) {
            grow = ArrayUtils.newUnpaddedIntArray(GrowingArrayUtils.growSize(want));
            System.arraycopy(lines, 0, grow, 0, lines.length);
            this.mLines = grow;
            lines = grow;
        }
        if (j >= this.mLineDirections.length) {
            grow = ArrayUtils.newUnpaddedArray(Layout.Directions.class, GrowingArrayUtils.growSize(j));
            System.arraycopy(this.mLineDirections, 0, grow, 0, this.mLineDirections.length);
            this.mLineDirections = (Layout.Directions[])grow;
        }
        lines[off + 0] = start;
        lines[off + 1] = v;
        int n = off + 0;
        lines[n] = lines[n] | flags & 0x20000000;
        lines[off + 4] = flags;
        int n2 = off + 0;
        lines[n2] = lines[n2] | dir << 30;
        this.mLineDirections[j] = easy ? DIRS_ALL_LEFT_TO_RIGHT : AndroidBidi.directions(dir, chdirs, start - widthStart, chs, start - widthStart, end - start);
        boolean firstLine = j == 0;
        boolean bl = currentLineIsTheLastVisibleOne = j + 1 == this.mMaximumVisibleLineCount;
        if (ellipsize != null) {
            boolean doEllipsis;
            boolean forceEllipsis = moreChars && this.mLineCount + 1 == this.mMaximumVisibleLineCount;
            boolean bl2 = doEllipsis = (this.mMaximumVisibleLineCount == 1 && moreChars || firstLine && !moreChars) && ellipsize != TextUtils.TruncateAt.MARQUEE || !firstLine && (currentLineIsTheLastVisibleOne || !moreChars) && ellipsize == TextUtils.TruncateAt.END;
            if (doEllipsis) {
                this.calculateEllipsis(text, start, end, widths, widthStart, ellipsisWidth - this.getTotalInsets(j), ellipsize, j, textWidth, paint, forceEllipsis, dir);
            }
        }
        if (this.mEllipsized) {
            lastLine = true;
        } else {
            boolean lastCharIsNewLine;
            boolean bl3 = lastCharIsNewLine = widthStart != bufEnd && bufEnd > 0 && text.charAt(bufEnd - 1) == '\n';
            lastLine = end == bufEnd && !lastCharIsNewLine ? true : start == bufEnd && lastCharIsNewLine;
        }
        if (chooseHt != null) {
            fm.ascent = above;
            fm.descent = below;
            fm.top = top;
            fm.bottom = bottom;
            for (int i = 0; i < chooseHt.length; ++i) {
                if (chooseHt[i] instanceof LineHeightSpan.WithDensity) {
                    ((LineHeightSpan.WithDensity)chooseHt[i]).chooseHeight(text, start, end, chooseHtv[i], v, fm, paint);
                    continue;
                }
                chooseHt[i].chooseHeight(text, start, end, chooseHtv[i], v, fm);
            }
            above = fm.ascent;
            below = fm.descent;
            top = fm.top;
            bottom = fm.bottom;
        }
        if (firstLine) {
            if (trackPad) {
                this.mTopPadding = top - above;
            }
            if (includePad) {
                above = top;
            }
        }
        if (lastLine) {
            if (trackPad) {
                this.mBottomPadding = bottom - below;
            }
            if (includePad) {
                below = bottom;
            }
        }
        int extra = needMultiply && (addLastLineLineSpacing || !lastLine) ? ((ex = (double)((float)(below - above) * (spacingmult - 1.0f) + spacingadd)) >= 0.0 ? (int)(ex + 0.5) : -((int)(-ex + 0.5))) : 0;
        lines[off + 2] = below + extra;
        lines[off + 3] = extra;
        if (!this.mEllipsized && currentLineIsTheLastVisibleOne) {
            int maxLineBelow = includePad ? bottom : below;
            this.mMaxLineHeight = v + (maxLineBelow - above);
        }
        lines[off + this.mColumns + 0] = end;
        lines[off + this.mColumns + 1] = v += below - above + extra;
        ++this.mLineCount;
        return v;
    }

    private void calculateEllipsis(CharSequence text, int lineStart, int lineEnd, float[] widths, int widthStart, float avail, TextUtils.TruncateAt where, int line, float textWidth, TextPaint paint, boolean forceEllipsis, int dir) {
        if (textWidth <= avail && !forceEllipsis) {
            this.mLines[this.mColumns * line + 5] = 0;
            this.mLines[this.mColumns * line + 6] = 0;
            return;
        }
        float tempAvail = avail;
        int numberOfTries = 0;
        boolean lineFits = false;
        this.mWorkPaint.set(paint);
        do {
            float ellipsizedWidth;
            if ((ellipsizedWidth = this.guessEllipsis(text, lineStart, lineEnd, widths, widthStart, tempAvail, where, line, textWidth, this.mWorkPaint, forceEllipsis, dir)) <= avail) {
                lineFits = true;
                continue;
            }
            if (++numberOfTries > 10) {
                this.mLines[this.mColumns * line + 5] = 0;
                this.mLines[this.mColumns * line + 6] = lineEnd - lineStart;
                lineFits = true;
                continue;
            }
            tempAvail -= ellipsizedWidth - avail;
        } while (!lineFits);
        this.mEllipsized = true;
    }

    private float guessEllipsis(CharSequence text, int lineStart, int lineEnd, float[] widths, int widthStart, float avail, TextUtils.TruncateAt where, int line, float textWidth, TextPaint paint, boolean forceEllipsis, int dir) {
        Object[] tabs;
        int ellipsisCount;
        int ellipsisStart;
        float sum;
        int savedHyphenEdit = paint.getHyphenEdit();
        paint.setHyphenEdit(0);
        float ellipsisWidth = paint.measureText(TextUtils.getEllipsisString(where));
        int len = lineEnd - lineStart;
        int offset = lineStart - widthStart;
        int hyphen = this.getHyphen(line);
        if (where == TextUtils.TruncateAt.START) {
            if (this.mMaximumVisibleLineCount == 1) {
                int i;
                sum = 0.0f;
                for (i = len; i > 0; --i) {
                    float w = widths[i - 1 + offset];
                    if (w + sum + ellipsisWidth > avail) {
                        while (i < len && widths[i + offset] == 0.0f) {
                            ++i;
                        }
                        break;
                    }
                    sum += w;
                }
                ellipsisStart = 0;
                ellipsisCount = i;
                hyphen &= 0xFFFFFFE7;
            } else {
                ellipsisStart = 0;
                ellipsisCount = 0;
                if (Log.isLoggable(TAG, 5)) {
                    Log.w(TAG, "Start ellipsis only supported with one line");
                }
            }
        } else if (where == TextUtils.TruncateAt.END || where == TextUtils.TruncateAt.MARQUEE || where == TextUtils.TruncateAt.END_SMALL) {
            float w;
            int i;
            sum = 0.0f;
            for (i = 0; i < len && !((w = widths[i + offset]) + sum + ellipsisWidth > avail); ++i) {
                sum += w;
            }
            if (forceEllipsis && i == len && len > 0) {
                ellipsisStart = len - 1;
                ellipsisCount = 1;
            } else {
                ellipsisStart = i;
                ellipsisCount = len - i;
            }
            hyphen &= 0xFFFFFFF8;
        } else if (this.mMaximumVisibleLineCount == 1) {
            float w;
            float lsum = 0.0f;
            float rsum = 0.0f;
            int left = 0;
            int right = len;
            float ravail = (avail - ellipsisWidth) / 2.0f;
            for (right = len; right > 0; --right) {
                float w2 = widths[right - 1 + offset];
                if (w2 + rsum > ravail) {
                    while (right < len && widths[right + offset] == 0.0f) {
                        ++right;
                    }
                    break;
                }
                rsum += w2;
            }
            float lavail = avail - ellipsisWidth - rsum;
            for (left = 0; left < right && !((w = widths[left + offset]) + lsum > lavail); ++left) {
                lsum += w;
            }
            ellipsisStart = left;
            ellipsisCount = right - left;
        } else {
            ellipsisStart = 0;
            ellipsisCount = 0;
            if (Log.isLoggable(TAG, 5)) {
                Log.w(TAG, "Middle ellipsis only supported with one line");
            }
        }
        this.mLines[this.mColumns * line + 5] = ellipsisStart;
        this.mLines[this.mColumns * line + 6] = ellipsisCount;
        if (ellipsisStart == 0 && (ellipsisCount == 0 || ellipsisCount == len)) {
            return 0.0f;
        }
        boolean isSpanned = text instanceof Spanned;
        Layout.Ellipsizer ellipsizedText = isSpanned ? new Layout.SpannedEllipsizer(text) : new Layout.Ellipsizer(text);
        ellipsizedText.mLayout = this;
        ellipsizedText.mMethod = where;
        boolean hasTabs = this.getLineContainsTab(line);
        Layout.TabStops tabStops = hasTabs && isSpanned ? ((tabs = StaticLayout.getParagraphSpans(ellipsizedText, lineStart, lineEnd, TabStopSpan.class)).length == 0 ? null : new Layout.TabStops(20, tabs)) : null;
        paint.setHyphenEdit(hyphen);
        TextLine textline = TextLine.obtain();
        textline.set(paint, ellipsizedText, lineStart, lineEnd, dir, this.getLineDirections(line), hasTabs, tabStops);
        float ellipsizedWidth = textline.metrics(null) * (float)dir;
        TextLine.recycle(textline);
        paint.setHyphenEdit(savedHyphenEdit);
        return ellipsizedWidth;
    }

    private float getTotalInsets(int line) {
        int totalIndent = 0;
        if (this.mLeftIndents != null) {
            totalIndent = this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
        }
        if (this.mRightIndents != null) {
            totalIndent += this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
        }
        return totalIndent;
    }

    @Override
    public int getLineForVertical(int vertical) {
        int high = this.mLineCount;
        int low = -1;
        int[] lines = this.mLines;
        while (high - low > 1) {
            int guess = high + low >> 1;
            if (lines[this.mColumns * guess + 1] > vertical) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    @Override
    public int getLineCount() {
        return this.mLineCount;
    }

    @Override
    public int getLineTop(int line) {
        return this.mLines[this.mColumns * line + 1];
    }

    @Override
    public int getLineExtra(int line) {
        return this.mLines[this.mColumns * line + 3];
    }

    @Override
    public int getLineDescent(int line) {
        return this.mLines[this.mColumns * line + 2];
    }

    @Override
    public int getLineStart(int line) {
        return this.mLines[this.mColumns * line + 0] & 0x1FFFFFFF;
    }

    @Override
    public int getParagraphDirection(int line) {
        return this.mLines[this.mColumns * line + 0] >> 30;
    }

    @Override
    public boolean getLineContainsTab(int line) {
        return (this.mLines[this.mColumns * line + 0] & 0x20000000) != 0;
    }

    @Override
    public Layout.Directions getLineDirections(int line) {
        if (line > this.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.mLineDirections[line];
    }

    @Override
    public int getTopPadding() {
        return this.mTopPadding;
    }

    @Override
    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    @Override
    public int getHyphen(int line) {
        return this.mLines[this.mColumns * line + 4] & 0xFF;
    }

    @Override
    public int getIndentAdjust(int line, Layout.Alignment align) {
        if (align == Layout.Alignment.ALIGN_LEFT) {
            if (this.mLeftIndents == null) {
                return 0;
            }
            return this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
        }
        if (align == Layout.Alignment.ALIGN_RIGHT) {
            if (this.mRightIndents == null) {
                return 0;
            }
            return -this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
        }
        if (align == Layout.Alignment.ALIGN_CENTER) {
            int left = 0;
            if (this.mLeftIndents != null) {
                left = this.mLeftIndents[Math.min(line, this.mLeftIndents.length - 1)];
            }
            int right = 0;
            if (this.mRightIndents != null) {
                right = this.mRightIndents[Math.min(line, this.mRightIndents.length - 1)];
            }
            return left - right >> 1;
        }
        throw new AssertionError((Object)("unhandled alignment " + (Object)((Object)align)));
    }

    @Override
    public int getEllipsisCount(int line) {
        if (this.mColumns < 7) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 6];
    }

    @Override
    public int getEllipsisStart(int line) {
        if (this.mColumns < 7) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 5];
    }

    @Override
    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    @Override
    public int getHeight(boolean cap) {
        if (cap && this.mLineCount >= this.mMaximumVisibleLineCount && this.mMaxLineHeight == -1 && Log.isLoggable(TAG, 5)) {
            Log.w(TAG, "maxLineHeight should not be -1.  maxLines:" + this.mMaximumVisibleLineCount + " lineCount:" + this.mLineCount);
        }
        return cap && this.mLineCount >= this.mMaximumVisibleLineCount && this.mMaxLineHeight != -1 ? this.mMaxLineHeight : super.getHeight();
    }

    @LayoutlibDelegate
    private static long nNewBuilder() {
        return StaticLayout_Delegate.nNewBuilder();
    }

    @LayoutlibDelegate
    private static void nFreeBuilder(long l) {
        StaticLayout_Delegate.nFreeBuilder(l);
    }

    @LayoutlibDelegate
    private static void nFinishBuilder(long l) {
        StaticLayout_Delegate.nFinishBuilder(l);
    }

    @LayoutlibDelegate
    static long nLoadHyphenator(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return StaticLayout_Delegate.nLoadHyphenator(byteBuffer, n, n2, n3);
    }

    @LayoutlibDelegate
    private static void nSetLocales(long l, String string2, long[] lArray) {
        StaticLayout_Delegate.nSetLocales(l, string2, lArray);
    }

    @LayoutlibDelegate
    private static void nSetupParagraph(long l, char[] cArray, int n, float f, int n2, float f2, int[] nArray, int n3, int n4, int n5, boolean bl, int[] nArray2, int n6) {
        StaticLayout_Delegate.nSetupParagraph(l, cArray, n, f, n2, f2, nArray, n3, n4, n5, bl, nArray2, n6);
    }

    @LayoutlibDelegate
    private static float nAddStyleRun(long l, long l2, int n, int n2, boolean bl) {
        return StaticLayout_Delegate.nAddStyleRun(l, l2, n, n2, bl);
    }

    @LayoutlibDelegate
    private static void nAddMeasuredRun(long l, int n, int n2, float[] fArray) {
        StaticLayout_Delegate.nAddMeasuredRun(l, n, n2, fArray);
    }

    @LayoutlibDelegate
    private static void nAddReplacementRun(long l, int n, int n2, float f) {
        StaticLayout_Delegate.nAddReplacementRun(l, n, n2, f);
    }

    @LayoutlibDelegate
    private static void nGetWidths(long l, float[] fArray) {
        StaticLayout_Delegate.nGetWidths(l, fArray);
    }

    @LayoutlibDelegate
    private static int nComputeLineBreaks(long l, LineBreaks lineBreaks, int[] nArray, float[] fArray, float[] fArray2, float[] fArray3, int[] nArray2, int n) {
        return StaticLayout_Delegate.nComputeLineBreaks(l, lineBreaks, nArray, fArray, fArray2, fArray3, nArray2, n);
    }

    static class LineBreaks {
        private static final int INITIAL_SIZE = 16;
        public int[] breaks = new int[16];
        public float[] widths = new float[16];
        public float[] ascents = new float[16];
        public float[] descents = new float[16];
        public int[] flags = new int[16];

        LineBreaks() {
        }
    }

    public static class Builder {
        long mNativePtr;
        private CharSequence mText;
        private int mStart;
        private int mEnd;
        private TextPaint mPaint;
        private int mWidth;
        private Layout.Alignment mAlignment;
        private TextDirectionHeuristic mTextDir;
        private float mSpacingMult;
        private float mSpacingAdd;
        private boolean mIncludePad;
        private boolean mFallbackLineSpacing;
        private int mEllipsizedWidth;
        private TextUtils.TruncateAt mEllipsize;
        private int mMaxLines;
        private int mBreakStrategy;
        private int mHyphenationFrequency;
        private int[] mLeftIndents;
        private int[] mRightIndents;
        private int mJustificationMode;
        private boolean mAddLastLineLineSpacing;
        private final Paint.FontMetricsInt mFontMetricsInt = new Paint.FontMetricsInt();
        private MeasuredText mMeasuredText;
        private LocaleList mLocales;
        private static final Pools.SynchronizedPool<Builder> sPool = new Pools.SynchronizedPool(3);

        private Builder() {
            this.mNativePtr = StaticLayout.nNewBuilder();
        }

        public static Builder obtain(CharSequence source, int start, int end, TextPaint paint, int width) {
            Builder b = sPool.acquire();
            if (b == null) {
                b = new Builder();
            }
            b.mText = source;
            b.mStart = start;
            b.mEnd = end;
            b.mPaint = paint;
            b.mWidth = width;
            b.mAlignment = Layout.Alignment.ALIGN_NORMAL;
            b.mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
            b.mSpacingMult = 1.0f;
            b.mSpacingAdd = 0.0f;
            b.mIncludePad = true;
            b.mFallbackLineSpacing = false;
            b.mEllipsizedWidth = width;
            b.mEllipsize = null;
            b.mMaxLines = Integer.MAX_VALUE;
            b.mBreakStrategy = 0;
            b.mHyphenationFrequency = 0;
            b.mJustificationMode = 0;
            b.mMeasuredText = MeasuredText.obtain();
            return b;
        }

        private static void recycle(Builder b) {
            b.mPaint = null;
            b.mText = null;
            MeasuredText.recycle(b.mMeasuredText);
            b.mMeasuredText = null;
            b.mLeftIndents = null;
            b.mRightIndents = null;
            StaticLayout.nFinishBuilder(b.mNativePtr);
            sPool.release(b);
        }

        void finish() {
            StaticLayout.nFinishBuilder(this.mNativePtr);
            this.mText = null;
            this.mPaint = null;
            this.mLeftIndents = null;
            this.mRightIndents = null;
            this.mMeasuredText.finish();
        }

        public Builder setText(CharSequence source) {
            return this.setText(source, 0, source.length());
        }

        public Builder setText(CharSequence source, int start, int end) {
            this.mText = source;
            this.mStart = start;
            this.mEnd = end;
            return this;
        }

        public Builder setPaint(TextPaint paint) {
            this.mPaint = paint;
            return this;
        }

        public Builder setWidth(int width) {
            this.mWidth = width;
            if (this.mEllipsize == null) {
                this.mEllipsizedWidth = width;
            }
            return this;
        }

        public Builder setAlignment(Layout.Alignment alignment) {
            this.mAlignment = alignment;
            return this;
        }

        public Builder setTextDirection(TextDirectionHeuristic textDir) {
            this.mTextDir = textDir;
            return this;
        }

        public Builder setLineSpacing(float spacingAdd, float spacingMult) {
            this.mSpacingAdd = spacingAdd;
            this.mSpacingMult = spacingMult;
            return this;
        }

        public Builder setIncludePad(boolean includePad) {
            this.mIncludePad = includePad;
            return this;
        }

        public Builder setUseLineSpacingFromFallbacks(boolean useLineSpacingFromFallbacks) {
            this.mFallbackLineSpacing = useLineSpacingFromFallbacks;
            return this;
        }

        public Builder setEllipsizedWidth(int ellipsizedWidth) {
            this.mEllipsizedWidth = ellipsizedWidth;
            return this;
        }

        public Builder setEllipsize(TextUtils.TruncateAt ellipsize) {
            this.mEllipsize = ellipsize;
            return this;
        }

        public Builder setMaxLines(int maxLines) {
            this.mMaxLines = maxLines;
            return this;
        }

        public Builder setBreakStrategy(int breakStrategy) {
            this.mBreakStrategy = breakStrategy;
            return this;
        }

        public Builder setHyphenationFrequency(int hyphenationFrequency) {
            this.mHyphenationFrequency = hyphenationFrequency;
            return this;
        }

        public Builder setIndents(int[] leftIndents, int[] rightIndents) {
            this.mLeftIndents = leftIndents;
            this.mRightIndents = rightIndents;
            return this;
        }

        public Builder setJustificationMode(int justificationMode) {
            this.mJustificationMode = justificationMode;
            return this;
        }

        Builder setAddLastLineLineSpacing(boolean value) {
            this.mAddLastLineLineSpacing = value;
            return this;
        }

        private long[] getHyphenators(LocaleList locales) {
            int length = locales.size();
            long[] result = new long[length];
            for (int i = 0; i < length; ++i) {
                Locale locale = locales.get(i);
                result[i] = Hyphenator.get(locale).getNativePtr();
            }
            return result;
        }

        private void setLocales(LocaleList locales) {
            if (!locales.equals(this.mLocales)) {
                StaticLayout.nSetLocales(this.mNativePtr, locales.toLanguageTags(), this.getHyphenators(locales));
                this.mLocales = locales;
            }
        }

        float addStyleRun(TextPaint paint, int start, int end, boolean isRtl) {
            this.setLocales(paint.getTextLocales());
            return StaticLayout.nAddStyleRun(this.mNativePtr, paint.getNativeInstance(), start, end, isRtl);
        }

        void addMeasuredRun(int start, int end, float[] widths) {
            StaticLayout.nAddMeasuredRun(this.mNativePtr, start, end, widths);
        }

        void addReplacementRun(int start, int end, float width) {
            StaticLayout.nAddReplacementRun(this.mNativePtr, start, end, width);
        }

        public StaticLayout build() {
            StaticLayout result = new StaticLayout(this);
            Builder.recycle(this);
            return result;
        }

        protected void finalize() throws Throwable {
            try {
                StaticLayout.nFreeBuilder(this.mNativePtr);
            }
            finally {
                super.finalize();
            }
        }
    }
}

